/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StreamContent {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String contentKey;
    private String contentType;
    private String contentDisposition;
    private byte[] contentBytes;
    private String servletMapping;
    private boolean disposeContents;
    private boolean noop;
    private boolean persistence;

    public StreamContent(HttpServletRequest request, HttpServletResponse response) {
        this.setRequest(request);
        this.setResponse(response);
        this.disposeContents = true;
        this.noop = false;
        this.persistence = true;
        this.servletMapping = "/StreamContentServlet";
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setContentKey(String contentKey) {
        this.contentKey = contentKey;
    }

    public String getContentKey() {
        return this.contentKey;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentBytes(byte[] contentBytes) {
        this.contentBytes = contentBytes;
    }

    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    public void setServletMapping(String servletMapping) {
        this.servletMapping = servletMapping;
    }

    public String getServletMapping() {
        return this.servletMapping;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setPersistence(boolean persistence) {
        this.persistence = persistence;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public String getAbsoluteURL() {
        StringBuffer URL2 = new StringBuffer("");
        URL2.append(this.request.getScheme());
        URL2.append("://");
        URL2.append(this.request.getServerName());
        URL2.append(":");
        URL2.append(this.request.getServerPort());
        URL2.append(this.getURL(true));
        return URL2.toString();
    }

    public String getURL() {
        return this.getURL(true);
    }

    public String getURL(boolean includeContext) {
        StringBuffer URL2 = new StringBuffer("");
        if (includeContext) {
            URL2.append(this.request.getContextPath());
        }
        URL2.append(this.getServletMapping());
        if (this.isNoop()) {
            URL2.append("?noop=true");
            return URL2.toString();
        }
        String b = this.isDisposeContents() ? "true" : "false";
        String key = this.getContentKey();
        boolean keySet = false;
        if (key != null && !key.equals("")) {
            URL2.append("?");
            URL2.append("CONTENT_KEY");
            URL2.append("=");
            URL2.append(key);
            keySet = true;
        }
        if (!this.isPersistence()) {
            if (keySet) {
                URL2.append("&");
            } else {
                URL2.append("?");
            }
            URL2.append("PERSISTENCE");
            URL2.append("=false");
        }
        if (key != null) {
            this.request.getSession().setAttribute("sas_StreamContentServlet_ContentType" + key, (Object)this.getContentType());
            this.request.getSession().setAttribute("sas_StreamContentServlet_ContentDisposition" + key, (Object)this.getContentDisposition());
            this.request.getSession().setAttribute("sas_StreamContentServlet_ContentBytes" + key, (Object)this.getContentBytes());
            this.request.getSession().setAttribute("sas_StreamContentServlet_DisposeContents" + key, (Object)b);
        } else {
            this.request.setAttribute("sas_StreamContentServlet_ContentType", (Object)this.getContentType());
            this.request.setAttribute("sas_StreamContentServlet_ContentDisposition", (Object)this.getContentDisposition());
            this.request.setAttribute("sas_StreamContentServlet_ContentBytes", (Object)this.getContentBytes());
            this.request.setAttribute("sas_StreamContentServlet_DisposeContents", (Object)b);
        }
        return URL2.toString();
    }

    public void setDisposeContent(boolean disposeContents) {
        this.disposeContents = disposeContents;
    }

    public boolean isDisposeContents() {
        return this.disposeContents;
    }
}

