/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeMappings;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

@SASScope(value="ALL")
public class JavaScriptIncludeHandler {
    @SASScope
    public static String INC_COLLECTION = "sas_JavaScript_Includes";
    @SASScope
    public static String JS_PATH = "sas_JavaScript_Path";
    @SASScope
    public static String JS_MAP = "sas_JavaScript_Map";
    @SASScope
    public static String JS_ENABLED = "sas_JavaScript_Enabled";
    public static final String DOJO_JS = "DOJO";
    public static final String SAS_COMMON_JS = "SAS_COMMON_JS";
    public static final String SAS_MODALSELECTOR_JS = "SAS_MODAL_JS";
    public static final String SAS_RESIZING_JS = "SAS_RESIZING_JS";
    public static final String SAS_TRANSFORMATIONBEAN_JS = "SAS_TRANSFORMATIONBEAN_JS";
    public static final String SAS_FASTCLICKPROTECTION_JS = "SAS_FASTCLICKPROTECTION_JS";
    public static final String SAS_FASTCLICKPROTECTION_CUSTOMFUNCTIONS_JS = "SAS_FASTCLICKPROTECTION_CUSTOMFUNCTIONS_JS";
    private static Map map = new HashMap();
    @SASScope
    protected String path = null;
    @SASScope
    protected Vector scripts = null;
    @SASScope
    protected Writer out;
    @SASScope
    protected HttpServletRequest request;
    @SASScope
    protected Map localMap = null;
    @SASScope
    protected boolean enabled = true;
    @SASScope
    static final boolean DEBUG = false;
    private static final String NO_JS = "NOJS";

    public JavaScriptIncludeHandler(Writer out, HttpServletRequest request) {
        this.setRequest(request);
        this.out = out;
    }

    private void setRequest(HttpServletRequest request) {
        this.request = request;
        if (request != null) {
            this.setPath(request);
            this.setScripts(request);
            this.localMap = (Map)request.getAttribute(JS_MAP);
            Boolean enabled = (Boolean)request.getAttribute(JS_ENABLED);
            if (enabled != null) {
                this.enabled = enabled;
            }
        }
        if (this.scripts == null) {
            this.scripts = new Vector();
            this.path = JavaScriptIncludeHandler.getDefaultPath();
        }
    }

    private void setPath(HttpServletRequest request) {
        this.path = JavaScriptIncludeHandler.getPath(request);
    }

    @SASScope
    public static String getDefaultPath() {
        return new ComponentPropertyManager().getJavaScriptLocation();
    }

    private void setScripts(HttpServletRequest request) {
        this.scripts = JavaScriptIncludeHandler.getScripts(request);
    }

    private static Vector getScripts(HttpServletRequest request) {
        if (request == null) {
            return new Vector();
        }
        Vector scripts = (Vector)request.getAttribute(INC_COLLECTION);
        if (scripts == null) {
            scripts = new Vector();
            request.setAttribute(INC_COLLECTION, scripts);
        }
        return scripts;
    }

    public void writeIncludes(Object tbean) throws IOException {
        if (!this.enabled || this.scripts.contains(tbean)) {
            return;
        }
        this.scripts.add(tbean);
        if (tbean.equals(DOJO_JS)) {
            JavaScriptIncludeHandler.writeDojoIncludeStatement(this.out, this.request);
            return;
        }
        String filename = this.processDependencies(tbean);
        if (filename != null && filename != NO_JS) {
            this.writeIncludeStatement(filename);
        }
    }

    @SASScope
    protected void writeIncludeStatement(String filename) throws IOException {
        JavaScriptIncludeHandler.writeIncludeStatement(this.out, filename, JavaScriptIncludeHandler.getPath(this.request));
    }

    public static void writeIncludeStatement(Writer out, String filename, String path) throws IOException {
        String fn = filename;
        if (fn.endsWith(".js")) {
            fn = fn.substring(0, fn.length() - 3);
        }
        out.write(" <script type=\"text/javascript\">/*<![CDATA[*/sas.requires(\"" + fn + "\", \"" + path + "\");/*]]>*/</script>\n");
    }

    @SASScope
    public static void writeDojoInclude(Writer out, HttpServletRequest request) throws IOException {
        Vector scripts = JavaScriptIncludeHandler.getScripts(request);
        if (scripts.contains(DOJO_JS)) {
            return;
        }
        scripts.add(DOJO_JS);
        JavaScriptIncludeHandler.writeDojoIncludeStatement(out, request);
    }

    private static void writeDojoIncludeStatement(Writer out, HttpServletRequest request) throws IOException {
        String dojoURI = JavaScriptIncludeHandler.getPath(request) + "dojo/";
        out.write("<script type=\"text/javascript\">/*<![CDATA[*/sas_includeDojo('" + dojoURI + "');/*]]>*/</script>\n");
    }

    @SASScope
    public static void clear(HttpServletRequest request) {
        JavaScriptIncludeHandler.getScripts(request).clear();
    }

    public static String getStartScript() {
        return "<script type=\"text/javascript\">/*<![CDATA[*/\n";
    }

    @SASScope
    public static String getEndScript() {
        return JavaScriptIncludeHandler.getEndScript(null);
    }

    public static String getEndScript(String noScript) {
        StringBuffer sb = new StringBuffer("/*]]>*/</script>\n");
        if (noScript != null) {
            sb.append("<noscript>\n").append(noScript).append("\n</noscript>\n");
        }
        return sb.toString();
    }

    private String processDependencies(Object tbean) throws IOException {
        Object[] dependencies = null;
        String path = "";
        if (tbean instanceof Class) {
            Class tbeanClass = tbean;
            try {
                tbean = Class.forName(tbeanClass.getName(), true, tbeanClass.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.localMap != null) {
            dependencies = (Object[])this.localMap.get(tbean);
        }
        if (dependencies == null) {
            dependencies = (Object[])map.get(tbean);
            path = this.path;
        }
        if (dependencies == null) {
            this.writeMessage("Could not find javascript file for key " + tbean);
            return null;
        }
        this.processDependencies(dependencies);
        return dependencies[0].toString();
    }

    private void processDependencies(Object[] dependencies) throws IOException {
        for (int i = 1; i < dependencies.length; ++i) {
            this.writeIncludes(dependencies[i]);
        }
    }

    private void writeMessage(String message) throws IOException {
        this.out.write(message);
    }

    @SASScope
    private static void addMapping(Map map, Object key, String filename, Object[] dependencies) {
        Object[] value = new Object[dependencies.length + 1];
        value[0] = filename;
        System.arraycopy(dependencies, 0, value, 1, dependencies.length);
        map.put(key, value);
    }

    private static String getFilename(Map map, Object key) {
        Object[] deps = (Object[])map.get(key);
        if (deps == null || deps.length == 0) {
            return null;
        }
        return (String)deps[0];
    }

    private static Object[] getDependencies(Map map, Object key) {
        Object[] deps = (Object[])map.get(key);
        if (deps == null || deps.length == 0) {
            return null;
        }
        Object[] ret = new Object[deps.length - 1];
        System.arraycopy(deps, 1, ret, 0, ret.length);
        return ret;
    }

    private static Map getLocalMap(HttpServletRequest request) {
        HashMap lmap = (HashMap)request.getAttribute(JS_MAP);
        if (lmap == null) {
            lmap = new HashMap();
            request.setAttribute(JS_MAP, lmap);
        }
        return lmap;
    }

    public static void writeIncludes(Writer out, Object tbean, HttpServletRequest request) throws IOException {
        JavaScriptIncludeHandler jsih = new JavaScriptIncludeHandler(out, request);
        jsih.writeIncludes(tbean);
    }

    @SASScope
    public static void writeInclude(Writer out, Object tbean, HttpServletRequest request) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, tbean, request);
    }

    @SASScope
    public static void addMapping(Object key, String filename, Object[] dependencies) {
        if (!map.containsKey(key)) {
            JavaScriptIncludeHandler.addMapping(map, key, filename, dependencies);
        }
    }

    @SASScope
    public static void addMapping(Object key, String filename) {
        JavaScriptIncludeHandler.addMapping(key, filename, new Object[0]);
    }

    @SASScope
    public static void addAlias(Object key, String dependency) {
        Object[] objectArray;
        if (dependency != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = dependency;
        } else {
            objectArray = new Object[]{};
        }
        Object[] dependencies = objectArray;
        JavaScriptIncludeHandler.addMapping(key, NO_JS, dependencies);
    }

    public static String getFilename(Object key) {
        return JavaScriptIncludeHandler.getFilename(map, key);
    }

    public static Object[] getDependencies(Object key) {
        return JavaScriptIncludeHandler.getDependencies(map, key);
    }

    public static void addLocalMapping(Object key, String filename, Object[] dependencies, HttpServletRequest request) {
        JavaScriptIncludeHandler.addMapping(JavaScriptIncludeHandler.getLocalMap(request), key, filename, dependencies);
    }

    public static void addLocalMapping(Object key, String filename, HttpServletRequest request) {
        JavaScriptIncludeHandler.addMapping(JavaScriptIncludeHandler.getLocalMap(request), key, filename, new Object[0]);
    }

    public static String getLocalFilename(Object key, HttpServletRequest request) {
        return JavaScriptIncludeHandler.getFilename(JavaScriptIncludeHandler.getLocalMap(request), key);
    }

    public static Object[] getLocalDependencies(Object key, HttpServletRequest request) {
        return JavaScriptIncludeHandler.getDependencies(JavaScriptIncludeHandler.getLocalMap(request), key);
    }

    public static void setPath(String path, HttpServletRequest request) {
        if (request != null) {
            request.setAttribute(JS_PATH, (Object)path);
        }
    }

    public static String getPath(HttpServletRequest request) {
        String path;
        try {
            path = (String)request.getAttribute(JS_PATH);
            if (path == null) {
                path = ComponentPropertyManager.getInstance(request).getJavaScriptLocation();
            }
        }
        catch (Exception ex) {
            path = JavaScriptIncludeHandler.getDefaultPath();
        }
        return path;
    }

    public static void setEnabled(boolean enable, HttpServletRequest request) {
        request.setAttribute(JS_ENABLED, (Object)new Boolean(enable));
    }

    public static void setIncluded(Object tbean, boolean included, HttpServletRequest request) {
        Vector scripts = JavaScriptIncludeHandler.getScripts(request);
        boolean inScripts = scripts.contains(tbean);
        if (!inScripts && included) {
            scripts.add(tbean);
        } else if (inScripts && !included) {
            scripts.remove(tbean);
        }
    }

    @SASScope
    public static void setIncluded(Object tbean, HttpServletRequest request) {
        JavaScriptIncludeHandler.setIncluded(tbean, true, request);
    }

    public static boolean getIncluded(Object tbean, HttpServletRequest request) {
        Vector scripts = JavaScriptIncludeHandler.getScripts(request);
        return scripts.contains(tbean);
    }

    static {
        JavaScriptIncludeMappings.addDefaultMappings(map);
        JavaScriptIncludeHandler.addMapping(SAS_COMMON_JS, "sas_Common.js");
        JavaScriptIncludeHandler.addAlias(SAS_RESIZING_JS, "RESIZING");
        JavaScriptIncludeHandler.addAlias(SAS_TRANSFORMATIONBEAN_JS, "TRANSFORMATIONBEAN");
        JavaScriptIncludeHandler.addAlias(SAS_MODALSELECTOR_JS, "MODALSELECTOR");
        JavaScriptIncludeHandler.addAlias(SAS_FASTCLICKPROTECTION_JS, "FASTCLICKPROTECTION");
        JavaScriptIncludeHandler.addAlias(SAS_FASTCLICKPROTECTION_CUSTOMFUNCTIONS_JS, "FASTCLICKPROTECTIONCUSTOMFUNCTIONS");
        JavaScriptIncludeHandler.addAlias("Selections.js", "SELECTIONS");
    }
}

