/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.HttpActionProviderInterface;
import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableViewComposite;
import com.sas.servlet.tbeans.tableview.html.TableViewComposite;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.Components;
import com.sas.servlet.util.RB;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class InformationMapViewerServlet
extends HttpServlet {
    @SASScope
    public static final String RB_KEY = "InformationMapViewerServlet.";
    private HttpActionProvider actionProvider;

    public String getServletInfo() {
        return "InformationMapViewerServlet";
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String charset = BaseUtil.getOutputCharacterEncoding(request);
        response.setContentType("text/html; charset=" + charset);
        TransformationInterface viewer = null;
        HttpSession session = request.getSession();
        PrintWriter out = response.getWriter();
        ComponentPropertyManager propertyManager = ComponentPropertyManager.getInstance(request);
        String fullyQualifiedPath = request.getParameter("fullyQualifiedPath");
        String sessionContextName = request.getParameter("SESSIONCONTEXTNAME");
        String informationMapName = request.getParameter("INFORMATIONMAPNAME");
        String iqServiceName = request.getParameter("IQSERVICENAME");
        if (informationMapName != null || fullyQualifiedPath != null) {
            try {
                DataSelection dataSelection;
                if (sessionContextName == null) {
                    throw new ServletException(RB.getStringResource(RB_KEY, "noSessionContextRequest.txt"));
                }
                SessionContextInterface sessionContext = (SessionContextInterface)session.getAttribute(sessionContextName);
                if (sessionContext == null) {
                    throw new ServletException(RB.getStringResource(RB_KEY, "noSessionContextSession.txt"));
                }
                if (iqServiceName == null) {
                    throw new ServletException(RB.getStringResource(RB_KEY, "noIQServiceRequest.txt"));
                }
                IntelligentQueryMetadataServiceInterface iqService = (IntelligentQueryMetadataServiceInterface)session.getAttribute(iqServiceName);
                if (iqService == null) {
                    throw new ServletException(RB.getStringResource(RB_KEY, "noIQServiceSession.txt"));
                }
                InformationMap informationMap = null;
                if (informationMapName != null) {
                    informationMap = (InformationMap)session.getAttribute(informationMapName);
                }
                if (informationMap == null && fullyQualifiedPath != null) {
                    informationMap = iqService.getInformationMap(sessionContext, new PathUrl(fullyQualifiedPath + "(BriefInformationMap)"));
                }
                if (informationMap == null) {
                    throw new ServletException(RB.getStringResource(RB_KEY, "noIQServiceSession.txt"));
                }
                if (informationMap.getStructure().isOLAP()) {
                    dataSelection = DataSelectionFactory.newSampleDataSelection((BusinessModel)informationMap, null);
                    BusinessQueryToOLAPDataSetAdapter adapter = new BusinessQueryToOLAPDataSetAdapter();
                    adapter.setModel((BusinessQuery)dataSelection);
                    viewer = new OLAPTableViewComposite();
                    ((OLAPTableViewComposite)viewer).setModel((OLAPDataSetInterface)adapter);
                    ((OLAPTableViewComposite)viewer).getComponent("OLAPTABLEVIEW_MENUBAR").setVisible(true);
                } else if (informationMap.getStructure().isRelational()) {
                    dataSelection = DataSelectionFactory.newSampleDataSelection((BusinessModel)informationMap, null);
                    BusinessQueryToTableModelAdapter adapter = new BusinessQueryToTableModelAdapter();
                    adapter.setModel((BusinessQuery)dataSelection);
                    viewer = new TableViewComposite();
                    ((TableViewComposite)viewer).setModel((TableModel)adapter);
                    ((TableViewComposite)viewer).getComponent("TABLEVIEW_MENUBAR").setVisible(true);
                }
                this.actionProvider = new HttpActionProvider();
                this.actionProvider.setLocale(request.getLocale());
                String newAPNAME = "sas_InformationMapViewerServlet_" + this.actionProvider.getName();
                this.actionProvider.setName(newAPNAME);
                if (viewer instanceof HttpActionProviderInterface) {
                    ((HttpActionProviderInterface)((Object)viewer)).setActionProvider(this.actionProvider);
                }
                session.setAttribute(newAPNAME, (Object)this.actionProvider);
                session.setAttribute("sas_InformationMapViewerServlet_" + viewer.getName(), (Object)viewer);
                this.actionProvider.addExternalRequestParameter(null, "VIEWERNAME", viewer.getName());
            }
            catch (MetadataException e) {
                throw new ServletException(e.getMessage());
            }
        } else if (this.actionProvider != null) {
            this.actionProvider.executeCommand(request, response, out);
            String viewerName = null;
            Map parms = this.actionProvider.getExternalRequestParameters();
            for (Object key : parms.keySet()) {
                if (!key.equals("VIEWERNAME")) continue;
                viewerName = (String)parms.get(key);
                break;
            }
            viewer = (TransformationInterface)session.getAttribute("sas_InformationMapViewerServlet_" + viewerName);
        } else {
            throw new ServletException(RB.getStringResource(RB_KEY, "noActionProvider.txt"));
        }
        if (viewer == null) {
            throw new ServletException(RB.getStringResource(RB_KEY, "noViewer.txt"));
        }
        viewer.setRequest(request);
        viewer.setResponse(response);
        out.println("<html><head>");
        Components.init(out, request);
        out.println("</head><body>");
        viewer.write(out);
        out.println("</body></html>");
    }
}

