/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.YearType;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.TimePicker;
import com.sas.servlet.tbeans.html.TimeStampPicker;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.swing.visuals.DateFormatter;
import com.sas.text.NLFormats;
import com.sas.text.NLInformats;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

@SASScope
public class DateUtil {
    public static final String DEFAULT_AJAX_URL_RELATIVE_VALUE_TEMPLATE = "%BASE_AJAX_URL(%BASE_AJAX_URL)%AJAX_URL_SUFFIX(%AJAX_URL_SUFFIX)CLASS_PARAMETER=" + DateUtil.class.getName() + "&id=%id";
    public static final String TIMESTAMP_PATTERN = "MM/dd/yyyy hh:mm:ss aaa";
    public static final String TIMESTAMP_24_HOUR_PATTERN = "MM/dd/yyyy HH:mm:ss";
    private static DateFormat TIMESTAMP_PARSER = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aaa", Locale.US);
    private static DateFormat TIMESTAMP_24_HOUR_PARSER = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.US);
    public static final String TIME_PATTERN = NLFormats.getPattern((String)TimeType.DEFAULT_INSTANCE.getDefaultFormatName(), (Locale)Locale.US);
    public static final String TIME_24_HOUR_PATTERN = "HH:mm:ss";
    private static DateFormat TIME_PARSER = new SimpleDateFormat(TIME_PATTERN, Locale.US);
    private static DataTypeInterface TIME_FORMATTER = DateUtil.getDataTypeFromDateString(DateTypes.TIME.toString(), TimeZone.getDefault());
    public static final String WEEK_PATTERN = NLFormats.getPattern((String)WeekType.DEFAULT_INSTANCE.getDefaultFormatName(), (Locale)Locale.US);
    private static DataTypeInterface WEEK_FORMATTER = DateUtil.getDataTypeFromDateString(DateTypes.WEEK.toString(), TimeZone.getDefault());

    public static void parseDate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        PrintWriter out = response.getWriter();
        String value = request.getParameter("value");
        String type = request.getParameter("type");
        String isRelativeString = request.getParameter("isRelative");
        boolean isRelative = Boolean.parseBoolean(isRelativeString);
        String format = request.getParameter("format");
        Locale locale = request.getLocale();
        DatePeriod datePeriod = null;
        DateFormat dateFormat = null;
        TimeZone tz = TimeZone.getDefault();
        DataTypeInterface dataType = DateUtil.getDataTypeFromDateString(type, tz);
        boolean honor24Hour = false;
        boolean use12Hour = DateUtil.use12Hour(locale);
        String pickerID = request.getParameter("id");
        if (pickerID != null) {
            BaseCompositeTransformation picker;
            TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID);
            if (ti instanceof TimeStampPicker) {
                picker = (TimeStampPicker)ti;
                honor24Hour = ((TimeStampPicker)picker).isHonor24HourLocale();
                SimpleDateFormat localizedDateFormat = ((TimeStampPicker)picker).getFormat();
                if (localizedDateFormat != null) {
                    dateFormat = localizedDateFormat;
                    format = localizedDateFormat.toLocalizedPattern();
                }
            } else if (ti instanceof TimePicker) {
                picker = (TimePicker)ti;
                honor24Hour = ((TimePicker)picker).isHonor24HourLocale();
            }
        }
        if (type.equals(DateTypes.DATE.toString()) || type.equals(DateTypes.TIMESTAMP.toString())) {
            value = DateUtil.removeBiDiCharacters(StringUtils.trimToNull((String)request.getParameter("value")));
            format = DateUtil.removeBiDiCharacters(request.getParameter("format"));
        }
        if (format == null && !DateUtil.use12Hour(locale) && honor24Hour) {
            if (type.equals(DateTypes.TIME.toString())) {
                format = TIME_24_HOUR_PATTERN;
            } else if (type.equals(DateTypes.TIMESTAMP.toString())) {
                format = NLInformats.getPattern((String)"NLDATML", (Locale)locale);
            }
        }
        out.print("var return_Obj = {");
        if (dateFormat == null) {
            dateFormat = format != null ? new SimpleDateFormat(format, request.getLocale()) : ((BaseDateType)dataType).getDateFormatter(null, request.getLocale());
        }
        DateFormatter formatter = new DateFormatter(dateFormat, DateTypes.valueOf((String)type), null, tz, request.getLocale());
        Object parsedObject = null;
        try {
            if (parsedObject == null) {
                parsedObject = formatter.stringToValue(value);
            }
            if (parsedObject instanceof DatePeriod) {
                datePeriod = (DatePeriod)parsedObject;
            } else if (parsedObject instanceof Date) {
                datePeriod = new DatePeriod((Date)parsedObject, DateTypes.valueOf((String)type), request.getLocale());
            }
        }
        catch (Exception e) {
            out.print("error : \"" + Strings.escapeForJavaScript((String)e.getLocalizedMessage(), (boolean)true) + "\"}");
            return;
        }
        if (dataType != null && datePeriod != null) {
            int hour;
            int year = datePeriod.getYear() + 1900;
            if (type.equals(DateTypes.DATE.toString()) || type.equals(DateTypes.WEEKDAY.toString())) {
                out.print("month : \"" + datePeriod.getMonth() + "\",");
                out.print("date : \"" + datePeriod.getDate() + "\",");
                out.print("year : \"" + year + "\"");
            } else if (type.equals(DateTypes.TIME.toString())) {
                if (!use12Hour && honor24Hour && !datePeriod.isRelativeDate()) {
                    try {
                        parsedObject = dateFormat.parse(value);
                    }
                    catch (ParseException e) {
                        try {
                            parsedObject = formatter.stringToValue(value);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)parsedObject);
                    hour = calendar.get(11);
                } else {
                    hour = datePeriod.getHour() == 0 ? 12 : datePeriod.getHour();
                }
                out.print("hour : \"" + hour + "\",");
                out.print("minute : \"" + datePeriod.getMinutes() + "\",");
                out.print("seconds : \"" + datePeriod.getSeconds() + "\",");
                String am_pm = honor24Hour && !use12Hour ? "" : (datePeriod.getAMPM() == 0 ? "AM" : "PM");
                out.print("am_pm : \"" + am_pm + "\"");
            } else if (type.equals(DateTypes.TIMESTAMP.toString())) {
                if (!use12Hour && honor24Hour && !datePeriod.isRelativeDate()) {
                    try {
                        dateFormat = new SimpleDateFormat(NLInformats.getPattern((String)"NLDATML", (Locale)request.getLocale()), request.getLocale());
                        parsedObject = dateFormat.parse(value);
                    }
                    catch (ParseException e) {
                        try {
                            parsedObject = formatter.stringToValue(value);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)parsedObject);
                    hour = calendar.get(11);
                } else {
                    hour = datePeriod.getHour() == 0 ? 12 : datePeriod.getHour();
                }
                out.print("month : \"" + datePeriod.getMonth() + "\",");
                out.print("date : \"" + datePeriod.getDate() + "\",");
                out.print("year : \"" + year + "\",");
                out.print("hour : \"" + hour + "\",");
                out.print("minute : \"" + datePeriod.getMinutes() + "\",");
                out.print("seconds : \"" + datePeriod.getSeconds() + "\",");
                String am_pm = honor24Hour && !use12Hour ? "" : (datePeriod.getAMPM() == 0 ? "AM" : "PM");
                out.print("am_pm : \"" + am_pm + "\"");
            } else if (type.equals(DateTypes.YEAR.toString())) {
                out.print("year : \"" + year + "\"");
            } else if (type.equals(DateTypes.QUARTER.toString())) {
                out.print("quarter : \"" + datePeriod.getQuarter() + "\",");
                out.print("year : \"" + year + "\"");
            } else if (type.equals(DateTypes.MONTH.toString())) {
                out.print("month : \"" + datePeriod.getMonth() + "\",");
                out.print("year : \"" + year + "\"");
            } else if (type.equals(DateTypes.WEEK.toString())) {
                out.print("month : \"" + datePeriod.getMonth() + "\",");
                out.print("week : \"" + datePeriod.getWeek() + "\",");
                out.print("year : \"" + year + "\"");
            } else {
                out.print("}");
                return;
            }
            if (isRelative) {
                String relativeString = "";
                relativeString = format != null ? dateFormat.format((Date)datePeriod) : dataType.getDisplayString((Object)datePeriod.getStartOfPeriod(), request.getLocale());
                out.print(",");
                out.print("relativeString : \"" + relativeString + "\"");
            }
        }
        out.print("}");
    }

    public static String removeBiDiCharacters(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder newValue = new StringBuilder(value.length());
        int len = value.length();
        block3: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\u200e': 
                case '\u200f': 
                case '\u202a': 
                case '\u202e': {
                    continue block3;
                }
                default: {
                    newValue.append(ch);
                }
            }
        }
        return newValue.toString();
    }

    public static DataTypeInterface getDataTypeFromDateString(String type, TimeZone tz) {
        DateType dataType = null;
        if (tz != null) {
            if (type.equals(DateTypes.DATE.toString())) {
                dataType = new DateType(tz);
            } else if (type.equals(DateTypes.TIME.toString())) {
                dataType = new TimeType(tz);
            } else if (type.equals(DateTypes.TIMESTAMP.toString())) {
                dataType = new TimeStampType(tz);
            } else if (type.equals(DateTypes.YEAR.toString())) {
                dataType = new YearType(tz);
            } else if (type.equals(DateTypes.QUARTER.toString())) {
                dataType = new QuarterType(tz);
            } else if (type.equals(DateTypes.MONTH.toString())) {
                dataType = new MonthType(tz);
            } else if (type.equals(DateTypes.WEEK.toString())) {
                dataType = new WeekType(tz);
            }
        } else if (type.equals(DateTypes.DATE.toString())) {
            dataType = new DateType();
        } else if (type.equals(DateTypes.TIME.toString())) {
            dataType = new TimeType();
        } else if (type.equals(DateTypes.TIMESTAMP.toString())) {
            dataType = new TimeStampType();
        } else if (type.equals(DateTypes.YEAR.toString())) {
            dataType = new YearType();
        } else if (type.equals(DateTypes.QUARTER.toString())) {
            dataType = new QuarterType();
        } else if (type.equals(DateTypes.MONTH.toString())) {
            dataType = new MonthType();
        } else if (type.equals(DateTypes.WEEK.toString())) {
            dataType = new WeekType();
        }
        return dataType;
    }

    public static void getTodayFormattedDate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        PrintWriter out = response.getWriter();
        int monthValue = Integer.parseInt(request.getParameter("month"));
        int dayValue = Integer.parseInt(request.getParameter("day"));
        int yearValue = Integer.parseInt(request.getParameter("year"));
        TimeZone tz = TimeZone.getDefault();
        out.print("var return_Obj = {");
        Calendar cal = Calendar.getInstance(tz, request.getLocale());
        cal.set(yearValue, monthValue, dayValue);
        Date d1 = cal.getTime();
        String todaysLocalizedString = Strings.escapeForJavaScript((String)DateFormat.getDateInstance(0, request.getLocale()).format(d1));
        out.print("todayLocaleString : \"" + todaysLocalizedString + "\"");
        out.print("}");
    }

    public static void getLocalizedTimeStamp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        TransformationInterface ti;
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String pickerID = request.getParameter("id");
        boolean honor24Hour = false;
        if (pickerID != null && (ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID)) instanceof TimeStampPicker) {
            TimeStampPicker picker = (TimeStampPicker)ti;
            honor24Hour = picker.isHonor24HourLocale();
            SimpleDateFormat localizedDateFormat = picker.getFormat();
            if (picker.isHonor24HourLocale() && localizedDateFormat == null && !DateUtil.use12Hour(request.getLocale())) {
                localizedDateFormat = new SimpleDateFormat(NLInformats.getPattern((String)"NLDATML", (Locale)request.getLocale()), request.getLocale());
            }
            if (localizedDateFormat != null) {
                boolean is24HourFormat;
                boolean bl = is24HourFormat = !DateUtil.use12Hour(request.getLocale()) && picker.isHonor24HourLocale();
                if (is24HourFormat) {
                    DateUtil.writeLocalizedDateTimeValue(request.getParameter("value"), response.getWriter(), TIMESTAMP_24_HOUR_PARSER, localizedDateFormat);
                } else {
                    DateUtil.writeLocalizedDateTimeValue(request.getParameter("value"), response.getWriter(), TIMESTAMP_PARSER, localizedDateFormat);
                }
                return;
            }
        }
        if (honor24Hour && !DateUtil.use12Hour(request.getLocale())) {
            SimpleDateFormat localizedDateFormat = new SimpleDateFormat(NLInformats.getPattern((String)"NLDATML", (Locale)request.getLocale()), request.getLocale());
            DateUtil.writeLocalizedDateTimeValue(request.getParameter("value"), response.getWriter(), TIMESTAMP_PARSER, localizedDateFormat);
        } else {
            DateUtil.writeLocalizedDateTimeValue(request.getParameter("value"), response.getWriter(), TIMESTAMP_PARSER, TIMESTAMP_PARSER);
        }
    }

    public static void getLocalizedTime(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String pickerID = request.getParameter("id");
        boolean honor24Hour = false;
        if (pickerID != null) {
            BaseCompositeTransformation picker;
            TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID);
            if (ti instanceof TimeStampPicker) {
                picker = (TimeStampPicker)ti;
                honor24Hour = ((TimeStampPicker)picker).isHonor24HourLocale();
            } else if (ti instanceof TimePicker) {
                picker = (TimePicker)ti;
                honor24Hour = ((TimePicker)picker).isHonor24HourLocale();
            }
        }
        Locale locale = request.getLocale();
        if (!honor24Hour || DateUtil.use12Hour(request.getLocale())) {
            DateUtil.writeLocalizedDateTimeValue(request.getParameter("value"), request, response.getWriter(), TIME_PARSER, TIME_FORMATTER);
        } else {
            String pattern = DateUtil.use12Hour(request.getLocale()) ? TIME_PATTERN : TIME_24_HOUR_PATTERN;
            SimpleDateFormat sm = new SimpleDateFormat(pattern, locale);
            DateUtil.writeLocalizedDateTimeValue(request.getParameter("value"), request, response.getWriter(), sm, TIME_FORMATTER);
        }
    }

    private static boolean use12Hour(Locale locale) {
        DateFormat instance = DateFormat.getTimeInstance(1, locale);
        String pattern = ((SimpleDateFormat)instance).toPattern();
        return pattern.indexOf("a") >= 0;
    }

    public static void getLocalizedWeek(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String startWeekOn = request.getParameter("startWeekOn");
        int start = 1;
        if (startWeekOn != null && "1".equals(startWeekOn.trim())) {
            start = 2;
        }
        Calendar usCal = Calendar.getInstance(Locale.US);
        usCal.setFirstDayOfWeek(start);
        usCal.setMinimalDaysInFirstWeek(4);
        SimpleDateFormat parser = new SimpleDateFormat(WEEK_PATTERN, Locale.US);
        parser.setCalendar(usCal);
        DateUtil.writeLocalizedDateTimeValue(request.getParameter("value"), request, response.getWriter(), parser, WEEK_FORMATTER);
    }

    private static void writeLocalizedDateTimeValue(String value, HttpServletRequest request, PrintWriter writer, DateFormat parser, DataTypeInterface formatter) {
        writer.print("var return_Obj = {");
        Date parsed = DateUtil.parseDateTimeValue(value, parser, writer);
        if (parsed == null) {
            return;
        }
        boolean honor24Hour = false;
        String pickerID = request.getParameter("id");
        if (pickerID != null) {
            BaseCompositeTransformation picker;
            TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID);
            if (ti instanceof TimeStampPicker) {
                picker = (TimeStampPicker)ti;
                honor24Hour = ((TimeStampPicker)picker).isHonor24HourLocale();
            } else if (ti instanceof TimePicker) {
                picker = (TimePicker)ti;
                honor24Hour = ((TimePicker)picker).isHonor24HourLocale();
            }
        }
        Locale locale = request.getLocale();
        String relativeString = !honor24Hour || DateUtil.use12Hour(locale) ? formatter.getDisplayString((Object)parsed, locale) : (DateUtil.use12Hour(locale) ? formatter.getDisplayString((Object)parsed, locale) : DateUtil.getDisplayTimeString(parsed, locale, formatter, parser));
        writer.print("relativeString : \"" + relativeString + "\"");
        writer.print("}");
    }

    private static String getDisplayTimeString(Object value, Locale locale, DataTypeInterface formatter, DateFormat parser) {
        if (value instanceof DatePeriod || value instanceof MissingValues || value instanceof SpecialValues || value instanceof Calendar) {
            return formatter.getDisplayString(value, locale);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            return null;
        }
        if (value instanceof MissingValues) {
            return MissingValues.toQueryString((MissingValues)((MissingValues)value));
        }
        return parser.format(value);
    }

    private static void writeLocalizedDateTimeValue(String value, PrintWriter writer, DateFormat parser, DateFormat formatter) {
        writer.print("var return_Obj = {");
        Date parsed = DateUtil.parseDateTimeValue(value, parser, writer);
        if (parsed == null) {
            return;
        }
        String relativeString = formatter.format(parsed);
        writer.print("relativeString : \"" + relativeString + "\"");
        writer.print("}");
    }

    private static Date parseDateTimeValue(String value, DateFormat parser, PrintWriter writer) {
        Date parsed = null;
        try {
            parsed = parser.parse(value);
        }
        catch (ParseException e) {
            writer.print("error : \"" + Strings.escapeForJavaScript((String)e.getLocalizedMessage(), (boolean)true) + "\"}");
        }
        return parsed;
    }
}

