/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.valuepicker;

import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.AjaxTreeView;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.tableview.ajax.AJAXTableController;
import com.sas.servlet.tbeans.tableview.html.CellContentsNoRowsRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.html.TableViewComposite;
import com.sas.servlet.tbeans.valuepicker.RB;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.tbeans.valuepicker.ValuePickerTableViewComposite;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.table.MutableTableColumnsInterface;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.TableModel;

public class ValuePickerSearch
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "ValuePicker.";
    public static final int SINGLE_SELECTION = 300;
    public static final int MULTIPLE_SELECTION = 301;
    public static final int ORDERED_MULTIPLE_SELECTION = 302;
    private int selectionMode;
    private String imageLocation;
    private ValueProviderInterface valueProvider;
    private TransformationInterface sourceComponent;
    private ChoiceBox searchChoice;
    private TextEntry searchValue;
    private Button searchButton;
    private Label searchLabel;
    public static String VALUEPICKER_SOURCE_COMPONENT = "VALUEPICKER_SOURCE_COMPONENT";
    public static String VALUEPICKER_SEARCH = "VALUEPICKER_SEARCH";
    public static String VALUEPICKER_SEARCH_CHOICE = "VALUEPICKER_SEARCH_CHOICE";
    public static String VALUEPICKER_SEARCH_LABEL = "VALUEPICKER_SEARCH_LABEL";
    public static String VALUEPICKER_SEARCH_VALUE = "VALUEPICKER_SEARCH_VALUE";
    public static String VALUEPICKER_SEARCH_BUTTON = "VALUEPICKER_SEARCH_BUTTON";
    public static String VALUEPICKER_SEARCH_APPLY = "VALUEPICKER_SEARCH_APPLY";
    public static String VALUEPICKER_SEARCH_CANCEL = "VALUEPICKER_SEARCH_CANCEL";
    private String onChange;
    private String onFocus;
    private String onBlur;
    private Object selectedValue;
    private Object values;
    private Form formObject;
    private boolean formEnabled;
    private AJAXTableController tableController;
    private ValuePicker valuePicker;
    private String valuePickerId;

    public ValuePickerSearch(ValueProviderInterface valueProvider, int selectionMode, ValuePicker valuePicker, Locale locale) {
        this.selectionMode = selectionMode;
        this.valueProvider = valueProvider;
        this.setTemplateKey("Value_Picker_Search");
        this.setTemplateDictionary(new HashMap());
        this.setObjectDataProperty("selectedValue");
        this.setId(Util.getName((String)"vps"));
        this.valuePicker = valuePicker;
        this.valuePickerId = valuePicker.getId();
        this.addSearchComponents();
        this.addSearchSourceComponent();
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    public void updateComponents(ValueProviderInterface valueProvider, Locale currentLocale) {
        this.valueProvider = valueProvider;
        if (this.searchChoice != null) {
            this.searchChoice.setModel(this.getSearchChoiceModel(currentLocale));
        }
        if (this.searchButton != null) {
            this.searchButton.setLabel(RB.getStringResource(RB_KEY, "search.txt", currentLocale));
        }
        if (this.searchLabel != null) {
            this.searchLabel.setText(RB.getStringResource(RB_KEY, "searchLabel.txt", currentLocale));
        }
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        this.updateComponents(this.valueProvider, currentLocale);
    }

    private ComboBoxModel getSearchChoiceModel(Locale locale) {
        DefaultComboBoxModel<Item> model = new DefaultComboBoxModel<Item>();
        model.addElement(new Item(RB.getStringResource(RB_KEY, "contains.txt", locale), SearchCriteria.OPERATOR_CONTAINS.toString()));
        model.addElement(new Item(RB.getStringResource(RB_KEY, "equalTo.txt", locale), SearchCriteria.OPERATOR_EQUAL.toString()));
        model.addElement(new Item(RB.getStringResource(RB_KEY, "startWith.txt", locale), SearchCriteria.OPERATOR_STARTS_WITH.toString()));
        model.addElement(new Item(RB.getStringResource(RB_KEY, "endWith.txt", locale), SearchCriteria.OPERATOR_ENDS_WITH.toString()));
        model.addElement(new Item(RB.getStringResource(RB_KEY, "match.txt", locale), SearchCriteria.OPERATOR_MATCH_PATTERN.toString()));
        return model;
    }

    public void addSearchComponents() {
        this.searchChoice = new ChoiceBox();
        this.searchValue = new TextEntry();
        this.searchButton = new Button();
        this.searchLabel = new Label();
        this.setComponent(VALUEPICKER_SEARCH_CHOICE, this.searchChoice);
        this.setComponent(VALUEPICKER_SEARCH_VALUE, this.searchValue);
        this.setComponent(VALUEPICKER_SEARCH_BUTTON, this.searchButton);
        this.searchLabel.setStyleInfo((StyleInfo)this.valuePicker.getStyleMap().get(ValuePicker.VALUEPICKER_LABEL_STYLE));
        this.setComponent(VALUEPICKER_SEARCH_LABEL, this.searchLabel);
    }

    public void addTableFeatures(TableView tv) {
        if (tv.getFeatures().find(AJAXTableController.class) == null) {
            this.tableController = AJAXTableController.save(tv, this.getRequest());
            this.tableController.setUpdateRowSelections(true);
            CellContentsNoRowsRenderer renderer = (CellContentsNoRowsRenderer)tv.getDefaultNoRowsRenderer();
            renderer.setText("");
            if (this.selectionMode == 301 || this.selectionMode == 302) {
                this.tableController.getRowSelections().setSelectionMode(2);
                DefaultTableCellRenderer defaultRenderer = (DefaultTableCellRenderer)tv.getDefaultRenderer();
                defaultRenderer.setCustomAttributes("onDblClick='" + this.getId() + "_Obj.add();'");
            } else {
                this.tableController.getRowSelections().setSelectionMode(1);
            }
            this.tableController.setContainerId(tv.getContainerId());
            tv.getFeatures().add(this.tableController);
        }
    }

    private void updateValuePickerId() {
        this.valuePickerId = this.valuePicker.getId();
        this.searchChoice.setId(this.valuePickerId + "_searchChoice");
        this.searchValue.setId(this.valuePickerId + "_searchValue");
        this.searchButton.setId(this.valuePickerId + "_searchButton");
        this.sourceComponent.setId(this.valuePickerId + "_valuePickerSourceSearch");
    }

    public void prepareSourceForWrite() {
        if (this.sourceComponent instanceof TableViewComposite) {
            TableView tv = (TableView)((TableViewComposite)this.sourceComponent).getComponent("TABLEVIEW_TABLEDATA");
            tv.setId(this.getId() + "vpsTable");
            this.addTableFeatures(tv);
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        try {
            this.updateValuePickerId();
            this.sourceComponent = this.getComponent(VALUEPICKER_SOURCE_COMPONENT);
            this.sourceComponent.setRequest(this.getRequest());
            this.sourceComponent.setResponse(this.getResponse());
            if (this.sourceComponent instanceof TableViewComposite) {
                ValuePicker caller;
                ((TableViewComposite)this.sourceComponent).getStyleMap().put("TABLEVIEW_CONTENT_STYLE", new StyleInfo("valuePickerSource valuePickerSearchTable"));
                ((TableViewComposite)this.sourceComponent).getStyleMap().put("TABLEVIEW_CONTAINER_STYLE", new StyleInfo("valuePickerFixedSourceSize valuePickerSearchTable"));
                ((TableViewComposite)this.sourceComponent).setAJAXControllerURL(this.getAJAXControllerURL());
                TableView tv = (TableView)((TableViewComposite)this.sourceComponent).getComponent("TABLEVIEW_TABLEDATA");
                tv.setLockColumnHeaders(false);
                tv.setRowHeaderVisible(false);
                ValueProviderModelAdapter modelAdapter = new ValueProviderModelAdapter(this.valueProvider, 603, null, 100, this.getLocale());
                boolean tree = false;
                if (this.valuePicker.getCallerId() != null && (caller = (ValuePicker)ComponentSessionManager.getSessionManager(this.valuePicker.getRequest()).get(this.valuePicker.getCallerId())) != null && caller.getComponent(ValuePicker.VALUEPICKER_SOURCE_COMPONENT) instanceof AjaxTreeView) {
                    tree = true;
                }
                this.valuePicker.setTableModelColumns((MutableTableColumnsInterface)modelAdapter, this.valueProvider, tree, this.getLocale());
                tv.setColumnHeaderVisible(this.valueProvider.isValueDisplayed() || tree);
                try {
                    ((TableViewComposite)this.sourceComponent).setModel((TableModel)modelAdapter.getModel());
                }
                catch (ValueProviderException e) {
                    e.printStackTrace();
                }
            }
            if (this.tableController != null) {
                this.tableController.getRowSelections().clearSelection();
            }
            JavaScriptIncludeHandler.writeIncludes(out, "VALUEPICKER", this.getRequest());
            this.getTemplateDictionary().put("ID", this.valuePickerId + "_container");
            this.getTemplateDictionary().put("SEARCH_ID", this.valuePickerId + "_search");
            this.getTemplateDictionary().put("SEARCH_SOURCE_ID", this.valuePickerId + "_searchSource");
            if (this.searchButton != null) {
                this.searchButton.setOnClick(this.valuePickerId + "_Obj.search()");
            }
            if (this.sourceComponent != null) {
                this.prepareSourceForWrite();
                if (this.sourceComponent instanceof JavaScriptEventHandlerInterface) {
                    if (this.getOnChange() != null) {
                        ((JavaScriptEventHandlerInterface)((Object)this.sourceComponent)).setOnChange(this.getOnChange());
                    }
                    if (this.getOnBlur() != null) {
                        ((JavaScriptEventHandlerInterface)((Object)this.sourceComponent)).setOnBlur(this.getOnBlur());
                    }
                    if (this.getOnFocus() != null) {
                        ((JavaScriptEventHandlerInterface)((Object)this.sourceComponent)).setOnFocus(this.getOnFocus());
                    }
                }
            }
            TemplateSupport.writeTemplate(this, null, out);
        }
        catch (Exception ex) {
            LoggerRepository2.getLogger((String)ValuePickerSearch.class.getName(), null).error(ex.getMessage(), (Throwable)ex);
        }
    }

    public String getSourceId() {
        if (this.sourceComponent instanceof TableViewComposite) {
            return ((TableViewComposite)this.sourceComponent).getComponent("TABLEVIEW_TABLEDATA").getId();
        }
        return null;
    }

    public String getImageLocation() {
        if (this.imageLocation != null) {
            return this.imageLocation;
        }
        return ComponentPropertyManager.getInstance(this.getRequest()).getImageLocation();
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public ValueProviderInterface getValueProvider() {
        return this.valueProvider;
    }

    public TableViewComposite getDefaultTableView() {
        this.sourceComponent = new ValuePickerTableViewComposite(this.valuePicker == null ? null : this.valuePicker.getDataType());
        TableView tv = (TableView)((TableViewComposite)this.sourceComponent).getComponent("TABLEVIEW_TABLEDATA");
        if (this.valuePicker.getFormObject() != null) {
            tv.setFormEnabled(false);
            tv.setFormObject(this.getFormObject());
        }
        this.setComponent(VALUEPICKER_SOURCE_COMPONENT, this.sourceComponent);
        return (TableViewComposite)this.sourceComponent;
    }

    public void addSearchSourceComponent() {
        if (this.sourceComponent == null) {
            this.sourceComponent = this.getDefaultTableView();
        }
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    @Override
    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnFocus(String onFocus) {
        this.onFocus = onFocus;
    }

    public Object getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(Object selectedValue) {
        if (this.selectionMode == 300) {
            if (selectedValue != null) {
                if (selectedValue instanceof Object[]) {
                    ((BaseTransformation)this.sourceComponent).setObjectData(((String[])selectedValue)[0]);
                } else {
                    ((BaseTransformation)this.sourceComponent).setObjectData(selectedValue);
                }
            }
        } else if (selectedValue == null) {
            this.sourceComponent = this.getComponent(VALUEPICKER_SOURCE_COMPONENT);
            if (this.sourceComponent instanceof TableViewComposite) {
                ((TableViewComposite)this.sourceComponent).setModel(null);
            }
        }
        this.selectedValue = selectedValue;
    }

    public Object getValues() {
        return this.values;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setFormObject(Form form) {
        this.formObject = form;
    }

    public Form getFormObject() {
        return this.formObject;
    }

    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    public void setFormEnabled(boolean enabled) {
        this.formEnabled = enabled;
    }

    public void setValueProvider(ValueProviderInterface valueProvider) {
        if (this.valuePicker != valueProvider) {
            this.valueProvider = valueProvider;
        }
    }
}

