/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.util.BaseUtil;
import com.sas.util.SimpleTemplate;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class ServerSideInputValidator
extends JavaScriptValidator
implements AJAXControllerURLInterface {
    private String ajaxControllerURL = null;
    private SimpleTemplate ajaxURLTemplate;
    protected String dataTypeId;

    public ServerSideInputValidator() {
        this("STRING");
    }

    public ServerSideInputValidator(String typeId) {
        this.dataTypeId = typeId;
        this.ajaxURLTemplate = new SimpleTemplate();
        this.ajaxURLTemplate.setTemplate(BaseUtil.AJAX_BASEUTIL_URL_TEMPLATE);
        this.ajaxURLTemplate.setValueDictionary(new HashMap());
    }

    @Override
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        if (bean != null && this.getAJAXControllerURL() != null) {
            super.writeJavaScriptValidatorObject(out, bean);
            out.println(this.getId() + "_Obj.validatorType = \"ServerSideValidator\";");
            Map map = this.ajaxURLTemplate.getValueDictionary();
            map.put("BASE_AJAX_URL", this.getAJAXControllerURL());
            if (this.getAJAXControllerURL().indexOf("?") == -1) {
                map.put("AJAX_URL_SUFFIX", "?");
            } else {
                map.put("AJAX_URL_SUFFIX", "&");
            }
            map.put("id", bean.getId());
            out.println(bean.getId() + "_Obj.validateOnServer = function(callback) {");
            out.println("\tvar bean = " + bean.getId() + "_Obj;");
            out.println("\turl = '" + this.ajaxURLTemplate.format() + "'");
            out.println("\tparms = {");
            out.println("\t\tMETHOD : \"validateByType\",");
            out.println("\t\ttype : \"" + String.valueOf(this.dataTypeId) + "\",");
            out.println("\t\tvalue : bean.getValue()");
            out.println("\t};\n\tsas.ajax.send(url, parms, callback);\n};");
        }
    }

    public String getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(String dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    @Override
    public String createValidationFunctionCall(TransformationInterface bean) {
        return "true";
    }

    @Override
    public String getAJAXControllerURL() {
        return this.ajaxControllerURL;
    }

    @Override
    public void setAJAXControllerURL(String ajaxControllerURL) {
        this.ajaxControllerURL = ajaxControllerURL;
    }
}

