/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.tbeans.util.validators.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.PrintWriter;

@SASScope(value="ALL")
public class MinimumValueValidator
extends JavaScriptValidator {
    public static final String INTEGER = "INTEGER";
    public static final String FLOAT = "FLOAT";
    @SASScope
    public static final String RB_KEY = "MinimumValueValidator.";
    @SASScope
    protected int min;
    protected String type;

    public MinimumValueValidator() {
        this(0);
    }

    public MinimumValueValidator(int min) {
        this.setValidationFunctionName("sas_Validator_isMinValueValid");
        this.min = min;
        this.type = INTEGER;
    }

    public void setMinValue(int min) {
        this.min = min;
    }

    public int getMinValue() {
        return this.min;
    }

    @SASScope
    public void setType(String type) {
        this.type = type;
    }

    @SASScope
    public String getType() {
        return this.type;
    }

    @Override
    @SASScope
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        super.writeJavaScriptValidatorObject(out, bean);
        out.println(this.getId() + "_Obj.validatorType = \"MinimumValueValidator\";");
        out.println(this.getId() + "_Obj.type = \"" + this.getType() + "\";");
        out.println(this.getId() + "_Obj.minValue = " + this.getMinValue() + ";");
        if (this.getValidationMessage() != null) {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getValidationMessage().toString()) + "\";");
        } else {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)Message.format((String)RB.getStringResource(RB_KEY, "lessThanMinValue.txt", bean.getLocale()), (Object)this.getDescription(bean), (Object)Integer.toString(this.min))) + "\";");
        }
    }

    @Override
    protected String getDefaultValidationMessage(TransformationInterface bean) {
        return Message.format((String)RB.getStringResource(RB_KEY, "lessThanMinValue.txt", bean.getLocale()), (Object)this.getDescription(bean));
    }

    @Override
    protected String getValidationParameters(TransformationInterface bean) {
        return "min: " + this.min + ", type:'" + this.type + "'";
    }
}

