/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.Calendar;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.tbeans.util.validators.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;

@SASScope
public class DateTimeStringValidator
extends JavaScriptValidator {
    public static final String RB_KEY = "DateTimeValidator.";
    private String containerId;
    protected SimpleDateFormat format;

    public DateTimeStringValidator() {
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 1);
        Calendar.convertShortDateFormatTo4DigitYear(dateFormat);
        this.format = dateFormat;
        this.setValidationFunctionName("sas_Validator_isDateTimeStringValid");
    }

    public DateTimeStringValidator(String formatString) {
        this(new SimpleDateFormat(formatString));
    }

    public DateTimeStringValidator(int dateStyle, int timeStyle) {
        this(DateFormat.getDateTimeInstance(dateStyle, timeStyle));
    }

    public DateTimeStringValidator(DateFormat format) {
        this.setValidationFunctionName("sas_Validator_isDateTimeStringValid");
        this.format = (SimpleDateFormat)format;
    }

    public void setFormat(DateFormat newFormat) {
        this.format = (SimpleDateFormat)newFormat;
    }

    public DateFormat getFormat() {
        return this.format;
    }

    public String getMonthValueString(Locale locale) {
        return RB.getStringResource(RB_KEY, "monthValueArr.txt", locale);
    }

    public String getShortMonthString(Locale locale) {
        return RB.getStringResource(RB_KEY, "shortMonthPat.txt", locale);
    }

    public String getFullMonthString(Locale locale) {
        return RB.getStringResource(RB_KEY, "fullMonthPat.txt", locale);
    }

    @Override
    protected String getDefaultValidationMessage(TransformationInterface bean) {
        return Message.format((String)RB.getStringResource(RB_KEY, "invalidDateTime.txt", bean.getLocale()), (Object)this.getDescription(bean));
    }

    @Override
    protected String getValidationParameters(TransformationInterface bean) {
        StringBuffer sb = new StringBuffer();
        if (this.format == null) {
            this.format = new SimpleDateFormat();
        }
        StringBuffer formatString = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.format.toPattern(), "/ - . :  ", true);
        if (st.countTokens() > 1) {
            while (st.hasMoreTokens()) {
                if (st.countTokens() != 2 && st.countTokens() != 4 && st.countTokens() != 6 && st.countTokens() != 8 && st.countTokens() != 10 && st.countTokens() != 12 && st.countTokens() != 14 && st.countTokens() != 16 && st.countTokens() != 18 && st.countTokens() != 20) {
                    formatString.append("%");
                }
                String token = st.nextToken();
                formatString.append(token);
                if (token != "yyyy") continue;
                formatString.append(",");
            }
        } else {
            String tempPattern = this.format.toPattern();
            formatString.append("%");
            formatString.append(tempPattern.charAt(0));
            for (int i = 1; i < tempPattern.length(); ++i) {
                if (tempPattern.substring(i, i + 1).equals(tempPattern.substring(i - 1, i))) {
                    formatString.append(tempPattern.charAt(i));
                    continue;
                }
                formatString.append("%");
                formatString.append(tempPattern.charAt(i));
            }
        }
        sb.append("format: '").append(Strings.escapeForJavaScript((String)formatString.toString())).append("'");
        sb.append(", monthValueString:'" + Strings.escapeForJavaScript((String)this.getMonthValueString(bean.getLocale()))).append("'");
        sb.append(", fullMonthString:'" + Strings.escapeForJavaScript((String)this.getFullMonthString(bean.getLocale()))).append("'");
        sb.append(", shortMonthString:'" + Strings.escapeForJavaScript((String)this.getShortMonthString(bean.getLocale()))).append("'");
        sb.append(", containerId:'" + this.getContainerId()).append("'");
        return sb.toString();
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Override
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        super.writeJavaScriptValidatorObject(out, bean);
        out.println(this.getId() + "_Obj.validatorType = \"DateTimeStringValidator\";");
        out.println(this.getId() + "_Obj.format = \"" + this.getFormat().toString() + "\";");
        if (this.getValidationMessage() != null) {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getValidationMessage().toString()) + "\";");
        } else {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getDefaultValidationMessage(bean)) + "\";");
        }
    }
}

