/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.Calendar;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.tbeans.util.validators.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;

@SASScope(value="ALL")
public class DateStringValidator
extends JavaScriptValidator {
    @SASScope
    public static final String RB_KEY = "DateValidator.";
    private String containerId;
    @SASScope
    protected SimpleDateFormat format;

    public DateStringValidator() {
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);
        Calendar.convertShortDateFormatTo4DigitYear(dateFormat);
        this.format = dateFormat;
        this.setValidationFunctionName("sas_Validator_isDateStringValid");
    }

    public DateStringValidator(String formatString) {
        this(new SimpleDateFormat(formatString));
    }

    public DateStringValidator(int dateStyle) {
        this(DateFormat.getDateInstance(dateStyle));
    }

    public DateStringValidator(DateFormat format) {
        this.setValidationFunctionName("sas_Validator_isDateStringValid");
        this.format = (SimpleDateFormat)format;
    }

    public void setFormat(DateFormat newFormat) {
        this.format = (SimpleDateFormat)newFormat;
    }

    public DateFormat getFormat() {
        return this.format;
    }

    @SASScope
    public String getMonthValueString(Locale locale) {
        return RB.getStringResource(RB_KEY, "monthValueArr.txt", locale);
    }

    @SASScope
    public String getShortMonthString(Locale locale) {
        return RB.getStringResource(RB_KEY, "shortMonthPat.txt", locale);
    }

    @SASScope
    public String getFullMonthString(Locale locale) {
        return RB.getStringResource(RB_KEY, "fullMonthPat.txt", locale);
    }

    @Override
    protected String getDefaultValidationMessage(TransformationInterface bean) {
        return Message.format((String)RB.getStringResource(RB_KEY, "invalidDate.txt", bean.getLocale()), (Object)this.getDescription(bean));
    }

    @Override
    protected String getValidationParameters(TransformationInterface bean) {
        StringBuffer sb = new StringBuffer();
        if (this.format == null) {
            this.format = new SimpleDateFormat();
        }
        StringBuffer formatString = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.format.toPattern(), "/ - .  ", true);
        if (st.countTokens() > 1) {
            while (st.hasMoreTokens()) {
                if (st.countTokens() != 2 && st.countTokens() != 4) {
                    formatString.append("%");
                }
                formatString.append(st.nextToken());
            }
        } else {
            String tempPattern = this.format.toPattern();
            formatString.append("%");
            formatString.append(tempPattern.charAt(0));
            for (int i = 1; i < tempPattern.length(); ++i) {
                if (tempPattern.substring(i, i + 1).equals(tempPattern.substring(i - 1, i))) {
                    formatString.append(tempPattern.charAt(i));
                    continue;
                }
                formatString.append("%");
                formatString.append(tempPattern.charAt(i));
            }
        }
        sb.append("format: '").append(Strings.escapeForJavaScript((String)formatString.toString())).append("'");
        sb.append(", monthValueString:'" + Strings.escapeForJavaScript((String)this.getMonthValueString(bean.getLocale()))).append("'");
        sb.append(", fullMonthString:'" + Strings.escapeForJavaScript((String)this.getFullMonthString(bean.getLocale()))).append("'");
        sb.append(", shortMonthString:'" + Strings.escapeForJavaScript((String)this.getShortMonthString(bean.getLocale()))).append("'");
        sb.append(", containerId:'" + this.getContainerId()).append("'");
        return sb.toString();
    }

    @SASScope
    public String getContainerId() {
        return this.containerId;
    }

    @SASScope
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Override
    @SASScope
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        super.writeJavaScriptValidatorObject(out, bean);
        out.println(this.getId() + "_Obj.validatorType = \"DateStringValidator\";");
        out.println(this.getId() + "_Obj.format = \"" + this.getFormat().toString() + "\";");
        if (this.getValidationMessage() != null) {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getValidationMessage().toString()) + "\";");
        } else {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getDefaultValidationMessage(bean)) + "\";");
        }
    }
}

