/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.rpf.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.html.CellContentsLabelRenderer;
import com.sas.servlet.tbeans.tableview.rpf.html.ImageAction;
import com.sas.servlet.tbeans.tableview.rpf.html.TextAction;
import java.io.IOException;
import java.io.PrintWriter;

@SASScope
public class CompositeCellContentsRenderer
extends CellContentsLabelRenderer {
    public static final int RENDER_LEFT = 1;
    public static final int RENDER_RIGHT = 2;
    public static final int RENDER_REPLACEMENT = 3;
    public static final int RENDER_ALL = 4;
    private BaseTransformation leftComponent_;
    private BaseTransformation rightComponent_;
    private BaseTransformation replacementComponent_;
    private int positionToRender = 3;
    private boolean renderForExcel = false;

    public void write(PrintWriter out, int position) throws IOException {
        this.setRenderPosition(position);
        this.write(out);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.positionToRender == 1) {
            this.writeComponent(out, this.leftComponent_);
            this.leftComponent_ = null;
        } else if (this.positionToRender == 3) {
            if (this.replacementComponent_ != null) {
                this.writeComponent(out, this.replacementComponent_);
            } else {
                super.write(out);
            }
            this.replacementComponent_ = null;
        } else if (this.positionToRender == 2) {
            this.writeComponent(out, this.rightComponent_);
            this.rightComponent_ = null;
        }
        if (this.positionToRender == 4) {
            this.writeComponent(out, this.leftComponent_);
            if (this.replacementComponent_ != null) {
                this.writeComponent(out, this.replacementComponent_);
            } else {
                super.write(out);
            }
            this.writeComponent(out, this.rightComponent_);
            this.replacementComponent_ = null;
            this.leftComponent_ = null;
            this.rightComponent_ = null;
        }
    }

    public void setRenderPosition(int position) {
        this.positionToRender = position;
    }

    public int getRenderPosition() {
        return this.positionToRender;
    }

    public boolean isRenderForExcel() {
        return this.renderForExcel;
    }

    public void setRenderForExcel(boolean renderForExcel) {
        this.renderForExcel = renderForExcel;
    }

    public void writeComponent(PrintWriter out, BaseTransformation component) throws IOException {
        if (component != null) {
            if (component instanceof TableCellContentsRenderer) {
                TableCellContentsRenderer tccr = (TableCellContentsRenderer)((Object)component);
                tccr.setActions(this.getActions());
                tccr.setTableView(this.getTableView());
            }
            String oldImageURL = null;
            if (this.isRenderForExcel()) {
                oldImageURL = this.absoluteImageURL(component);
            }
            component.setLocale(this.getLocale());
            component.setRequest(this.getRequest());
            component.setResponse(this.getResponse());
            if (component instanceof TextAction) {
                out.println("<NOBR>");
            }
            component.write(out);
            if (component instanceof TextAction) {
                out.println("</NOBR>");
            }
            if (oldImageURL != null && component instanceof ImageAction) {
                ((ImageAction)component).setImage(oldImageURL);
            }
        } else {
            out.println("<span style=\"font-size:1px\">&#160;</span>");
        }
    }

    public void reset() {
        this.setLeftComponent(null);
        this.setReplacementComponent(null);
        this.setRightComponent(null);
        this.setRenderPosition(3);
    }

    public BaseTransformation getCurrentComponent() {
        BaseTransformation component = null;
        if (this.positionToRender == 1) {
            component = this.getLeftComponent();
        } else if (this.positionToRender == 3) {
            component = this.getReplacementComponent();
        } else if (this.positionToRender == 2) {
            component = this.getRightComponent();
        }
        return component;
    }

    public BaseTransformation getRightComponent() {
        return this.rightComponent_;
    }

    public void setRightComponent(BaseTransformation rightComponent) {
        this.rightComponent_ = rightComponent;
    }

    public BaseTransformation getLeftComponent() {
        return this.leftComponent_;
    }

    public void setLeftComponent(BaseTransformation leftComponent) {
        this.leftComponent_ = leftComponent;
    }

    public BaseTransformation getReplacementComponent() {
        return this.replacementComponent_;
    }

    public void setReplacementComponent(BaseTransformation replacementComponent) {
        this.replacementComponent_ = replacementComponent;
    }

    private String absoluteImageURL(BaseTransformation component) {
        if (component instanceof ImageAction) {
            String origImageURL = ((ImageAction)component).getImage();
            if (this.getRequest() != null && origImageURL != null && origImageURL.indexOf("http") == -1) {
                String imageURL = this.getRequest().getScheme() + "://" + this.getRequest().getServerName() + ":" + this.getRequest().getServerPort() + origImageURL;
                ((ImageAction)component).setImage(imageURL);
                return origImageURL;
            }
        }
        return null;
    }
}

