/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.rpf;

import com.sas.MissingValues;
import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.Util;
import com.sas.codepolicy.SASScope;
import com.sas.commands.dataselectors.exceptionhighlighting.RuleExtension;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingOLAPRule;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingUtil;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.rpf.ActionInterface;
import com.sas.rpf.Context;
import com.sas.rpf.Rule;
import com.sas.rpf.RuleInterface;
import com.sas.rpf.TargetInterface;
import com.sas.rpf.data.CharacterValue;
import com.sas.rpf.data.DataVector;
import com.sas.rpf.data.MissingValue;
import com.sas.rpf.data.NumericValue;
import com.sas.rpf.data.ValueInterface;
import com.sas.rpf.data.Variable;
import com.sas.rpf.expr.EvaluateException;
import com.sas.rpf.expr.Expression;
import com.sas.rpf.expr.ExpressionInterface;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.olaptableview.BaseOLAPTableView;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.rpf.ActionLocation;
import com.sas.servlet.tbeans.tableview.rpf.LocationInterface;
import com.sas.servlet.tbeans.tableview.rpf.html.CompositeCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.rpf.html.ConditionTableCellRenderer;
import com.sas.servlet.tbeans.tableview.rpf.html.ImageAction;
import com.sas.servlet.tbeans.tableview.rpf.html.TextAction;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.swing.util.Action;
import com.sas.swing.visuals.olaptableview.OLAPCellRendererManager;
import com.sas.swing.visuals.olaptableview.OLAPTableFormatArea;
import com.sas.table.FormattedInterface;
import com.sas.util.Strings;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.table.TableModel;

@SASScope
public class RulesUtil {
    public static ValueInterface getValue(Object o) {
        if (o instanceof Number) {
            return new NumericValue(((Number)o).doubleValue());
        }
        if (o instanceof String) {
            return new CharacterValue((String)o);
        }
        if (o instanceof MissingValues) {
            return new MissingValue();
        }
        if (o instanceof Date) {
            return new NumericValue((double)((Date)o).getTime());
        }
        return null;
    }

    public static void addLevels(DataVector dataVector, TupleElementInterface[] tuples, TupleElementInterface measure) throws OLAPException {
        for (int i = 0; i < tuples.length; ++i) {
            TupleElementInterface tuple = tuples[i];
            if (tuple == measure) continue;
            String uLevelName = tuple.getUniqueLevelName();
            int index1 = uLevelName.indexOf(93, 1);
            String dim = uLevelName.substring(1, index1);
            int index2 = uLevelName.indexOf(93, index1 + 1);
            String hierarchy = uLevelName.substring(index1 + 3, index2);
            int index3 = uLevelName.indexOf(93, index2 + 1);
            String level = null;
            if (index3 < 0) {
                level = hierarchy;
                hierarchy = "*";
                String startingDim = uLevelName.substring(0, index1 + 1);
                hierarchy = RulesUtil.findHierarchyForDimension(tuple, startingDim);
                if (hierarchy == null) {
                    hierarchy = dim;
                }
            } else {
                level = uLevelName.substring(index2 + 3, index3);
            }
            dataVector.setDrillLevel(dim, hierarchy, level);
        }
    }

    private static String findHierarchyForDimension(TupleElementInterface tuple, String startingDim) throws OLAPException {
        String[] hiers = tuple.getTuple().getAxis().getHierarchyNames();
        for (int j = 0; j < hiers.length; ++j) {
            String hier = hiers[j];
            if (!hier.startsWith(startingDim)) continue;
            return hier.substring(startingDim.length() + 2, hier.length() - 1);
        }
        return null;
    }

    public static void addMembers(DataVector dataVector, TupleElementInterface[] col, TupleElementInterface[] row, OLAPCellRendererManager mgr) throws OLAPException {
        RulesUtil.addMembers(dataVector, col, mgr);
        RulesUtil.addMembers(dataVector, row, mgr);
    }

    public static void addMembers(DataVector dataVector, TupleElementInterface[] tuples, OLAPCellRendererManager mgr) throws OLAPException {
        for (int i = 0; i < tuples.length; ++i) {
            BusinessQuery businessQuery;
            BusinessModel businessModel;
            StructureOfData structure;
            String variable;
            TupleElementInterface tuple = tuples[i];
            if (TupleElementType.MEASURE.equals(tuple.getType()) || tuple.isContextual()) continue;
            String key = variable = mgr.getResultSetID(tuple);
            String memberName = tuple.getName();
            OLAPDataSetInterface dataSet = mgr.getDataSet();
            if (dataSet instanceof BusinessQueryProviderInterface && !(structure = (businessModel = (businessQuery = ((BusinessQueryProviderInterface)dataSet).getBusinessQuery()).getBusinessModel()).getStructure()).isOLAP()) {
                memberName = tuple.getLabel();
            }
            CharacterValue value = new CharacterValue(memberName);
            dataVector.setValue(key, (ValueInterface)value);
        }
    }

    public static void setValueOnDataVector(DataVector dataVector, String name, TableModel tableModel, int row, int col, Locale locale) {
        if (tableModel instanceof FormattedInterface) {
            FormattedInterface fi = (FormattedInterface)tableModel;
            try {
                String formatted = fi.getFormattedValueAt(row - 1, col);
                dataVector.setFormattedValue(name, RulesUtil.getValue(formatted));
                Object unformatted = fi.getUnformattedValueAt(row - 1, col);
                dataVector.setValue(name, RulesUtil.getValue(unformatted));
                return;
            }
            catch (Exception ex) {
                String formatted = fi.getFormattedValueAt(row - 1, col);
                dataVector.setValue(name, RulesUtil.getValue(RulesUtil.parse(formatted, locale)));
                return;
            }
        }
        Object formatted = tableModel.getValueAt(row - 1, col);
        ValueInterface value = RulesUtil.getValue(formatted);
        dataVector.setValue(name, value);
        dataVector.setFormattedValue(name, value);
    }

    private static Object parse(String formattedValue, Locale locale) {
        String value = formattedValue.trim();
        if (value.length() == 0) {
            return formattedValue;
        }
        if (value.charAt(0) == '$') {
            value = value.substring(1);
        }
        try {
            Number dValue = NumberFormat.getInstance(locale).parse(value);
            return new Double(dValue.doubleValue());
        }
        catch (ParseException parseException) {
            Object ret = RulesUtil.parseAllFormats(value, locale);
            if (ret != null) {
                return ret;
            }
            if (locale != null && locale.getCountry().equals("EN")) {
                ret = RulesUtil.parseAllFormats(value, Locale.ENGLISH);
            }
            if (ret != null) {
                return ret;
            }
            return formattedValue;
        }
    }

    private static Object parseAllFormats(String value, Locale locale) {
        Object ret = RulesUtil.parse(NumberFormat.getCurrencyInstance(locale), value);
        if (ret != null) {
            return ret;
        }
        ret = RulesUtil.parse(NumberFormat.getPercentInstance(locale), value);
        if (ret != null) {
            return ret;
        }
        ret = RulesUtil.parse(NumberFormat.getNumberInstance(locale), value);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private static Object parse(NumberFormat format, String value) {
        try {
            Number dValue = format.parse(value);
            return new Double(dValue.doubleValue());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static void validateRules(AbstractBaseTableView table) {
        CommonLoggerInterface log = LoggerRepository2.getLogger((String)RulesUtil.class.getPackage().getName(), null);
        Context cleanContext = new Context();
        for (Rule rule : table.getRulesContext().getRules()) {
            try {
                Set vars = rule.extractVariables();
                Iterator ruleVarsIterator = vars.iterator();
                boolean validRule = true;
                while (ruleVarsIterator.hasNext()) {
                    Variable var = (Variable)ruleVarsIterator.next();
                    String name = var.getName();
                    if (RulesUtil.findDataItemByResultSetId(table, name) != null) continue;
                    validRule = false;
                    break;
                }
                if (validRule && table instanceof BaseOLAPTableView) {
                    RulesUtil.validateRuleLevels((BaseOLAPTableView)table, rule);
                }
                if (validRule && table instanceof TableView) {
                    RulesUtil.validateWholeRowRule(table, rule);
                }
                if (validRule) {
                    cleanContext.addRule((RuleInterface)rule);
                    continue;
                }
                List<TargetInterface> targets = Arrays.asList(rule.getTargets());
                table.removeCellRenderers(targets);
            }
            catch (EvaluateException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        table.setRulesContext(cleanContext);
    }

    private static void validateWholeRowRule(AbstractBaseTableView table, Rule rule) {
        if (!(rule instanceof RuleExtension)) {
            return;
        }
        RuleExtension ehsRule = (RuleExtension)rule;
        if (ehsRule.isWholeRow()) {
            TargetInterface[] targets = rule.getTargets();
            int colCount = table.getColumnCount();
            if (colCount != targets.length) {
                ActionInterface[] actions = rule.getActionsForTarget(targets[0]);
                TableView relTable = (TableView)table;
                for (int colI = targets.length; colI < colCount; ++colI) {
                    ConditionTableCellRenderer newTarget = new ConditionTableCellRenderer();
                    relTable.setCellRenderer(1, -1, 1, colI + 1, colI + 1, 1, newTarget);
                    rule.add((TargetInterface)newTarget, actions);
                }
            }
        }
    }

    private static void validateRuleLevels(BaseOLAPTableView table, Rule rule) {
        ExceptionHighlightingOLAPRule olapRule;
        String[] levels;
        CommonLoggerInterface log = LoggerRepository2.getLogger((String)RulesUtil.class.getPackage().getName(), null);
        if (rule instanceof RuleExtension && (levels = (olapRule = (ExceptionHighlightingOLAPRule)((RuleExtension)rule).getExceptionHighlightingRule()).getSelectedLevels()) != null) {
            ArrayList<String> cleanLevels = new ArrayList<String>();
            ArrayList<String> dirtyLevels = new ArrayList<String>();
            for (int i = 0; i < levels.length; ++i) {
                if (!(table.getModel() instanceof BusinessQueryToOLAPDataSetAdapter)) continue;
                BusinessQueryToOLAPDataSetAdapter bqadapter = (BusinessQueryToOLAPDataSetAdapter)table.getModel();
                boolean foundHierarchy = false;
                for (DataItem dataItem : bqadapter.getBusinessQuery().getResultItems()) {
                    if (!dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) continue;
                    String uniqueHierarchyName = null;
                    try {
                        uniqueHierarchyName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)dataItem.getBusinessModel(), (DataItem)dataItem);
                    }
                    catch (MetadataException e1) {
                        e1.printStackTrace();
                    }
                    if (uniqueHierarchyName == null || !uniqueHierarchyName.equalsIgnoreCase(RulesUtil.getUniqueHierarchyName(levels[i]))) continue;
                    foundHierarchy = true;
                    break;
                }
                if (foundHierarchy) {
                    cleanLevels.add(levels[i]);
                    continue;
                }
                dirtyLevels.add(levels[i]);
            }
            if (dirtyLevels.size() > 0) {
                olapRule.setSelectedLevels(cleanLevels.toArray(new String[0]));
                ExpressionInterface expression = null;
                try {
                    expression = Expression.compile((String)olapRule.getExpression());
                }
                catch (com.sas.rpf.exception.ParseException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (expression != null) {
                    rule.setExpression(expression);
                }
                OLAPTableView otv = (OLAPTableView)table;
                TargetInterface[] targets = rule.getTargets();
                for (int i = 0; i < targets.length; ++i) {
                    OLAPTableFormatArea[] areas = otv.getCellRendererAreas(targets[i]);
                    OLAPTableFormatArea area = null;
                    for (int j = 0; j < areas.length; ++j) {
                        area = areas[j];
                        area.clearLevelMap();
                        String[] selectedLevels = olapRule.getSelectedLevels();
                        if (selectedLevels == null) continue;
                        for (int l = 0; l < selectedLevels.length; ++l) {
                            area.setLevel(ExceptionHighlightingUtil.getDimensionName((String)selectedLevels[l]), ExceptionHighlightingUtil.getHierarchyName((String)selectedLevels[l]), ExceptionHighlightingUtil.getLevelName((String)selectedLevels[l]));
                        }
                    }
                }
            }
        }
    }

    private static String getUniqueHierarchyName(String uniqueLevelName) {
        return "[" + ExceptionHighlightingUtil.getDimensionName((String)uniqueLevelName) + "].[" + ExceptionHighlightingUtil.getHierarchyName((String)uniqueLevelName) + "]";
    }

    private static DataItem findDataItemByResultSetId(AbstractBaseTableView table, String resultSetId) {
        DataItem item = null;
        TableModel model = null;
        model = table instanceof TableView ? ((TableView)table).getModel() : ((OLAPTableView)table).getModel();
        if (model != null && model instanceof BusinessQueryProviderInterface) {
            BusinessQuery query = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            for (DataItem dataItem : query.getResultItems()) {
                if (!dataItem.getResultSetID().equals(resultSetId)) continue;
                item = dataItem;
                break;
            }
        }
        return item;
    }

    @SASScope
    public static List getMultiColumnRules(Context context) {
        Collection rules;
        ArrayList<Rule> list = new ArrayList<Rule>();
        if (context != null && (rules = context.getRules()) != null && rules.size() > 0) {
            for (Rule rule : rules) {
                if (!RulesUtil.isMultiColumnRule(rule)) continue;
                list.add(rule);
            }
        }
        return list;
    }

    @SASScope
    public static Rule findWholeRowRule(Context rulesContext) {
        if (rulesContext == null) {
            return null;
        }
        Collection rules = rulesContext.getRules();
        for (Rule rule : rules) {
            if (!(rule instanceof RuleExtension)) continue;
            RuleExtension ehRule = (RuleExtension)rule;
            if (rule.getTargets().length <= 0) continue;
            return rule;
        }
        return null;
    }

    @SASScope
    public static boolean isWholeRowRuleMulticolumn(Context rulesContext) {
        Rule wholeRowRule = RulesUtil.findWholeRowRule(rulesContext);
        return wholeRowRule != null && RulesUtil.isMultiColumnRule(wholeRowRule);
    }

    @SASScope
    public static boolean isMultiColumnRule(Rule rule) {
        TargetInterface[] targets = rule.getTargets();
        for (int i = 0; i < targets.length; ++i) {
            TargetInterface target = targets[i];
            ActionInterface[] actions = rule.getActionsForTarget(target);
            for (int j = 0; j < actions.length; ++j) {
                LocationInterface location2;
                ActionInterface action = actions[j];
                if (!(action instanceof LocationInterface) || (location2 = (LocationInterface)action).getLocation() == ActionLocation.REPLACEMENT) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateActionsForConditions(TableCellRenderer renderer, ActionList actionList, String dataCell) {
        if (actionList == null) {
            return;
        }
        BaseTransformation replacement = null;
        if (!(renderer.getTableCellContentsRenderer() instanceof CompositeCellContentsRenderer)) {
            return;
        }
        ((ConditionTableCellRenderer)renderer).createComponents();
        CompositeCellContentsRenderer cccr = (CompositeCellContentsRenderer)renderer.getTableCellContentsRenderer();
        replacement = cccr.getReplacementComponent();
        if (replacement == null) {
            return;
        }
        List actions = actionList.getActions();
        for (int i = 0; i < actions.size(); ++i) {
            Object obj = actions.get(i);
            if (!(obj instanceof Action)) continue;
            Action action = (Action)obj;
            String val = Util.getLabel(action);
            char[] xmlSpecial = new char[]{'&', '\"', '<', '>', '-'};
            String[] xmlReplacements = new String[]{"&amp;", "&quot;", "&lt;", "&gt;", "&#8722;"};
            if (!(dataCell = Strings.replace((String)dataCell, (char[])xmlSpecial, (String[])xmlReplacements)).trim().equals(val.trim())) continue;
            if (replacement instanceof ImageAction) {
                ImageAction image = (ImageAction)replacement;
                String imageName = image.getImage();
                action.putValue("SmallIconName", (Object)imageName);
                action.putValue("Name", null);
                action.putValue("Label", null);
                break;
            }
            if (!(replacement instanceof TextAction)) break;
            TextAction text = (TextAction)replacement;
            String textString = text.getText();
            action.putValue("Label", (Object)textString);
            action.putValue("Name", null);
            break;
        }
    }
}

