/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html.features;

import com.sas.servlet.tbeans.features.DnDFeature;
import com.sas.servlet.tbeans.features.Feature;
import com.sas.servlet.tbeans.features.dnd.ZoneElement;
import com.sas.servlet.tbeans.features.dnd.ZoneInfo;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.ajax.AJAXTableController;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.swing.table.TableModel;

public class TableDnDFeature
extends DnDFeature
implements Feature {
    private TableView _tableView;

    public TableDnDFeature(TableView tableView) {
        this._tableView = tableView;
        String[] zones = new String[]{"Columns"};
        this.setDragZones(this.createZoneList(zones, true));
        this.setDropZones(this.createZoneList(zones, false));
        this.setZoneInfos(this.createZoneInfoList(zones));
        this.setDropHandler("sas_DnD_Table_handleDrop");
    }

    @Override
    public void write(HttpServletRequest request, Writer out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "AJAX", request);
        AJAXTableController.writeFastClickProtection(out, request, false);
        TableModel model = this._tableView.getModel();
        this.fillZones(model);
        super.write(request, out, this._tableView.getId());
    }

    private void fillZones(TableModel model) {
        try {
            this.fillZone(this.getZoneInfo("Columns"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillZone(ZoneInfo zone) {
        for (int i = this._tableView.getStartColumn(); i <= this._tableView.getEndColumn(); ++i) {
            ZoneElement ze = this.addZoneElement(zone, i + 1);
            this.addToZoneElement(ze, i + 1);
        }
    }

    protected void addToZoneElement(ZoneElement ze, int i) {
    }

    private ZoneElement addZoneElement(ZoneInfo zone, int i) {
        String orientation = "HORIZONTAL";
        String suffix = "_c";
        String id = this._tableView.getId() + suffix + i;
        ZoneElement ze = this.createZoneElement(zone, id, Integer.toString(i), orientation);
        String header = this.calculateHeaderText(i);
        ze.addProperty("label", header);
        return ze;
    }

    private String calculateHeaderText(int i) {
        TableModel model = this._tableView.getModel();
        TableColumn column = this._tableView.getColumnModel().getColumn(i - 1);
        String header = column.getHeaderValue();
        if (header == null && column.getModelIndex() != -1) {
            header = model.getColumnName(column.getModelIndex());
        }
        return header;
    }

    private ZoneElement createZoneElement(ZoneInfo zone, String id, String name, String orientation) {
        ZoneElement element = new ZoneElement(id, name, orientation);
        zone.addElement(element);
        return element;
    }

    public TableView getTableView() {
        return this._tableView;
    }
}

