/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html.features;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.servlet.tbeans.tableview.ajax.AJAXPacket;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.html.TableViewComposite;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.table.MoveColumnInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class TableDnDAction {
    TableView _tableView;
    TableViewComposite _tableViewComposite;
    private String _sourceId;
    private String[] _sourceItemIds;
    private String _targetId;
    private String _placement;

    TableDnDAction(TableView tableView) {
        this._tableView = tableView;
    }

    TableDnDAction(TableViewComposite tableViewComposite) {
        this._tableViewComposite = tableViewComposite;
        this._tableView = TableDnDAction.convertToTableView(tableViewComposite);
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("id");
        if (id.endsWith("_tv")) {
            id = id.substring(0, id.length() - 3);
        }
        HttpSession session = request.getSession();
        Object tbeanObj = session.getAttribute(id);
        TableDnDAction.handleAction(request, response, tbeanObj);
    }

    private static void handleAction(HttpServletRequest request, HttpServletResponse response, Object tbeanObj) throws Exception {
        TableDnDAction action = tbeanObj instanceof TableViewComposite ? new TableDnDAction((TableViewComposite)tbeanObj) : new TableDnDAction((TableView)tbeanObj);
        action.moveColumn(request, response);
        AJAXPacket packet = new AJAXPacket();
        action.sendEntireTable(packet);
        packet.send(response);
    }

    private static TableView convertToTableView(Object tbeanObj) {
        if (tbeanObj instanceof TableViewComposite) {
            TableViewComposite composite = (TableViewComposite)tbeanObj;
            return (TableView)composite.getComponent("TABLEVIEW_TABLEDATA");
        }
        return (TableView)tbeanObj;
    }

    void moveColumn(HttpServletRequest request, HttpServletResponse response) {
        this._tableView.setRequest(request);
        this._tableView.setResponse(response);
        this.parseParameters(request);
        if (this._sourceId == null) {
            try {
                this.addColumn();
            }
            catch (IQueryServicesException e) {
                e.printStackTrace();
            }
            return;
        }
        this.moveColumn();
    }

    public void moveColumn() {
        boolean before;
        int sourceCol = Integer.parseInt(this._sourceId);
        int targetCol = Integer.parseInt(this._targetId);
        boolean bl = before = !"false".equals(this._placement);
        if (!before) {
            ++targetCol;
        }
        if (sourceCol < targetCol) {
            --targetCol;
        }
        Object obj = null;
        if (this._tableView.getModel() instanceof MoveColumnInterface) {
            obj = this._tableView.getModel();
            --sourceCol;
            --targetCol;
        } else {
            obj = this._tableView;
        }
        ((MoveColumnInterface)obj).moveColumn(sourceCol, targetCol);
    }

    public void addColumn() throws IQueryServicesException {
        int targetCol = Integer.parseInt(this._targetId);
        boolean before = !"false".equals(this._placement);
        --targetCol;
        if (!before) {
            ++targetCol;
        }
        BusinessQueryToTableModelAdapter adapter = (BusinessQueryToTableModelAdapter)this._tableView.getModel();
        BusinessQuery bq = adapter.getModel();
        BusinessModel bm = bq.getBusinessModel();
        List availableDIs = bm.getObjects(true, DataItem.class);
        ArrayList<DataItem> sourceDIs = new ArrayList<DataItem>();
        for (int j = 0; j < this._sourceItemIds.length; ++j) {
            String sId = this._sourceItemIds[j];
            for (int i = 0; i < availableDIs.size(); ++i) {
                DataItem di = (DataItem)availableDIs.get(i);
                if (!sId.equals(di.getResultSetID())) continue;
                sourceDIs.add(di);
            }
        }
        for (int i = 0; i < sourceDIs.size(); ++i) {
            DataItem di = (DataItem)sourceDIs.get(i);
            bq.insertResultItemsAt(di, Role.COLUMN, targetCol + i);
        }
        adapter.refreshBusinessQuery(bq);
        adapter.refresh();
    }

    private void parseParameters(HttpServletRequest request) {
        this._sourceId = request.getParameter("sourceId");
        this._sourceItemIds = request.getParameterValues("sourceDII");
        this._targetId = request.getParameter("targetId");
        this._placement = request.getParameter("isBefore");
    }

    private void sendEntireTable(AJAXPacket packet) throws IOException {
        String html = this.generateEntireTable();
        packet.add(html, "type", "table");
        String id = null;
        id = this._tableViewComposite != null ? this._tableViewComposite.getContainerId() : this._tableView.getContainerId();
        if (id == null) {
            id = "tableDIV_" + this._tableView.getId();
        }
        packet.set("containerId", id);
    }

    private String generateEntireTable() throws IOException {
        StringWriter strOut = new StringWriter();
        PrintWriter strPrintWriter = new PrintWriter(strOut);
        HttpServletRequest request = this._tableView.getRequest();
        HttpServletResponse response = this._tableView.getResponse();
        if (this._tableViewComposite != null) {
            this._tableViewComposite.writePartialRefresh(request, response, strPrintWriter);
        } else {
            this._tableView.writePartialRefresh(request, response, strPrintWriter);
        }
        String html = strOut.toString();
        return html;
    }
}

