/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.html.TreeTableView;
import com.sas.servlet.tbeans.tableview.BaseColumnHeader;
import com.sas.servlet.tbeans.tableview.BaseRowHeader;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.DefaultTableColumnModel;
import com.sas.servlet.tbeans.tableview.DefaultTableRowModel;
import com.sas.servlet.tbeans.tableview.HttpEditController;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.TableCellEditor;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.TableRowModel;
import com.sas.servlet.tbeans.tableview.TableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.BaseTableCell;
import com.sas.servlet.tbeans.tableview.html.CellContentsNoRowsRenderer;
import com.sas.servlet.tbeans.tableview.html.ColumnHeader;
import com.sas.servlet.tbeans.tableview.html.DefaultRowSelectionRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellEditor;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.HtmlTableViewUtil;
import com.sas.servlet.tbeans.tableview.html.RowHeader;
import com.sas.servlet.tbeans.tableview.html.TableViewStyleKeysInterface;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TableView
extends BaseTableView
implements FormViewInterface,
TableViewStyleKeysInterface {
    static final long serialVersionUID = -6360150214086367475L;
    static final String RB_KEY = "TableView.";
    private Form formObject;
    private HashMap additionalParameters;
    private TableCellRenderer defaultRenderer;
    private TableCellEditor defaultEditor;
    private TableRowRenderer defaultRowRenderer;
    private TableRowRenderer defaultColumnHeaderRowRenderer;
    private TableCellContentsRenderer defaultNoRowsRenderer;
    private boolean formEnabled;
    private static final HashMap defaultStyleMap;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("TABLEVIEW_STYLE", new ImmutableStyleInfo("mainTable"));
            defaultStyleMap.put("TABLEVIEW_ROW_HEADER_STYLE", new ImmutableStyleInfo("tableRowHeader"));
            defaultStyleMap.put("TABLEVIEW_COLUMN_HEADER_STYLE", new ImmutableStyleInfo("tableColumnHeader"));
            defaultStyleMap.put("TABLEVIEW_DATA_STYLE", new ImmutableStyleInfo("tableData"));
            defaultStyleMap.put("TABLEVIEW_DATA_NUMERIC_STYLE", new ImmutableStyleInfo("tableDataNumeric"));
            defaultStyleMap.put("TABLEVIEW_EMPTY_DATA_STYLE", new ImmutableStyleInfo("emptyTableData"));
            defaultStyleMap.put("TABLEVIEW_ROW_STYLE", new ImmutableStyleInfo("tableRow"));
            defaultStyleMap.put("TABLEVIEW_TOTALS_ROW_STYLE", new ImmutableStyleInfo("tableTotalsRow"));
            defaultStyleMap.put("TABLEVIEW_COLUMN_HEADER_ROW_STYLE", new ImmutableStyleInfo("tableColumnHeaderRow"));
            defaultStyleMap.put("TABLEVIEW_EDIT_COLUMN_CELL_STYLE", new ImmutableStyleInfo("tableEditColumnCell"));
            defaultStyleMap.put("TABLEVIEW_EDIT_ROW_CELL_STYLE", new ImmutableStyleInfo("tableEditRowCell"));
            defaultStyleMap.put("TABLEVIEW_ROW_SELECTION_STYLE", new ImmutableStyleInfo("tableRowSelectionCell"));
            defaultStyleMap.put("OLAPTABLEVIEW_TITLE_ROW_STYLE", new ImmutableStyleInfo("tableTitleRow"));
            defaultStyleMap.put("OLAPTABLEVIEW_FOOTER_ROW_STYLE", new ImmutableStyleInfo("tableFooterRow"));
        }
    }

    public TableView() {
        this(null, null, null);
    }

    public TableView(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public TableView(TableModel tableModel, TableColumnModel columnModel) {
        this(tableModel, columnModel, null);
    }

    public TableView(TableModel tm, TableColumnModel cm, TableRowModel rm) {
        if (cm == null) {
            cm = this.getDefaultColumnModel();
            this.setAutoCreateColumnsFromModel(true);
        } else {
            this.setAutoCreateColumnsFromModel(false);
        }
        this.setColumnModel(cm);
        if (rm == null) {
            rm = this.getDefaultRowModel();
        }
        this.setRowModel(rm);
        this.setModel(tm);
        this.setFormEnabled(true);
        TableView.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
    }

    public TableView(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public TableView(final Object[][] rowData, final Object[] columnNames) {
        this(new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return columnNames[column].toString();
            }

            @Override
            public int getRowCount() {
                return rowData.length;
            }

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return rowData[row][col];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                rowData[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
        });
    }

    public TableView(final Vector rowData, final Vector columnNames) {
        this(new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return columnNames.elementAt(column).toString();
            }

            @Override
            public int getRowCount() {
                return rowData.size();
            }

            @Override
            public int getColumnCount() {
                return columnNames.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return ((Vector)rowData.elementAt(row)).elementAt(column);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                ((Vector)rowData.elementAt(row)).setElementAt(value, column);
                this.fireTableCellUpdated(row, column);
            }
        });
    }

    @Override
    public TableColumnModel getDefaultColumnModel() {
        DefaultTableColumnModel defaultColumnModel = new DefaultTableColumnModel();
        return defaultColumnModel;
    }

    @Override
    public TableRowModel getDefaultRowModel() {
        return new DefaultTableRowModel();
    }

    @Override
    public BaseColumnHeader getDefaultColumnHeader() {
        return new ColumnHeader(this, this.getColumnModel());
    }

    @Override
    public BaseRowHeader getDefaultRowHeader() {
        return new RowHeader(this);
    }

    @Override
    public void setFormObject(Form form) {
        this.formObject = form;
    }

    @Override
    public Form getFormObject() {
        if (this.formObject == null) {
            this.formObject = this.getDefaultFormObject();
        }
        return this.formObject;
    }

    @Override
    public Form getDefaultFormObject() {
        return BaseUtil.getDefaultFormObject(this, this.getRequest(), this.getResponse());
    }

    @Override
    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    @Override
    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap();
        }
        this.additionalParameters.put(name, value);
    }

    @Override
    public void setFormEnabled(boolean enable) {
        this.formEnabled = enable;
    }

    @Override
    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    @Override
    public TableCellRenderer getDefaultRenderer() {
        if (this.defaultRenderer == null) {
            this.defaultRenderer = new DefaultTableCellRenderer();
        }
        return this.defaultRenderer;
    }

    public void setDefaultRenderer(TableCellRenderer renderer) {
        this.defaultRenderer = renderer;
    }

    @Override
    public TableCellEditor getDefaultEditor() {
        if (this.defaultEditor == null) {
            this.defaultEditor = new DefaultTableCellEditor();
        }
        return this.defaultEditor;
    }

    public void setDefaultEditor(TableCellEditor editor) {
        this.defaultEditor = editor;
    }

    @Override
    public TableRowRenderer getDefaultColumnHeaderRowRenderer() {
        if (this.defaultColumnHeaderRowRenderer == null) {
            this.defaultColumnHeaderRowRenderer = new DefaultTableRowRenderer();
        }
        return this.defaultColumnHeaderRowRenderer;
    }

    public void setDefaultColumnHeaderRowRenderer(TableRowRenderer renderer) {
        this.defaultColumnHeaderRowRenderer = renderer;
    }

    @Override
    public TableRowRenderer getDefaultRowRenderer() {
        if (this.defaultRowRenderer == null) {
            this.defaultRowRenderer = new DefaultTableRowRenderer();
        }
        return this.defaultRowRenderer;
    }

    public void setDefaultRowRenderer(TableRowRenderer renderer) {
        this.defaultRowRenderer = renderer;
    }

    @Override
    public TableCellContentsRenderer getDefaultNoRowsRenderer() {
        if (this.defaultNoRowsRenderer == null) {
            this.defaultNoRowsRenderer = new CellContentsNoRowsRenderer();
        }
        return this.defaultNoRowsRenderer;
    }

    @Override
    public void writeTableHeader(PrintWriter out) throws IOException {
        if (this.isAllActionsVisible()) {
            HttpActionProvider ap;
            if (this.isFormEnabled()) {
                Form form = this.getFormObject();
                HttpServletRequest request = this.getRequest();
                HttpServletResponse response = this.getResponse();
                form.setRequest(request);
                form.setResponse(response);
                form.setLocale(this.getLocale());
                form.writeHeader(out);
            }
            if (this.getEditController().isEditEnabled()) {
                out.println("<input type=\"text\" style=\"visibility:hidden;position:absolute;\" disabled=\"disabled\" />");
            }
            if ((ap = this.getActionProvider()) != null) {
                Hidden.writeElement(out, null, ap.getParameterPrefix() + "gotoRow", "", false);
                Hidden.writeElement(out, null, ap.getParameterPrefix() + "gotoColumn", "", false);
                if (this.getEditController().isEditEnabled()) {
                    Hidden.writeElement(out, null, ap.getParameterPrefix() + "changedCells", "", false);
                    if (!this.getEditController().isSingleRowEditingEnabled()) {
                        Hidden.writeElement(out, null, ap.getParameterPrefix() + "selectedRows", "", false);
                    }
                }
            }
            BaseUtil.writeAdditionalParameters(this.getAdditionalParameters(), out);
        }
        HtmlTableViewUtil.writeTableHeader(this, out);
        if (this instanceof TreeTableView && ((TreeTableView)this).getTreeView().isRenderUsingDivs() && this.getWidthPercentage() > 0 && this.getWidthPercentage() < 100) {
            HtmlTableViewUtil.writeColumnsPercentageWidthForOptimizedTreeTableView(this, out);
        }
        if (this.getTitleRenderer() != null && !this.isColumnHeaderVisible()) {
            this.writeSpanAll(out, this.getTitleRenderer(), this.getTitle(), "OLAPTABLEVIEW_TITLE_ROW_STYLE");
        }
    }

    @Override
    public int getColSpanAll() {
        int colsWithMultiColumnRules;
        int width = this.getEndColumn() - this.getStartColumn() + 1 + this.getColumnHeader().getHeldIndices(2).size() + this.getColumnHeader().getHeldIndices(4).size();
        if (this.getRulesContext() != null && this.getRulesContext().getRules().size() != 0 && (colsWithMultiColumnRules = this.getMultiColumnRuleCount()) > 0) {
            int widthForMultiColumnRules = colsWithMultiColumnRules * 3;
            int widthForOtherColumns = width - colsWithMultiColumnRules;
            width = widthForMultiColumnRules + widthForOtherColumns;
        }
        if (this.isAllActionsVisible() && this.getEditController().isEditColumnVisible() && this.getEditController().isEditEnabled()) {
            ++width;
        }
        if (this.isRowHeaderVisible()) {
            ++width;
        }
        return width;
    }

    @Override
    public void writeColumnHeader(PrintWriter out) throws IOException {
        out.println("<thead>");
        if (this.getTitleRenderer() != null) {
            this.writeSpanAll(out, this.getTitleRenderer(), this.getTitle(), "OLAPTABLEVIEW_TITLE_ROW_STYLE");
        }
        super.writeColumnHeader(out);
        out.println("</thead>");
    }

    @Override
    public void writeTableTFoot(PrintWriter out) throws IOException {
        boolean isTFootWritten = false;
        if (this.isAllActionsVisible()) {
            int savedCurrentRow = this.getCurrentRow();
            this.setCurrentRow(-22);
            boolean editRowVisible = this.isEditRowVisible();
            if (editRowVisible) {
                TableCellRenderer editRowRenderer;
                int found = 0;
                TableColumnModel cModel = this.getColumnHeader().getColumnModel();
                for (int i = this.startColumn; i <= this.endColumn; ++i) {
                    String identString;
                    TableColumn column = cModel.getColumn(i);
                    Object identObject = column.getIdentifier();
                    if (identObject == null || !(identObject instanceof String) || !(identString = (String)identObject).equals("TABLEVIEW_EDIT_COLUMN")) continue;
                    ++found;
                }
                int colSpan = this.endColumn - this.startColumn + 1;
                if (found == 0) {
                    ++colSpan;
                }
                int heldCount = this.getColumnHeader().getHeldIndices(2).size() + this.getColumnHeader().getHeldIndices(4).size();
                colSpan += heldCount;
                TableRowRenderer editFooterRow = this.getRowModel().getColumnHeaderRowRenderer();
                if (editFooterRow == null) {
                    editFooterRow = this.getDefaultColumnHeaderRowRenderer();
                }
                boolean resetEditFooterRowStyleInfo = false;
                if (editFooterRow instanceof StyleInterface && ((StyleInterface)((Object)editFooterRow)).getStyleInfo() == null) {
                    resetEditFooterRowStyleInfo = true;
                }
                this.setStyleOnRenderer(editFooterRow, "TABLEVIEW_COLUMN_HEADER_ROW_STYLE", this.getStyleClassPrefix());
                editFooterRow.setLocale(this.getLocale());
                out.println("<tfoot>");
                isTFootWritten = true;
                editFooterRow.writeBeginRow(this, out);
                if (this.isRowHeaderVisible()) {
                    TableCellRenderer rowHeaderRenderer = this.getRowModel().getRowHeaderRenderer();
                    if (rowHeaderRenderer == null) {
                        rowHeaderRenderer = this.getRowHeader().getDefaultRenderer();
                    }
                    boolean resetStyleInfo = false;
                    if (rowHeaderRenderer instanceof StyleInterface && ((StyleInterface)((Object)rowHeaderRenderer)).getStyleInfo() == null) {
                        resetStyleInfo = true;
                    }
                    this.setStyleOnRenderer(rowHeaderRenderer, "TABLEVIEW_ROW_HEADER_STYLE", this.getStyleClassPrefix());
                    rowHeaderRenderer.setLocale(this.getLocale());
                    this.render(rowHeaderRenderer, out, this, "", null, null);
                    if (resetStyleInfo) {
                        this.resetStyleOnRenderer(rowHeaderRenderer);
                    }
                }
                if ((editRowRenderer = this.getRowModel().getRowHeaderRenderer()) == null) {
                    editRowRenderer = this.getRowHeader().getDefaultRenderer();
                }
                int temp = ((BaseTableCell)((Object)editRowRenderer)).getColSpan();
                ((BaseTableCell)((Object)editRowRenderer)).setColSpan(colSpan);
                ActionList editActions = this.getEditRowActions();
                boolean resetStyleInfo = false;
                if (editRowRenderer instanceof StyleInterface && ((StyleInterface)((Object)editRowRenderer)).getStyleInfo() == null) {
                    resetStyleInfo = true;
                }
                this.setStyleOnRenderer(editRowRenderer, "TABLEVIEW_EDIT_ROW_CELL_STYLE", this.getStyleClassPrefix());
                editRowRenderer.setLocale(this.getLocale());
                this.render(editRowRenderer, out, this, "", null, editActions);
                ((BaseTableCell)((Object)editRowRenderer)).setColSpan(temp);
                if (resetStyleInfo) {
                    this.resetStyleOnRenderer(editRowRenderer);
                }
                editFooterRow.writeEndRow(this, out);
                if (resetEditFooterRowStyleInfo) {
                    this.resetStyleOnRenderer(editFooterRow);
                }
            }
            this.setCurrentRow(savedCurrentRow);
            this.resetEditRowActions();
        }
        if (this.getFooterRenderer() != null) {
            if (!isTFootWritten) {
                out.println("<tfoot>");
                isTFootWritten = true;
            }
            this.writeSpanAll(out, this.getFooterRenderer(), this.getFooter(), "OLAPTABLEVIEW_FOOTER_ROW_STYLE");
        }
        if (isTFootWritten) {
            out.println("</tfoot>");
        }
    }

    @Override
    protected void writeRows(PrintWriter out) throws IOException {
        out.print("<tbody id=\"");
        out.print(this.getId() + "_body");
        out.println("\">");
        super.writeRows(out);
        out.println("</tbody>");
    }

    @Override
    public void writeTableFooter(PrintWriter out) throws IOException {
        if (this.isAllActionsVisible()) {
            this.setCurrentRow(-1);
            this.resetEditRowActions();
        }
        HtmlTableViewUtil.writeTableFooter(this, out);
        if (!this.isExportToExcel()) {
            JavaScriptIncludeHandler.writeIncludes(out, "TABLEVIEW", this.getRequest());
        }
        if (this.isAllActionsVisible() && this.isFormEnabled()) {
            Form form = this.getFormObject();
            form.writeFooter(out);
        }
    }

    @Override
    public void writeEmptyTable(PrintWriter out) throws IOException {
        HtmlTableViewUtil.writeEmptyTable(this, out);
    }

    @Override
    public HttpEditController getDefaultEditController() {
        HttpEditController controller = new HttpEditController();
        controller.setEditEnabled(false);
        return controller;
    }

    @Override
    public TableColumn getDefaultRowSelectionColumn() {
        TableColumn column = new TableColumn(-1);
        column.setIdentifier("TABLEVIEW_ROW_SELECTION");
        column.setHeaderValue("");
        DefaultRowSelectionRenderer rend = new DefaultRowSelectionRenderer();
        rend.setLocale(this.getLocale());
        column.setCellRenderer(rend);
        return column;
    }

    @Override
    public TableColumn getDefaultEditColumn() {
        TableColumn column = new TableColumn(-1);
        column.setIdentifier("TABLEVIEW_EDIT_COLUMN");
        column.setHeaderValue("");
        DefaultTableCellRenderer rend = new DefaultTableCellRenderer();
        rend.setLocale(this.getLocale());
        column.setCellRenderer(rend);
        return column;
    }

    static {
        JavaScriptIncludeHandler.addAlias(TableView.class, "TABLEVIEW");
        defaultStyleMap = new HashMap();
    }
}

