/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.servlet.tbeans.graphics.BaseGraphics;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.html.BaseTableCell;
import com.sas.servlet.util.ClientInfo;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.servlet.util.StyleSheetUtil;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.util.Strings;
import java.awt.Dimension;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@SASScope
public class ResizingUtil {
    private BaseActionTransformation _viewer;
    private ArrayList _resizingInfo = new ArrayList();
    private String _url = null;
    private String _tableGroupId = null;
    String _extraInfo = "";
    private boolean _cleared = false;
    public static final String MEASURES_LEVEL_CODE = "$";
    static final int FORCE_NONE = 0;
    static final int FORCE_MINWIDTH = 1;
    static final int FORCE_NOWRAP = 2;
    static final int FORCE_SPACER = 3;

    public ResizingUtil(BaseActionTransformation viewer) {
        this._viewer = viewer;
        this._cleared = false;
    }

    public void clear() {
        this._resizingInfo.clear();
        this._url = null;
        this._tableGroupId = null;
        this._extraInfo = "";
    }

    public void writeResizingScript(PrintWriter out, Object resizedColumns, String areaType) throws IOException {
        if (this._resizingInfo.size() == 0 || this._viewer.getActionProvider() == null) {
            return;
        }
        String cmdid = this.generateResizingCMDID(resizedColumns, areaType, "RESIZE_COLUMN_ACTION");
        this._extraInfo = ", '" + this._tableGroupId + "'";
        this.writeResizingScript(out, cmdid, false);
        this._resizingInfo.clear();
    }

    private String generateResizingCMDID(Object resizedColumns, String areaType, String actionType) {
        ActionSupportFilter filter = new ActionSupportFilter(this._viewer.getActionSupportType(), areaType, (ActionProviderViewInterface)this._viewer, false);
        try {
            String url;
            filter.setAttribute("resizedColumns", resizedColumns);
            filter.setPoolingOn(true);
            filter.setSwing(false);
            filter.setViewerId(this._viewer.getId());
            HttpActionProvider actionProvider = this._viewer.getActionProvider();
            if (actionProvider == null) {
                return null;
            }
            BaseAction action = actionProvider.getAction(actionType, filter);
            if (action == null) {
                return null;
            }
            HttpAction httpaction = (HttpAction)action;
            String cmdid = httpaction.getCmdId();
            this._url = url = (String)httpaction.getCommand().getAttribute("URL");
            String tableGroupId = (String)httpaction.getCommand().getAttribute("TableGroupId");
            this._tableGroupId = tableGroupId != null ? tableGroupId : this._viewer.getId();
            if (httpaction.getURLTemplate() != null) {
                this._url = "*" + httpaction.getURLTemplate().getTemplate();
            }
            actionProvider.returnAction(action);
            return cmdid;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void writeResizingScript(PrintWriter out, String cmdid, boolean isgraph) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "RESIZING", this._viewer.getRequest());
        out.write(JavaScriptIncludeHandler.getStartScript());
        if (this._viewer.getRequest() != null) {
            out.write("sas_Resizing_BaseContext = \"" + this._viewer.getRequest().getContextPath() + "\";");
        }
        if (!this._cleared) {
            out.write("sas_Resizing_removeResizingElements(\"" + this._viewer.getId() + "\");");
            out.write("sas_Resizing_addCleanup(\"" + this._viewer.getId() + "\");");
        }
        if (cmdid != null) {
            out.write("var sas_AP=\"" + this._viewer.getActionProvider().getName() + "\";");
            out.write("var sas_CMDID=\"" + cmdid + "\";");
        }
        String functionName = isgraph ? "sas_Resizing_addGraphResizing(\"" : "sas_Resizing_addResizing(\"";
        String resizeUrl = this._url;
        if (resizeUrl == null) {
            resizeUrl = "";
        }
        for (int i = 0; i < this._resizingInfo.size(); ++i) {
            String[] info = (String[])this._resizingInfo.get(i);
            out.write(functionName + Strings.escapeForJavaScript((String)info[0]) + "\", \"" + Strings.escapeForJavaScript((String)info[1]) + "\", \"" + Strings.escapeForJavaScript((String)resizeUrl) + "\"" + this._extraInfo + ");");
        }
        out.write("sas_registerEventHandler(window,'load',sas_Resizing_addResizingElements);");
        out.write(JavaScriptIncludeHandler.getEndScript(null));
        this._cleared = true;
    }

    private static StyleInfo setResizedStyleInfo(StyleInterface resizingRenderer, String size, String propName) {
        StyleInfo resizingStyleInfo = resizingRenderer.getStyleInfo();
        String style = resizingStyleInfo.getStyle();
        style = style == null || style.length() == 0 ? "" : style + "; ";
        String px = size.endsWith("px") ? "" : "px";
        style = style + propName + ": " + size + px;
        StyleInfo newStyleInfo = new StyleInfo(resizingStyleInfo.getClassid(), style);
        resizingRenderer.setStyleInfo(newStyleInfo);
        return resizingStyleInfo;
    }

    public StyleInfo handleResizing(TableColumn column, TableCellRenderer renderer, int columnIndex) {
        StyleInfo resizingStyleInfo = null;
        AbstractBaseTableView tableView = (AbstractBaseTableView)this._viewer;
        BaseTableCell cell = (BaseTableCell)((Object)renderer);
        if (tableView.isColumnsResizable() && column.isResizable()) {
            this._resizingInfo.add(new String[]{cell.getId(), Integer.toString(columnIndex)});
        }
        if (renderer instanceof StyleInterface && column.getSize() >= 0) {
            StyleInterface tbean = (StyleInterface)((Object)renderer);
            resizingStyleInfo = ResizingUtil.setResizedStyleInfo(tbean, Integer.toString(column.getSize()), "width");
        }
        return resizingStyleInfo;
    }

    public StyleInfo handleResizing(TupleElementInterface tupleElem, Map _resizedColumns, TableCellRenderer renderer) throws OLAPException {
        if (!this.isResizable() && _resizedColumns.isEmpty()) {
            return null;
        }
        String name = this.convertToId(tupleElem);
        if (this.isResizable()) {
            this.addResizingInfo(name, renderer);
        }
        return this.updateStyleInfo(renderer, name, _resizedColumns);
    }

    public StyleInfo handleResizing(String name, boolean isMeasure, Map _resizedColumns, TableCellRenderer renderer) {
        if (isMeasure) {
            name = MEASURES_LEVEL_CODE;
        }
        if (this.isResizable()) {
            this.addResizingInfo(name, renderer);
        }
        return this.updateStyleInfo(renderer, name, _resizedColumns);
    }

    private boolean isResizable() {
        AbstractBaseTableView tableView = (AbstractBaseTableView)this._viewer;
        return tableView.isColumnsResizable();
    }

    private void addResizingInfo(String name, TableCellRenderer renderer) {
        this._resizingInfo.add(new String[]{((BaseTableCell)((Object)renderer)).getId(), name});
    }

    private StyleInfo updateStyleInfo(TableCellRenderer renderer, String name, Map _resizedColumns) {
        String size;
        if (renderer instanceof StyleInterface && name != null && (size = (String)_resizedColumns.get(name)) != null) {
            StyleInterface tbean = (StyleInterface)((Object)renderer);
            return ResizingUtil.setResizedStyleInfo(tbean, size, "width");
        }
        return null;
    }

    private String convertToId(TupleElementInterface tupleElem) throws OLAPException {
        String level;
        String string = level = tupleElem.getType() == TupleElementType.MEASURE ? MEASURES_LEVEL_CODE : tupleElem.getUniqueLevelName();
        if (level == null || level.equals("")) {
            return null;
        }
        String name = tupleElem.getName();
        if (name == null || name.equals("")) {
            return null;
        }
        int i = name.lastIndexOf("].[");
        String member = name.substring(i + 3, name.length() - 1);
        return level + "@" + member;
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String apname = request.getParameter("APNAME");
        HttpSession session = request.getSession();
        HttpActionProvider ap = (HttpActionProvider)((Object)session.getAttribute(apname));
        if (ap != null) {
            ap.executeCommand(request, response, null);
        }
    }

    public void writeGraphResizingScript(PrintWriter out, BaseGraphics baseGraphics, String domId) throws IOException {
        if (this._viewer.getActionProvider() == null) {
            return;
        }
        this._resizingInfo.add(new String[]{domId, baseGraphics.getId()});
        String cmdid = this.generateResizingCMDID(baseGraphics, "DATA_VALUE_AREA", "RESIZE_GRAPH_ACTION");
        if (this._url == null) {
            this._url = this._viewer.getActionProvider().getControllerURL();
        }
        if (baseGraphics instanceof BaseGraph) {
            BaseGraph graph = (BaseGraph)baseGraphics;
            Dimension min = graph.getMinimumSize();
            Dimension max = graph.getMaximumSize();
            this._extraInfo = "";
            if (min != null) {
                this._extraInfo = ResizingUtil.formatSize(min);
            }
            if (max != null) {
                this._extraInfo = this._extraInfo + ResizingUtil.formatSize(max);
            }
        }
        this.writeResizingScript(out, cmdid, true);
    }

    private static String formatSize(Dimension size) {
        return ", " + size.width + ", " + size.height;
    }

    public void writeGraphResizingScript(PrintWriter out, BaseGraphics baseGraphics) throws IOException {
        this.writeGraphResizingScript(out, baseGraphics, baseGraphics.getId());
    }

    private static void addSpacer(PrintWriter out, String width, AbstractBaseTableView tableview) {
        if (width.endsWith("px")) {
            width = width.substring(0, width.length() - 2);
        }
        int widthValue = Integer.parseInt(width.trim());
        out.write("<div class=\"resizingSpacer\" style=\"width: " + (widthValue -= 3) + "px\"></div>");
    }

    private static boolean setNoWrapForIE(AbstractBaseTableView tableview, BaseTableCell cell, String width) {
        cell.setNoWrap(true);
        return true;
    }

    private static String findWidth(BaseTableCell cell) {
        if (!cell.isHeader()) {
            return null;
        }
        return StyleSheetUtil.findStyleAttribute(cell.getStyleInfo(), "width");
    }

    private static int typeOfForceWidthWorkaround(BaseTableCell cell, AbstractBaseTableView tableview, String width) {
        if (width == null || cell.isNoWrap()) {
            return 0;
        }
        if (tableview.isExportToExcel()) {
            return 2;
        }
        ClientInfo client = new ClientInfo(tableview.getRequest());
        if (client.isInternetExplorer() && client.getBrowserVersion().startsWith("8")) {
            return 1;
        }
        if (client.isFirefox() && client.getBrowserVersion().startsWith("3")) {
            return 1;
        }
        if (client.isInternetExplorer() || "?".equals(client.getBrowserType())) {
            return 2;
        }
        if (client.isFirefox()) {
            return 3;
        }
        return 0;
    }

    public static void writeBeginCell(PrintWriter out, AbstractBaseTableView tableview, TableCellRenderer renderer) throws IOException {
        BaseTableCell cell = (BaseTableCell)((Object)renderer);
        String width = ResizingUtil.findWidth(cell);
        int force = ResizingUtil.typeOfForceWidthWorkaround(cell, tableview, width);
        if (force == 2) {
            ResizingUtil.setNoWrapForIE(tableview, cell, width);
        }
        StyleInfo styleInfo = null;
        if (force == 1) {
            styleInfo = ResizingUtil.setResizedStyleInfo(cell, width, "min-width");
        }
        renderer.writeBeginCell(out);
        if (force == 2) {
            cell.setNoWrap(false);
        }
        if (force == 1) {
            cell.setStyleInfo(styleInfo);
        }
        if (force == 3) {
            ResizingUtil.addSpacer(out, width, tableview);
        }
    }
}

