/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.Util;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.FormElementModificationEventInterface;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.html.TreeTableView;
import com.sas.servlet.tbeans.olaptableview.OLAPTableArea;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.BaseTableCell;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.RB;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.swing.visuals.tableview.TableViewUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class HtmlTableViewUtil
extends TableViewUtil {
    public static void writeTableHeader(AbstractBaseTableView tableView, PrintWriter out) throws IOException {
        String prolog = tableView.getTagProlog();
        if (prolog != null && prolog.length() > 0) {
            out.println(prolog);
        }
        HtmlTableViewUtil.writeBeginTableTag(tableView, out);
        String cap = tableView.getCaption();
        if (cap != null && cap.length() > 0) {
            out.println(cap);
        }
    }

    public static void writeTableFooter(AbstractBaseTableView tableView, PrintWriter out) throws IOException {
        out.println("</table>");
        String epilog = tableView.getTagEpilog();
        if (epilog != null && epilog.length() > 0) {
            out.println(epilog);
        }
    }

    public static void writeEmptyTable(AbstractBaseTableView tableView, PrintWriter out) throws IOException {
        tableView.writeTableHeader(out);
        if (tableView instanceof OLAPTableView) {
            StringBuffer sb = new StringBuffer();
            String styleClassPrefix = tableView.getStyleClassPrefix();
            sb.append("<tr><td");
            OLAPTableView table = (OLAPTableView)tableView;
            Map styleMap = table.getStyleMap();
            StyleInfo styleinfo = (StyleInfo)styleMap.get("OLAPTABLEVIEW_EMPTY_DATA_STYLE");
            HtmlTableViewUtil.appendStyleInfo(sb, styleinfo, styleClassPrefix);
            sb.append(">");
            String msg = table.getWriteFailureMessage();
            if (msg != null) {
                sb.append(msg);
            } else {
                sb.append("&#160;");
            }
            sb.append("</td></tr>");
            out.println(sb);
        } else if (tableView instanceof TableView) {
            StyleInfo styleinfo;
            TableView table = (TableView)tableView;
            int colspan = 1;
            if (table.getModel() != null && table.isColumnHeaderVisible()) {
                colspan = table.getColumnModel().getColumnCount();
                colspan += table.isRowHeaderVisible() ? 1 : 0;
                table.writeColumnHeader(out);
            }
            String prefix = tableView.getStyleClassPrefix();
            DefaultTableRowRenderer row = (DefaultTableRowRenderer)table.getDefaultRowRenderer();
            row.setLocale(tableView.getLocale());
            DefaultTableCellRenderer cell = new DefaultTableCellRenderer(table.getNoRowsRenderer());
            cell.setLocale(tableView.getLocale());
            ((BaseTableCell)cell).setColSpan(colspan);
            if (prefix != null) {
                row.setStyleClassPrefix(prefix);
                ((BaseTableCell)cell).setStyleClassPrefix(prefix);
            }
            if (cell instanceof StyleInterface && ((StyleInterface)cell).getStyleInfo() == null && (styleinfo = (StyleInfo)table.getStyleMap().get("TABLEVIEW_EMPTY_DATA_STYLE")) != null) {
                ((StyleInterface)cell).setStyleInfo(styleinfo);
            }
            row.writeBeginRow(table, out);
            cell.write(out, table, null, null, null);
            row.writeEndRow(table, out);
        }
        tableView.writeTableFooter(out);
    }

    private static void writeBeginTableTag(AbstractBaseTableView tableView, PrintWriter out) throws IOException {
        String summ;
        StyleInfo styleinfo;
        Map styleMap;
        String styleClassPrefix = tableView.getStyleClassPrefix();
        StringBuffer sb = new StringBuffer();
        sb.append("<table");
        if (tableView instanceof OLAPTableView) {
            styleMap = tableView.getStyleMap();
            styleinfo = (StyleInfo)styleMap.get("OLAPTABLEVIEW_STYLE");
            HtmlTableViewUtil.appendStyleInfo(sb, styleinfo, styleClassPrefix);
        } else if (tableView instanceof TableView) {
            styleMap = tableView.getStyleMap();
            styleinfo = (StyleInfo)styleMap.get("TABLEVIEW_STYLE");
            HtmlTableViewUtil.appendStyleInfo(sb, styleinfo, styleClassPrefix);
        }
        if (tableView.getId() != null) {
            sb.append(" id=\"");
            sb.append(tableView.getId());
            sb.append("\"");
        }
        if (tableView.getWidth() > 0) {
            sb.append(" width=\"");
            sb.append(tableView.getWidth());
            sb.append("\"");
        } else if (!(tableView.getWidthPercentage() <= 0 || tableView instanceof TreeTableView && ((TreeTableView)tableView).getTreeView().isRenderUsingDivs())) {
            sb.append(" width=\"");
            sb.append(tableView.getWidthPercentage());
            sb.append("%\"");
        }
        sb.append(" border=\"");
        sb.append(tableView.getBorderWidth());
        sb.append("\"");
        sb.append(" cellspacing=\"");
        sb.append(tableView.getCellSpacing());
        sb.append("\" cellpadding=\"");
        sb.append(tableView.getCellPadding());
        sb.append("\"");
        String custom = tableView.getCustomAttributes();
        if (custom != null && custom.length() > 0) {
            sb.append(" ");
            sb.append(custom);
        }
        if ((summ = tableView.getSummary()) != null && summ.length() > 0) {
            sb.append(" summary=\"");
            sb.append(summ);
            sb.append("\"");
        }
        sb.append(">");
        out.println(sb);
    }

    public static void writeColumnsPercentageWidthForOptimizedTreeTableView(AbstractBaseTableView tableView, PrintWriter out) {
        if (tableView != null && out != null) {
            out.println("<col width=\"100%\" style=\"white-space:nowrap;\"></col>");
            int span = tableView.getColumnCount() - 1;
            if (span > 0) {
                out.println("<col span=\"" + span + "\" width=\"" + tableView.getWidthPercentage() + "%\"></col>");
            }
        }
    }

    private static void appendStyleInfo(StringBuffer sb, StyleInfo styleinfo, String styleClassPrefix) {
        if (styleinfo.getClassid() != null) {
            sb.append(" class=\"");
            if (styleClassPrefix != null) {
                sb.append(styleClassPrefix);
            }
            sb.append(styleinfo.getClassid());
            sb.append("\"");
        }
        if (styleinfo.getStyle() != null) {
            sb.append(" style=\"");
            sb.append(styleinfo.getStyle());
            sb.append("\"");
        }
    }

    public static void writeActions(AbstractBaseTableView tableview, ActionList actions, PrintWriter out) throws IOException {
        HtmlTableViewUtil.writeActions(tableview, actions, out, true);
    }

    public static void writeActions(AbstractBaseTableView tableview, ActionList actions, PrintWriter out, boolean encodeText) throws IOException {
        if (tableview.isAllActionsVisible() && actions != null && actions.size() > 0) {
            String prefix = tableview.getStyleClassPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if (tableview instanceof TableView) {
                prefix = prefix + "tableview";
            } else if (tableview instanceof OLAPTableView) {
                prefix = prefix + ((OLAPTableView)tableview).getCurrentAreaPrefix();
            }
            HashMap argumentMap = ActionProviderMapPool.getMap();
            argumentMap.put("REQUEST", tableview.getRequest());
            argumentMap.put("STYLE_CLASS_PREFIX", prefix);
            TableCellRenderer currentCellRenderer = tableview.getCurrentRenderer();
            if (currentCellRenderer != null && currentCellRenderer instanceof BaseTableCell) {
                BaseTableCell btc = (BaseTableCell)((Object)currentCellRenderer);
                if (btc.getId() != null && !"".equals(btc.getId())) {
                    argumentMap.put("POPUPMENU_CONTEXT_CELL_ID", btc.getId());
                }
                if (btc.isHeader()) {
                    argumentMap.put("POPUPMENU_CONTEXT_CELL_TYPE", "TH");
                } else {
                    argumentMap.put("POPUPMENU_CONTEXT_CELL_TYPE", "TD");
                }
            }
            if (!(tableview instanceof BaseTableView) && tableview.getTextWrapping() != 0) {
                OLAPTableView otv;
                boolean olapDataArea = false;
                if (tableview instanceof OLAPTableView && (otv = (OLAPTableView)tableview).getCurrentArea() == OLAPTableArea.TABLE_DATA) {
                    olapDataArea = true;
                }
                if (!olapDataArea) {
                    argumentMap.put("CONTAINER_WRAPPING", Boolean.TRUE);
                }
            }
            if (encodeText) {
                argumentMap.put("ENCODE_TEXT", Boolean.TRUE);
            }
            Util.writeActionList(actions, out, argumentMap);
            ActionProviderMapPool.returnMap((Map)argumentMap);
        }
    }

    public static void setOnModificationEvent(AbstractBaseTableView tableView, Object renderer) throws IOException {
        HtmlTableViewUtil.setEvent(tableView, renderer, "sas_TableView_OnModification", "changedCells");
    }

    public static void setOnRowSelectionEvent(AbstractBaseTableView tableView, Object renderer) throws IOException {
        HtmlTableViewUtil.setEvent(tableView, renderer, "sas_TableView_OnRowSelection", "selectedRows");
    }

    private static void setEvent(AbstractBaseTableView tableView, Object renderer, String onModMethodName, String formElementName) throws IOException {
        if (renderer instanceof FormElementModificationEventInterface && tableView instanceof FormViewInterface) {
            HttpActionProvider ap = tableView.getActionProvider();
            if (ap == null) {
                return;
            }
            FormViewInterface fvi = (FormViewInterface)((Object)tableView);
            String onModString = onModMethodName + "('" + fvi.getFormObject().getName() + "', this, '" + ap.getParameterPrefix() + formElementName + "');";
            FormElementModificationEventInterface fe = (FormElementModificationEventInterface)renderer;
            String modEventName = fe.getModificationEventName();
            String tempModEventName = modEventName.substring(0, 1).toUpperCase() + modEventName.substring(1);
            String getMethodName = "get" + tempModEventName;
            String setMethodName = "set" + tempModEventName;
            Class<?> c = fe.getClass();
            try {
                Method getMethod = c.getMethod(getMethodName, null);
                String oldOnModString = (String)getMethod.invoke((Object)fe, null);
                if (oldOnModString.indexOf(onModString) == -1) {
                    Class[] parameterTypes = new Class[]{String.class};
                    Method setMethod = c.getMethod(setMethodName, parameterTypes);
                    String modificationValue = onModString + oldOnModString;
                    Object[] arguments = new Object[]{modificationValue};
                    setMethod.invoke((Object)fe, arguments);
                }
            }
            catch (NoSuchMethodException e) {
                throw new IOException(RB.getStringResource("TableView.", "methodInaccessible.txt", tableView.getLocale()));
            }
            catch (IllegalAccessException e) {
                throw new IOException(RB.getStringResource("TableView.", "methodInaccessible.txt", tableView.getLocale()));
            }
            catch (InvocationTargetException e) {
                throw new IOException(RB.getStringResource("TableView.", "methodFailed.txt", tableView.getLocale()));
            }
        }
    }
}

