/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.HttpConstants;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.tableview.TableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.RB;
import java.util.Locale;

@SASScope(value="ALL")
public abstract class BaseTableRow
implements TableRowRenderer,
HttpConstants,
StyleInterface {
    static final String RB_KEY = "BaseTableRow.";
    private int horizontalAlignment = 99;
    private int verticalAlignment = 99;
    private String bgcolor;
    private String customAttributes;
    private boolean columnHeaderRow;
    private StyleInfo styleInfo;
    private String styleClassPrefix;
    private Locale locale;

    public void setHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 2: 
            case 4: 
            case 20: 
            case 21: 
            case 99: {
                this.horizontalAlignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAlignment.txt", this.getLocale()));
            }
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 1: 
            case 3: 
            case 22: 
            case 99: {
                this.verticalAlignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAlignment.txt", this.getLocale()));
            }
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setBgColor(String color) {
        this.bgcolor = color;
    }

    public String getBgColor() {
        return this.bgcolor;
    }

    public void setCustomAttributes(String value) {
        this.customAttributes = value;
    }

    public String getCustomAttributes() {
        return this.customAttributes;
    }

    @Override
    public StyleInfo getStyleInfo() {
        return this.styleInfo;
    }

    @Override
    public void setStyleInfo(StyleInfo styleInfo) {
        this.styleInfo = styleInfo;
    }

    @SASScope
    public void setStyleClassPrefix(String styleClassPrefix) {
        this.styleClassPrefix = styleClassPrefix;
    }

    @SASScope
    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    public void setColumnHeaderRow(boolean headerRow) {
        this.columnHeaderRow = headerRow;
    }

    public boolean isColumnHeaderRow() {
        return this.columnHeaderRow;
    }

    @SASScope
    protected static String getHorizontalAlignmentString(int alignment) {
        String alignmentString = "";
        switch (alignment) {
            case 2: {
                alignmentString = " align=\"left\"";
                break;
            }
            case 4: {
                alignmentString = " align=\"right\"";
                break;
            }
            case 0: {
                alignmentString = " align=\"center\"";
                break;
            }
            case 20: {
                alignmentString = " align=\"justify\"";
                break;
            }
            case 21: {
                alignmentString = " align=\"char\"";
                break;
            }
        }
        return alignmentString;
    }

    @SASScope
    protected static String getVerticalAlignmentString(int alignment) {
        String alignmentString = "";
        switch (alignment) {
            case 1: {
                alignmentString = " valign=\"top\"";
                break;
            }
            case 3: {
                alignmentString = " valign=\"bottom\"";
                break;
            }
            case 0: {
                alignmentString = " valign=\"middle\"";
                break;
            }
            case 22: {
                alignmentString = " valign=\"baseline\"";
                break;
            }
        }
        return alignmentString;
    }

    @Override
    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }
}

