/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.ajax;

import com.sas.servlet.tbeans.features.Feature;
import com.sas.servlet.tbeans.tableview.ajax.AJAXTableActions;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

public class AJAXTableController
implements Feature {
    private TableView _table;
    private ListSelectionModel _rowSelections;
    private boolean updateRowSelections = false;
    public boolean useDnD = false;
    public Vector includedMap = null;
    private String _contextPath = null;
    private String _containerId = null;
    private UpdateMode _nextUpdateMode = null;
    private UpdateMode _updateMode = null;
    public boolean enableEditor = true;
    public static final UpdateMode UpdateEntireTable;
    public static final UpdateMode UpdateEntireRow;
    public static final UpdateMode UpdateCell;

    public AJAXTableController(TableView table) {
        this._table = table;
        this._rowSelections = new DefaultListSelectionModel();
        this._rowSelections.setSelectionMode(2);
    }

    public TableView getTable() {
        return this._table;
    }

    void setTable(TableView table) {
        this._table = table;
    }

    public String getContainerId() {
        return this._containerId;
    }

    public void setContainerId(String containerId) {
        this._containerId = containerId;
    }

    public static AJAXTableController save(TableView table, HttpServletRequest request) {
        Map sessionInfo = ComponentSessionManager.getSessionManager(request);
        Object o = sessionInfo.get(table.getId());
        if (o != null) {
            AJAXTableController controller = (AJAXTableController)o;
            controller.setTable(table);
            return controller;
        }
        AJAXTableController controller = new AJAXTableController(table);
        controller.saveContextPath(request);
        sessionInfo.put(table.getId(), controller);
        return controller;
    }

    @Override
    public void write(HttpServletRequest request, Writer out) throws IOException {
        this.saveContextPath(request);
        JavaScriptIncludeHandler.writeIncludes(out, "TABLEEDITING", request);
        if (this.useDnD) {
            JavaScriptIncludeHandler.writeIncludes(out, "DND", request);
        }
        out.write(JavaScriptIncludeHandler.getStartScript());
        this.writeJavaScript(out);
        out.write(JavaScriptIncludeHandler.getEndScript(null));
    }

    private void saveContextPath(HttpServletRequest request) {
        this._contextPath = request.getContextPath();
    }

    public void initJavaScriptIncludeHandler(HttpServletRequest request) {
        if (this.includedMap == null) {
            this.includedMap = (Vector)request.getAttribute(JavaScriptIncludeHandler.INC_COLLECTION);
        } else {
            request.setAttribute(JavaScriptIncludeHandler.INC_COLLECTION, (Object)this.includedMap);
        }
    }

    private void writeJavaScript(Writer out) throws IOException {
        out.write("sas_TableEditing_ContextURL = \"" + this._contextPath + "/\";\n");
        out.write(AJAXTableController.getAttachEditorScript(this._table, this.enableEditor));
        String baseURL = this._table.getAJAXControllerURL();
        if (baseURL == null) {
            baseURL = this._contextPath + "/MethodInvocationServlet";
        }
        out.write(this._table.getId() + "_Obj.baseURL=\"" + baseURL + "\";\n");
        out.write(this._table.getId() + "_Obj.selectionController.setSelectionMode(" + this.mapSelectionMode() + ");\n");
        out.write(this._table.getId() + "_Obj.setRowOffset(" + this._table.getStartRow() + ");\n");
        this.writeRowSelections(out);
        if (this.isUpdateRowSelections()) {
            out.write(this._table.getId() + "_Obj.isUpdateRowSelections = true;\n");
        }
        if (this.useDnD) {
            out.write(this._table.getId() + "_Obj.addDnDColumns(\"" + this._table.getId() + "_c\", " + this._table.getColumnCount() + ");\n");
        }
    }

    private int mapSelectionMode() {
        return this.getRowSelections().getSelectionMode() + 1;
    }

    private void writeRowSelections(Writer out) throws IOException {
        ListSelectionModel rows = this.getRowSelections();
        int min = rows.getMinSelectionIndex();
        int max = rows.getMaxSelectionIndex();
        out.write(this._table.getId() + "_Obj.setSelectedRows([");
        boolean first = true;
        for (int i = min; i <= max; ++i) {
            if (!rows.isSelectedIndex(i)) continue;
            if (first) {
                first = false;
            } else {
                out.write(",");
            }
            out.write(Integer.toString(i));
        }
        out.write("]);\n");
    }

    public static String getAttachEditorScript(TableView table) {
        return AJAXTableController.getAttachEditorScript(table, true);
    }

    public static String getAttachEditorScript(TableView table, boolean enableEditor) {
        return "sas_TableEditing_attachEditor('" + table.getId() + "'," + enableEditor + ");\n";
    }

    public String getScript() {
        try {
            StringWriter strout = new StringWriter();
            this.writeJavaScript(strout);
            String str = strout.toString();
            strout.close();
            return str;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) {
        AJAXTableController controller = AJAXTableController.findController(request);
        AJAXTableActions actions = new AJAXTableActions(controller);
        actions.doit(request, response);
    }

    private static AJAXTableController findController(HttpServletRequest request) {
        Map sessionInfo = ComponentSessionManager.getSessionManager(request);
        String id = request.getParameter("id");
        AJAXTableController controller = (AJAXTableController)sessionInfo.get(id);
        return controller;
    }

    public void setUpdateEntireTable(boolean b) {
        this.setNextUpdateMode(b ? UpdateEntireTable : null);
    }

    public boolean isUpdateEntireTable() {
        return this.effectiveUpdateMode(true) == UpdateEntireTable;
    }

    public UpdateMode getNextUpdateMode() {
        return this._nextUpdateMode;
    }

    public void setNextUpdateMode(UpdateMode nextUpdateMode) {
        this._nextUpdateMode = nextUpdateMode;
    }

    public UpdateMode getUpdateMode() {
        return this._updateMode;
    }

    public void setUpdateMode(UpdateMode updateMode) {
        this._updateMode = updateMode;
    }

    UpdateMode effectiveUpdateMode(boolean updated) {
        if (this.getNextUpdateMode() != null) {
            return this.getNextUpdateMode();
        }
        return updated ? this.getUpdateMode() : UpdateCell;
    }

    public ListSelectionModel getRowSelections() {
        return this._rowSelections;
    }

    public void setRowSelections(ListSelectionModel rowSelections) {
        this._rowSelections = rowSelections;
    }

    public boolean isUpdateRowSelections() {
        return this.updateRowSelections;
    }

    public void setUpdateRowSelections(boolean updateRowSelections) {
        this.updateRowSelections = updateRowSelections;
    }

    public int getSelectedRowCount() {
        if (this._rowSelections != null) {
            int iMin = this._rowSelections.getMinSelectionIndex();
            int iMax = this._rowSelections.getMaxSelectionIndex();
            int count = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this._rowSelections.isSelectedIndex(i)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public int[] getSelectedRows() {
        if (this._rowSelections != null) {
            int iMin = this._rowSelections.getMinSelectionIndex();
            int iMax = this._rowSelections.getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0];
            }
            int[] rvTmp = new int[1 + (iMax - iMin)];
            int n = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this._rowSelections.isSelectedIndex(i)) continue;
                rvTmp[n++] = i;
            }
            int[] rv = new int[n];
            System.arraycopy(rvTmp, 0, rv, 0, n);
            return rv;
        }
        return new int[0];
    }

    public static void writeFastClickProtection(Writer out1, HttpServletRequest request, boolean isConnectionSecure) throws IOException {
        PrintWriter out = new PrintWriter(out1);
        JavaScriptIncludeHandler.writeIncludes(out, "FASTCLICKPROTECTION", request);
        out.println(JavaScriptIncludeHandler.getStartScript());
        String processText = "Processing";
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' ) ");
        out.println(" { ");
        if (isConnectionSecure) {
            out.println(" sas_FastClick_createFastClickManager('\\StreamContentServlet?NOOP=true',\"" + processText + "\");");
        } else {
            out.println(" sas_FastClick_createFastClickManager(null,\"" + processText + "\");");
        }
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
        out.flush();
    }

    static {
        JavaScriptIncludeHandler.addAlias(AJAXTableController.class, "TABLEEDITING");
        UpdateEntireTable = new UpdateMode("Update Entire Table");
        UpdateEntireRow = new UpdateMode("Update Entire Row");
        UpdateCell = new UpdateMode("Update Individual Cell");
    }

    private static class UpdateMode {
        String _title;

        UpdateMode(String title) {
            this._title = title;
        }
    }
}

