/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.ajax;

import com.sas.servlet.tbeans.form.JavaScriptObjectCreationInterface;
import com.sas.servlet.tbeans.tableview.TableCellContentsEditor;
import com.sas.servlet.tbeans.tableview.TableCellEditor;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.ajax.AJAXPacket;
import com.sas.servlet.tbeans.tableview.ajax.AJAXTableController;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationOnChangeInterface;
import com.sas.util.Strings;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import com.sas.util.validators.GenericValidatorInterface;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ListSelectionModel;

public class AJAXTableActions {
    private AJAXTableController _controller;
    private TableView _table;

    AJAXTableActions(AJAXTableController controller) {
        this._controller = controller;
        this._table = this._controller.getTable();
    }

    public void doit(HttpServletRequest request, HttpServletResponse response) {
        CommonLoggerInterface log = this.getLogger();
        try {
            if (log.isDebugEnabled()) {
                log.debug(AJAXTableActions.toString(request));
            }
            this._controller.initJavaScriptIncludeHandler(request);
            this.editColumn(request, response);
        }
        catch (Exception e) {
            try {
                PrintWriter out = response.getWriter();
                out.println("");
                out.close();
            }
            catch (IOException e1) {
                log.warn(e1.getMessage(), (Throwable)e1);
            }
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void editColumn(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Parms parms = new Parms(request, this._table);
        this._table.setRequest(request);
        this.updateRowSelection(parms);
        boolean updated = this.commitEdit(request);
        AJAXPacket packet = new AJAXPacket();
        if (this._controller.effectiveUpdateMode(updated) == AJAXTableController.UpdateEntireTable) {
            this.sendEntireTable(packet);
        } else {
            this.sendCell(packet, parms);
        }
        this._table.setRequest(request);
        this.sendEditor(packet, parms);
        packet.send(response);
        this._controller.setNextUpdateMode(null);
    }

    private void updateRowSelection(Parms parms) {
        if (this._controller.isUpdateRowSelections() && parms.newrows != null) {
            int[] rows = parms.newrows;
            ListSelectionModel rowSelections = this._controller.getRowSelections();
            rowSelections.clearSelection();
            for (int i = 0; i < rows.length; ++i) {
                int j = rows[i];
                if (j < 0) continue;
                rowSelections.addSelectionInterval(j - 1, j - 1);
            }
        }
    }

    private boolean commitEdit(HttpServletRequest request) {
        boolean edit;
        String editParm = request.getParameter("edit");
        boolean bl = edit = editParm != null && !editParm.equals("");
        if (edit) {
            HashMap<String, String> uncommitted = new HashMap<String, String>(1, 5.0f);
            String value = edit ? request.getParameter(editParm) : null;
            uncommitted.put(editParm, value);
            this._table.setUncommittedValues(uncommitted);
            this._table.commit();
            this._table.setUncommittedValues(null);
            return true;
        }
        return false;
    }

    private void sendEditor(AJAXPacket packet, Parms parms) throws IOException {
        String html = this.generateEditor(parms);
        if (html == null) {
            return;
        }
        packet.add(html, "type", "editor");
        TableColumn column = this._table.getColumnModel().getColumn(parms.editcol - 1);
        String id = this._table.getId() + "_" + (parms.editrow - 1) + "_" + column.getModelIndex();
        packet.set("editorId", id);
    }

    private String generateEditor(Parms parms) throws IOException {
        String editor = null;
        if (parms.editcol >= 0) {
            TableColumn column = this._table.getColumnModel().getColumn(parms.editcol - 1);
            this._table.setCurrentColumn(parms.editcol);
            this._table.setCurrentRow(parms.editrow);
            this._table.update(parms.editrow);
            TableCellEditor tcEditor = this._table.getCellEditor(parms.editrow, false, column.getModelIndex() + 1);
            if (tcEditor != null) {
                editor = this.generateEditorCell(tcEditor, column, parms);
            }
            this._table.update(-99);
        }
        return editor;
    }

    private String generateEditorCell(TableCellEditor tcEditor, TableColumn column, Parms parms) throws IOException {
        StringWriter strOut = new StringWriter();
        PrintWriter strPrintWriter = new PrintWriter(strOut);
        JavaScriptObjectCreationInterface creator = this.useJavaScriptEditor(tcEditor);
        JavaScriptValidationOnChangeInterface change = this.useValidationError(tcEditor);
        this._table.writeEditorCell(strPrintWriter, tcEditor, parms.editrow, column.getModelIndex() + 1, null);
        if (creator != null) {
            creator.setJavaScriptObjectCreationEnabled(false);
        }
        if (change != null) {
            change.setValidationOnChange(false);
        }
        strPrintWriter.flush();
        strPrintWriter.close();
        String editor = strOut.toString();
        return editor;
    }

    private JavaScriptObjectCreationInterface useJavaScriptEditor(TableCellEditor tcEditor) {
        TableCellContentsEditor contentsEditor = tcEditor.getTableCellContentsEditor();
        if (contentsEditor instanceof JavaScriptObjectCreationInterface) {
            JavaScriptObjectCreationInterface creator = (JavaScriptObjectCreationInterface)((Object)contentsEditor);
            if (!creator.isJavaScriptObjectCreationEnabled()) {
                creator.setJavaScriptObjectCreationEnabled(true);
                return creator;
            }
        } else {
            CommonLoggerInterface log = this.getLogger();
            log.debug("editor is not an instance of JavaScriptObjectCreationInterface: " + contentsEditor.getClass());
        }
        return null;
    }

    private JavaScriptValidationOnChangeInterface useValidationError(TableCellEditor tcEditor) {
        TableCellContentsEditor contentsEditor = tcEditor.getTableCellContentsEditor();
        if (contentsEditor instanceof GenericValidatorInterface) {
            JavaScriptValidationOnChangeInterface change;
            GenericValidatorInterface formElement = (GenericValidatorInterface)contentsEditor;
            ValidationInterface validator = formElement.getValidator();
            if (validator != null && validator instanceof JavaScriptValidationOnChangeInterface && !(change = (JavaScriptValidationOnChangeInterface)validator).isValidationOnChange()) {
                change.setValidationOnChange(true);
                return change;
            }
        } else {
            CommonLoggerInterface log = this.getLogger();
            log.debug("editor is not an instance of JavaScriptValidationOnChangeInterface: " + contentsEditor.getClass());
        }
        return null;
    }

    private void sendCell(AJAXPacket packet, Parms parms) throws IOException {
        String html = this.generateCell(parms);
        packet.add(html, "type", "cell");
    }

    private String generateCell(Parms parms) throws IOException {
        String cell = null;
        if (parms.col >= 0) {
            StringWriter strOut = new StringWriter();
            PrintWriter strPrintWriter = new PrintWriter(strOut);
            TableColumn column = this._table.getColumnModel().getColumn(parms.col - 1);
            this._table.setCurrentColumn(parms.col);
            this._table.setCurrentRow(parms.row);
            this._table.writeCell(strPrintWriter, parms.row, column.getModelIndex() + 1, false, false, false, null);
            strPrintWriter.flush();
            cell = strOut.toString();
            strPrintWriter.close();
        }
        return cell;
    }

    private void sendEntireTable(AJAXPacket packet) throws IOException {
        String html = this.generateEntireTable();
        packet.add(html, "type", "table");
        String id = this._controller.getContainerId();
        if (id == null) {
            id = "tableDIV_" + this._table.getId();
        }
        packet.set("containerId", id);
    }

    private String generateEntireTable() throws IOException {
        StringWriter strOut = new StringWriter();
        PrintWriter strPrintWriter = new PrintWriter(strOut);
        HttpServletRequest request = this._table.getRequest();
        this._table.writePartialRefresh(request, this._table.getResponse(), strPrintWriter);
        String html = strOut.toString();
        return html;
    }

    public static int calculateColumnOffset(TableView table) {
        int colOffest = 0;
        if (table.isRowHeaderVisible()) {
            --colOffest;
        }
        return colOffest += table.getStartColumn();
    }

    public static int calculateRowOffset(TableView table) {
        int rowOffest = 0;
        return rowOffest += table.getStartRow();
    }

    static int getInt(HttpServletRequest request, String name) {
        String parm = request.getParameter(name);
        return parm == null ? -1 : Integer.parseInt(parm);
    }

    static int[] getInts(HttpServletRequest request, String name) {
        String str = request.getParameter(name);
        if (str == null) {
            return null;
        }
        String[] parms = str.split(",");
        int[] ret = new int[parms.length];
        for (int i = 0; i < parms.length; ++i) {
            int val;
            String parm = parms[i];
            ret[i] = val = parm == null ? -1 : Integer.parseInt(parm);
        }
        return ret;
    }

    static void addToInts(int[] ints, int offset) {
        if (ints == null) {
            return;
        }
        for (int i = 0; i < ints.length; ++i) {
            int j = ints[i];
            if (j < 0) continue;
            ints[i] = j + offset;
        }
    }

    private static String toString(HttpServletRequest request) {
        StringBuffer sbuf = new StringBuffer();
        Map map = request.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            if ("CLASS_PARAMETER".equals(entry.getKey())) continue;
            sbuf.append(entry.getKey()).append(" = ");
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                sbuf.append(values[i]);
                if (i >= values.length - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append("; ");
        }
        return sbuf.toString();
    }

    private CommonLoggerInterface getLogger() {
        CommonLoggerInterface log = LoggerRepository2.getLogger((String)AJAXTableController.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        return log;
    }

    public static String escapeForJavaScript(String str) {
        return Strings.escapeForJavaScript((String)str, (boolean)true);
    }

    private static class Parms {
        int row;
        int col;
        int editrow;
        int editcol;
        int[] newrows;

        public Parms(HttpServletRequest request, TableView table) {
            this.row = AJAXTableActions.getInt(request, "row");
            this.col = AJAXTableActions.getInt(request, "col");
            this.editrow = AJAXTableActions.getInt(request, "editrow");
            this.editcol = AJAXTableActions.getInt(request, "editcol");
            this.newrows = AJAXTableActions.getInts(request, "newrow");
            int colOffset = AJAXTableActions.calculateColumnOffset(table);
            ++colOffset;
            if (this.col >= 0) {
                this.col += colOffset;
            }
            if (this.editcol >= 0) {
                this.editcol += colOffset;
            }
            int rowOffset = AJAXTableActions.calculateRowOffset(table);
            ++rowOffset;
            if (this.row >= 0) {
                this.row += rowOffset;
            }
            if (this.editrow >= 0) {
                this.editrow += rowOffset;
            }
            AJAXTableActions.addToInts(this.newrows, rowOffset - table.getStartRow());
        }
    }
}

