/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.tableview.RB;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.TableColumnModelEvent;
import com.sas.servlet.tbeans.tableview.TableColumnModelListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.event.EventListenerList;

@SASScope(value="ALL")
public class DefaultTableColumnModel
implements TableColumnModel {
    static final String RB_KEY = "DefaultTableColumnModel.";
    private Locale locale;
    @SASScope
    protected EventListenerList listenerList;
    @SASScope
    protected Vector tableColumns = new Vector();

    public DefaultTableColumnModel() {
        this.listenerList = new EventListenerList();
    }

    @Override
    public void addColumn(TableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullColumn.txt", this.getLocale()));
        }
        this.tableColumns.addElement(column);
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
    }

    @Override
    public void removeColumn(TableColumn column) {
        int index = this.tableColumns.indexOf(column);
        if (index > -1) {
            this.tableColumns.removeElementAt(index);
            this.fireColumnRemoved(new TableColumnModelEvent(this, this.getColumnCount() - 1, 0));
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidColumnIndex.txt", this.getLocale()));
        }
        if (columnIndex != newIndex) {
            TableColumn moveColumn = (TableColumn)this.tableColumns.elementAt(columnIndex);
            this.tableColumns.removeElementAt(columnIndex);
            this.tableColumns.insertElementAt(moveColumn, newIndex);
            this.fireColumnMoved(new TableColumnModelEvent(this, columnIndex, newIndex));
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public Enumeration getColumns() {
        return this.tableColumns.elements();
    }

    @Override
    public int getColumnIndex(Object columnIdentifier) {
        if (columnIdentifier == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullIdentifier.txt", this.getLocale()));
        }
        Enumeration enumeration = this.getColumns();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn column = (TableColumn)enumeration.nextElement();
            if (columnIdentifier.equals(column.getIdentifier())) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "identifierNotFound.txt", this.getLocale()));
    }

    @Override
    public TableColumn getColumn(int columnIndex) {
        try {
            return (TableColumn)this.tableColumns.elementAt(columnIndex);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidColumnIndex.txt", this.getLocale()));
        }
    }

    @Override
    public void setColumnOrder(int[] columnIndexes) {
        int i;
        if (columnIndexes.length > this.tableColumns.size()) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "arrayTooBig.txt", this.getLocale()));
        }
        Object[] columns = this.tableColumns.toArray();
        this.tableColumns.removeAllElements();
        boolean invalidIndexError = false;
        for (i = 0; i < columnIndexes.length; ++i) {
            int index = columnIndexes[i];
            if (index < 0 || index >= columns.length) {
                invalidIndexError = true;
                break;
            }
            this.tableColumns.addElement((TableColumn)columns[index]);
        }
        if (invalidIndexError) {
            this.tableColumns.removeAllElements();
            for (i = 0; i < columns.length; ++i) {
                this.tableColumns.addElement(columns[i]);
            }
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidColumnIndex.txt", this.getLocale()));
        }
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener listener) {
        this.listenerList.add(TableColumnModelListener.class, listener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener listener) {
        this.listenerList.remove(TableColumnModelListener.class, listener);
    }

    @SASScope
    protected void fireColumnAdded(TableColumnModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnAdded(event);
        }
    }

    @SASScope
    protected void fireColumnRemoved(TableColumnModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnRemoved(event);
        }
    }

    @SASScope
    protected void fireColumnMoved(TableColumnModelEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnMoved(event);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }
}

