/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.remotefileselector2.html;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.remotefileselector2.BaseRemoteFileToolBar;
import com.sas.servlet.tbeans.remotefileselector2.RemoteFileSelectorInterface;
import com.sas.servlet.tbeans.remotefileselector2.RemoteFileSelectorKeysInterface;
import com.sas.servlet.tbeans.remotefileselector2.html.RB;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileSelectorStyleKeysInterface;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.servlet.util.URLEncoder;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.Location;
import com.sas.swing.models.remotefileselector2.LocationNode;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import com.sas.swing.util.ActionList;
import com.sas.swing.util.ActionUtils;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

@SASScope(value="ALL")
public class RemoteFileToolBar
extends BaseRemoteFileToolBar
implements RemoteFileSelectorKeysInterface,
RemoteFileSelectorStyleKeysInterface {
    public static final String RB_KEY = "RemoteFileToolBar.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "RemoteFileToolBar.html";
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("RFS_TOOLBAR_CONTAINER_STYLE", new ImmutableStyleInfo("rfs_ToolBarContainer"));
        }
    }

    public RemoteFileToolBar() {
        this(null);
    }

    public RemoteFileToolBar(RemoteFileSelectorInterface rfs) {
        this(rfs, null);
    }

    public RemoteFileToolBar(RemoteFileSelectorInterface rfs, Locale locale) {
        this.setId(Util.getName((String)"rftb"));
        if (locale != null) {
            this.setLocale(locale);
        }
        this.setActionSupportType("REMOTE_FILE_SELECTOR2_COMPOSITE_SUPPORT");
        this.setVisible(true);
        if (rfs != null) {
            this.setModel(rfs);
        }
        this.setComponent("RFS_TOOLBAR_LOCATION_LABEL", this.createDefaultLabel());
        this.setComponent("RFS_TOOLBAR_LOCATION_CHOICE", this.createDefaultNavigator());
        this.setComponent("RFS_TOOLBAR_SHOWDESCRIPTION_COMPONENT", null);
        this.setComponent("RFS_UPONELEVEL_ACTION", this.createDefaultUpOneLevelComponent(), "UP_ONE_LEVEL_ACTION");
        this.setDefaultRefreshProxyRelationships();
        ((BaseLabel)this.getComponent("RFS_TOOLBAR_LOCATION_LABEL")).setFor(this.getComponent("RFS_TOOLBAR_LOCATION_CHOICE").getId());
        this.setTemplateKey("Remote_File_Tool_Bar");
        RemoteFileToolBar.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
    }

    private void setDefaultRefreshProxyRelationships() {
        this.setPartialRefreshProxy("RFS_TOOLBAR_LOCATION_CHOICE", this);
        this.setPartialRefreshProxy("RFS_UPONELEVEL_ACTION", this);
        this.setPartialRefreshProxy("RFS_TOOLBAR_SHOWDESCRIPTION_COMPONENT", this);
    }

    protected void prepareToWriteToolbar() {
        BaseChoiceBox locationChoiceView = (BaseChoiceBox)this.getComponent("RFS_TOOLBAR_LOCATION_CHOICE");
        if (locationChoiceView != null) {
            locationChoiceView.setOnChange(this.getOnChangeActionString());
        }
        DefaultComboBoxModel locationChoiceModel = (DefaultComboBoxModel)locationChoiceView.getModel();
        this.populateLocationChoiceModel(locationChoiceModel);
        if (1 == this.getModel().getMode()) {
            try {
                locationChoiceView.setSelectedIndex(0);
            }
            catch (IOException iOException) {}
        } else {
            try {
                RemoteFileNavigationModelInterface rfsModel = this.getModel().getModel();
                if (this.isMultipleRootLocationsOn() & rfsModel instanceof RemoteFileModel2Interface) {
                    Object topElement = locationChoiceModel.getElementAt(0);
                    String topElementValue = "";
                    if (topElement != null) {
                        topElementValue = ((JavaScriptNode)topElement).getValue();
                    }
                    if (topElementValue.equals("SEARCH_RESULTS")) {
                        locationChoiceView.setSelectedIndex(((RemoteFileModel2Interface)rfsModel).getLocationsCurrentPathIndex() + 1);
                    } else {
                        locationChoiceView.setSelectedIndex(((RemoteFileModel2Interface)rfsModel).getLocationsCurrentPathIndex());
                    }
                } else {
                    locationChoiceView.setSelectedIndex(locationChoiceModel.getSize() - 1);
                }
            }
            catch (IOException e1) {
                try {
                    locationChoiceView.setSelectedIndex(0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected BaseChoiceBox createDefaultNavigator() {
        ComboBoxView nc = new ComboBoxView();
        nc.setMaximumRowCount(20);
        nc.setId(this.getId() + "_locationChoice");
        Map styleMap = nc.getStyleMap();
        ImmutableStyleInfo customComboLabelStyle = new ImmutableStyleInfo(((StyleInfo)styleMap.get("COMBOBOXVIEW_LABEL_DIV")).getClassid(), "width:220px;");
        ImmutableStyleInfo customComboLabelXPStyle = new ImmutableStyleInfo(((StyleInfo)styleMap.get("COMBOBOXVIEW_LABEL_DIV_XP")).getClassid(), "width:220px;");
        ImmutableStyleInfo customComboLabelVistaStyle = new ImmutableStyleInfo(((StyleInfo)styleMap.get("COMBOBOXVIEW_LABEL_DIV_VISTA")).getClassid(), "width:220px;");
        styleMap.put("COMBOBOXVIEW_LABEL_DIV", customComboLabelStyle);
        styleMap.put("COMBOBOXVIEW_LABEL_DIV_XP", customComboLabelXPStyle);
        styleMap.put("COMBOBOXVIEW_LABEL_DIV_VISTA", customComboLabelVistaStyle);
        ImmutableStyleInfo customStyleClass = new ImmutableStyleInfo("rfs_comboBoxViewDropDown", "");
        styleMap.put("COMBOBOXVIEW_LIST_DIV", customStyleClass);
        return nc;
    }

    protected BaseLabel createDefaultLabel() {
        Label ll = new Label(RB.getStringResource(RB_KEY, "location.txt", this.getLocale()));
        ll.setStyleInfo(new StyleInfo("rfs_ToolBarLabel"));
        ll.setId(this.getId() + "_locationLabel");
        return ll;
    }

    protected BaseButton createDefaultUpOneLevelComponent() {
        Button b = new Button();
        b.setButtonType(4);
        b.getStyleMap().put("BUTTON_CENTER", new StyleInfo("rfs_ToolBarAction_ButtonCenter"));
        b.getStyleMap().put("BUTTON_CENTER_DISABLED", new StyleInfo("rfs_ToolBarAction_ButtonCenterDisabled"));
        b.setId(this.getId() + "_upOneLevelAction");
        return b;
    }

    protected com.sas.actionprovider.ActionList getNavigatorActions() {
        ActionSupportFilter comboFilter = new ActionSupportFilter(this.getActionSupportType(), "COMBO_AREA", (ActionProviderViewInterface)this);
        if (this.getClass() == RemoteFileToolBar.class) {
            comboFilter.setPoolingOn(true);
        }
        comboFilter.setViewerId(this.getId());
        comboFilter.setHiddenActionsMap(this.getViewerSupport().getHiddenActionsMap());
        try {
            comboFilter.setAttribute("model", (Object)this.getModel().getModel());
            comboFilter.setAttribute("modelColumn", (Object)new Integer(0));
        }
        catch (AttributeSetException attributeSetException) {
            // empty catch block
        }
        return this.getActionProvider().getActions(comboFilter);
    }

    @Override
    protected ActionSupportFilter getActionFilter(String actionType) {
        if (actionType.equals("UP_ONE_LEVEL_ACTION")) {
            ActionSupportFilter toolBarFilter = new ActionSupportFilter(this.getActionSupportType(), "TOOLBAR_AREA", (ActionProviderViewInterface)this);
            try {
                toolBarFilter.setAttribute("model", (Object)this.getModel().getModel());
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            return toolBarFilter;
        }
        return super.getActionFilter(actionType);
    }

    private void populateLocationChoiceModel(DefaultComboBoxModel locationComboModel) {
        RemoteFileSelectorInterface rfsView = this.getModel();
        RemoteFileNavigationModelInterface rfsModel = rfsView.getModel();
        if (rfsModel != null) {
            Object topElement = locationComboModel.getElementAt(0);
            String topElementValue = "";
            if (topElement != null) {
                topElementValue = ((JavaScriptNode)topElement).getValue();
            }
            if (1 == this.getModel().getMode()) {
                if (!topElementValue.equals("SEARCH_RESULTS")) {
                    ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
                    String overrideImageLocation = this.getActionProvider() != null ? this.getActionProvider().getImageLocation() : null;
                    String folderImageURI = cpm.getImageURI("Folder", overrideImageLocation);
                    JavaScriptNode node = new JavaScriptNode();
                    node.setText(RB.getStringResource(RB_KEY, "searchResults.txt", this.getLocale()));
                    node.setValue("SEARCH_RESULTS");
                    node.setImageURI(folderImageURI);
                    locationComboModel.insertElementAt(node, 0);
                    this.setSearchResultsDisplayed(true);
                }
            } else {
                boolean addSearch = false;
                if (topElementValue.equals("SEARCH_RESULTS") && this.isSearchResultsDisplayed()) {
                    addSearch = true;
                }
                if (this.isMultipleRootLocationsOn() && rfsModel instanceof RemoteFileModel2Interface) {
                    this.populateWithMultipleRootLocations(locationComboModel, (RemoteFileModel2Interface)rfsModel);
                } else {
                    this.populateWithSingleRootLocation(locationComboModel, (BaseRemoteFileModelInterface)rfsModel);
                }
                if (addSearch) {
                    ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
                    String overrideImageLocation = this.getActionProvider() != null ? this.getActionProvider().getImageLocation() : null;
                    String folderImageURI = cpm.getImageURI("Folder", overrideImageLocation);
                    JavaScriptNode node = new JavaScriptNode();
                    node.setText(RB.getStringResource(RB_KEY, "searchResults.txt", this.getLocale()));
                    node.setValue("SEARCH_RESULTS");
                    node.setImageURI(folderImageURI);
                    locationComboModel.insertElementAt(node, 0);
                }
            }
        }
    }

    private void populateWithSingleRootLocation(DefaultComboBoxModel locationComboModel, BaseRemoteFileModelInterface rfsModel) {
        String path = rfsModel.getLocation().trim();
        String basePath = rfsModel.getBasePath();
        if (basePath != null) {
            basePath = basePath.trim();
        }
        String[][] fal = this.removeSkippedLocations(rfsModel, rfsModel.parseIntoFoldersAndLocations(path));
        locationComboModel.removeAllElements();
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        String overrideImageLocation = this.getActionProvider() != null ? this.getActionProvider().getImageLocation() : null;
        String folderImageURI = cpm.getImageURI("Folder", overrideImageLocation);
        String apName = this.getActionProvider().getName();
        if (basePath == null || basePath.equals("")) {
            int indentValue = 0;
            int indentFactor = 1;
            int nodeIndex = 0;
            for (int i = fal.length - 1; i >= 0; --i) {
                JavaScriptNode node = new JavaScriptNode();
                try {
                    String locationString = fal[i][0];
                    if (locationString == null) continue;
                    String encodedLocationString = URLEncoder.encodeURL(locationString.toString(), BaseUtil.getInputCharacterEncoding(this.getRequest()));
                    String encodedUrl = new StringBuffer("&").append(apName).append("_fullyQualifiedLocation=").append(encodedLocationString).toString();
                    node.setValue(encodedUrl);
                    node.setImageURI(folderImageURI);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                node.setText(fal[i][1]);
                locationComboModel.addElement(node);
                node.setIndentionLevel(nodeIndex + indentValue);
                indentValue += indentFactor;
                ++nodeIndex;
            }
        } else {
            int index = fal.length - 1;
            while (index >= 0 && !basePath.equals(fal[--index + 1][0])) {
            }
            index = index < 0 ? fal.length - 1 : index;
            int indentValue = 0;
            int indentFactor = 1;
            int nodeIndex = 0;
            while (index >= 0) {
                String currentLocation = fal[index][0];
                if (currentLocation == null) continue;
                JavaScriptNode node = new JavaScriptNode();
                try {
                    String encodedLocationString = URLEncoder.encodeURL(currentLocation.toString(), BaseUtil.getInputCharacterEncoding(this.getRequest()));
                    String encodedURL = new StringBuffer("&").append(apName).append("_fullyQualifiedLocation=").append(encodedLocationString).toString();
                    node.setValue(encodedURL);
                    node.setImageURI(folderImageURI);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                node.setText(fal[index][1]);
                locationComboModel.addElement(node);
                node.setIndentionLevel(nodeIndex + indentValue);
                indentValue += indentFactor;
                ++nodeIndex;
                --index;
            }
        }
    }

    private String[][] removeSkippedLocations(BaseRemoteFileModelInterface model, String[][] foldersAndLocations) {
        if (!(model instanceof RemoteFileNavigationModelInterface) || RemoteFileModelsUtil.getModelType((RemoteFileNavigationModelInterface)((RemoteFileNavigationModelInterface)model)) != 2) {
            return foldersAndLocations;
        }
        Object[][] customRepositoryRootFolderInfo = RemoteFileModelsUtil.getCustomRepositoryRootFolderInfo((List)RemoteFileModelsUtil.getCustomRepositoriesList((List)((InformationServicesNavigationModel)model).getRepositoryList()));
        for (int i = 0; i < customRepositoryRootFolderInfo.length; ++i) {
            String customRepositoryRootFolderLocation = (String)customRepositoryRootFolderInfo[i][0];
            if (customRepositoryRootFolderLocation == null) continue;
            customRepositoryRootFolderLocation = customRepositoryRootFolderLocation + "(Folder)";
            for (int j = 0; j < foldersAndLocations.length; ++j) {
                String parsedLocation = foldersAndLocations[j][0];
                if (!customRepositoryRootFolderLocation.equals(parsedLocation)) continue;
                foldersAndLocations[j][0] = null;
            }
        }
        return foldersAndLocations;
    }

    @SASScope
    public void populateWithMultipleRootLocations(DefaultComboBoxModel locationComboModel, RemoteFileModel2Interface rfs2Model) {
        List locations = rfs2Model.getLocations();
        locationComboModel.removeAllElements();
        for (int i = 0; i < locations.size(); ++i) {
            Object locationInfo = locations.get(i);
            if (!(locationInfo instanceof Location)) continue;
            Location location2 = (Location)locationInfo;
            List locationNodes = location2.getLocationNodes();
            int numOfLocationNodes = locationNodes.size();
            int indentValue = 0;
            int indentFactor = 2;
            int nodeIndex = 0;
            for (int j = 0; j < numOfLocationNodes; ++j) {
                JavaScriptNode node = new JavaScriptNode();
                LocationNode locNode = (LocationNode)locationNodes.get(j);
                String nodeLocation = locNode.getLocation();
                node.setName(this.getId() + "_" + j);
                try {
                    String apName = this.getActionProvider().getName();
                    String encodedLocationString = null;
                    if (nodeLocation != null) {
                        encodedLocationString = URLEncoder.encodeURL(nodeLocation.toString(), BaseUtil.getInputCharacterEncoding(this.getRequest()));
                    }
                    String encodedURL = new StringBuffer("&").append(apName).append("_fullyQualifiedLocation=").append(encodedLocationString).toString();
                    node.setValue(encodedURL);
                }
                catch (UnsupportedEncodingException apName) {
                    // empty catch block
                }
                node.setText(locNode.getLabel());
                ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
                String overrideImageLocation = this.getActionProvider() != null ? this.getActionProvider().getImageLocation() : null;
                String folderImageURI = null;
                folderImageURI = locNode != null && "Root Folder".equals(locNode.getType()) ? cpm.getImageURI("SAS_Folders", overrideImageLocation) : (locNode != null && "My Folder".equals(locNode.getType()) ? cpm.getImageURI("My_Folder", overrideImageLocation) : cpm.getImageURI("Folder", overrideImageLocation));
                node.setImageURI(folderImageURI);
                locationComboModel.addElement(node);
                node.setIndentionLevel(nodeIndex + indentValue);
                indentValue += indentFactor;
                ++nodeIndex;
            }
        }
    }

    private String getOnChangeActionString() {
        com.sas.actionprovider.ActionList comboActions = this.getNavigatorActions();
        if (comboActions != null) {
            StringBuffer actionAnchor = new StringBuffer();
            Iterator iterator = ActionUtils.iterator((ActionList)comboActions);
            Object openFolderBaseURL = null;
            Object displaySearchResultsBaseURL = null;
            while (iterator.hasNext()) {
                Object listElement = iterator.next();
                if (listElement == com.sas.actionprovider.ActionList.SEPARATOR || listElement instanceof ActionList) continue;
                HttpAction navigatorAction = (HttpAction)((Object)listElement);
                if (navigatorAction.getActionType().equals("OPEN_FOLDER_ACTION")) {
                    openFolderBaseURL = navigatorAction.getValue("URL");
                    continue;
                }
                if (!navigatorAction.getActionType().equals("DISPLAY_SEARCH_RESULTS_ACTION")) continue;
                displaySearchResultsBaseURL = navigatorAction.getValue("URL");
            }
            this.getActionProvider().returnActionList(comboActions);
            if (this.isPartialRefreshActionsEnabled()) {
                actionAnchor.append("sas_RemoteFileSelector_processLocationSelectionUsingAJAX('");
            } else {
                actionAnchor.append("sas_RemoteFileSelector_processLocationSelection2('");
            }
            actionAnchor.append(openFolderBaseURL);
            actionAnchor.append("','");
            actionAnchor.append(displaySearchResultsBaseURL);
            String id = ((ComboBoxView)this.getComponent("RFS_TOOLBAR_LOCATION_CHOICE")).getId();
            actionAnchor.append("', '" + id + "' );");
            return actionAnchor.toString();
        }
        return "";
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        ComboBoxModel dropDownValues;
        BaseChoiceBox locationDropDown;
        super.setLocaleDependentProperties(locale);
        BaseLabel ll = (BaseLabel)this.getComponent("RFS_TOOLBAR_LOCATION_LABEL");
        if (ll != null) {
            ll.setText(RB.getStringResource(RB_KEY, "location.txt", locale));
        }
        if ((locationDropDown = (BaseChoiceBox)this.getComponent("RFS_TOOLBAR_LOCATION_CHOICE")) != null && (dropDownValues = locationDropDown.getModel()) != null && dropDownValues.getSize() > 0) {
            Object topElement = dropDownValues.getElementAt(0);
            String topElementValue = "";
            if (topElement != null && topElement instanceof JavaScriptNode && (topElementValue = ((JavaScriptNode)topElement).getValue()).equals("SEARCH_RESULTS")) {
                ((JavaScriptNode)topElement).setText(RB.getStringResource(RB_KEY, "searchResults.txt", locale));
            }
        }
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        this.flushActionProvider();
        if (this.isPartialRefreshActionsEnabled()) {
            HttpServletRequest request;
            JavaScriptIncludeHandler.writeIncludes(out, "AJAX", this.getRequest());
            if (this.getPartialRefreshProxy() == null && (request = this.getRequest()) != null) {
                ComponentSessionManager.getSessionManager(request).put(this.getId(), this);
            }
        }
        if (this.isVisible()) {
            JavaScriptIncludeHandler.writeIncludes(out, "REMOTEFILESELECTOR", this.getRequest());
            this.prepareToWriteToolbar();
            this.writeTemplate(this, null, out);
            this.cleanUpResources();
        } else {
            this.cleanUpResources();
        }
    }
}

