/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.remotefileselector2.html;

import com.sas.codepolicy.SASScope;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.BaseCheckBox;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.remotefileselector2.BaseFieldRenderer;
import com.sas.servlet.tbeans.remotefileselector2.html.CellContentsDateRenderer;
import com.sas.servlet.tbeans.remotefileselector2.html.ColumnAsRowCellRenderer;
import com.sas.servlet.tbeans.remotefileselector2.html.InformationServicesSearch;
import com.sas.servlet.tbeans.remotefileselector2.html.NoColumnTableHeaderRenderer;
import com.sas.servlet.tbeans.remotefileselector2.html.RB;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileSelector;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileToolBar;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.DefaultTableColumnModel;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.LocaleDataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;

@SASScope(value="ALL")
public class InformationServicesSelector
extends RemoteFileSelector {
    public static final String RB_KEY = "InformationServicesSelector.";
    private RemoteFileNavigationModelInterface model;
    private boolean useMultipleRootLocations;

    public InformationServicesSelector() {
    }

    public InformationServicesSelector(RepositoryInterface repository, String locationURL, Locale locale) {
        super((RemoteFileNavigationModelInterface)new InformationServicesNavigationModel(repository), locale);
        this.initialize(repository, locationURL, locale);
    }

    public InformationServicesSelector(UserContextInterface user, String locationURL, Locale locale) {
        super((RemoteFileNavigationModelInterface)new InformationServicesNavigationModel(user), locale);
        this.initialize(user, false, locationURL, locale);
    }

    @SASScope
    public InformationServicesSelector(UserContextInterface user, boolean navigateUsingServer, String locationURL, Locale locale) {
        super((RemoteFileNavigationModelInterface)new InformationServicesNavigationModel(user, navigateUsingServer), locale);
        this.initialize(user, navigateUsingServer, locationURL, locale);
    }

    @SASScope
    public InformationServicesSelector(ServerInterface dataServer, String locationURL, Locale locale) {
        this(dataServer, null, locationURL, locale);
    }

    @SASScope
    public InformationServicesSelector(ServerInterface dataServer, RepositoryInterface repositoryFilter, String locationURL, Locale locale) {
        super((RemoteFileNavigationModelInterface)new InformationServicesNavigationModel(dataServer, repositoryFilter), locale);
        this.initialize(dataServer, locationURL, locale);
    }

    private void initialize(RepositoryInterface repository, String locationURL, Locale locale) {
        InformationServicesSearch search = new InformationServicesSearch(repository, locale);
        this.initialize(search, locationURL, locale);
    }

    private void initialize(UserContextInterface user, boolean navigateUsingServer, String locationURL, Locale locale) {
        InformationServicesSearch search = new InformationServicesSearch(user, navigateUsingServer, locale);
        this.useMultipleRootLocations = navigateUsingServer;
        this.initialize(search, locationURL, locale);
    }

    private void initialize(ServerInterface dataServer, String locationURL, Locale locale) {
        InformationServicesSearch search = new InformationServicesSearch(dataServer, locale);
        this.useMultipleRootLocations = true;
        this.initialize(search, locationURL, locale);
    }

    private void initialize(InformationServicesSearch search, String locationURL, Locale locale) {
        TableView searchResultsDetailView;
        RemoteFileToolBar toolBar;
        if (locale != null) {
            this.setLocale(locale);
        }
        if (search != null) {
            this.setComponent("RFS_SEARCH", search);
            search.setId(this.getId() + "_" + "rfsrch");
            this.setPartialRefreshProxy("RFS_SEARCH", this);
            this.setPartialRefreshProxy("RFS_SEARCH_DETAILVIEW", this);
            search.setExpandCollapseVisible(true);
        }
        if ((toolBar = (RemoteFileToolBar)this.getComponent("RFS_TOOLBAR")) != null) {
            toolBar.setComponent("RFS_TOOLBAR_SHOWDESCRIPTION_COMPONENT", this.createDefaultShowDescriptionComponent());
            if (this.useMultipleRootLocations) {
                toolBar.setMultipleRootLocationsOn(true);
            }
        }
        RemoteFileNavigationModelInterface model = this.getModel();
        if (locationURL != null) {
            model.setLocation(locationURL);
        }
        if (model != null && model instanceof LocaleDataInterface) {
            ((LocaleDataInterface)model).setLocale(locale);
        }
        DefaultTableColumnModel fileColumnModel = new DefaultTableColumnModel();
        fileColumnModel.addColumn(new TableColumn(model.getColumnIndex("NAME_COLUMN")));
        fileColumnModel.addColumn(new TableColumn(model.getColumnIndex("TYPE_COLUMN")));
        TableColumn modifiedDateColumn = new TableColumn(model.getColumnIndex("MODIFIED_DATE_COLUMN"));
        fileColumnModel.addColumn(modifiedDateColumn);
        TableColumn descriptionColumn = new TableColumn(model.getColumnIndex("DESCRIPTION_COLUMN"));
        fileColumnModel.addColumn(descriptionColumn);
        TableView regularFileView = (TableView)this.getComponent("RFS_FILE_DETAILVIEW");
        regularFileView.setAutoCreateColumnsFromModel(false);
        regularFileView.setColumnModel(fileColumnModel);
        this.updateColumnHeaderValues(fileColumnModel, locale);
        modifiedDateColumn.setCellRenderer(new CellContentsDateRenderer(new SimpleDateFormat(RB.getStringResource(RB_KEY, "datePattern.lcl", this.getLocale()), this.getLocale())));
        ColumnAsRowCellRenderer colAsRowCellRenderer = new ColumnAsRowCellRenderer();
        NoColumnTableHeaderRenderer noColHeaderRenderer = new NoColumnTableHeaderRenderer();
        descriptionColumn.setCellRenderer(colAsRowCellRenderer);
        descriptionColumn.setHeaderRenderer(noColHeaderRenderer);
        if (search != null && (searchResultsDetailView = (TableView)search.getComponent("RFS_SEARCHRESULTS_DETAILVIEW")) != null) {
            TableColumnModel searchColModel = searchResultsDetailView.getColumnModel();
            int searchDescriptionModelColumnIndex = search.getModel().getColumnIndex("DESCRIPTION_COLUMN");
            int numberOfColModelColumns = searchColModel.getColumnCount();
            TableColumn searchDescriptionColumn = searchColModel.getColumn(numberOfColModelColumns - 1);
            if (searchDescriptionColumn.getModelIndex() == searchDescriptionModelColumnIndex) {
                searchDescriptionColumn.setCellRenderer(colAsRowCellRenderer);
                searchDescriptionColumn.setHeaderRenderer(noColHeaderRenderer);
            }
        }
    }

    private void updateColumnHeaderValues(TableColumnModel fileColumnModel, Locale locale) {
        RemoteFileNavigationModelInterface model = this.getModel();
        Enumeration e = fileColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn fileColumn = (TableColumn)e.nextElement();
            if (fileColumn.getModelIndex() == model.getColumnIndex("NAME_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "nameColumn.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == model.getColumnIndex("TYPE_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "typeColumn.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == model.getColumnIndex("AUTHOR_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "authorColumn.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == model.getColumnIndex("MODIFIED_DATE_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "modifiedDateColumn.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == model.getColumnIndex("KEYWORDS_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "keywordsColumn.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() != model.getColumnIndex("DESCRIPTION_COLUMN")) continue;
            fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "descriptionColumn.txt", locale));
        }
    }

    public void setRepository(RepositoryInterface repository) {
        RemoteFileNavigationModelInterface model = this.getModel();
        if (model == null) {
            model = new InformationServicesNavigationModel(repository);
            this.setModel(model);
            this.initialize(repository, null, this.getLocale());
        } else if (model instanceof InformationServicesNavigationModel) {
            ((InformationServicesNavigationModel)model).setRepository(repository);
        }
        this.useMultipleRootLocations = false;
    }

    public RepositoryInterface getRepository() {
        RemoteFileNavigationModelInterface model = this.getModel();
        if (model != null && model instanceof InformationServicesNavigationModel) {
            return ((InformationServicesNavigationModel)model).getRepository();
        }
        return null;
    }

    public void setUserContext(UserContextInterface user) {
        RemoteFileNavigationModelInterface model = this.getModel();
        if (model == null) {
            model = new InformationServicesNavigationModel(user);
            this.setModel(model);
            this.initialize(user, false, null, this.getLocale());
        } else if (model instanceof InformationServicesNavigationModel) {
            ((InformationServicesNavigationModel)model).setUserContext(user);
        }
        this.useMultipleRootLocations = true;
    }

    public UserContextInterface getUserContext() {
        this.model = this.getModel();
        if (this.model != null) {
            // empty if block
        }
        return null;
    }

    @Override
    protected void prepareToWriteToolBar() {
        TableCellRenderer cellRenderer;
        int numberOfColModelColumns;
        TableColumnModel fileColModel;
        TableColumn descriptionColumn;
        int descriptionModelColumnIndex;
        TransformationInterface descriptionComponent;
        TransformationInterface toolBar = this.getComponent("RFS_TOOLBAR");
        if (toolBar != null && toolBar instanceof RemoteFileToolBar && (descriptionComponent = ((RemoteFileToolBar)toolBar).getComponent("RFS_TOOLBAR_SHOWDESCRIPTION_COMPONENT")) != null && descriptionComponent instanceof BaseCheckBox && (descriptionModelColumnIndex = this.getModel().getColumnIndex("DESCRIPTION_COLUMN")) >= 0 && 1 != this.getMode() && (descriptionColumn = (fileColModel = ((TableView)this.getComponent("RFS_FILE_DETAILVIEW")).getColumnModel()).getColumn((numberOfColModelColumns = fileColModel.getColumnCount()) - 1)).getModelIndex() == descriptionModelColumnIndex && (cellRenderer = descriptionColumn.getCellRenderer()) instanceof BaseFieldRenderer) {
            this.setupShowDescription((BaseCheckBox)descriptionComponent, (BaseFieldRenderer)cellRenderer);
        }
    }

    protected BaseCheckBox createDefaultShowDescriptionComponent() {
        CheckBox descChkbox = new CheckBox();
        descChkbox.setText(RB.getStringResource(RB_KEY, "showDescription.txt", this.getLocale()));
        descChkbox.setId(this.getId() + "_showDesc");
        descChkbox.getStyleMap().put("CHECKBOX_LABEL", new StyleInfo("rfs_ToolBarShowDescriptionLabel"));
        descChkbox.getStyleMap().put("CHECKBOX_BOX", new StyleInfo("rfs_ToolBarShowDescription"));
        descChkbox.setSelected(false);
        return descChkbox;
    }

    @Override
    protected void setupView(BaseTableView table, BaseRemoteFileModelInterface model) {
        super.setupView(table, model);
        this.sort(table, model, "NAME_COLUMN", 0);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        BaseCheckBox showDescCheckBox;
        RemoteFileToolBar rftb;
        super.setLocaleDependentProperties(locale);
        TableView detailView = (TableView)this.getComponent("RFS_FILE_DETAILVIEW");
        if (detailView != null) {
            this.updateColumnHeaderValues(detailView.getColumnModel(), locale);
        }
        if ((rftb = (RemoteFileToolBar)this.getComponent("RFS_TOOLBAR")) != null && (showDescCheckBox = (BaseCheckBox)rftb.getComponent("RFS_TOOLBAR_SHOWDESCRIPTION_COMPONENT")) != null) {
            showDescCheckBox.setText(RB.getStringResource(RB_KEY, "showDescription.txt", locale));
        }
        this.model = this.getModel();
        if (this.model != null && this.model instanceof LocaleDataInterface) {
            ((LocaleDataInterface)this.model).setLocale(locale);
        }
    }
}

