/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.remotefileselector2.directoryfile;

import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.html.AjaxTreeView;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.tbeans.remotefileselector2.directoryfile.BaseDirectoryFileViewer;
import com.sas.servlet.tbeans.remotefileselector2.directoryfile.DirectoryFileViewerComponentKeysInterface;
import com.sas.servlet.tbeans.remotefileselector2.directoryfile.DirectoryFileViewerStyleKeysInterface;
import com.sas.servlet.tbeans.remotefileselector2.directoryfile.RB;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.models.remotefileselector2.ifileservice.tree.BaseIFileServiceTreeModel;
import com.sas.swing.models.remotefileselector2.ifileservice.tree.IFileServiceMetadataTreeNode;
import com.sas.swing.models.remotefileselector2.ifileservice.tree.IFileServiceTreeNavigationModel;
import com.sas.util.MapWithDefaults;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.tree.TreeModel;

public class DirectoryFileViewer
extends BaseDirectoryFileViewer
implements DirectoryFileViewerStyleKeysInterface,
DirectoryFileViewerComponentKeysInterface {
    public static final String UPDATE_VIEWER_ID_PARAMETER = "updateViewerId";
    public static final String TREE_ID_SUFFIX = "_TreeView";
    public static final String FILE_CHECKBOX_ID_SUFFIX = "_FileCheckBox";
    public static final String RB_KEY = "DirectoryFileViewer.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "DirectoryFileViewer.html";
    private static final String DEFAULT_BASE_CONTROLLER = "/MethodInvocationServlet?";
    private static final String DEFAULT_REFRESH_HANDLER_PARAMETERS = "CLASS_PARAMETER=com.sas.servlet.tbeans.util.PartialRefreshHandler";
    private static final String DEFAULT_TOGGLE_HANDLER_PARAMETERS = "CLASS_PARAMETER=com.sas.servlet.tbeans.remotefileselector2.directoryfile.DirectoryFileViewer&METHOD=toggleDirectoriesOnly";
    private static final String DIRECTORIES_ONLY_PARAM = "directoriesOnly";
    private static Map defaultStyleMap;

    public DirectoryFileViewer(String id) {
        this(id, null);
    }

    public DirectoryFileViewer(String id, BaseIFileServiceTreeModel model) {
        this(id, model, null);
    }

    public DirectoryFileViewer(String id, BaseIFileServiceTreeModel treeNavigationModel, Locale locale) {
        this.setId(id);
        this.setLocale(locale);
        this.setTreeNavigationModel(treeNavigationModel);
        this.setTemplateKey("Directory_File_Viewer");
        this.addComponents();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        CheckBox fileCheckBox = (CheckBox)this.getComponent("DFV_FILE_CHECKBOX");
        if (fileCheckBox != null) {
            fileCheckBox.setText(RB.getStringResource(RB_KEY, "fileCheckBoxText.txt", locale));
        }
    }

    protected void addComponents() {
        this.setComponent("DFV_TREEVIEW", this.newTreeViewInstance());
        this.setComponent("DFV_FILE_CHECKBOX", this.newFileCheckBoxInstance());
    }

    protected AjaxTreeView newTreeViewInstance() {
        AjaxTreeView treeView = new AjaxTreeView(this.getId() + TREE_ID_SUFFIX);
        treeView.setRootNodeVisible(false);
        treeView.setFolderExpandCollapseEnabled(true);
        treeView.setSelectionMode(1);
        treeView.setUsingURLLinks(false);
        treeView.setTransform(new TreeNodeTransform());
        return treeView;
    }

    protected CheckBox newFileCheckBoxInstance() {
        CheckBox fileCheckBox = new CheckBox();
        fileCheckBox.setId(this.getId() + FILE_CHECKBOX_ID_SUFFIX);
        fileCheckBox.setSelected(false);
        fileCheckBox.setOnClick(this.getId() + "_Obj.toggleDirectoriesOnly()");
        return fileCheckBox;
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        CheckBox fileCheckBox;
        JavaScriptIncludeHandler.writeIncludes(out, "DIRECTORYFILEVIEWER", this.getRequest());
        AjaxTreeView tv = (AjaxTreeView)this.getComponent("DFV_TREEVIEW");
        BaseIFileServiceTreeModel treeNavigationModel = this.getTreeNavigationModel();
        if (treeNavigationModel != tv.getModel()) {
            tv.setModel((TreeModel)treeNavigationModel);
        }
        if ((fileCheckBox = (CheckBox)this.getComponent("DFV_FILE_CHECKBOX")) != null) {
            fileCheckBox.setSelected(treeNavigationModel.isDirectoriesOnly());
        }
        this.writeTemplate(this, null, out);
        this.writeScript(out);
    }

    private void writeScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        String jsObj = this.getId() + "_Obj";
        out.println(jsObj + " = new sas_DirectoryFileViewer('" + this.getId() + "');");
        out.println(jsObj + ".baseRefreshUrl = \"" + this.getBaseRefreshURL() + "\";");
        out.println(jsObj + ".baseToggleCheckboxURL = \"" + this.getBaseToggleCheckboxURL() + "\";");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private String getBaseRefreshURL() {
        String contextPath;
        String value = DEFAULT_BASE_CONTROLLER;
        if (this.getRequest() != null && (contextPath = this.getRequest().getContextPath()) != null) {
            value = contextPath + DEFAULT_BASE_CONTROLLER;
        }
        return value + DEFAULT_REFRESH_HANDLER_PARAMETERS;
    }

    private String getBaseToggleCheckboxURL() {
        String contextPath;
        String value = DEFAULT_BASE_CONTROLLER;
        if (this.getRequest() != null && (contextPath = this.getRequest().getContextPath()) != null) {
            value = contextPath + DEFAULT_BASE_CONTROLLER;
        }
        return value + DEFAULT_TOGGLE_HANDLER_PARAMETERS;
    }

    public static void toggleDirectoriesOnly(HttpServletRequest request, HttpServletResponse response) {
        String viewerId = request.getParameter(UPDATE_VIEWER_ID_PARAMETER);
        Object viewer = request.getSession().getAttribute(viewerId);
        if (viewer == null) {
            viewer = ComponentSessionManager.getSessionManager(request).get(viewerId);
        }
        if (viewer == null || !(viewer instanceof AjaxTreeView)) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "viewerNotFound.txt", null));
        }
        TreeModel model = ((AjaxTreeView)viewer).getModel();
        if (model == null || !(model instanceof IFileServiceTreeNavigationModel)) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "modelNotFound.txt", null));
        }
        IFileServiceTreeNavigationModel treeNavModel = (IFileServiceTreeNavigationModel)model;
        String directoriesOnlyParameter = request.getParameter(DIRECTORIES_ONLY_PARAM);
        boolean directoriesOnly = directoriesOnlyParameter != null && directoriesOnlyParameter.equalsIgnoreCase("true");
        boolean refreshNeeded = directoriesOnly != treeNavModel.isDirectoriesOnly();
        treeNavModel.setDirectoriesOnly(directoriesOnly);
        if (refreshNeeded) {
            treeNavModel.init();
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(DirectoryFileViewer.class, "DIRECTORYFILEVIEWER");
        defaultStyleMap = null;
        defaultStyleMap = new HashMap();
        defaultStyleMap.put("DFV_CONTAINER_STYLE", new ImmutableStyleInfo("dfv_Container"));
        defaultStyleMap.put("DFV_TREEVIEW_CONTAINER_STYLE", new ImmutableStyleInfo("dfv_TreeViewContainer"));
        defaultStyleMap.put("DFV_FILE_CHECKBOX_CONTAINER_STYLE", new ImmutableStyleInfo("dfv_FileCheckBoxContainer"));
        defaultStyleMap.put("DFV_TREEVIEW_FILE_CHECKBOX_SPACER_STYLE", new ImmutableStyleInfo("dfv_TreeViewFileCheckBoxSpacer"));
        defaultStyleMap.put("DFV_VERTICAL_BORDER_SPACER_STYLE", new ImmutableStyleInfo("dfv_VerticalBorderSpacer"));
        defaultStyleMap.put("DFV_HORIZONTAL_BORDER_SPACER_STYLE", new ImmutableStyleInfo("dfv_HorizontalBorderSpacer"));
    }

    static class TreeNodeTransform
    implements TreeView.TreeNodeTransform {
        TreeNodeTransform() {
        }

        @Override
        public void transform(TreeNodeInterface node, Object obj) {
            if (obj instanceof IFileServiceMetadataTreeNode) {
                IFileServiceMetadataTreeNode tn = (IFileServiceMetadataTreeNode)obj;
                node.setURL(tn.getFileMetadata().getLocation());
                node.setText(tn.getFileMetadata().getName());
            } else {
                node.setText(obj.toString());
            }
        }
    }
}

