/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.range.html;

import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.TimePicker;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.range.BaseDateTimeRange;
import com.sas.servlet.tbeans.range.RB;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;

public class TimePickerRange
extends BaseDateTimeRange {
    private TimePicker min;
    private TimePicker max;

    @Override
    public TransformationInterface getMinimumRangeComponent() {
        if (this.min == null) {
            this.min = this.getDefaultComponent();
        }
        return this.min;
    }

    @Override
    public TransformationInterface getMaximumRangeComponent() {
        if (this.max == null) {
            this.max = this.getDefaultComponent();
        }
        return this.max;
    }

    protected TimePicker getDefaultComponent() {
        TimePicker timePicker = new TimePicker();
        timePicker.removeComponent("COMBO_LABEL_COMPONENT");
        timePicker.setRelativeValuesIncluded(true);
        return timePicker;
    }

    private ComboBoxModel getRelativeValues(int alignment) {
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
        Locale locale = this.getLocale();
        JavaScriptNode currentHourNode = new JavaScriptNode();
        currentHourNode.setValue(new DatePeriod(DateTypes.TIME, this.getTimeZone(), locale).toString());
        currentHourNode.setText(com.sas.servlet.tbeans.html.RB.getStringResource("TimePicker.", "currentTime.txt", locale));
        JavaScriptNode curHourNode = new JavaScriptNode();
        DatePeriod dp = new DatePeriod(DateTypes.TIME, DateTypes.HOUR, alignment, locale);
        curHourNode.setValue(dp.toString());
        curHourNode.setText(dp.toDisplayString(null, locale));
        dp = new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, -1, 0, DateTypes.HOUR, alignment, locale);
        JavaScriptNode prevHourNode = new JavaScriptNode();
        prevHourNode.setValue(dp.toString());
        prevHourNode.setText(dp.toDisplayString(null, locale));
        dp = new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 1, 0, DateTypes.HOUR, alignment, locale);
        JavaScriptNode nxtHourNode = new JavaScriptNode();
        nxtHourNode.setValue(dp.toString());
        nxtHourNode.setText(dp.toDisplayString(null, locale));
        JavaScriptNode curMinNode = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIME, DateTypes.MINUTE, alignment, locale);
        curMinNode.setValue(dp.toString());
        curMinNode.setText(dp.toDisplayString(null, locale));
        JavaScriptNode prevMinNode = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, -1, DateTypes.MINUTE, alignment, locale);
        prevMinNode.setValue(dp.toString());
        prevMinNode.setText(dp.toDisplayString(null, locale));
        JavaScriptNode nxtMinNode = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIME, 0, 0, 0, 0, 0, 0, 1, DateTypes.MINUTE, alignment, locale);
        nxtMinNode.setValue(dp.toString());
        nxtMinNode.setText(dp.toDisplayString(null, locale));
        JavaScriptNode nHoursAgoNode = new JavaScriptNode();
        nHoursAgoNode.setValue("t-NH");
        nHoursAgoNode.setText(com.sas.swing.visuals.RB.getStringResource((String)"DatePicker.", (String)"nHoursAgo.txt", (Locale)locale));
        JavaScriptNode nHoursFromNowNode = new JavaScriptNode();
        nHoursFromNowNode.setValue("tNH");
        nHoursFromNowNode.setText(com.sas.swing.visuals.RB.getStringResource((String)"DatePicker.", (String)"nHoursFromNow.txt", (Locale)locale));
        JavaScriptNode nMinutesAgoNode = new JavaScriptNode();
        nMinutesAgoNode.setValue("t-Nm");
        nMinutesAgoNode.setText(com.sas.swing.visuals.RB.getStringResource((String)"DatePicker.", (String)"nMinutesAgo.txt", (Locale)locale));
        JavaScriptNode nMinutesFromNowNode = new JavaScriptNode();
        nMinutesFromNowNode.setValue("tNm");
        nMinutesFromNowNode.setText(com.sas.swing.visuals.RB.getStringResource((String)"DatePicker.", (String)"nMinutesFromNow.txt", (Locale)locale));
        ((MutableComboBoxModel)comboModel).insertElementAt(currentHourNode, 0);
        ((MutableComboBoxModel)comboModel).insertElementAt(curHourNode, 1);
        ((MutableComboBoxModel)comboModel).insertElementAt(prevHourNode, 2);
        ((MutableComboBoxModel)comboModel).insertElementAt(nxtHourNode, 3);
        ((MutableComboBoxModel)comboModel).insertElementAt(curMinNode, 4);
        ((MutableComboBoxModel)comboModel).insertElementAt(prevMinNode, 5);
        ((MutableComboBoxModel)comboModel).insertElementAt(nxtMinNode, 6);
        ((MutableComboBoxModel)comboModel).insertElementAt(nHoursAgoNode, 7);
        ((MutableComboBoxModel)comboModel).insertElementAt(nHoursFromNowNode, 8);
        ((MutableComboBoxModel)comboModel).insertElementAt(nMinutesAgoNode, 9);
        ((MutableComboBoxModel)comboModel).insertElementAt(nMinutesFromNowNode, 10);
        return comboModel;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        TimePicker minTp = (TimePicker)this.getComponent(MINIMUM_RANGE_COMPONENT);
        TimePicker maxTp = (TimePicker)this.getComponent(MAXIMUM_RANGE_COMPONENT);
        if (this.getTimeZone() != null) {
            minTp.setTimeZone(this.getTimeZone());
            maxTp.setTimeZone(this.getTimeZone());
        }
        minTp.setOnChange(this.getId() + "_Obj.pickerChanged()");
        maxTp.setOnChange(this.getId() + "_Obj.pickerChanged()");
        minTp.setModel(this.getRelativeValues(1));
        maxTp.setModel(this.getRelativeValues(2));
        minTp.setRelativeValuesAddedToModel(true);
        maxTp.setRelativeValuesAddedToModel(true);
        super.write(out);
    }

    @Override
    protected void writeJavaScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println(" " + this.getId() + "_Obj = new sas_TimeRange({" + this.getJavaScriptParameters() + "});");
        if (this.getOnBlur() != null) {
            out.println(" " + this.getId() + "_Obj.onBlurEvent = \"" + this.getOnBlur() + "\";");
        }
        if (this.getOnChange() != null) {
            out.println(" " + this.getId() + "_Obj.onChangeEvent = \"" + this.getOnChange() + "\";");
        }
        if (this.getOnUpdate() != null) {
            out.println(" " + this.getId() + "_Obj.onUpdateEvent = \"" + this.getOnUpdate() + "\";");
        }
        if (this.getErrorHandlerFunctionName() != null) {
            out.println(" " + this.getId() + "_Obj.errorHandlerFunction = \"" + this.getErrorHandlerFunctionName() + "\";");
        }
        out.println(" " + this.getId() + "_Obj.message = \"" + RB.getStringResource("BaseRange.", "invalidMinMaxValue.txt", this.getLocale()) + "\";");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    @Override
    protected String getRangeType() {
        return "sas_Range.TIME";
    }

    @Override
    public ValidationInterface getMinimumValidator() {
        return null;
    }

    @Override
    public ValidationInterface getMaximumValidator() {
        return null;
    }
}

