/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html.features;

import com.sas.dataselectors.dataitems.OLAPTableRoles;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.servlet.tbeans.olaptableview.html.features.BQOLAPDnDDataModel;
import com.sas.servlet.tbeans.olaptableview.html.features.ItemMatcher;
import com.sas.servlet.tbeans.olaptableview.html.features.OLAPDnDDataModel;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.util.RoleInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class OLAPRolesDnDDataModel
extends OLAPDnDDataModel {
    private OLAPTableRoles _roles;
    private BusinessModel _bmodel;
    private BusinessQuery _query;
    private BusinessQueryToOLAPDataSetAdapter _dataset;

    OLAPRolesDnDDataModel(OLAPTableRoles roles, BusinessQueryToOLAPDataSetAdapter dataset) {
        this(roles, dataset.getBusinessQuery());
        this._dataset = dataset;
    }

    OLAPRolesDnDDataModel(OLAPTableRoles roles, BusinessQuery query) {
        this._roles = roles;
        this._query = query;
        this._bmodel = query.getBusinessModel();
    }

    public BusinessModel getModel() {
        return this._bmodel;
    }

    public BusinessQuery getQuery() {
        return this._query;
    }

    public OLAPDataSetInterface getDataSet() {
        return this._dataset;
    }

    private List createAddItemsList(Vector itemVector, Map itemmap) {
        Collection valueSet = itemmap.values();
        ArrayList<DataItem> itemsList = new ArrayList<DataItem>();
        int numItems = itemVector.size();
        for (int i = 0; i < numItems; ++i) {
            String itemid = (String)itemVector.get(i);
            if (itemid.substring(0, 1).equalsIgnoreCase("_")) {
                itemid = itemid.substring(1);
            }
            DataItem addItem = null;
            addItem = (DataItem)itemmap.get(itemid);
            if (addItem == null) {
                for (DataItem item : valueSet) {
                    if (!(item instanceof DataItemReference)) continue;
                    DataItem parentItem = ((DataItemReference)item).getBaseDataItem();
                    try {
                        if (!itemid.equals(parentItem.getID())) continue;
                        addItem = item;
                    }
                    catch (InvalidIDException invalidIDException) {}
                }
            }
            itemsList.add(addItem);
        }
        return itemsList;
    }

    @Override
    public void addItems(List items, Role role) throws MetadataException {
        RoleInterface axis = this.getRole(role);
        axis.addRoleItems(items);
    }

    private RoleInterface getRole(Role role) {
        String roleName = "column";
        if (role == Role.ROW) {
            roleName = "row";
        }
        RoleInterface[] roles = this._roles.getRoles();
        for (int i = 0; i < roles.length; ++i) {
            RoleInterface rolei = roles[i];
            if (!rolei.getRoleName().equals(roleName)) continue;
            return rolei;
        }
        return null;
    }

    @Override
    public List getAvailableItems() {
        return this._roles.getRoleItems();
    }

    @Override
    public List getItems(Role role) {
        try {
            return this.getRole(role).getRoleItems();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public List getSelectedItems() {
        ArrayList list = new ArrayList();
        list.addAll(this.getItems(Role.COLUMN));
        list.addAll(this.getItems(Role.ROW));
        return list;
    }

    @Override
    protected boolean isMeasure(Object item) {
        return ((DataItem)item).getStructure() == StructureOfDataItem.STRUCTURE_MEASURE;
    }

    @Override
    public void refreshModel() throws Exception {
        List dataItems = this._query.getResultItems();
        this._query.removeResultItems(dataItems);
        this._query.addResultItems(this.getRole(Role.COLUMN).getRoleItems(), Role.COLUMN);
        this._query.addResultItems(this.getRole(Role.ROW).getRoleItems(), Role.ROW);
        if (this._dataset != null) {
            this._dataset.refreshBusinessQuery(this._query);
            this._dataset.executeQuery();
            this._dataset = new BusinessQueryToOLAPDataSetAdapter(this._query);
        }
    }

    @Override
    public void removeItem(Object sourceItem) throws MetadataException {
        RoleInterface[] roles = this._roles.getRoles();
        for (int i = 0; i < roles.length; ++i) {
            RoleInterface role = roles[i];
            List roleItems = role.getRoleItems();
            if (!roleItems.contains(sourceItem)) continue;
            role.removeRoleItem(sourceItem);
            return;
        }
    }

    @Override
    public void removeItems(List items) throws MetadataException {
        for (int i = 0; i < items.size(); ++i) {
            Object item = items.get(i);
            this.removeItem(item);
        }
    }

    @Override
    protected ItemMatcher getDefaultDimensionMatcher() {
        return new BQOLAPDnDDataModel.BQDimensionMatcher(this._bmodel);
    }

    @Override
    protected ItemMatcher getDefaultItemByIdMatcher() {
        return new BQOLAPDnDDataModel.BQItemMatcher();
    }

    @Override
    protected ItemMatcher getDefaultMeasureMatcher() {
        return new BQOLAPDnDDataModel.BQMeasureMatcher();
    }
}

