/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html.features;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.servlet.tbeans.olaptableview.html.features.ItemMatcher;
import com.sas.servlet.tbeans.olaptableview.html.features.OLAPDnDDataModel;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import java.util.List;

public class BQOLAPDnDDataModel
extends OLAPDnDDataModel {
    private BusinessQueryToOLAPDataSetAdapter _dataset;
    private BusinessQuery _query;
    private BusinessModel _bmodel;

    public BQOLAPDnDDataModel(BusinessQueryToOLAPDataSetAdapter dataset) {
        this._dataset = dataset;
        this._query = this._dataset.getBusinessQuery();
        this._bmodel = ((DataSelection)this._query).getBaseModel();
    }

    @Override
    public List getItems(Role role) throws MetadataException {
        return this._query.getResultItems(role);
    }

    @Override
    public List getAvailableItems() {
        return this._bmodel.getObjects(false, DataItem.class);
    }

    @Override
    public List getSelectedItems() {
        return this._query.getResultItems();
    }

    @Override
    public void removeItems(List items) throws MetadataException {
        this._query.removeResultItems(items);
    }

    @Override
    public void removeItem(Object sourceItem) throws MetadataException {
        this._query.removeResultItem((DataItem)sourceItem);
    }

    @Override
    public void addItems(List items, Role role) throws MetadataException {
        this._query.addResultItems(items, role);
    }

    @Override
    public void refreshModel() throws Exception {
        this._dataset.refreshBusinessQuery(this._query);
        this._dataset.executeQuery();
        this._dataset = new BusinessQueryToOLAPDataSetAdapter(this._query);
    }

    @Override
    protected boolean isMeasure(Object item) {
        return ((DataItem)item).getStructure() == StructureOfDataItem.STRUCTURE_MEASURE;
    }

    @Override
    protected ItemMatcher getDefaultDimensionMatcher() {
        return new BQDimensionMatcher(this.getBusinessModel());
    }

    @Override
    protected ItemMatcher getDefaultMeasureMatcher() {
        return new BQMeasureMatcher();
    }

    @Override
    protected ItemMatcher getDefaultItemByIdMatcher() {
        return new BQItemMatcher();
    }

    public BusinessModel getBusinessModel() {
        return this._bmodel;
    }

    public void setBusinessModel(BusinessModel bmodel) {
        this._bmodel = bmodel;
    }

    public BusinessQueryToOLAPDataSetAdapter getDataSet() {
        return this._dataset;
    }

    public void setDataSet(BusinessQueryToOLAPDataSetAdapter dataset) {
        this._dataset = dataset;
    }

    public BusinessQuery getQuery() {
        return this._query;
    }

    public void setQuery(BusinessQuery query) {
        this._query = query;
    }

    public static class BQDimensionMatcher
    implements ItemMatcher {
        BusinessModel _bmodel;

        public BQDimensionMatcher(BusinessModel businessModel) {
            this._bmodel = businessModel;
        }

        @Override
        public boolean matches(Object item, String id) {
            String hier = this.getHierarchy((DataItem)item, this._bmodel);
            String hierHeader = this.stripHierarchy(hier);
            return hierHeader.equals(id);
        }

        private String getHierarchy(DataItem item, BusinessModel bm) {
            String hier = "";
            try {
                hier = bm.getStructure().isOLAP() ? BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)bm, (DataItem)item) : "[D_" + item.getResultSetID() + "]";
            }
            catch (MetadataException e) {
                e.printStackTrace();
            }
            return hier;
        }

        private String stripHierarchy(String hier) {
            if (hier == null || hier.length() == 0 || hier.charAt(0) != '[') {
                return "";
            }
            int i0 = hier.indexOf(93);
            return hier.substring(1, i0);
        }
    }

    public static class BQMeasureMatcher
    implements ItemMatcher {
        @Override
        public boolean matches(Object item, String id) {
            String measure = ((DataItem)item).getLabel();
            return measure.equals(id);
        }
    }

    public static class BQItemMatcher
    implements ItemMatcher {
        boolean _checkBaseItem = true;

        public BQItemMatcher() {
            this(true);
        }

        public BQItemMatcher(boolean checkBaseItem) {
            this._checkBaseItem = checkBaseItem;
        }

        @Override
        public boolean matches(Object item, String id) {
            DataItem dataItem = (DataItem)item;
            if (id.equals(dataItem.getResultSetID())) {
                return true;
            }
            if (this._checkBaseItem && dataItem instanceof DataItemReference) {
                DataItemReference dir = (DataItemReference)dataItem;
                return id.equals(dir.getBaseDataItem().getResultSetID());
            }
            return false;
        }
    }
}

