/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.HttpActionProviderViewInterface;
import com.sas.actionprovider.refresh.PartialRefreshActionHandler;
import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.olap.ShowDetailDataCommand;
import com.sas.framework.themes.client.BrowserType;
import com.sas.framework.themes.client.Theme;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.navigationbar.html.NavigationBarColumnScrollingElement;
import com.sas.servlet.tbeans.navigationbar.html.NavigationBarRowScrollingElement;
import com.sas.servlet.tbeans.navigationbar.html.TableColumnNavigationBar;
import com.sas.servlet.tbeans.navigationbar.html.TableRowNavigationBar;
import com.sas.servlet.tbeans.olaptableview.html.RB;
import com.sas.servlet.tbeans.olaptableview.html.ShowDetailDataComposite;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.html.TableViewComposite;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.Components;
import com.sas.servlet.util.DocType;
import com.sas.storage.jdbc.JDBCToTableModelAdapter;
import com.sas.util.SimpleTemplateToPrintWriter;
import com.sas.util.Strings;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.table.TableModel;

@SASScope
public class ShowDetailDataUtil {
    private static CommonLoggerInterface _log;
    public static final String DEFAULT_PARTIAL_REFRESH_URL_TEMPLATE = "javascript: void(sas.ajax.doAction('%AJAX_CONTROLLER_URL%QUERYSTRING&amp;METHOD=doAjaxExecuteAndWrite&amp;viewerId=%REFRESHVIEWERID&amp;_referringURI=%REFERRINGURI'));";
    public static final String RB_KEY = "ShowDetailDataUtil.";

    @SASScope
    public static HttpActionProvider getActionProvider(HttpServletRequest request) {
        String apName = request.getParameter("APNAME");
        HttpActionProvider ap = null;
        ap = (HttpActionProvider)((Object)request.getAttribute(apName));
        if (ap == null) {
            ap = (HttpActionProvider)((Object)request.getSession().getAttribute(apName));
        }
        return ap;
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter out = null;
        ShowDetailDataComposite sddc = null;
        try {
            out = response.getWriter();
            HttpSession session = request.getSession();
            HttpActionProvider ap = ShowDetailDataUtil.getActionProvider(request);
            String showDetailStatus = request.getParameter("SAS_ShowDetailMode");
            if (showDetailStatus != null && showDetailStatus.equals("NEW")) {
                sddc = ShowDetailDataUtil.createComponent(ap, request, session);
            } else {
                if (showDetailStatus != null && showDetailStatus.equals("SWITCH_CH")) {
                    ShowDetailDataUtil.switchColumnHeaders(out, session);
                    return;
                }
                sddc = (ShowDetailDataComposite)session.getAttribute("SAS_SHOW_DETAIL_TABLE");
                if (showDetailStatus == null || !showDetailStatus.equalsIgnoreCase("DISPLAYONLY")) {
                    ap.executeCommand(request, response, out);
                }
            }
            if (sddc != null) {
                ShowDetailDataUtil.initializeDialogForWrite(sddc, request, response);
            }
            if (sddc != null) {
                sddc.write(out);
            } else {
                out.println("<h1>" + RB.getStringResource(RB_KEY, "inError.txt", request.getLocale()) + "</h1>");
            }
        }
        catch (Exception ex) {
            ShowDetailDataUtil.handleException(ex, request, response, out, sddc);
        }
    }

    private static ShowDetailDataComposite createComponent(HttpActionProvider ap, HttpServletRequest request, HttpSession session) {
        ShowDetailDataCommand showDetailCommand = null;
        if (ap == null) {
            return null;
        }
        DynamicAttributeCommandInterface command = ap.getExecutableCommand(request);
        if (command instanceof ShowDetailDataCommand) {
            showDetailCommand = (ShowDetailDataCommand)command;
        }
        if (showDetailCommand == null) {
            return null;
        }
        Map attrMap = ap.getStoredCommandAttributes(request);
        ShowDetailDataComposite sddc = (ShowDetailDataComposite)attrMap.get("showDetailDataViewer");
        if (sddc == null) {
            sddc = new ShowDetailDataComposite();
        }
        TableModel showDetailModel = showDetailCommand.getShowDetailDataModel();
        sddc.setVisible(true);
        sddc.setModel(showDetailModel);
        sddc.setActionProvider(ap);
        String apName = request.getParameter("APNAME");
        String cmdid = request.getParameter("CMDID");
        ShowDetailDataUtil.fixForwardLocations(sddc, apName, cmdid, ap);
        session.setAttribute("SAS_SHOW_DETAIL_TABLE", (Object)sddc);
        return sddc;
    }

    private static void initializeDialogForWrite(ShowDetailDataComposite sddc, HttpServletRequest request, HttpServletResponse response) {
        sddc.setRequest(request);
        sddc.setResponse(response);
        sddc.setLocale(request.getLocale());
        ComponentPropertyManager propertyManager = ComponentPropertyManager.getInstance(request);
        HashMap<String, String> dictionary = sddc.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            sddc.setTemplateDictionary(dictionary);
        }
        StringWriter docTypeWriter = new StringWriter();
        DocType.write(docTypeWriter, propertyManager.getDocType());
        docTypeWriter.flush();
        StringWriter componentsInitWriter = new StringWriter();
        PrintWriter componentsInitPrintWriter = new PrintWriter(componentsInitWriter);
        Theme theme = (Theme)request.getAttribute("sas.framework.themeobject");
        if (theme != null) {
            BrowserType browserType = (BrowserType)request.getAttribute("sas.framework.browsertype");
            String stylesString = BaseUtil.getStyleSheetLinks(theme, browserType, null);
            componentsInitPrintWriter.println(stylesString);
        }
        Components.init(componentsInitPrintWriter, request);
        componentsInitWriter.flush();
        dictionary.put(BaseUtil.COMPONENTS_INIT, componentsInitWriter.toString());
        dictionary.put(BaseUtil.IMAGE_LOCATION, propertyManager.getImageLocation());
        dictionary.put(BaseUtil.STYLE_LOCATION, propertyManager.getStyleLocation());
        dictionary.put(BaseUtil.JAVASCRIPT_LOCATION, propertyManager.getJavaScriptLocation());
        dictionary.put(BaseUtil.TEMPLATE_LOCATION, propertyManager.getTemplateLocation());
        dictionary.put(BaseUtil.DOC_TYPE, docTypeWriter.toString());
    }

    private static void switchColumnHeaders(PrintWriter out, HttpSession session) throws IOException {
        ShowDetailDataComposite sddc = (ShowDetailDataComposite)session.getAttribute("SAS_SHOW_DETAIL_TABLE");
        if (sddc == null) {
            return;
        }
        TableViewComposite tvc = (TableViewComposite)sddc.getComponent("SHOWDETAIL_TABLEVIEW_COMPOSITE");
        if (tvc == null) {
            return;
        }
        TableView tv = (TableView)tvc.getComponent("TABLEVIEW_TABLEDATA");
        if (tv == null) {
            return;
        }
        int startRow = tv.getStartRow();
        int endRow = tv.getEndRow();
        int startCol = tv.getStartColumn();
        int endCol = tv.getEndColumn();
        TableModel showDetailModel = tvc.getModel();
        if (showDetailModel instanceof JDBCToTableModelAdapter) {
            tvc.setModel(null);
            JDBCToTableModelAdapter jdbcTableModel = (JDBCToTableModelAdapter)showDetailModel;
            String columnInfoToUse = "LABEL".equals(jdbcTableModel.getColumnInfoUsed()) ? "NAME" : "LABEL";
            jdbcTableModel.setColumnInfoUsed(columnInfoToUse);
        }
        tvc.setModel(showDetailModel);
        tv.setStartRow(startRow);
        tv.setEndRow(endRow);
        tv.setStartColumn(startCol);
        tv.setEndColumn(endCol);
        tv.write(out);
    }

    private static void handleException(Exception ex, HttpServletRequest request, HttpServletResponse response, PrintWriter out, ShowDetailDataComposite sddc) {
        if (sddc != null) {
            HashMap<String, StringBuffer> map;
            sddc.setInErrorState(true);
            StringWriter componentsInitWriter = new StringWriter();
            Components.init(new PrintWriter(componentsInitWriter), request);
            componentsInitWriter.flush();
            ComponentPropertyManager propertyManager = ComponentPropertyManager.getInstance(request);
            StringBuffer message = new StringBuffer();
            StringBuffer m = new StringBuffer("<h2>" + RB.getStringResource(RB_KEY, "inError.txt", request.getLocale()) + "</h2>");
            m.append(ex.getLocalizedMessage());
            if (ex.getCause() != null) {
                m.append(ex.getCause().getMessage());
                if (m != null) {
                    message.append("<ul >");
                    String formattedMessage = Strings.replace((String)m.toString(), (int)0, (int)(m.length() - 1), (String)"\n", (String)"<BR><li>");
                    message = message.append(formattedMessage);
                    message.append("</ul>");
                }
            } else {
                message.append(m);
            }
            if ((map = sddc.getTemplateDictionary()) == null) {
                map = new HashMap<String, StringBuffer>();
            }
            map.put("SHOWDETAIL_ERROR", message);
            map.put(BaseUtil.COMPONENTS_INIT, (StringBuffer)((Object)componentsInitWriter.toString()));
            map.put(BaseUtil.TEMPLATE_LOCATION, (StringBuffer)((Object)propertyManager.getTemplateLocation()));
            PrintWriter bufferedWriter = new PrintWriter(new BufferedWriter(out));
            Button closeButton = (Button)sddc.getComponent("SHOWDETAIL_ERROR_BUTTON");
            if (closeButton != null) {
                closeButton.setVisible(true);
                closeButton.setRequest(request);
                closeButton.setResponse(response);
                map.put("SHOWDETAIL_ERROR_BUTTON", (StringBuffer)((Object)closeButton));
            }
            SimpleTemplateToPrintWriter.write((String)TemplateSupport.getTemplate(request, "ShowDetail.html"), map, (PrintWriter)bufferedWriter);
            if (closeButton != null) {
                closeButton.setVisible(false);
            }
            map.remove("SHOWDETAIL_ERROR");
            sddc.getDefaultTemplate();
            bufferedWriter.flush();
            out.println();
        } else {
            out.println("<h2>" + RB.getStringResource(RB_KEY, "inError.txt", request.getLocale()) + "</h2>");
            String message = ex.getMessage();
            if (ex.getCause() != null && (message = ex.getCause().getMessage()) != null) {
                out.println("<ul>");
                message = Strings.replace((String)message, (int)0, (int)(message.length() - 1), (String)"\n", (String)"<BR><li>");
                out.println(message);
                out.println("</ul>");
            }
            out.println("</span>");
            out.println("<center><Button onClick='window.close()' >" + com.sas.servlet.tbeans.dataselectors.find.html.RB.getStringResource("FindSelector.", "close.txt", request.getLocale()) + "</Button></center>");
        }
    }

    private static void fixForwardLocations(ShowDetailDataComposite sddc, String apName, String cmdid, HttpActionProvider ap) {
        TableViewComposite tvc = (TableViewComposite)sddc.getComponent("SHOWDETAIL_TABLEVIEW_COMPOSITE");
        TableView tv = (TableView)tvc.getComponent("TABLEVIEW_TABLEDATA");
        ShowDetailDataUtil.setForwardLocation(tv, apName, cmdid, ap);
        TableColumnNavigationBar cnb = (TableColumnNavigationBar)tvc.getComponent("TABLEVIEW_COLUMN_NAVIGATIONBAR");
        NavigationBarColumnScrollingElement cse = (NavigationBarColumnScrollingElement)cnb.getComponent("NAVIGATIONBAR_COLUMN_ELEMENT");
        ShowDetailDataUtil.setForwardLocation(cse, apName, cmdid, ap);
        TableRowNavigationBar rnb = (TableRowNavigationBar)tvc.getComponent("TABLEVIEW_ROW_NAVIGATIONBAR");
        NavigationBarRowScrollingElement rse = (NavigationBarRowScrollingElement)rnb.getComponent("NAVIGATIONBAR_ROW_ELEMENT");
        ShowDetailDataUtil.setForwardLocation(rse, apName, cmdid, ap);
    }

    private static void setForwardLocation(HttpActionProviderViewInterface tv, String apName, String cmdid, HttpActionProvider ap) {
        ap.addExternalRequestParameter(tv, "CLASS_PARAMETER", "com.sas.servlet.tbeans.olaptableview.html.ShowDetailDataUtil");
        ap.addExternalRequestParameter(tv, "sas_forwardLocation", "/MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.olaptableview.html.ShowDetailDataUtil%26APNAME=" + apName + "%26CMDID=" + cmdid);
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)PartialRefreshActionHandler.class.getName(), null);
        }
        return _log;
    }
}

