/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.codepolicy.SASScope;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.olaptableview.html.DefaultOLAPTableDataCellRenderer;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.util.HttpCondition;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.ConditionEvaluationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

@SASScope
public class OLAPConditionTableCellRenderer
extends DefaultOLAPTableDataCellRenderer {
    @Override
    public void write(PrintWriter out, AbstractBaseTableView tableview, Object value, String name, ActionList actions) throws IOException {
        StyleInfo oldStyleInfo = this.getStyleInfo();
        ConditionEvaluationInterface evaluator = tableview.getConditionEvaluator();
        if (evaluator != null) {
            StyleInfo styleInfo;
            Object identifier = null;
            HttpCondition condition = null;
            if (tableview instanceof OLAPTableView) {
                OLAPTableView OLAPTable = (OLAPTableView)tableview;
                Object[] values = this.getValues(OLAPTable);
                condition = (HttpCondition)((Object)evaluator.evaluateConditions((Object)name, values));
            }
            if (condition != null && (styleInfo = condition.getStyleInfo()) != null) {
                this.setStyleInfo(condition.getStyleInfo());
            }
        }
        super.write(out, tableview, value, name, actions);
        this.setStyleInfo(oldStyleInfo);
    }

    private Object[] getValues(OLAPTableView tableView) {
        Object[] values = null;
        OLAPDataSetInterface model = tableView.getModel();
        try {
            if (model instanceof BusinessQueryProviderInterface) {
                BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                List resultItems = businessQuery.getResultItems();
                Role role = null;
                ArrayList<DataItem> measureList = new ArrayList<DataItem>();
                for (DataItem di : resultItems) {
                    if (di.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) continue;
                    if (role == null) {
                        role = businessQuery.getResultItemRole(di);
                    }
                    measureList.add(di);
                }
                ResultSetMetadataInterface resultSetMetadata = model.getResultSetMetadata();
                int[] coordinates = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)resultSetMetadata, (int)tableView.getCurrentCellOrdinal());
                AxisInterface axis = null;
                TupleInterface tuple = null;
                if (role == Role.COLUMN) {
                    axis = resultSetMetadata.getAxes(0, 1)[0];
                    tuple = axis.getTuples(coordinates[0], 1)[0];
                } else if (role == Role.ROW) {
                    axis = resultSetMetadata.getAxes(1, 1)[0];
                    tuple = axis.getTuples(coordinates[1], 1)[0];
                }
                if (tuple.getTupleDepth() == 1) {
                    if (role == Role.COLUMN) {
                        int[] startCoordinates = new int[]{0, coordinates[1]};
                        int start = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)resultSetMetadata, (int[])startCoordinates);
                        int[] endCoordinates = new int[]{axis.getTupleCount() - 1, coordinates[1]};
                        int end = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)resultSetMetadata, (int[])endCoordinates);
                        values = model.getCells((long)start, (long)end);
                    } else if (role == Role.ROW) {
                        int[] startCoordinates = new int[]{coordinates[0], 0};
                        int start = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)resultSetMetadata, (int[])startCoordinates);
                        int[] endCoordinates = new int[]{coordinates[0], axis.getTupleCount() - 1};
                        int end = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)resultSetMetadata, (int[])endCoordinates);
                        values = model.getCells((long)start, (long)end);
                    }
                } else if (role == Role.COLUMN) {
                    TupleElementInterface tupleElement = tuple.getElements(tuple.getTupleDepth() - 2, 1)[0];
                    int[] startCoordinates = new int[]{tupleElement.getMinimumCoordinate(), coordinates[1]};
                    int start = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)resultSetMetadata, (int[])startCoordinates);
                    int[] endCoordinates = new int[]{tupleElement.getMaximumCoordinate(), coordinates[1]};
                    int end = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)resultSetMetadata, (int[])endCoordinates);
                    values = model.getCells((long)start, (long)end);
                } else if (role == Role.ROW) {
                    TupleElementInterface tupleElement = tuple.getElements(tuple.getTupleDepth() - 2, 1)[0];
                    int[] startCoordinates = new int[]{coordinates[0], tupleElement.getMinimumCoordinate()};
                    int start = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)resultSetMetadata, (int[])startCoordinates);
                    int[] endCoordinates = new int[]{coordinates[0], tupleElement.getMaximumCoordinate()};
                    int end = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)resultSetMetadata, (int[])endCoordinates);
                    values = model.getCells((long)start, (long)end);
                }
            }
        }
        catch (OLAPException oLAPException) {
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return values;
    }
}

