/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import java.io.PrintWriter;
import java.util.Map;

@SASScope
class MemberPropertiesUtil {
    MemberPropertiesUtil() {
    }

    static void displayMemberProperties(PrintWriter out, AbstractBaseTableView tableview, Object value, ActionList actions, String styleClassPrefix) throws OLAPException {
        if (!(value instanceof TupleElementInterface)) {
            return;
        }
        TupleElementInterface tupleElem = (TupleElementInterface)value;
        Map properties = tupleElem.getProperties();
        if (properties == null || properties.size() == 0) {
            return;
        }
        int axis = tupleElem.getTuple().getAxis().getAxisNumber();
        String classStr = MemberPropertiesUtil.getPropertyStyleClass(tableview, actions, axis, styleClassPrefix);
        boolean first = true;
        for (Map.Entry entry : properties.entrySet()) {
            boolean usingTable;
            String str = MemberPropertiesUtil.buildMemberPropertyString(entry, tupleElem, tableview);
            if (str == null) continue;
            boolean pad = actions != null && actions.size() >= 3 && axis == 1;
            boolean bl = usingTable = tableview.getTextWrapping() != 0 && actions != null && actions.size() > 0;
            if (!(pad || first && usingTable)) {
                out.print("<br>");
            }
            if (pad) {
                out.print("<div style=\"padding-left:34px\">");
            }
            out.print("<span" + classStr + ">" + str + "</span>");
            if (pad) {
                out.print("</div>");
            }
            first = false;
        }
    }

    private static String getPropertyStyleClass(AbstractBaseTableView tableview, ActionList actions, int axis, String styleClassPrefix) {
        String classStr = "";
        if (tableview.isAllActionsVisible() && actions != null && !actions.isEmpty()) {
            String classid = axis == 0 ? "OLAPTable_ch_menu" : "OLAPTable_rh_menu";
            String stylePrefix = styleClassPrefix;
            if (stylePrefix == null) {
                stylePrefix = "";
            }
            classStr = " class=\"" + stylePrefix + classid + "\"";
        }
        return classStr;
    }

    private static PropertyInterface[] checkLevelForMemberProperty(TupleElementInterface tupleElem, String uniquePropertyName, AbstractBaseTableView tableview) throws OLAPException {
        if (tupleElem.getType() == TupleElementType.TOTAL || tupleElem.getType() == TupleElementType.SUBTOTAL) {
            return null;
        }
        OLAPTableView otv = (OLAPTableView)tableview;
        MetadataInterface metadata = otv.getModel().getDatabaseMetadata();
        if (metadata == null) {
            return null;
        }
        int i = uniquePropertyName.indexOf(91, 1);
        if (i < 0) {
            return null;
        }
        String propName = uniquePropertyName.substring(i + 1, uniquePropertyName.length() - 1);
        Filter filter = new Filter();
        filter.setPropertyName(propName);
        filter.setCubeName(otv.getModel().getCubeName());
        filter.setUniqueLevelName(tupleElem.getUniqueLevelName());
        return metadata.getProperties(filter);
    }

    private static String buildMemberPropertyString(Map.Entry entry, TupleElementInterface tupleElem, AbstractBaseTableView tableview) throws OLAPException {
        String propValue = (String)entry.getValue();
        if (propValue == null) {
            return null;
        }
        PropertyInterface[] props = MemberPropertiesUtil.checkLevelForMemberProperty(tupleElem, (String)entry.getKey(), tableview);
        String propName = null;
        if (props != null && props.length > 0) {
            propName = props[0].getLabel();
        } else {
            if (props != null) {
                return null;
            }
            propName = (String)entry.getKey();
            int i = propName.indexOf(91, 1);
            if (i < 0) {
                return null;
            }
            propName = propName.substring(i + 1, propName.length() - 1);
        }
        return propName + ": " + propValue;
    }
}

