/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.gl.JLegend;
import com.sas.graphics.util.gtk.gl.Legend;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.dataselectors.html.OLAPMenuBar;
import com.sas.servlet.tbeans.html.AppliedFilters;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.navigationbar.BaseNavigationBar;
import com.sas.servlet.tbeans.navigationbar.html.TableColumnNavigationBar;
import com.sas.servlet.tbeans.navigationbar.html.TableRowNavigationBar;
import com.sas.servlet.tbeans.olaptableview.BaseOLAPTableView;
import com.sas.servlet.tbeans.olaptableview.html.GraphOLAPTableUtil;
import com.sas.servlet.tbeans.olaptableview.html.GraphOLAPTableViewCompositeKeysInterface;
import com.sas.servlet.tbeans.olaptableview.html.GraphOLAPTableViewCompositeStyleKeysInterface;
import com.sas.servlet.tbeans.olaptableview.html.OLAPColorMapTableCellRenderer;
import com.sas.servlet.tbeans.olaptableview.html.OLAPDrillState;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableLegend;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.text.SASFormat;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Format;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SASScope
public class GraphOLAPTableViewComposite
extends BaseCompositeTransformation
implements GraphOLAPTableViewCompositeKeysInterface,
GraphOLAPTableViewCompositeStyleKeysInterface,
ContentsChangedListener {
    static final String RB_KEY = "GraphOLAPTableViewComposite.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "GraphOLAPTableView.html";
    public static final String DEFAULT_COLORMAP_ID = "DEFAULT_COLOR_MAP_ID";
    private OLAPDataSetInterface dataModel;
    private OLAPColorMapTableCellRenderer colorMapCellRenderer;
    private double[] spectrumValues;
    private String rampedMeasureName;
    private String defaultMeasureName;
    private HttpActionProvider oldAP;
    private DataItem dataItem;
    private CommonLoggerInterface log = null;
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("GRAPHOLAPTABLEVIEW_CONTAINER_STYLE", new ImmutableStyleInfo("GraphOLAPTableContainer"));
            defaultStyleMap.put("GRAPHOLAPTABLEVIEW_CONTENT_STYLE", new ImmutableStyleInfo("GraphOLAPTableContent"));
            defaultStyleMap.put("GRAPHOLAPTABLEVIEW_TITLE_STYLE", new ImmutableStyleInfo("GraphOLAPTableTitle"));
            defaultStyleMap.put("GRAPHOLAPTABLEVIEW_FOOTER_STYLE", new ImmutableStyleInfo("GraphOLAPTableFooter"));
            defaultStyleMap.put("GRAPHOLAPTABLEVIEW_TOOLBAR_STYLE", new ImmutableStyleInfo("GraphOLAPTableToolBar"));
            defaultStyleMap.put("GRAPHOLAPTABLEVIEW_ROW_NAVIGATIONBAR_STYLE", new ImmutableStyleInfo("GraphOLAPTableRowNavigationBar"));
            defaultStyleMap.put("GRAPHOLAPTABLEVIEW_LEGEND_STYLE", new ImmutableStyleInfo("GraphOLAPTableLegend"));
        }
    }

    public GraphOLAPTableViewComposite() {
        this(null);
    }

    public GraphOLAPTableViewComposite(OLAPDataSetInterface model) {
        this(model, null, null);
    }

    public GraphOLAPTableViewComposite(OLAPDataSetInterface model, HttpServletRequest request, HttpServletResponse response) {
        this.setId(Util.getName((String)"gotvc"));
        this.log = LoggerRepository2.getLogger((String)GraphOLAPTableViewComposite.class.getPackage().getName(), null);
        OLAPTableView table = new OLAPTableView();
        table.setId(this.getId() + "_otv");
        table.setWidthPercentage(100);
        table.setRowPageSize(20);
        table.setColumnPageSize(10);
        this.setModel(model);
        this.setResponse(response);
        this.setRequest(request);
        this.rampedMeasureName = null;
        this.oldAP = null;
        this.colorMapCellRenderer = new OLAPColorMapTableCellRenderer();
        GraphOLAPTableViewComposite.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setComponent("GRAPHOLAPTABLEVIEW_TABLEDATA", table);
        this.setComponent("GRAPHOLAPTABLEVIEW_COLUMN_NAVIGATIONBAR", this.getDefaultColumnNavigationBar());
        this.setComponent("GRAPHOLAPTABLEVIEW_ROW_NAVIGATIONBAR", this.getDefaultRowNavigationBar());
        this.setComponent("GRAPHOLAPTABLEVIEW_MENUBAR", this.getDefaultMenuBar());
        this.setComponent("GRAPHOLAPTABLEVIEW_TITLE", this.getDefaultTitle());
        this.setComponent("GRAPHOLAPTABLEVIEW_FOOTER", this.getDefaultFooter());
        this.setComponent("GRAPHOLAPTABLEVIEW_DRILLSTATE", this.getDefaultOLAPDrillState());
        this.setComponent("GRAPHOLAPTABLEVIEW_APPLIEDFILTERS", this.getDefaultAppliedFilters());
        this.setComponent("GRAPHOLAPTABLEVIEW_LEGEND", this.getDefaultLegend());
        this.setTemplateKey("Graph_OLAP_Table_View");
    }

    protected BaseNavigationBar getDefaultColumnNavigationBar() {
        TransformationInterface table = this.getComponent("GRAPHOLAPTABLEVIEW_TABLEDATA");
        if (table instanceof BaseOLAPTableView) {
            TableColumnNavigationBar cnb = new TableColumnNavigationBar((BaseOLAPTableView)table);
            cnb.setId(this.getId() + "_cnb");
            return cnb;
        }
        return null;
    }

    protected BaseNavigationBar getDefaultRowNavigationBar() {
        TransformationInterface table = this.getComponent("GRAPHOLAPTABLEVIEW_TABLEDATA");
        if (table instanceof BaseOLAPTableView) {
            TableRowNavigationBar rnb = new TableRowNavigationBar((BaseOLAPTableView)table);
            rnb.setId(this.getId() + "_rnb");
            return rnb;
        }
        return null;
    }

    protected Label getDefaultTitle() {
        Label title = new Label("GRAPHOLAPTABLEVIEW TITLE");
        title.setVisible(false);
        title.setId(this.getId() + "_title");
        return title;
    }

    protected Label getDefaultFooter() {
        Label footer = new Label("GRAPHOLAPTABLEVIEW FOOTER");
        footer.setVisible(false);
        footer.setId(this.getId() + "_footer");
        return footer;
    }

    protected ActionProviderMenuBar getDefaultMenuBar() {
        OLAPMenuBar mb = new OLAPMenuBar();
        mb.setModel(this.getModel());
        TransformationInterface table = this.getComponent("GRAPHOLAPTABLEVIEW_TABLEDATA");
        if (table instanceof BaseActionTransformation) {
            mb.setViewer((BaseActionTransformation)table);
        }
        mb.setId(this.getId() + "_mb");
        return mb;
    }

    protected OLAPDrillState getDefaultOLAPDrillState() {
        OLAPDrillState drillState = new OLAPDrillState();
        drillState.setSeparator(">");
        drillState.setSeparatorImage(null);
        drillState.setId(this.getId() + "_ds");
        return drillState;
    }

    protected AppliedFilters getDefaultAppliedFilters() {
        AppliedFilters appliedFilters = new AppliedFilters();
        appliedFilters.setId(this.getId() + "_af");
        appliedFilters.setTitleDisplayed(4);
        appliedFilters.setNoFilterTextDisplayed(false);
        appliedFilters.setVisible(false);
        return appliedFilters;
    }

    protected TableLegend getDefaultLegend() {
        JLegend jlegend = new JLegend();
        TableLegend tableLegend = new TableLegend(jlegend);
        tableLegend.setId(this.getId() + "_tl");
        return tableLegend;
    }

    private void setupTableLegend() {
        TableLegend tl = (TableLegend)this.getComponent("GRAPHOLAPTABLEVIEW_LEGEND");
        GraphStyle graphStyle = this.getGraphStyle();
        ContinuousRangeToColorMap colorMap = new ContinuousRangeToColorMap();
        Color[] colorRampColors = new Color[]{graphStyle.getDataElementStyles().getContinuousFillThreeColorStartColor(), graphStyle.getDataElementStyles().getContinuousContrastThreeColorNeutralColor(), graphStyle.getDataElementStyles().getContinuousFillThreeColorEndColor()};
        colorMap.setColorSpectrumColors(colorRampColors);
        if (this.spectrumValues == null || this.spectrumValues != null && this.spectrumValues.length == 0) {
            double[] dArray = this.getSpectrumValues(this.dataModel, this.rampedMeasureName);
        }
        if (this.spectrumValues != null) {
            colorMap.setColorSpectrumValues(this.spectrumValues);
            tl.setVisible(true);
        } else {
            tl.setVisible(false);
        }
        String format = null;
        if (this.dataItem != null) {
            format = this.dataItem.getFormat();
        }
        if (format != null && format.length() > 0) {
            colorMap.setFormat(new GTKFormat((Format)SASFormat.getInstance((String)format)));
        } else {
            colorMap.setFormat(new GTKFormat((Format)SASFormat.getInstance((String)"BEST12.")));
        }
        Legend legend = new Legend();
        legend.colors.connectFrom(colorMap.uniqueValue);
        legend.labels.connectFrom(colorMap.label);
        legend.setContinuous(true);
        legend.setSmoothShading(true);
        legend.getStyle().setShapePolicy(2);
        legend.setLayoutByRow(true);
        legend.setEndLabelsOnly(true);
        legend.getStyle().setBackgroundOn(true);
        legend.getStyle().setBackgroundColor(graphStyle.getBackgroundFillStyle().getSolidFillColor());
        legend.getStyle().getTitleStyle().setFont(graphStyle.getLabelTextStyle().getFont());
        legend.getStyle().getLabelStyle().setFont(graphStyle.getValueTextStyle().getFont());
        if (this.dataItem != null) {
            legend.title.setValue(this.dataItem.getLabel());
        }
        tl.setLegend(legend);
        tl.setWidth(300);
        tl.setHeight(60);
    }

    public OLAPDataSetInterface getModel() {
        return this.dataModel;
    }

    public void setModel(OLAPDataSetInterface model) {
        if (this.dataModel != model) {
            this.dataModel = model;
            TransformationInterface o = this.getComponent("GRAPHOLAPTABLEVIEW_TABLEDATA");
            if (o != null && o instanceof BaseOLAPTableView) {
                ((BaseOLAPTableView)o).setModel(this.dataModel);
            }
            if ((o = this.getComponent("GRAPHOLAPTABLEVIEW_MENUBAR")) != null && o instanceof OLAPMenuBar) {
                ((OLAPMenuBar)o).setModel(this.dataModel);
            }
            if ((o = this.getComponent("GRAPHOLAPTABLEVIEW_DRILLSTATE")) != null && o instanceof OLAPDrillState) {
                ((OLAPDrillState)o).setModel(this.dataModel);
            }
            if ((o = this.getComponent("GRAPHOLAPTABLEVIEW_APPLIEDFILTERS")) != null && o instanceof AppliedFilters) {
                ((AppliedFilters)o).setModel(this.dataModel);
            }
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider provider) {
        super.setActionProvider(provider);
        if (provider != null && this.oldAP != provider) {
            provider.addContentsChangedListener(this);
            if (this.oldAP != null) {
                this.oldAP.removeContentsChangedListener(this);
            }
            this.oldAP = provider;
        } else if (provider == null && this.oldAP != null) {
            this.oldAP.removeContentsChangedListener(this);
            this.oldAP = provider;
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        super.write(out);
        OLAPTableView tv = (OLAPTableView)this.getComponent("GRAPHOLAPTABLEVIEW_TABLEDATA");
        tv.removeAllCellRenderers();
        int startRow = tv.getStartRow();
        int endRow = tv.getEndRow();
        int startCol = tv.getStartColumn();
        int endCol = tv.getEndColumn();
        if (startRow == -1 && endRow == -1 && startCol == -1 && endCol == -1) {
            tv.initialize();
        }
        tv.setup();
        this.setupTableLegend();
        if (this.spectrumValues != null) {
            this.colorMapCellRenderer.setColorRampValues(this.spectrumValues[0], this.spectrumValues[1], this.spectrumValues[2]);
        }
        try {
            if (this.dataItem != null) {
                tv.setCellRenderer(this.dataItem.getID(), (TableCellRenderer)this.colorMapCellRenderer);
            } else {
                tv.setCellRenderer(DEFAULT_COLORMAP_ID, (TableCellRenderer)this.colorMapCellRenderer);
                double[] dArray = this.colorMapCellRenderer.getColorRampValues();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        OLAPDrillState ds = (OLAPDrillState)this.getComponent("GRAPHOLAPTABLEVIEW_DRILLSTATE");
        if (ds != null) {
            ds.setUseCachedTuples(true);
        }
        this.writeTemplate(this, null, out);
        this.cleanUpResources();
    }

    public void contentsChanged(ContentsChangedEvent cce) {
        if (cce != null && cce instanceof ActionProviderEvent) {
            ActionProviderEvent ape = (ActionProviderEvent)cce;
            Map eventInfo = ape.getEventInfo();
            if (eventInfo == null || ape.getSource() != this.dataModel) {
                return;
            }
            double[] sv = null;
            sv = this.rampedMeasureName != null ? this.getSpectrumValues(this.dataModel, this.rampedMeasureName) : this.getSpectrumValues(this.dataModel, null);
        }
    }

    private DataItem getBackgroundMeasure(OLAPDataSetInterface model) {
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.dataModel).getBusinessQuery();
            if (businessQuery != null) {
                List l = businessQuery.getResultItems();
                for (int i = 0; i < l.size(); ++i) {
                    DataItem di = (DataItem)l.get(i);
                    Role brole = businessQuery.getResultItemRole(di);
                    if (!brole.toString().equals(Role.BACKGROUND.toString()) || !di.getStructure().toString().equals(StructureOfDataItem.STRUCTURE_MEASURE.toString())) continue;
                    return di;
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }

    public double[] getSpectrumValues(OLAPDataSetInterface model, String uniqueName) {
        Map hm = null;
        try {
            hm = GraphOLAPTableUtil.getMinMax(model, uniqueName);
        }
        catch (OLAPException oe) {
            System.out.println("Exception in getMinMax()-" + oe.getMessage());
        }
        if (hm != null) {
            double min = (Double)hm.get("MIN");
            double max = (Double)hm.get("MAX");
            this.spectrumValues = new double[]{min, min + (max - min) / 2.0, max};
            this.defaultMeasureName = (String)hm.get("UNIQUE_NAME");
            this.dataItem = (DataItem)hm.get("DATA_ITEM");
            return this.spectrumValues;
        }
        this.spectrumValues = null;
        return null;
    }

    public String getRampedMeasureName() {
        if (this.rampedMeasureName != null) {
            return this.rampedMeasureName;
        }
        return this.defaultMeasureName;
    }

    public OLAPColorMapTableCellRenderer getOLAPColorMapTableCellRenderer() {
        return this.colorMapCellRenderer;
    }

    public void setOLAPColorMapTableCellRenderer(OLAPColorMapTableCellRenderer renderer) {
        this.colorMapCellRenderer = renderer;
    }

    protected GraphStyle getGraphStyle() {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        return cpm.getGraphStyle();
    }
}

