/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SASScope
public class GraphOLAPTableUtil {
    public static Map getMinMax(OLAPDataSetInterface model, String uName) throws OLAPException {
        Map hm = GraphOLAPTableUtil.getMeasureInfo(model, uName);
        String uniqueName = null;
        DataItem di = null;
        if (hm != null) {
            String role = (String)hm.get("ROLE");
            AxisInterface axis = (AxisInterface)hm.get("AXIS");
            int rowCount = (Integer)hm.get("ROW_COUNT");
            int columnCount = (Integer)hm.get("COLUMN_COUNT");
            int backgroundCount = (Integer)hm.get("BACKGROUND_COUNT");
            uniqueName = uName == null ? (String)hm.get("UNIQUE_NAME") : uName;
            di = (DataItem)hm.get("DATA_ITEM");
            int startCell = -1;
            int endCell = -1;
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            double cell = Double.MAX_VALUE;
            TupleInterface[] tuples = axis.getTuples(0, -1);
            for (int i = 0; i < tuples.length; ++i) {
                TupleElementInterface[] tupleElements = tuples[i].getElements(0, -1);
                for (int j = 0; j < tupleElements.length; ++j) {
                    Object[] cells;
                    if (!tupleElements[j].getName().trim().equals(uniqueName.trim())) continue;
                    if (role.equals("COLUMN")) {
                        for (int k = 0; k < rowCount; ++k) {
                            long cellOrdinal = i + k * columnCount;
                            cells = model.getCells(cellOrdinal, cellOrdinal);
                            if (cells == null || cells.length <= 0 || !(cells[0] instanceof Double)) continue;
                            cell = (Double)cells[0];
                            if (cell < min) {
                                min = cell;
                            }
                            if (!(cell > max)) continue;
                            max = cell;
                        }
                        continue;
                    }
                    if (role.equals("ROW")) {
                        for (int k = 0; k < columnCount; ++k) {
                            long cellOrdinal = i * columnCount + k;
                            cells = model.getCells(cellOrdinal, cellOrdinal);
                            if (cells == null || cells.length <= 0 || !(cells[0] instanceof Double)) continue;
                            cell = (Double)cells[0];
                            if (cell < min) {
                                min = cell;
                            }
                            if (!(cell > max)) continue;
                            max = cell;
                        }
                        continue;
                    }
                    if (!role.equals("BACKGROUND")) continue;
                    Object[] cells2 = model.getCells(0L, (long)(rowCount * columnCount - 1));
                    for (int k = 0; k < cells2.length; ++k) {
                        if (cells2 == null || cells2.length <= 0 || !(cells2[k] instanceof Double)) continue;
                        cell = (Double)cells2[k];
                        if (cell < min) {
                            min = cell;
                        }
                        if (!(cell > max)) continue;
                        max = cell;
                    }
                }
            }
            if (min == Double.MAX_VALUE && max == Double.MIN_VALUE) {
                return null;
            }
            HashMap<String, Object> rm = new HashMap<String, Object>();
            rm.put("MIN", new Double(min));
            rm.put("MAX", new Double(max));
            rm.put("UNIQUE_NAME", uniqueName);
            rm.put("DATA_ITEM", di);
            return rm;
        }
        return null;
    }

    public static Map getMeasureInfo(OLAPDataSetInterface model, String uniqueName) throws OLAPException {
        if (model instanceof BusinessQueryProviderInterface) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            AxisInterface[] axes = null;
            int rowCount = 0;
            int columnCount = 0;
            int backgroundCount = 0;
            AxisInterface rowAxis = null;
            AxisInterface columnAxis = null;
            AxisInterface backgroundAxis = null;
            Object measureAxis = null;
            AxisInterface axis = null;
            DataItem di = null;
            String role = null;
            ResultSetMetadataInterface metadata = model.getResultSetMetadata();
            if (metadata != null) {
                axes = metadata.getAxes(1, 1);
                if (axes != null) {
                    rowAxis = axes[0];
                }
                if ((axes = metadata.getAxes(0, 1)) != null) {
                    // empty if block
                }
                columnAxis = axes[0];
                axes = metadata.getAxes(-1, 1);
                if (axes != null) {
                    // empty if block
                }
                backgroundAxis = axes[0];
            }
            if (rowAxis != null) {
                rowCount = rowAxis.getTupleCount();
            }
            if (columnAxis != null) {
                columnCount = columnAxis.getTupleCount();
            }
            if (backgroundAxis != null) {
                backgroundCount = backgroundAxis.getTupleCount();
            }
            if (uniqueName == null) {
                DataItem dataItem;
                String uln;
                int y;
                TupleElementInterface[] tupleElements;
                if (columnCount > 0 && columnAxis != null) {
                    tupleElements = columnAxis.getTuple(0).getElements(0, -1);
                    for (y = 0; y < tupleElements.length; ++y) {
                        uln = tupleElements[y].getName().trim();
                        dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, (OLAPDataSetInterface)model, (Object)tupleElements[y], (int)1);
                        if (dataItem == null || dataItem.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) continue;
                        uniqueName = uln;
                        role = "COLUMN";
                        axis = columnAxis;
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("ROLE", role);
                        hashMap.put("AXIS", axis);
                        hashMap.put("ROW_COUNT", new Integer(rowCount));
                        hashMap.put("COLUMN_COUNT", new Integer(columnCount));
                        hashMap.put("BACKGROUND_COUNT", new Integer(backgroundCount));
                        hashMap.put("UNIQUE_NAME", uln);
                        hashMap.put("DATA_ITEM", dataItem);
                        return hashMap;
                    }
                }
                if (uniqueName == null && rowAxis != null && rowCount > 0) {
                    tupleElements = rowAxis.getTuple(0).getElements(0, -1);
                    for (y = 0; y < tupleElements.length; ++y) {
                        uln = tupleElements[y].getName();
                        dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, (OLAPDataSetInterface)model, (Object)tupleElements[y], (int)1);
                        if (dataItem == null || dataItem.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) continue;
                        uniqueName = uln;
                        role = "ROW";
                        axis = rowAxis;
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("ROLE", role);
                        hashMap.put("AXIS", axis);
                        hashMap.put("ROW_COUNT", new Integer(rowCount));
                        hashMap.put("COLUMN_COUNT", new Integer(columnCount));
                        hashMap.put("BACKGROUND_COUNT", new Integer(backgroundCount));
                        hashMap.put("UNIQUE_NAME", uniqueName);
                        hashMap.put("DATA_ITEM", dataItem);
                        return hashMap;
                    }
                }
                if (uniqueName == null && backgroundAxis != null && backgroundCount > 0 && (y = 0) < (tupleElements = backgroundAxis.getTuple(0).getElements(0, -1)).length) {
                    uniqueName = uln = tupleElements[y].getName();
                    di = GraphOLAPTableUtil.getBackgroundMeasure(model);
                    role = "BACKGROUND";
                    axis = backgroundAxis;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("ROLE", role);
                    hashMap.put("AXIS", axis);
                    hashMap.put("ROW_COUNT", new Integer(rowCount));
                    hashMap.put("COLUMN_COUNT", new Integer(columnCount));
                    hashMap.put("BACKGROUND_COUNT", new Integer(backgroundCount));
                    hashMap.put("UNIQUE_NAME", uniqueName);
                    hashMap.put("DATA_ITEM", di);
                    return hashMap;
                }
            }
        }
        return null;
    }

    private static DataItem getBackgroundMeasure(OLAPDataSetInterface model) {
        CommonLoggerInterface log = LoggerRepository2.getLogger((String)GraphOLAPTableUtil.class.getPackage().getName(), null);
        try {
            BusinessQuery businessQuery;
            if (model instanceof BusinessQueryProviderInterface && (businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery()) != null) {
                List l = businessQuery.getResultItems();
                for (int i = 0; i < l.size(); ++i) {
                    DataItem di = (DataItem)l.get(i);
                    Role brole = businessQuery.getResultItemRole(di);
                    if (!brole.toString().equals(Role.BACKGROUND.toString()) || !di.getStructure().toString().equals(StructureOfDataItem.STRUCTURE_MEASURE.toString())) continue;
                    return di;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }
}

