/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.olaptableview.BaseOLAPTableView;
import com.sas.servlet.tbeans.olaptableview.OLAPTableArea;
import com.sas.servlet.tbeans.olaptableview.html.DefaultOLAPTableLabelCellRenderer;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.StyleSheetUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.swing.util.Action;
import com.sas.util.ColorUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@SASScope(value="ALL")
public class ColorGradientUtil {
    public static final String COLUMN_HEADER = ".OLAPTableColumnHeader";
    public static final String ROW_HEADER = ".OLAPTableRowHeader";
    private static final Color DEFAULT_GRADIENT_COLOR = new Color(15854283);
    private static HashMap gradientColors = new HashMap();

    static StyleInfo applyGradientAndSaveStyle(DefaultOLAPTableLabelCellRenderer renderer, Object tbean, Object value, ActionList actionList) {
        StyleInfo savedStyle = DefaultOLAPTableLabelCellRenderer.NO_SAVED_STYLE;
        if (ColorGradientUtil.checkTableViewGradient(tbean)) {
            try {
                int depth = ColorGradientUtil.calculateDepth(value, tbean, renderer);
                if (depth <= 0) {
                    return savedStyle;
                }
                Color backgroundColor = ColorGradientUtil.calculateBaseGradientColor(renderer, (BaseTransformation)tbean);
                String newStyle = ColorGradientUtil.applyGradient(backgroundColor, depth, actionList);
                savedStyle = renderer.saveStyle(renderer, newStyle);
            }
            catch (Exception ex) {
                renderer.log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return savedStyle;
    }

    private static boolean checkTableViewGradient(Object tbean) {
        if (tbean instanceof BaseOLAPTableView) {
            BaseOLAPTableView otv = (BaseOLAPTableView)tbean;
            return otv.isGradientHeaderColors();
        }
        return false;
    }

    private static String applyGradient(Color backgroundColor, int depth, ActionList actionList) {
        Color thisColor = ColorUtil.applyGradient((Color)backgroundColor, (int)(depth - 1));
        String newColor = ColorGradientUtil.toHex(thisColor, "background-color: #");
        newColor = ColorGradientUtil.updateTextColor(thisColor, newColor, actionList);
        return newColor;
    }

    static String updateTextColor(Color color, String style, ActionList actionList) {
        if (ColorUtil.isDark((Color)color)) {
            style = style + "; color: white;";
            if (actionList != null) {
                List actions = actionList.getActions();
                for (int i = 0; i < actionList.size(); ++i) {
                    Action action = (Action)actions.get(i);
                    action.putValue("ACTION_STYLE", (Object)"color: white;");
                }
            }
        }
        return style;
    }

    private static String toHex(Color thisColor, String prefix) {
        String str = Integer.toString(0xFFFFFF & thisColor.getRGB(), 16).toUpperCase();
        return prefix + "000000".substring(str.length()) + str;
    }

    static int calculateDepth(Object value, Object tbean, DefaultOLAPTableLabelCellRenderer renderer) throws OLAPException {
        if (value instanceof TupleElementInterface) {
            TupleElementInterface te = (TupleElementInterface)value;
            return ColorGradientUtil.calculateDepth(te);
        }
        if (tbean instanceof OLAPTableView) {
            OLAPTableView otv = (OLAPTableView)tbean;
            OLAPTableArea area = otv.getCurrentArea();
            if (area != null && area.isTitle() && !area.isMeasure()) {
                return ColorGradientUtil.calculateDepth(otv, area, renderer.getLevelDepthMap());
            }
            if (otv.getRaggedTupleInterface() != null) {
                TupleElementInterface te = otv.getRaggedTupleInterface();
                return ColorGradientUtil.calculateDepth(te);
            }
        }
        return 0;
    }

    private static int calculateDepth(TupleElementInterface te) throws OLAPException {
        if (te.getType() != TupleElementType.UNSPECIFIED) {
            return -1;
        }
        return te.getLevelDepth();
    }

    private static int calculateDepth(OLAPTableView otv, OLAPTableArea area, Map cache) throws OLAPException {
        OLAPDataSetInterface model = otv.getModel();
        String levelname = ColorGradientUtil.getLevelName(model, area, otv);
        Integer depth = (Integer)cache.get(levelname);
        if (depth != null) {
            return depth;
        }
        int leveldepth = ColorGradientUtil.getLevelFromMetadata(model, levelname, cache);
        return leveldepth;
    }

    private static String getLevelName(OLAPDataSetInterface model, OLAPTableArea area, OLAPTableView otv) throws OLAPException {
        int axisIndex = area == OLAPTableArea.COLUMN_TITLE ? 0 : 1;
        AxisInterface axis = model.getResultSetMetadata().getAxis(axisIndex);
        String[] levelnames = axis.getUniqueLevelNames();
        String levelname = levelnames[otv.getCurrentHeaderIndex()];
        return levelname;
    }

    private static int getLevelFromMetadata(OLAPDataSetInterface model, String levelname, Map cache) {
        int leveldepth = 1;
        try {
            Filter filter = new Filter();
            filter.setCubeName(model.getCubeName());
            filter.setUniqueLevelName(levelname);
            MetadataInterface metadata = model.getDatabaseMetadata();
            LevelInterface level = metadata.getLevel(filter);
            leveldepth = level.getDepth();
        }
        catch (Exception exception) {
            // empty catch block
        }
        cache.put(levelname, new Integer(leveldepth));
        return leveldepth;
    }

    @SASScope
    static Color calculateBaseGradientColor(DefaultOLAPTableLabelCellRenderer renderer, BaseTransformation tbean) {
        try {
            Color backgroundColor = renderer.getBaseGradientColor();
            if (backgroundColor != null) {
                return backgroundColor;
            }
            backgroundColor = ColorGradientUtil.findBackgroundColor(renderer);
            if (backgroundColor != null) {
                return backgroundColor;
            }
            backgroundColor = ColorGradientUtil.findBackgroundColorFromTheme(tbean);
            if (backgroundColor != null) {
                return backgroundColor;
            }
        }
        catch (Exception ex) {
            renderer.log.error(ex.getMessage(), (Throwable)ex);
        }
        return DEFAULT_GRADIENT_COLOR;
    }

    @SASScope
    static Color findBackgroundColor(DefaultOLAPTableLabelCellRenderer renderer) {
        String color = ColorGradientUtil.findBackgroundColorStyle(renderer);
        return StyleSheetUtil.parseColor(color);
    }

    private static String findBackgroundColorStyle(DefaultOLAPTableLabelCellRenderer renderer) {
        String color = StyleSheetUtil.findStyleAttribute(renderer.getExtraStyle(), "background-color");
        if (color != null) {
            return color;
        }
        StyleInfo styleInfo = renderer.getStyleInfo();
        color = StyleSheetUtil.findStyleAttribute(styleInfo, "background-color");
        return color;
    }

    @SASScope
    static Color findBackgroundColorFromTheme(BaseTransformation tbean) {
        OLAPTableArea area = OLAPTableArea.COLUMN_HEADER;
        OLAPTableView otv = (OLAPTableView)tbean;
        area = otv.getCurrentArea();
        String styleName = area == OLAPTableArea.ROW_HEADER || area == OLAPTableArea.ROW_TITLE ? ROW_HEADER : COLUMN_HEADER;
        HttpServletRequest request = tbean.getRequest();
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
        return ColorGradientUtil.findBackgroundColorFromTheme(cpm, styleName);
    }

    @SASScope
    public static Color findBackgroundColorFromTheme(ComponentPropertyManager cpm, String styleName) {
        String key = cpm.getStyleLocation() + styleName;
        Color color = (Color)gradientColors.get(key);
        if (color != null) {
            return color;
        }
        if (gradientColors.containsKey(key)) {
            return null;
        }
        ColorGradientUtil.findColorsFromStyleSheets(cpm);
        return (Color)gradientColors.get(key);
    }

    private static void findColorsFromStyleSheets(ComponentPropertyManager cpm) {
        String[] styleNames = new String[]{ROW_HEADER, COLUMN_HEADER};
        List<String> list = Arrays.asList(styleNames);
        String[] values = StyleSheetUtil.findStylesFromStyleSheets(cpm, list, "background-color");
        gradientColors.put(cpm.getStyleLocation() + ROW_HEADER, values[0] == null ? null : Color.decode(values[0]));
        gradientColors.put(cpm.getStyleLocation() + COLUMN_HEADER, values[1] == null ? null : Color.decode(values[1]));
    }
}

