/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.servlet.tbeans.BaseActionTransformation2;
import com.sas.servlet.tbeans.olaptableview.DrillStateInfo;
import com.sas.servlet.tbeans.olaptableview.DrillStateProvider;
import com.sas.servlet.tbeans.olaptableview.OLAPDataSetDrillStateProvider;
import com.sas.servlet.tbeans.olaptableview.RB;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.List;

@SASScope(value="ALL")
public abstract class BaseOLAPDrillState
extends BaseActionTransformation2
implements ContentsChangedListener {
    @SASScope
    public static final String RB_KEY = "BaseOLAPDrillState.";
    public static final int TITLE_ALWAYS = 0;
    public static final int TITLE_NEVER = 2;
    public static final int TITLE_WHEN_CONTENT = 4;
    @SASScope
    protected static final String DRILLSTATE_CLASS_NAME = "olapDrillState";
    @SASScope
    protected static final String DRILLSTATE_LABEL = "olapDrillStateLabel";
    @SASScope
    protected static final String DRILLSTATE_ITEM = "olapDrillStateItem";
    @SASScope
    protected List drillState;
    private DrillStateProvider _drillStateProvider;
    private boolean _drillStateDirty = true;
    private int labelType;
    private static final String NAME_PREFIX = "ods";
    private String separatorImage;
    private String separator;
    private int horizontalAlignment;
    private int cellSpacing;
    private int cellPadding;
    private String styleClassPrefix;
    private boolean useCachedTuples;
    private String title;
    private int isTitleDisplayed;
    private String noDrillStateText;
    private boolean isNoDrillStateDisplayed;
    private boolean includeAllMember;

    public BaseOLAPDrillState() {
        this.setId(Util.getName((String)NAME_PREFIX));
        this.cellSpacing = 0;
        this.cellPadding = 0;
        this.horizontalAlignment = 99;
        this.drillState = new ArrayList(0);
        this.setActionSupportType("OLAP_DRILLSTATE_SUPPORT");
        this.labelType = 0;
        this.useCachedTuples = true;
        this.includeAllMember = false;
        this.setTitleDisplayed(2);
        this.setNoDrillStateTextDisplayed(false);
        this.setTitle(RB.getStringResource(RB_KEY, "drillStateTitle.txt", this.getLocale()));
        this.setNoDrillStateText(RB.getStringResource(RB_KEY, "noDrillStateApplied.txt", this.getLocale()));
    }

    public OLAPDataSetInterface getModel() {
        DrillStateProvider drillStateInfo = this.getDrillStateProvider();
        if (drillStateInfo instanceof OLAPDataSetDrillStateProvider) {
            return ((OLAPDataSetDrillStateProvider)drillStateInfo).getDataSet();
        }
        return null;
    }

    public void setModel(OLAPDataSetInterface model) {
        OLAPDataSetDrillStateProvider drillStateProvider = null;
        if (model instanceof BusinessQueryProviderInterface) {
            drillStateProvider = new OLAPDataSetDrillStateProvider(model, (BusinessQueryProviderInterface)model);
        } else if (model != null) {
            drillStateProvider = new OLAPDataSetDrillStateProvider(model);
        }
        this.setDrillStateProvider(drillStateProvider);
    }

    @SASScope
    public DrillStateProvider getDrillStateProvider() {
        return this._drillStateProvider;
    }

    @SASScope
    public void setDrillStateProvider(DrillStateProvider drillStateProvider) {
        if (this._drillStateProvider == drillStateProvider) {
            return;
        }
        this._drillStateProvider = drillStateProvider;
        this.setDrillStateDirty(true);
    }

    protected boolean isDrillStateDirty() {
        return this._drillStateDirty;
    }

    protected void setDrillStateDirty(boolean dirty) {
        this._drillStateDirty = dirty;
    }

    @SASScope
    public void captureDrillState() {
        this.drillState = this._captureDrillState();
        this.setDrillStateDirty(false);
    }

    private List _captureDrillState() {
        DrillStateProvider drillStateProvider = this.getDrillStateProvider();
        if (drillStateProvider == null) {
            return new ArrayList(0);
        }
        ArrayList rval = drillStateProvider.getDrillStateInfo(this.getIncludeAllMember(), this.getUseCachedTuples());
        if (rval == null) {
            rval = new ArrayList(0);
        }
        return rval;
    }

    public void setLabelType(int labelType) {
        if (labelType != 1 && labelType != 2 && labelType != 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidType.txt", this.getLocale()));
        }
        this.labelType = labelType;
    }

    public int getLabelType() {
        return this.labelType;
    }

    @SASScope
    public void setIncludeAllMember(boolean includeAllMember) {
        this.includeAllMember = includeAllMember;
    }

    @SASScope
    public boolean getIncludeAllMember() {
        return this.includeAllMember;
    }

    public void contentsChanged(ContentsChangedEvent event) {
        if (event instanceof ActionProviderEvent) {
            this.setDrillStateDirty(true);
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider actionProvider) {
        HttpActionProvider oldActionProvider = this.getActionProvider();
        if (oldActionProvider != null) {
            oldActionProvider.removeContentsChangedListener(this);
        }
        super.setActionProvider(actionProvider);
        if (actionProvider != null) {
            actionProvider.addContentsChangedListener(this);
        }
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparatorImage(String separatorImage) {
        this.separatorImage = separatorImage;
    }

    public String getSeparatorImage() {
        return this.separatorImage;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 2: 
            case 4: 
            case 99: {
                this.horizontalAlignment = alignment;
                break;
            }
        }
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(int cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public int getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(int cellPadding) {
        this.cellPadding = cellPadding;
    }

    @SASScope
    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    @SASScope
    public void setStyleClassPrefix(String styleClassPrefix) {
        this.styleClassPrefix = styleClassPrefix;
    }

    public boolean getUseCachedTuples() {
        return this.useCachedTuples;
    }

    public void setUseCachedTuples(boolean useTupleCache) {
        if (this.useCachedTuples == useTupleCache) {
            return;
        }
        this.useCachedTuples = useTupleCache;
        this.setDrillStateDirty(true);
    }

    @Override
    public boolean isVisible() {
        if (this.getDrillStateProvider() == null) {
            return false;
        }
        if (!super.isVisible()) {
            return false;
        }
        return this.getTitleDisplayed() == 0 || this.getTitle() == null || this.getTitle().length() <= 0 || !this.isDrillStateEmpty();
    }

    private boolean isDrillStateEmpty() {
        if (this.isDrillStateDirty()) {
            this.captureDrillState();
        }
        for (DrillStateInfo dimensionDrillInfo : this.drillState) {
            List dsLabels = dimensionDrillInfo.getDrillStateLabels();
            if (dsLabels == null || dsLabels.size() <= 0) continue;
            return false;
        }
        return true;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleDisplayed(int isTitleDisplayed) {
        this.isTitleDisplayed = isTitleDisplayed;
    }

    public int getTitleDisplayed() {
        return this.isTitleDisplayed;
    }

    public void setNoDrillStateText(String noDrillStateText) {
        this.noDrillStateText = noDrillStateText;
    }

    public String getNoDrillStateText() {
        return this.noDrillStateText;
    }

    public void setNoDrillStateTextDisplayed(boolean isNoDrillStateTextDisplayed) {
        this.isNoDrillStateDisplayed = isNoDrillStateTextDisplayed;
    }

    public boolean isNoDrillStateTextDisplayed() {
        return this.isNoDrillStateDisplayed;
    }
}

