/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.navigationbar.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.Util;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.navigationbar.BaseNavigationInterface;
import com.sas.servlet.tbeans.navigationbar.ColumnNavigationInterface;
import com.sas.servlet.tbeans.navigationbar.EditNavigationInterface;
import com.sas.servlet.tbeans.navigationbar.html.NavigationBarScrollingElement;
import com.sas.servlet.tbeans.navigationbar.html.RB;
import com.sas.util.SimpleTemplate;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class NavigationBarColumnScrollingElement
extends NavigationBarScrollingElement {
    @SASScope
    public static final String RB_KEY = "NavigationBarColumnScrollingElement.";
    private static final String NAME_PREFIX = "cse";
    private SimpleTemplate defaultMessageTemplate;
    private HashMap valueDictionary;
    private String scrollForwardArea;
    private String scrollBackwardArea;
    private String gotoArea;
    private boolean gotoFieldVisible;
    private boolean firstVisible;
    private boolean pageBackwardVisible;
    private boolean previousVisible;
    private boolean nextVisible;
    private boolean pageForwardVisible;
    private boolean lastVisible;

    public NavigationBarColumnScrollingElement() {
        this(null);
    }

    public NavigationBarColumnScrollingElement(BaseNavigationInterface model) {
        super(model);
        this.setId(com.sas.util.Util.getName((String)NAME_PREFIX));
        this.defaultMessageTemplate = new SimpleTemplate();
        this.valueDictionary = new HashMap(3);
        this.scrollForwardArea = "COLUMN_SCROLL_FORWARD_AREA";
        this.scrollBackwardArea = "COLUMN_SCROLL_BACKWARD_AREA";
        this.gotoArea = "COLUMN_GOTO_AREA";
        this.gotoFieldVisible = true;
        this.firstVisible = true;
        this.pageBackwardVisible = true;
        this.previousVisible = true;
        this.nextVisible = true;
        this.pageForwardVisible = true;
        this.lastVisible = true;
    }

    @Override
    public void setModel(BaseNavigationInterface navigationBarModel) {
        if (!(navigationBarModel instanceof ColumnNavigationInterface) && navigationBarModel != null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "notColumnModel.txt", this.getLocale()));
        }
        super.setModel(navigationBarModel);
    }

    @Override
    public String getMessage() {
        String startColumn = null;
        ColumnNavigationInterface model = (ColumnNavigationInterface)this.getModel();
        if (model != null) {
            if (this.isGotoFieldInMessage() && this.isActionVisible("GOTO_COLUMN_ACTION", this.gotoArea)) {
                ActionList gotoActions = null;
                try {
                    gotoActions = this.getActions("COLUMN_GOTO_AREA");
                    if (gotoActions != null) {
                        HttpAction gotoColAction = (HttpAction)gotoActions.get("GOTO_COLUMN_ACTION");
                        if (gotoColAction != null) {
                            startColumn = this.getGotoFieldTextEntry(gotoColAction);
                        } else {
                            gotoColAction = (HttpAction)gotoActions.get("GOTO_COLUMN_EDIT_ENABLED_ACTION");
                            if (gotoColAction != null) {
                                startColumn = this.getGotoFieldTextEntry(gotoColAction);
                            }
                        }
                    }
                }
                catch (IOException gotoColAction) {
                    // empty catch block
                }
                HttpActionProvider actionProvider = this.getActionProvider();
                if (actionProvider != null) {
                    actionProvider.returnActionList(gotoActions);
                }
            }
            if (startColumn == null) {
                startColumn = Integer.toString(model.getStartColumn() + 1);
            }
            this.valueDictionary.put("STARTCOLUMN", startColumn);
            this.valueDictionary.put("ENDCOLUMN", Integer.toString(model.getEndColumn() + 1));
            this.valueDictionary.put("COLUMNCOUNT", Integer.toString(model.getColumnCount()));
            this.getMessageTemplate().setValueDictionary((Map)this.valueDictionary);
        }
        return this.getMessageTemplate().format();
    }

    @Override
    public SimpleTemplate getDefaultMessageTemplate() {
        ColumnNavigationInterface columnModel = (ColumnNavigationInterface)this.getModel();
        if (columnModel != null) {
            int endColumn;
            int startColumn = columnModel.getStartColumn();
            if (startColumn != (endColumn = columnModel.getEndColumn())) {
                this.defaultMessageTemplate.setTemplate(RB.getStringResource(RB_KEY, "columnMessage1.txt", this.getLocale()));
            } else if (startColumn > -1) {
                this.defaultMessageTemplate.setTemplate(RB.getStringResource(RB_KEY, "columnMessage2.txt", this.getLocale()));
            }
        }
        return this.defaultMessageTemplate;
    }

    @Override
    public void writeMessage(PrintWriter out) throws IOException {
        if (this.isVisible()) {
            out.print("<span");
            String prefix = this.getStyleClassPrefix();
            StyleInfo styleinfo = (StyleInfo)this.getStyleMap().get("NAVIGATIONBAR_MESSAGE_STYLE");
            if (styleinfo.getClassid() != null) {
                out.print(" class=\"");
                if (prefix != null) {
                    out.print(prefix);
                }
                out.print(styleinfo.getClassid());
                out.print("\"");
            }
            if (styleinfo.getStyle() != null) {
                out.print(" style=\"");
                out.print(styleinfo.getStyle());
                out.print("\"");
            }
            out.print(">");
            out.print(this.getMessage());
            out.println("</span>");
        }
    }

    @Override
    public void writeBackwardScrollers(PrintWriter out) throws IOException {
        if (this.isVisible()) {
            ActionList actions = this.getActions("COLUMN_SCROLL_BACKWARD_AREA");
            HashMap argumentMap = ActionProviderMapPool.getMap();
            argumentMap.put("REQUEST", this.getRequest());
            argumentMap.put("STYLE_CLASS_PREFIX", "navbar");
            Util.writeActionList(actions, out, argumentMap);
            ActionProviderMapPool.returnMap((Map)argumentMap);
            HttpActionProvider actionProvider = this.getActionProvider();
            if (actionProvider != null) {
                actionProvider.returnActionList(actions);
            }
        }
    }

    @Override
    public void writeForwardScrollers(PrintWriter out) throws IOException {
        if (this.isVisible()) {
            ActionList actions = this.getActions("COLUMN_SCROLL_FORWARD_AREA");
            HashMap argumentMap = ActionProviderMapPool.getMap();
            argumentMap.put("REQUEST", this.getRequest());
            argumentMap.put("STYLE_CLASS_PREFIX", "navbar");
            Util.writeActionList(actions, out, argumentMap);
            ActionProviderMapPool.returnMap((Map)argumentMap);
            HttpActionProvider actionProvider = this.getActionProvider();
            if (actionProvider != null) {
                actionProvider.returnActionList(actions);
            }
        }
    }

    @Override
    public void writeGotoField(PrintWriter out) throws IOException {
        ActionList gotoActions;
        if (!this.isGotoFieldInMessage() && this.isActionVisible("GOTO_COLUMN_ACTION", this.gotoArea) && (gotoActions = this.getActions("COLUMN_GOTO_AREA")) != null) {
            HttpAction gotoColumnAction = (HttpAction)gotoActions.get("GOTO_COLUMN_ACTION");
            if (gotoColumnAction != null) {
                out.println(this.getGotoFieldTextEntry(gotoColumnAction));
            } else {
                gotoColumnAction = (HttpAction)gotoActions.get("GOTO_COLUMN_EDIT_ENABLED_ACTION");
                if (gotoColumnAction != null) {
                    out.println(this.getGotoFieldTextEntry(gotoColumnAction));
                }
            }
            HttpActionProvider actionProvider = this.getActionProvider();
            if (actionProvider != null) {
                actionProvider.returnActionList(gotoActions);
            }
        }
    }

    private ActionList getActions(String area) throws IOException {
        BaseNavigationInterface model = this.getModel();
        if (model != null) {
            ActionSupportFilter columnsFilter = new ActionSupportFilter(this.getActionSupportType(), area, (ActionProviderViewInterface)this, false);
            columnsFilter.setPoolingOn(true);
            columnsFilter.setViewerId(this.getId());
            columnsFilter.setHiddenActionsMap(this.getViewerSupport().getHiddenActionsMap());
            try {
                columnsFilter.setAttribute("model", (Object)model);
                if (model instanceof EditNavigationInterface) {
                    EditNavigationInterface eni = (EditNavigationInterface)model;
                    columnsFilter.setAttribute("row", (Object)new Integer(eni.getCurrentRow()));
                    columnsFilter.setAttribute("autoCommit", (Object)new Boolean(eni.isAutoCommit()));
                    if (model instanceof FormViewInterface) {
                        columnsFilter.setAttribute("formName", (Object)((FormViewInterface)((Object)model)).getFormObject().getName());
                    } else if (model instanceof Form) {
                        columnsFilter.setAttribute("formName", (Object)((Form)((Object)model)).getName());
                    }
                }
            }
            catch (AttributeSetException ase) {
                throw new IOException(ase.getMessage());
            }
            HttpActionProvider actionProvider = this.getActionProvider();
            if (actionProvider != null && columnsFilter != null) {
                return actionProvider.getActions(columnsFilter);
            }
        }
        return null;
    }

    private String getGotoFieldTextEntry(HttpAction action) {
        StringBuffer sb = new StringBuffer();
        ColumnNavigationInterface cni = (ColumnNavigationInterface)this.getModel();
        HttpActionProvider ap = this.getActionProvider();
        if (cni.getFormName() != null) {
            if (this.getGotoFieldLabel() != null && !this.isGotoFieldInMessage()) {
                sb.append("<label for=\"gotoColumn\">");
                sb.append(this.getGotoFieldLabel());
                sb.append("</label>");
            }
            sb.append("<input type=\"TEXT\"");
            String prefix = this.getStyleClassPrefix();
            StyleInfo styleinfo = (StyleInfo)this.getStyleMap().get("NAVIGATIONBAR_INPUT_STYLE");
            if (styleinfo.getClassid() != null) {
                sb.append(" class=\"");
                if (prefix != null) {
                    sb.append(prefix);
                }
                sb.append(styleinfo.getClassid());
                sb.append("\"");
            }
            if (styleinfo.getStyle() != null) {
                sb.append(" style=\"");
                sb.append(styleinfo.getStyle());
                sb.append("\"");
            }
            sb.append(" size=\"5\" id=\"");
            sb.append(this.getId());
            sb.append("_GotoColumn\" value=\"");
            sb.append(cni.getStartColumn() + 1);
            sb.append("\" ONKEYDOWN=\"javascript:sas_NavigationBar_executeGoto(event,this,'");
            sb.append(cni.getFormName());
            sb.append("', '");
            sb.append(ap.getParameterPrefix());
            sb.append("gotoColumn', '");
            sb.append(action.getCmdId());
            sb.append("','");
            sb.append(ap.getName());
            sb.append("')\" >\n");
        }
        return sb.toString();
    }

    @Override
    public void setGotoFieldVisible(boolean visible) {
        this.gotoFieldVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("GOTO_COLUMN_ACTION", this.gotoArea, visible);
        }
    }

    @Override
    public void setFirstVisible(boolean visible) {
        this.firstVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("FIRST_COLUMN_ACTION", this.scrollBackwardArea, visible);
        }
    }

    @Override
    public void setPageBackwardVisible(boolean visible) {
        this.pageBackwardVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("PAGE_BACKWARD_COLUMNS_ACTION", this.scrollBackwardArea, visible);
        }
    }

    @Override
    public void setPreviousVisible(boolean visible) {
        this.previousVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("PREVIOUS_COLUMN_ACTION", this.scrollBackwardArea, visible);
        }
    }

    @Override
    public void setNextVisible(boolean visible) {
        this.nextVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("NEXT_COLUMN_ACTION", this.scrollForwardArea, visible);
        }
    }

    @Override
    public void setPageForwardVisible(boolean visible) {
        this.pageForwardVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("PAGE_FORWARD_COLUMNS_ACTION", this.scrollForwardArea, visible);
        }
    }

    @Override
    public void setLastVisible(boolean visible) {
        this.lastVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("LAST_COLUMN_ACTION", this.scrollForwardArea, visible);
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider provider) {
        super.setActionProvider(provider);
        if (provider != null) {
            if (!this.gotoFieldVisible) {
                this.setActionVisible("GOTO_COLUMN_ACTION", this.gotoArea, false);
            }
            if (!this.firstVisible) {
                this.setActionVisible("FIRST_COLUMN_ACTION", this.scrollBackwardArea, false);
            }
            if (!this.pageBackwardVisible) {
                this.setActionVisible("PAGE_BACKWARD_COLUMNS_ACTION", this.scrollBackwardArea, false);
            }
            if (!this.previousVisible) {
                this.setActionVisible("PREVIOUS_COLUMN_ACTION", this.scrollBackwardArea, false);
            }
            if (!this.nextVisible) {
                this.setActionVisible("NEXT_COLUMN_ACTION", this.scrollForwardArea, false);
            }
            if (!this.pageForwardVisible) {
                this.setActionVisible("PAGE_FORWARD_COLUMNS_ACTION", this.scrollForwardArea, false);
            }
            if (!this.lastVisible) {
                this.setActionVisible("LAST_COLUMN_ACTION", this.scrollForwardArea, false);
            }
        }
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        ColumnNavigationInterface model = (ColumnNavigationInterface)this.getModel();
        return model != null && (this.isActionVisible("LAST_COLUMN_ACTION", this.scrollForwardArea) && model.isLastColumnSupported() || this.isActionVisible("PAGE_FORWARD_COLUMNS_ACTION", this.scrollForwardArea) && model.isPageForwardColumnsSupported() || this.isActionVisible("NEXT_COLUMN_ACTION", this.scrollForwardArea) && model.isNextColumnSupported() || this.isActionVisible("PREVIOUS_COLUMN_ACTION", this.scrollBackwardArea) && model.isPreviousColumnSupported() || this.isActionVisible("PAGE_BACKWARD_COLUMNS_ACTION", this.scrollBackwardArea) && model.isPageBackwardColumnsSupported() || this.isActionVisible("FIRST_COLUMN_ACTION", this.scrollBackwardArea) && model.isFirstColumnSupported() || this.isActionVisible("GOTO_COLUMN_ACTION", this.gotoArea) && model.isGotoColumnSupported());
    }

    @Override
    public void setActionVisible(String actionType, String areaType, boolean visible) {
        super.setActionVisible(actionType, areaType, visible);
        if (actionType == "LAST_COLUMN_ACTION") {
            super.setActionVisible("LAST_COLUMN_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "PAGE_FORWARD_COLUMNS_ACTION") {
            super.setActionVisible("PAGE_FORWARD_COLUMNS_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "NEXT_COLUMN_ACTION") {
            super.setActionVisible("NEXT_COLUMN_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "PREVIOUS_COLUMN_ACTION") {
            super.setActionVisible("PREVIOUS_COLUMN_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "PAGE_BACKWARD_COLUMNS_ACTION") {
            super.setActionVisible("PAGE_BACKWARD_COLUMNS_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "FIRST_COLUMN_ACTION") {
            super.setActionVisible("FIRST_COLUMN_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "GOTO_COLUMN_ACTION") {
            super.setActionVisible("GOTO_COLUMN_EDIT_ENABLED_ACTION", areaType, visible);
        }
    }
}

