/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.models;

import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.swing.models.CollectionToComboBoxModelAdapter;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

@SASScope
public class ValueItemsToComboBoxModelAdapter
extends CollectionToComboBoxModelAdapter {
    private static final long serialVersionUID = 1L;
    protected Object selectedItem;
    private SupportedSpecialValues specialValues;

    public ValueItemsToComboBoxModelAdapter() {
    }

    public ValueItemsToComboBoxModelAdapter(int size) {
        super(size);
    }

    public ValueItemsToComboBoxModelAdapter(Collection c) {
        super(c);
    }

    public ValueItemsToComboBoxModelAdapter(Collection c, SupportedSpecialValues specialValues, Locale locale) {
        super(c);
        this.setSpecialValues(specialValues, locale);
    }

    public void setSpecialValues(SupportedSpecialValues specialValues, Locale locale) {
        this.specialValues = specialValues;
        if (this.model != null && specialValues != null && this.specialValues != null && this.isSpecialValuesAvailable(specialValues)) {
            ArrayList<ValueItem> tempCollection = new ArrayList<ValueItem>();
            if (specialValues.isAllSupported()) {
                tempCollection.add(new ValueItem((Object)Strings.quoteForXML((String)SpecialValues.ALL.toString(locale)), (Object)SpecialValues.ALL));
            }
            if (specialValues.isOtherSupported()) {
                tempCollection.add(new ValueItem((Object)Strings.quoteForXML((String)SpecialValues.OTHER.toString(locale)), (Object)SpecialValues.OTHER));
            }
            tempCollection.addAll(this.model);
            this.setModel(tempCollection);
        }
    }

    private boolean isSpecialValuesAvailable(SupportedSpecialValues values) {
        return values != null && (values.isAllSupported() || values.isMissingValuesSupported() || values.isOtherSupported());
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object item) {
        Object oldSelectedItem = this.selectedItem;
        if (Util.unequal((Object)oldSelectedItem, (Object)item)) {
            this.selectedItem = item;
            this.fireContentsChanged((Object)this, -1, -1);
            this.spcs.firePropertyChange("selectedItem", oldSelectedItem, item);
        }
    }

    protected void createDelegate() {
        this.delegate = new ArrayList();
        if (this.model != null) {
            for (Object v : this.model) {
                JavaScriptNode node = new JavaScriptNode();
                if (v instanceof ValueItem) {
                    node.setValue(((ValueItem)v).getValueAsString());
                    node.setText(((ValueItem)v).getLabel());
                } else {
                    node.setValue(v.toString());
                    node.setText(v.toString());
                }
                this.delegate.add(node);
            }
        }
    }

    public void add(JavaScriptNode node, int i) {
        this.delegate.add(i, node);
    }

    public Object getElementAt(int index) {
        boolean i = true;
        if (this.model instanceof List) {
            Object value;
            Object obj = ((List)this.model).get(index);
            if (obj instanceof ValueItem && (value = ((ValueItem)obj).getValue()) instanceof DataSourceColumnInterface) {
                StringBuffer label = new StringBuffer();
                label.append(((DataSourceColumnInterface)value).getColumnLabel()).append(" [").append(((DataSourceColumnInterface)value).getColumnName()).append("]");
                label.append("[").append(((DataSourceColumnInterface)value).getDataSource().getDataSourceLocation()).append("]");
                return new ValueItem((Object)label.toString(), value);
            }
            return obj;
        }
        return new ValueItem((Object)"", null);
    }
}

