/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar.html;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.menubar.BaseSelectorMenuItem;
import com.sas.servlet.tbeans.menubar.html.HtmlUtilMenu;
import com.sas.servlet.tbeans.menubar.html.Menu;
import com.sas.servlet.tbeans.menubar.html.MenuBarStyleAreaKeysInterface;
import com.sas.util.MapWithDefaults;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@SASScope(value="ALL")
public class SelectorMenuItem
extends BaseSelectorMenuItem
implements MenuBarStyleAreaKeysInterface,
ComplexStyleInterface {
    private static final ImmutableStyleInfo MenuItemStyle = new ImmutableStyleInfo("menuItem");
    private static final ImmutableStyleInfo MenuItemDisabledStyle = new ImmutableStyleInfo("menuItemDisabled");
    private static final ImmutableStyleInfo MenuItemLinkStyle = new ImmutableStyleInfo("menuItemLink");
    private static final ImmutableStyleInfo MenuItemLinkDisabledStyle = new ImmutableStyleInfo("menuItemLinkDisabled");
    private static final ImmutableStyleInfo MenuItemContainerStyle = new ImmutableStyleInfo("menuItemContainer");
    private static final ImmutableStyleInfo MenuItemDividerStyle = new ImmutableStyleInfo("menuItemDivider");
    private static final ImmutableStyleInfo MenuItemArrowStyle = new ImmutableStyleInfo("menuItemArrow");
    private Map componentStyleMap;
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("MENU_ITEM", MenuItemStyle);
            defaultStyleMap.put("MENU_ITEM_DISABLED", MenuItemDisabledStyle);
            defaultStyleMap.put("MENU_ITEM_LINK", MenuItemLinkStyle);
            defaultStyleMap.put("MENU_ITEM_LINK_DISABLED", MenuItemLinkDisabledStyle);
            defaultStyleMap.put("MENU_ITEM_CONTAINER", MenuItemContainerStyle);
            defaultStyleMap.put("MENU_ITEM_DIVIDER", MenuItemDividerStyle);
            defaultStyleMap.put("MENU_ITEM_ARROW", MenuItemArrowStyle);
        }
    }

    public SelectorMenuItem() {
        this(null, null);
    }

    public SelectorMenuItem(HttpServletRequest request) {
        this(null, request);
    }

    public SelectorMenuItem(BaseTransformation selector) {
        this(selector, null);
    }

    public SelectorMenuItem(BaseTransformation selector, HttpServletRequest request) {
        this.setRequest(request);
        this.setSelector(selector);
        this.setSelectorWidth(600);
        this.setSelectorHeight(450);
        this.setTabIndex(-1);
        this.setEnabled(true);
        this.setDefaultURLSuppressed(false);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        BaseTransformation selector = this.getSelector();
        if (selector != null) {
            if (selector.getRequest() == null) {
                selector.setRequest(this.getRequest());
            }
            if (selector.getResponse() == null) {
                selector.setResponse(this.getResponse());
            }
            selector.setLocale(this.getLocale());
        }
        if (selector != null && this.getMenuType() == 3) {
            if (this.getMenuType() == 3) {
                if (selector instanceof DataSelectorInterface) {
                    this.setVisible(true);
                }
                if (!this.isVisible()) {
                    out.println("<div id=\"selectorobject" + this.getMenu().getId() + "\" style=\"display: none\">");
                } else {
                    out.println("<div id=\"selectorobject" + this.getMenu().getId() + "\" style=\"display: block\">");
                }
            }
            selector.write(out);
            if (this.getMenuType() == 3) {
                out.println("</div>");
            }
        } else {
            if (!this.isVisible()) {
                this.cleanUpResources();
                return;
            }
            out.println("<tr>");
            if (!this.isDefaultURLSuppressed()) {
                this.setOnClick(this.getOnClick());
            } else {
                this.setOnClick(null);
            }
            HtmlUtilMenu.writeItem(out, this, this.getDefaultComponentStyleMap(), this.isDefaultURLSuppressed() ? this.getURL() : null, this.isAnchorNeeded());
            out.println("</tr>");
        }
        this.cleanUpResources();
    }

    @Override
    public String getTarget() {
        if (this.getMenu() != null && this.getMenu().getMenuBar() != null) {
            return this.getMenu().getMenuBar().getTarget();
        }
        return null;
    }

    @Override
    public Map getStyleMap() {
        if (this.componentStyleMap == null) {
            SelectorMenuItem.setupDefaultStyleMap();
            this.componentStyleMap = new MapWithDefaults((Map)defaultStyleMap);
        }
        return this.componentStyleMap;
    }

    public void setStyleMap(Map styleMap) {
        this.componentStyleMap = styleMap;
    }

    private Map getDefaultComponentStyleMap() {
        if (this.componentStyleMap == null && this.getMenu() != null && this.getMenu().getMenuBar() != null) {
            this.componentStyleMap = new MapWithDefaults(((Menu)this.getMenu()).getStyleMap());
        }
        return this.componentStyleMap;
    }

    private boolean isAnchorNeeded() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.getTabIndex() > 0 || this.getAccessKey() != null || this.getURL() != null || this.getOnClick() != null || this.getOnKeyDown() != null;
    }

    @SASScope
    public StyleInfo getStyle(String value) {
        Map defaultMap = this.getDefaultComponentStyleMap();
        if (defaultMap.get(value) != null) {
            return (StyleInfo)defaultMap.get(value);
        }
        SelectorMenuItem.setupDefaultStyleMap();
        return (StyleInfo)defaultStyleMap.get(value);
    }
}

