/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.HTMLConstantsInterface;
import com.sas.servlet.tbeans.html.HtmlUtil;
import com.sas.servlet.tbeans.menubar.BaseMenu;
import com.sas.servlet.tbeans.menubar.BaseMenuItem;
import com.sas.servlet.tbeans.menubar.BaseSelectorMenuItem;
import com.sas.servlet.tbeans.menubar.html.BaseHTMLMenuBar;
import com.sas.servlet.tbeans.menubar.html.HtmlUtilMenu;
import com.sas.servlet.tbeans.menubar.html.MenuBarStyleAreaKeysInterface;
import com.sas.servlet.tbeans.menubar.html.MenuItem;
import com.sas.servlet.tbeans.menubar.html.SelectorMenuItem;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@SASScope(value="ALL")
public class Menu
extends BaseMenu
implements MenuBarStyleAreaKeysInterface,
ComplexStyleInterface,
HTMLConstantsInterface {
    private static String QUOTE_COMMA_QUOTE = "','";
    private static String COMMA = ",";
    private static String QUOTE_COMMA = "',";
    private static String QUOTE = "'";
    private ArrayList submenuCollection;
    private int menuItemCounter = 0;
    private int counter = 0;
    private boolean popupMenuIndicatorVisible = true;
    private int submenuCount = 0;
    private int submenuWritten = 0;
    private String popupMenuIndicatorImage = null;
    private String popupMenuIndicatorImageKey = "Menu_Down_Arrow";
    private Map componentStyleMap;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo MenuStyle = new ImmutableStyleInfo("menu");
    private static final ImmutableStyleInfo MenuDisabledStyle = new ImmutableStyleInfo("menuDisabled");
    private static final ImmutableStyleInfo MenuLinkStyle = new ImmutableStyleInfo("menuLink");
    private static final ImmutableStyleInfo MenuLinkDisabledStyle = new ImmutableStyleInfo("menuLinkDisabled");
    private static final ImmutableStyleInfo MenuDividerStyle = new ImmutableStyleInfo("menuDivider");
    private static final ImmutableStyleInfo MenuItemContainerStyle = new ImmutableStyleInfo("menuItemContainer");
    private static final ImmutableStyleInfo MenuItemStyle = new ImmutableStyleInfo("menuItem");
    private static final ImmutableStyleInfo MenuItemDisabledStyle = new ImmutableStyleInfo("menuItemDisabled");
    private static final ImmutableStyleInfo MenuItemLinkStyle = new ImmutableStyleInfo("menuItemLink");
    private static final ImmutableStyleInfo MenuItemLinkDisabledStyle = new ImmutableStyleInfo("menuItemLinkDisabled");
    private static final ImmutableStyleInfo MenuItemDividerStyle = new ImmutableStyleInfo("menuItemDivider");
    private static final ImmutableStyleInfo MenuItemArrowStyle = new ImmutableStyleInfo("menuItemArrow");

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("MENU", MenuStyle);
            defaultStyleMap.put("MENU_DISABLED", MenuDisabledStyle);
            defaultStyleMap.put("MENU_LINK", MenuLinkStyle);
            defaultStyleMap.put("MENU_LINK_DISABLED", MenuLinkDisabledStyle);
            defaultStyleMap.put("MENU_DIVIDER", MenuDividerStyle);
            defaultStyleMap.put("MENU_ITEM_CONTAINER", MenuItemContainerStyle);
            defaultStyleMap.put("MENU_ITEM", MenuItemStyle);
            defaultStyleMap.put("MENU_ITEM_DISABLED", MenuItemDisabledStyle);
            defaultStyleMap.put("MENU_ITEM_LINK", MenuItemLinkStyle);
            defaultStyleMap.put("MENU_ITEM_LINK_DISABLED", MenuItemLinkDisabledStyle);
            defaultStyleMap.put("MENU_ITEM_CONTAINER", MenuItemContainerStyle);
            defaultStyleMap.put("MENU_ITEM_DIVIDER", MenuItemDividerStyle);
            defaultStyleMap.put("MENU_ITEM_ARROW", MenuItemArrowStyle);
        }
    }

    public Menu() {
        this(null, null, null);
    }

    public Menu(String label) {
        this(label, null, null);
    }

    public Menu(String label, String image) {
        this(label, image, null);
    }

    public Menu(String label, String image, String url) {
        this.setLabel(label);
        this.setImage(image);
        this.setURL(url);
        this.setEnabled(true);
        this.setStyleClassPrefix("");
        this.setImageLocation("");
        this.setTabIndex(-2);
        this.setSelected(false);
        this.menuItemCounter = 0;
        this.counter = 0;
        this.setDefaultURLSuppressed(false);
    }

    private String getCurrentImage() {
        if (this.isEnabled()) {
            return this.getImage();
        }
        if (this.getDisabledImage() != null) {
            return this.getDisabledImage();
        }
        return this.getImage();
    }

    private String getCurrentImageKey() {
        if (this.isEnabled()) {
            return this.getImageKey();
        }
        if (this.getDisabledImage() != null) {
            return this.getDisabledImageKey();
        }
        return this.getImageKey();
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        String label = this.getLabel();
        BaseHTMLMenuBar mbar = (BaseHTMLMenuBar)this.getMenuBar();
        boolean useSpan = mbar.isUseSpan();
        boolean horizontal = mbar.getHorizontalOrientation();
        if (this.getTemplate() != null || this.getTemplateFileName() != null || this.getTemplateKey() != null) {
            if (this.getTemplateDictionary() == null) {
                this.setTemplateDictionary(this.getDefaultTemplateDictionary());
            }
            boolean i = false;
            if (this.isWrapped()) {
                out.println("  <td>");
            } else {
                out.println("  <td nowrap=\"nowrap\">");
            }
            TemplateSupport.writeTemplate(this, null, out);
            out.println("</td>");
        } else if (this.isSimpleMenu()) {
            if (useSpan && horizontal) {
                out.print("<span");
            } else if (this.isWrapped()) {
                out.print("  <td");
            } else {
                out.print("  <td nowrap=\"nowrap\"");
            }
            if (this.getWidth() > 0) {
                out.print(" width=\"");
                out.print(this.getWidth());
                out.print("\"");
            } else if (this.getWidthPercentage() > 0) {
                out.print(" width=\"");
                out.print(this.getWidthPercentage());
                out.print("%\"");
            }
            if (this.getHeight() > 0) {
                out.print(" height=\"");
                out.print(this.getHeight());
                out.print("\"");
            } else if (this.getHeightPercentage() > 0) {
                out.print(" height=\"");
                out.print(this.getHeightPercentage());
                out.print("%\"");
            }
            out.print(" id=\"");
            out.print(this.getId());
            out.print("\"");
            Map styleMap = this.getDefaultComponentStyleMap();
            if (styleMap == null) {
                styleMap = this.getStyleMap();
            }
            HtmlUtil.writeStyleClass(out, this.getStyleClassPrefix(), HtmlUtilMenu.getDependentStyleClass(styleMap, this.getURL(), this.isEnabled(), true));
            if (this.isEnabled()) {
                this.setCustomAttributes(this.getScriptName(false, null));
                HtmlUtil.writeOnAttributes(out, this);
                if (this.getDynamicButtonArea() == 0) {
                    String image = this.getImage();
                    if (image != null) {
                        String rolloverImage = this.getRolloverImage();
                        if (rolloverImage != null) {
                            HtmlUtil.writeOnMouseOver(out, this.getId(), this.getImageLocation(), rolloverImage);
                            HtmlUtil.writeOnMouseOut(out, this.getId(), this.getImageLocation(), image);
                        }
                    } else {
                        String rolloverImageKey;
                        String imageKey = this.getImageKey();
                        if (imageKey != null && (rolloverImageKey = this.getRolloverImageKey()) != null) {
                            HtmlUtil.writeOnMouseOver(out, this.getId(), this.getImageLocation(), ComponentPropertyManager.getInstance(this.getRequest()).getImageName(rolloverImageKey));
                            HtmlUtil.writeOnMouseOut(out, this.getId(), this.getImageLocation(), ComponentPropertyManager.getInstance(this.getRequest()).getImageName(imageKey));
                        }
                    }
                } else {
                    HtmlUtil.writeButtonDynamicRootInfo(out, this);
                }
                if (!this.isAnchorNeeded()) {
                    HtmlUtil.writeCustomAttributes(out, this.getCustomAttributes());
                }
            }
            out.print(">");
            HtmlUtil.writeCenterButtonText(out, this, this.getId(), 4, this.getCurrentURL(), this.isAnchorNeeded());
            if (this.isPopupMenuIndicatorVisible() && this.getMenuItems() != null) {
                ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
                out.print("<img border=\"0\" src=\"");
                if (this.popupMenuIndicatorImage != null) {
                    out.print(cpm.getImageLocation());
                    out.print(this.popupMenuIndicatorImage + "\" alt=\"\"></img>");
                } else {
                    out.print(cpm.getImageURI(this.popupMenuIndicatorImageKey, this.imageLocation));
                }
                out.print("\" alt=\"\"></img>");
            }
            if (useSpan && horizontal) {
                out.print("</span>");
            } else {
                out.print("</td>");
            }
        } else {
            String menuStyleClass = this.getMenuStyleClass();
            Button button = new Button();
            button.setRequest(this.getRequest());
            button.setResponse(this.getResponse());
            button.setLocale(this.getLocale());
            button.setButtonType(4);
            button = (Button)this.setButtonProperties(button);
            if (this.isEnabled()) {
                button.setCustomAttributes(this.getScriptName(false, null));
            }
            button.setLabel(label);
            button.setImage(this.getCurrentImage());
            button.setImageKey(this.getCurrentImageKey());
            button.setImageKeyConfig(this.getImageKeyConfig());
            button.setURL(this.getCurrentURL());
            button.setStyleClass(menuStyleClass);
            StyleInfo buttonStyle = new StyleInfo();
            buttonStyle.setClassid(menuStyleClass);
            Map buttonMap = button.getStyleMap();
            buttonMap.put("BUTTON_CENTER", buttonStyle);
            button.setId(this.getId());
            button.setStyleClassPrefix(this.getStyleClassPrefix());
            button.setButtonType(4);
            button.setRolloverImage(this.getRolloverImage());
            if (!useSpan || !horizontal) {
                out.println("<td>");
            }
            if (button.getTabIndex() == -2) {
                button.setTabIndex(0);
            }
            button.write(out);
            if (!useSpan || !horizontal) {
                out.println("</td>");
            }
        }
        this.cleanUpResources();
    }

    @SASScope
    protected HashMap getDefaultTemplateDictionary() {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        String label = this.getLabel();
        dictionary.put("LABEL", label);
        dictionary.put("URL", this.getCurrentURL());
        dictionary.put("IMAGE_LOCATION", this.getImageLocation());
        if (this.getImage() != null) {
            dictionary.put("IMAGE", this.getImage());
        } else if (this.getImageKey() != null) {
            dictionary.put("IMAGE", ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(this.getImageKey()));
        } else {
            dictionary.put("IMAGE", null);
        }
        if (this.getDisabledImage() != null) {
            dictionary.put("DISABLEDIMAGE", this.getDisabledImage());
        } else if (this.getDisabledImageKey() != null) {
            dictionary.put("DISABLEDIMAGE", ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(this.getDisabledImageKey()));
        } else {
            dictionary.put("DISABLEDIMAGE", null);
        }
        dictionary.put("ALTERNATETEXT", this.getAlternateText());
        dictionary.put("TITLE", this.getTitle());
        dictionary.put("TARGET", this.getTarget());
        dictionary.put("ACCESSKEY", this.getAccessKey());
        dictionary.put("TABINDEX", new Integer(this.getTabIndex()));
        Map styleMap = this.getStyleMap();
        Set set = styleMap.keySet();
        for (String key : set) {
            StyleInfo styleinfo = (StyleInfo)styleMap.get(key);
            dictionary.put(key, styleinfo.getClassid());
        }
        String script = this.getScriptName(false, null);
        StringBuffer custom = new StringBuffer();
        custom.append(" id=\"").append(this.getId()).append("\"");
        custom.append(" ").append(script);
        dictionary.put("ACTION", custom.toString());
        return dictionary;
    }

    public void writeDropdown(PrintWriter out) throws IOException {
        ArrayList menuItems = this.getMenuItems();
        if (menuItems == null) {
            return;
        }
        StringBuffer header = new StringBuffer();
        header.append("<div id=\"").append(this.getId()).append("_dropper").append("\"");
        header.append(" style=\"display:none;position:absolute;\"");
        String containerStyle = this.getStyle("MENU_ITEM_CONTAINER").getClassid();
        header.append(" class=\"").append(this.getStyleClassPrefix()).append(containerStyle).append("\">\n");
        header.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        out.println(header.toString());
        for (int j = 0; j < menuItems.size(); ++j) {
            Object menuObject = menuItems.get(j);
            BaseMenuItem menuItem = null;
            if (menuObject instanceof ArrayList) {
                menuItem = new MenuItem(null, null, null);
                menuItem.setMenu(this);
                menuItem.setRequest(this.getRequest());
                menuItem.setResponse(this.getResponse());
                menuItem.setLocale(this.getLocale());
                menuItem.setStyleClassPrefix(this.getStyleClassPrefix());
            } else if (menuObject instanceof BaseMenu) {
                BaseMenu tempMenu = (BaseMenu)menuObject;
                menuItem = this.setMenuItemProperties((BaseMenuItem)menuObject);
                menuItem.setStyleClassPrefix(this.getStyleClassPrefix());
                menuItem.setMenu(this);
                menuItem.setRequest(this.getRequest());
                if (tempMenu.count() > 0) {
                    ++this.menuItemCounter;
                    ++this.submenuCount;
                    StringBuffer onMouseOver = new StringBuffer("MenuBar_showPop('");
                    onMouseOver.append(tempMenu.getId()).append("_sub");
                    onMouseOver.append(QUOTE_COMMA_QUOTE).append(tempMenu.getId()).append("',false, true, event);");
                    menuItem.setOnMouseOver(onMouseOver.toString());
                    StringBuffer onKeyDown = new StringBuffer("sas_MenuBar_navigateMenu(event,").append(QUOTE);
                    if (tempMenu.getPreviousMenuItem() != null) {
                        onKeyDown.append(tempMenu.getPreviousMenuItem().getId());
                    }
                    onKeyDown.append(QUOTE_COMMA_QUOTE);
                    if (tempMenu.getNextMenuItem() != null) {
                        onKeyDown.append(tempMenu.getNextMenuItem().getId());
                    }
                    onKeyDown.append(QUOTE_COMMA_QUOTE);
                    if (tempMenu.getPreviousMenu() != null) {
                        onKeyDown.append(tempMenu.getPreviousMenu().getId());
                    }
                    onKeyDown.append(QUOTE_COMMA_QUOTE);
                    if (tempMenu.getNextMenu() != null) {
                        onKeyDown.append(tempMenu.getNextMenu().getId());
                    }
                    onKeyDown.append(QUOTE_COMMA_QUOTE);
                    if (tempMenu.getMenuItems().size() > 0) {
                        onKeyDown.append(tempMenu.getId());
                    }
                    onKeyDown.append("')");
                    menuItem.setOnKeyDown(onKeyDown.toString());
                    menuItem.submenu = true;
                    this.processMenuItem(tempMenu);
                }
            } else if (menuObject instanceof BaseMenuItem) {
                menuItem = (BaseMenuItem)menuObject;
                menuItem.setRequest(this.getRequest());
                menuItem.setStyleClassPrefix(this.getStyleClassPrefix());
                if (menuItem.getTemplate() == null && this.getTemplate() != null) {
                    menuItem.setTemplate(this.getTemplate());
                }
                menuItem.setMenu(this);
                if (!menuItem.isDivider()) {
                    if (menuItem instanceof BaseSelectorMenuItem && menuItem.isEnabled()) {
                        String selector_url;
                        BaseSelectorMenuItem selectorItem = (BaseSelectorMenuItem)menuItem;
                        String target = selectorItem.getTarget();
                        if (target == null && this.getRequest() != null) {
                            target = "opener" + this.getRequest().getSession().getCreationTime();
                        }
                        if ((selector_url = selectorItem.getURL()) == null) {
                            selector_url = "";
                        }
                        StringBuffer onClick = new StringBuffer();
                        onClick.append("SelectorMenuBar_openExternalSelector('").append(Strings.escapeForJavaScript((String)selector_url)).append(QUOTE_COMMA_QUOTE).append(selectorItem.getSelectorWidth());
                        onClick.append(QUOTE_COMMA_QUOTE).append(selectorItem.getSelectorHeight()).append(QUOTE_COMMA_QUOTE).append(target).append(QUOTE_COMMA_QUOTE);
                        onClick.append(selectorItem.isModal()).append(QUOTE_COMMA_QUOTE);
                        onClick.append(this.getId()).append("_dropper").append("')");
                        menuItem.setOnClick(onClick.toString());
                    }
                    if (menuItem instanceof MenuItem || menuItem instanceof SelectorMenuItem) {
                        StringBuffer mouseOver = new StringBuffer("MenuBar_hideMenuItems('");
                        mouseOver.append(this.getId()).append("_dropper").append("',event);sas_MenuBar_highlightMenuItem(this);");
                        menuItem.setOnMouseOver(mouseOver.toString());
                        StringBuffer keyDown = new StringBuffer("sas_MenuBar_navigateMenu(event,").append(QUOTE);
                        if (menuItem.getPreviousMenuItem() != null) {
                            keyDown.append(menuItem.getPreviousMenuItem().getId());
                        }
                        keyDown.append(QUOTE_COMMA_QUOTE);
                        if (menuItem.getNextMenuItem() != null) {
                            keyDown.append(menuItem.getNextMenuItem().getId());
                        }
                        keyDown.append(QUOTE_COMMA_QUOTE);
                        if (menuItem.getPreviousMenu() != null) {
                            keyDown.append(menuItem.getPreviousMenu().getId());
                        }
                        keyDown.append(QUOTE_COMMA_QUOTE);
                        if (menuItem.getNextMenu() != null) {
                            keyDown.append(menuItem.getNextMenu().getId());
                        }
                        keyDown.append("','')");
                        menuItem.setOnKeyDown(keyDown.toString());
                    }
                }
            }
            if (menuItem == null) continue;
            menuItem.write(out);
        }
        out.println("</table>");
        out.println("</div>");
        int numSubMenus = this.getSubMenuCollectionSize();
        if (numSubMenus > 0) {
            for (int k = 0; k < numSubMenus; ++k) {
                ArrayList tempArray = (ArrayList)this.getSubMenuCollection().get(k);
                this.writeMenu(out, tempArray);
            }
        }
    }

    private void writeMenu(PrintWriter out, ArrayList submenu) {
        StringBuffer sb = new StringBuffer();
        ++this.counter;
        ++this.submenuWritten;
        String tempmenuid = ((BaseMenuItem)submenu.get(0)).getMenu().getId();
        sb.append("<div");
        sb.append(" id=\"").append(tempmenuid).append("_sub").append("\"");
        sb.append(" style=\"display:none;position:absolute;\"");
        sb.append(" class=").append(QUOTE);
        String containerStyle = this.getStyle("MENU_ITEM_CONTAINER").getClassid();
        sb.append(this.getStyleClassPrefix()).append(containerStyle).append(QUOTE);
        sb.append(">").append("\n");
        sb.append("<table").append(" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"");
        sb.append(">");
        sb.append("\n");
        for (int i = 0; i < submenu.size(); ++i) {
            BaseMenuItem mitem = (BaseMenuItem)submenu.get(i);
            mitem.setRequest(this.getRequest());
            sb.append(mitem.toString());
        }
        sb.append("</table>").append("\n");
        sb.append("</div>\n");
        out.println(sb.toString());
    }

    @SASScope
    protected String getMenuStyleClass() {
        StringBuffer style = new StringBuffer();
        style.append(this.getStyleClassPrefix());
        if (!this.isEnabled()) {
            if (this.getURL() == null) {
                style.append(this.getStyle("MENU_DISABLED").getClassid());
            } else {
                style.append(this.getStyle("MENU_LINK_DISABLED").getClassid());
            }
            return style.toString();
        }
        if (this.getURL() == null) {
            style.append(this.getStyle("MENU").getClassid());
        } else {
            style.append(this.getStyle("MENU_LINK").getClassid());
        }
        return style.toString();
    }

    @SASScope
    protected String getMenuItemStyleClass(BaseMenuItem mitem) {
        StringBuffer style = new StringBuffer();
        style.append(this.getStyleClassPrefix());
        if (!this.isEnabled()) {
            if (this.getURL() == null) {
                style.append(this.getStyle("MENU_ITEM_DISABLED").getClassid());
            } else {
                style.append(this.getStyle("MENU_ITEM_LINK_DISABLED").getClassid());
            }
            return style.toString();
        }
        if (this.isSelected()) {
            // empty if block
        }
        if (this.getURL() == null) {
            style.append(this.getStyle("MENU_ITEM").getClassid());
        } else {
            style.append(this.getStyle("MENU_ITEM_LINK").getClassid());
        }
        return style.toString();
    }

    @SASScope
    protected String getScriptName(boolean submenu, SelectorMenuItem selectorItem) {
        String id = this.getId();
        StringBuffer script = new StringBuffer();
        SelectorMenuItem item = (SelectorMenuItem)this.getSelectorMenuItem();
        if (item == null && this.count() > 0 && this.getMenuItems().get(0) instanceof SelectorMenuItem) {
            item = (SelectorMenuItem)this.getMenuItems().get(0);
        }
        if (item == null && selectorItem != null) {
            item = selectorItem;
        }
        if (this.getMenuType() == 4) {
            if (item != null && item.getURL() != null) {
                String target = item.getTarget();
                if (target == null && this.getRequest() != null) {
                    target = "opener" + this.getRequest().getSession().getCreationTime();
                }
                if (!item.isDefaultURLSuppressed() && !this.isDefaultURLSuppressed()) {
                    script.append(" onclick=\"SelectorMenuBar_openExternalSelector").append("('").append(Strings.escapeForJavaScript((String)item.getURL())).append(QUOTE_COMMA_QUOTE).append(item.getSelectorWidth()).append(QUOTE_COMMA_QUOTE).append(item.getSelectorHeight()).append(QUOTE_COMMA_QUOTE).append(target).append(QUOTE_COMMA_QUOTE).append(item.isModal()).append(QUOTE_COMMA).append(QUOTE).append(id).append("_dropper").append(QUOTE).append(");\"");
                }
            } else if (this.getURL() != null) {
                int width;
                int height;
                boolean modal = false;
                if (item != null) {
                    height = item.getSelectorHeight();
                    width = item.getSelectorWidth();
                    modal = item.isModal();
                } else {
                    height = 450;
                    width = 600;
                }
                String target = this.getTarget();
                if (target == null && this.getRequest() != null) {
                    target = "opener" + this.getRequest().getSession().getCreationTime();
                }
                if (!this.isDefaultURLSuppressed()) {
                    script.append(" onclick=\"SelectorMenuBar_openExternalSelector").append("('").append(Strings.escapeForJavaScript((String)this.getURL())).append(QUOTE_COMMA_QUOTE).append(width).append(QUOTE_COMMA_QUOTE).append(height).append(QUOTE_COMMA_QUOTE).append(target).append(QUOTE_COMMA_QUOTE).append(modal).append(QUOTE_COMMA).append(0).append(");\"");
                }
            }
        } else if (this.getMenuType() == 3) {
            if (item == null && this.count() > 0 && this.getMenuItems().get(0) instanceof SelectorMenuItem) {
                item = (SelectorMenuItem)this.getMenuItems().get(0);
            }
            if (item != null && item.getSelector() != null && !item.isDefaultURLSuppressed() && !this.isDefaultURLSuppressed()) {
                script.append(" onclick=\"SelectorMenuBar_hideUnhide('selectorobject").append(id).append(QUOTE_COMMA);
                script.append(QUOTE).append(this.getId()).append(QUOTE).append(")\"");
            }
        } else if (this.getMenuType() == 5 || this.getMenuType() == 1) {
            if (this.count() == 0) {
                script.append(" onmouseover=\"MenuBar_hidePop(null, event)\"");
                script.append(" onfocus=\"MenuBar_hidePop(null, event)\"");
                if (this.getOnClick() != null) {
                    script.append(" onclick=\"" + this.getOnClick() + "\";");
                }
                script.append(" onkeydown=\"sas_MenuBar_navigateMenu(event,").append(QUOTE);
                if (this.getPreviousMenuItem() != null) {
                    script.append(this.getPreviousMenuItem().getId());
                }
                script.append(QUOTE_COMMA_QUOTE);
                if (this.getNextMenuItem() != null) {
                    script.append(this.getNextMenuItem().getId());
                }
                script.append(QUOTE_COMMA_QUOTE);
                if (this.getPreviousMenu() != null) {
                    script.append(this.getPreviousMenu().getId());
                }
                script.append(QUOTE_COMMA_QUOTE);
                if (this.getNextMenu() != null) {
                    script.append(this.getNextMenu().getId());
                }
                script.append("','')\"\n");
                return script.toString();
            }
            if (this.getMenuType() == 1) {
                if (this.isEnabled()) {
                    script.append(" onmouseover=\"MenuBar_showPop(").append(QUOTE).append(id).append("_dropper").append(QUOTE).append(COMMA).append(QUOTE).append(this.getId()).append(QUOTE).append(COMMA).append(this.getMenuBar().getHorizontalOrientation()).append(",false,event);\"");
                    script.append(" onfocus=\"MenuBar_showPop(").append(QUOTE).append(id).append("_dropper").append(QUOTE).append(COMMA).append(QUOTE).append(this.getId()).append(QUOTE).append(COMMA).append(this.getMenuBar().getHorizontalOrientation()).append(",false,event);\"");
                }
                script.append(" onkeydown=\"sas_MenuBar_navigateMenu(event,").append(QUOTE);
                if (this.getPreviousMenuItem() != null) {
                    script.append(this.getPreviousMenuItem().getId());
                }
                script.append(QUOTE_COMMA_QUOTE);
                if (this.getNextMenuItem() != null) {
                    script.append(this.getNextMenuItem().getId());
                }
                script.append(QUOTE_COMMA_QUOTE);
                if (this.getPreviousMenu() != null) {
                    script.append(this.getPreviousMenu().getId());
                }
                script.append(QUOTE_COMMA_QUOTE);
                if (this.getNextMenu() != null) {
                    script.append(this.getNextMenu().getId());
                }
                script.append("','')\"\n");
            } else if (this.getMenuType() == 5 || this.count() > 0) {
                if (this.isEnabled()) {
                    script.append(" onclick=\"MenuBar_showPopClick(").append(QUOTE).append(this.getId()).append("_dropper").append(QUOTE).append(COMMA).append(QUOTE).append(this.getId()).append(QUOTE).append(COMMA).append(this.getMenuBar().getHorizontalOrientation()).append(",event);\"");
                    script.append(" onkeydown=\"sas_MenuBar_navigateMenu(event,").append(QUOTE);
                    if (this.getPreviousMenuItem() != null) {
                        script.append(this.getPreviousMenuItem().getId());
                    }
                    script.append(QUOTE_COMMA_QUOTE);
                    if (this.getNextMenuItem() != null) {
                        script.append(this.getNextMenuItem().getId());
                    }
                    script.append(QUOTE_COMMA_QUOTE);
                    if (this.getPreviousMenu() != null) {
                        script.append(this.getPreviousMenu().getId());
                    }
                    script.append(QUOTE_COMMA_QUOTE);
                    if (this.getNextMenu() != null) {
                        script.append(this.getNextMenu().getId());
                    }
                    script.append("','')\"\n");
                }
            } else if (this.getOnClick() != null) {
                script.append(" onclick=\"" + this.getOnClick() + "\";");
            }
        } else if (this.getMenuType() == 2 && this.getOnClick() != null) {
            script.append(" onclick=\"" + this.getOnClick() + "\";");
        }
        return script.toString();
    }

    private void storeItems(BaseMenu mitem) {
        ArrayList<BaseMenuItem> storedItems = new ArrayList<BaseMenuItem>();
        ArrayList items = mitem.getMenuItems();
        ++this.menuItemCounter;
        for (int i = 0; i < mitem.count(); ++i) {
            BaseMenuItem menuItem = (BaseMenuItem)items.get(i);
            menuItem.setMenu(this);
            if (menuItem instanceof BaseMenu) {
                BaseMenu omenu = (BaseMenu)menuItem;
                menuItem = this.setMenuItemProperties(menuItem);
                ++this.submenuCount;
                StringBuffer mouseOver = new StringBuffer("MenuBar_showPop('");
                mouseOver.append(omenu.getId()).append("_sub").append(QUOTE_COMMA_QUOTE);
                mouseOver.append(omenu.getId()).append("',false,true,event);");
                menuItem.setOnMouseOver(mouseOver.toString());
                StringBuffer keyDown = new StringBuffer("sas_MenuBar_navigateMenu(event,").append(QUOTE);
                if (omenu.getPreviousMenuItem() != null) {
                    keyDown.append(omenu.getPreviousMenuItem().getId());
                }
                keyDown.append(QUOTE_COMMA_QUOTE);
                if (omenu.getNextMenuItem() != null) {
                    keyDown.append(omenu.getNextMenuItem().getId());
                }
                keyDown.append(QUOTE_COMMA_QUOTE);
                if (omenu.getPreviousMenu() != null) {
                    keyDown.append(omenu.getPreviousMenu().getId());
                }
                keyDown.append(QUOTE_COMMA_QUOTE);
                if (omenu.getNextMenu() != null) {
                    keyDown.append(omenu.getNextMenu().getId());
                }
                keyDown.append(QUOTE_COMMA_QUOTE);
                if (omenu.getMenuItems().size() > 0) {
                    keyDown.append(omenu.getId());
                }
                keyDown.append("')");
                menuItem.setOnKeyDown(keyDown.toString());
                menuItem.submenu = true;
            }
            if (menuItem instanceof MenuItem) {
                // empty if block
            }
            menuItem.setMenu(mitem);
            menuItem.setStyleClassPrefix(this.getStyleClassPrefix());
            storedItems.add(menuItem);
        }
        this.getSubMenuCollection().add(storedItems);
    }

    @SASScope
    public void processMenuItem(BaseMenu mitem) {
        ArrayList items = mitem.getMenuItems();
        this.storeItems(mitem);
        BaseMenuItem menuItem = null;
        BaseMenuItem menuObject = null;
        for (int i = 0; i < mitem.count(); ++i) {
            StringBuffer onClick;
            String selector_url;
            String target;
            BaseSelectorMenuItem selectorItem;
            menuObject = (BaseMenuItem)items.get(i);
            if (menuObject instanceof BaseMenu) {
                BaseMenu tempMenu = (BaseMenu)menuObject;
                this.processMenuItem(tempMenu);
                continue;
            }
            if (menuObject instanceof BaseSelectorMenuItem) {
                menuItem = menuObject;
                selectorItem = (BaseSelectorMenuItem)menuItem;
                target = selectorItem.getTarget();
                if (target == null && this.getRequest() != null) {
                    target = "opener" + this.getRequest().getSession().getCreationTime();
                }
                if ((selector_url = selectorItem.getURL()) == null) {
                    selector_url = "";
                }
                onClick = new StringBuffer("SelectorMenuBar_openExternalSelector('");
                onClick.append(Strings.escapeForJavaScript((String)selector_url)).append(QUOTE_COMMA_QUOTE).append(selectorItem.getSelectorWidth());
                onClick.append(QUOTE_COMMA_QUOTE).append(selectorItem.getSelectorHeight()).append(QUOTE_COMMA_QUOTE);
                onClick.append(target).append(QUOTE_COMMA_QUOTE);
                onClick.append(selectorItem.isModal()).append(QUOTE_COMMA_QUOTE).append(this.getId());
                onClick.append("_dropper").append("')");
                menuItem.setOnClick(onClick.toString());
                continue;
            }
            ++this.submenuCount;
            menuItem = menuObject;
            if (menuObject instanceof BaseSelectorMenuItem) {
                selectorItem = (BaseSelectorMenuItem)menuItem;
                target = selectorItem.getTarget();
                if (target == null && this.getRequest() != null) {
                    target = "opener" + this.getRequest().getSession().getCreationTime();
                }
                if ((selector_url = selectorItem.getURL()) == null) {
                    selector_url = "";
                }
                onClick = new StringBuffer("SelectorMenuBar_openExternalSelector('");
                onClick.append(Strings.escapeForJavaScript((String)selector_url)).append(QUOTE_COMMA_QUOTE).append(selectorItem.getSelectorWidth());
                onClick.append(QUOTE_COMMA_QUOTE).append(selectorItem.getSelectorHeight()).append(QUOTE_COMMA_QUOTE);
                onClick.append(target).append(QUOTE_COMMA_QUOTE);
                onClick.append(selectorItem.isModal()).append(QUOTE_COMMA_QUOTE).append(this.getId());
                onClick.append("_dropper").append("')");
                menuItem.setOnClick(onClick.toString());
            }
            StringBuffer mouseOver = new StringBuffer("MenuBar_hideMenuItems('");
            mouseOver.append(mitem.getId()).append("_sub").append("',event);");
            menuItem.setOnMouseOver(mouseOver.toString());
            StringBuffer keyDown = new StringBuffer("sas_MenuBar_navigateMenu(event,").append(QUOTE);
            if (menuItem.getPreviousMenuItem() != null) {
                keyDown.append(menuItem.getPreviousMenuItem().getId());
            }
            keyDown.append(QUOTE_COMMA_QUOTE);
            if (menuItem.getNextMenuItem() != null) {
                keyDown.append(menuItem.getNextMenuItem().getId());
            }
            keyDown.append(QUOTE_COMMA_QUOTE);
            if (menuItem.getPreviousMenu() != null) {
                keyDown.append(menuItem.getPreviousMenu().getId());
            }
            keyDown.append(QUOTE_COMMA_QUOTE);
            if (menuItem.getNextMenu() != null) {
                keyDown.append(menuItem.getNextMenu().getId());
            }
            keyDown.append("','')");
            menuItem.setOnKeyDown(keyDown.toString());
        }
    }

    private MenuItem setMenuItemProperties(BaseMenuItem selectorItem) {
        MenuItem mitem = new MenuItem();
        mitem.setRequest(this.getRequest());
        mitem.setResponse(this.getResponse());
        mitem.setLocale(this.getLocale());
        mitem.setId(selectorItem.getId());
        mitem.setImage(selectorItem.getImage());
        mitem.setImageKey(selectorItem.getImageKey());
        mitem.setLabel(selectorItem.getLabel());
        mitem.setURL(selectorItem.getURL());
        mitem.setTarget(selectorItem.getTarget());
        mitem.setAccessKey(selectorItem.getAccessKey());
        mitem.setWrap(selectorItem.isWrapped());
        mitem.setOnClick(selectorItem.getOnClick());
        mitem.setOnKeyDown(selectorItem.getOnKeyDown());
        mitem.setOnKeyPress(selectorItem.getOnKeyPress());
        mitem.setOnKeyUp(selectorItem.getOnKeyUp());
        mitem.setOnMouseOut(selectorItem.getOnMouseOut());
        mitem.setOnMouseOver(selectorItem.getOnMouseOver());
        mitem.setOnMouseDown(selectorItem.getOnMouseDown());
        mitem.setOnMouseUp(selectorItem.getOnMouseUp());
        mitem.setTitle(selectorItem.getTitle());
        mitem.setAccessKey(selectorItem.getAccessKey());
        mitem.setLeftImage(selectorItem.getLeftImage());
        mitem.setRightImage(selectorItem.getRightImage());
        mitem.getImageKeyConfig().setLeftImageKey(selectorItem.getImageKeyConfig().getLeftImageKey());
        mitem.getImageKeyConfig().setRightImageKey(selectorItem.getImageKeyConfig().getRightImageKey());
        mitem.setBottomImage(selectorItem.getBottomImage());
        mitem.setBottomRightImage(selectorItem.getBottomRightImage());
        mitem.setBottomLeftImage(selectorItem.getBottomLeftImage());
        mitem.getImageKeyConfig().setBottomImageKey(selectorItem.getImageKeyConfig().getBottomImageKey());
        mitem.getImageKeyConfig().setBottomRightImageKey(selectorItem.getImageKeyConfig().getBottomRightImageKey());
        mitem.getImageKeyConfig().setBottomLeftImageKey(selectorItem.getImageKeyConfig().getBottomLeftImageKey());
        mitem.setTopImage(selectorItem.getTopImage());
        mitem.setTopLeftImage(selectorItem.getTopLeftImage());
        mitem.setTopRightImage(selectorItem.getTopRightImage());
        mitem.getImageKeyConfig().setTopImageKey(selectorItem.getImageKeyConfig().getTopImageKey());
        mitem.getImageKeyConfig().setTopLeftImageKey(selectorItem.getImageKeyConfig().getTopLeftImageKey());
        mitem.getImageKeyConfig().setTopRightImageKey(selectorItem.getImageKeyConfig().getTopRightImageKey());
        mitem.setCustomAttributes(selectorItem.getCustomAttributes());
        mitem.setHeight(selectorItem.getHeight());
        mitem.setHeightPercentage(selectorItem.getHeightPercentage());
        mitem.setWidth(selectorItem.getWidth());
        mitem.setWidthPercentage(selectorItem.getWidthPercentage());
        mitem.setImagePosition(selectorItem.getImagePosition());
        if (selectorItem.getTabIndex() == 0) {
            mitem.setTabIndex(-1);
        } else {
            mitem.setTabIndex(selectorItem.getTabIndex());
        }
        mitem.setAlternateText(selectorItem.getAlternateText());
        mitem.setDisabledAlternateText(selectorItem.getDisabledAlternateText());
        mitem.setDisabledImage(selectorItem.getDisabledImage());
        mitem.setDisabledImageKey(selectorItem.getDisabledImageKey());
        mitem.setRolloverImage(selectorItem.getRolloverImage());
        mitem.setRolloverImageKey(selectorItem.getRolloverImageKey());
        mitem.setMenu(this);
        return mitem;
    }

    @Override
    public Map getStyleMap() {
        if (this.componentStyleMap == null) {
            Menu.setupDefaultStyleMap();
            this.componentStyleMap = new MapWithDefaults((Map)defaultStyleMap);
        }
        return this.componentStyleMap;
    }

    public void setStyleMap(Map styleMap) {
        this.componentStyleMap = styleMap;
    }

    private Map getDefaultComponentStyleMap() {
        if (this.componentStyleMap == null && this.getMenuBar() != null) {
            this.componentStyleMap = new MapWithDefaults(((BaseHTMLMenuBar)this.getMenuBar()).getStyleMap());
        }
        return this.componentStyleMap;
    }

    private boolean isAnchorNeeded() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.count() > 0 || this.getTabIndex() > -2 || this.getAccessKey() != null || this.getURL() != null || this.getOnClick() != null || this.getOnKeyDown() != null;
    }

    private StyleInfo getStyle(String value) {
        Map defaultMap = this.getDefaultComponentStyleMap();
        if (defaultMap.get(value) != null) {
            return (StyleInfo)defaultMap.get(value);
        }
        Menu.setupDefaultStyleMap();
        return (StyleInfo)defaultStyleMap.get(value);
    }

    private ArrayList getSubMenuCollection() {
        if (this.submenuCollection == null) {
            this.submenuCollection = new ArrayList();
        }
        return this.submenuCollection;
    }

    private int getSubMenuCollectionSize() {
        if (this.submenuCollection == null) {
            return 0;
        }
        return this.submenuCollection.size();
    }

    @SASScope
    public boolean isPopupMenuIndicatorVisible() {
        return this.popupMenuIndicatorVisible;
    }

    @SASScope
    public void setPopupMenuIndicatorVisible(boolean popupMenuIndicatorVisible) {
        this.popupMenuIndicatorVisible = popupMenuIndicatorVisible;
    }

    @SASScope
    public void setPopupMenuIndicatorImage(String popupMenuIndicatorImage) {
        this.popupMenuIndicatorImage = popupMenuIndicatorImage;
    }

    @SASScope
    public String getPopupMenuIndicatorImageKey() {
        return this.popupMenuIndicatorImageKey;
    }

    @SASScope
    public void setPopupMenuIndicatorImageKey(String popupMenuIndicatorImageKey) {
        this.popupMenuIndicatorImageKey = popupMenuIndicatorImageKey;
    }
}

