/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.HTMLConstantsInterface;
import com.sas.servlet.tbeans.html.HtmlUtil;
import com.sas.servlet.tbeans.menubar.BaseMenuItem;
import com.sas.servlet.tbeans.menubar.html.MenuBarStyleAreaKeysInterface;
import com.sas.servlet.tbeans.menubar.html.MenuItem;
import com.sas.servlet.tbeans.menubar.html.SelectorMenuItem;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.util.Strings;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@SASScope
public class HtmlUtilMenu
implements MenuBarStyleAreaKeysInterface,
HTMLConstantsInterface {
    static final String RB_KEY = "Util.";
    public static final String BUTTON_TYPE = "BUTTON_TYPE";
    public static final String STYLE_CLASS = "STYLE_CLASS";
    public static final String DIVIDER_IMAGE = "DIVIDER_IMAGE";
    public static final String STYLE_CLASS_PREFIX = "STYLE_CLASS_PREFIX";
    public static final String CLASS_ID = "CLASS_ID";
    public static final String ID = "ID";
    public static final String URL = "URL";
    public static final String TARGET = "TARGET";
    public static final String STYLE_MAP = "STYLE_MAP";
    public static final String REQUEST = "REQUEST";
    public static final String POPUPMENU_CONTEXT_CELL_ID = "POPUPMENU_CONTEXT_CELL_ID";
    public static final String POPUPMENU_CONTEXT_CELL_TYPE = "POPUPMENU_CONTEXT_CELL_TYPE";
    public static final String POPUPMENU_LAUNCH_EVENT = "POPUPMENU_LAUNCH_EVENT";
    private static Map defaultStyleMap = new HashMap(24);

    public static StringBuffer generateMenuItem(StringBuffer inBuf, BaseMenuItem baseMenuItem, Map defaultStyleMap, String url, boolean anchorNeeded) {
        System.out.println("generateMenuItem: for " + baseMenuItem.getLabel());
        boolean debug = false;
        if (baseMenuItem.getLabel().equals("Sex")) {
            debug = true;
            System.out.println("found baseMenuItem = " + baseMenuItem);
            System.out.println("found baseMenuItem class = " + baseMenuItem.getClass().getName());
        }
        StringBuffer outBuf = HtmlUtilMenu.getOutBuf(inBuf);
        String menuItemStyleClass = HtmlUtilMenu.generateMenuItemStyleClass(null, baseMenuItem, url, defaultStyleMap).toString();
        if (baseMenuItem.isDivider()) {
            outBuf.append(HtmlUtil.generateDivider(null, baseMenuItem.getMenu().getImageLocation(), baseMenuItem.getMenu().getDividerImage(), baseMenuItem.getStyleClassPrefix(), menuItemStyleClass, HtmlUtilMenu.getStyle(baseMenuItem, "MENU_ITEM_DISABLED").getClassid()));
        } else {
            String button_id = baseMenuItem.getId();
            if (baseMenuItem.isWrapped()) {
                outBuf.append("  <td");
            } else {
                outBuf.append("  <td nowrap=\"nowrap\"");
            }
            if (baseMenuItem.getWidth() > 0) {
                outBuf.append(" width=\"").append(baseMenuItem.getWidth()).append("\"");
            } else if (baseMenuItem.getWidthPercentage() > 0) {
                outBuf.append(" width=\"").append(baseMenuItem.getWidthPercentage()).append("%\"");
            }
            if (baseMenuItem.getHeight() > 0) {
                outBuf.append(" height=\"").append(baseMenuItem.getHeight()).append("\"");
            } else if (baseMenuItem.getHeightPercentage() > 0) {
                outBuf.append(" height=\"").append(baseMenuItem.getHeightPercentage()).append("%\"");
            }
            if (baseMenuItem.getMenu().hasSubMenus() && !baseMenuItem.submenu) {
                outBuf.append(" colspan=\"2\"");
            }
            outBuf.append(" id=\"").append(button_id).append("\"");
            outBuf.append(" class=\"").append(menuItemStyleClass).append("\"");
            if (baseMenuItem.isEnabled()) {
                HtmlUtil.generateButtonProperties(outBuf, baseMenuItem, button_id, anchorNeeded);
            }
            outBuf.append(">\n");
            HtmlUtil.generateCenterButtonText(outBuf, baseMenuItem, button_id, 4, url, anchorNeeded);
            outBuf.append("\n  </td>");
            if (baseMenuItem.submenu) {
                outBuf.append("   <td ");
                outBuf.append(" class=\"").append(menuItemStyleClass).append("\"");
                outBuf.append(">");
                if (baseMenuItem.getMenu().getSubMenuImage() != null) {
                    outBuf.append("<img src=\"").append(baseMenuItem.getMenu().getSubMenuImage()).append("\" alt=\"\"></img>\n");
                } else {
                    HttpServletRequest request = baseMenuItem.getMenu().getRequest();
                    if (request != null) {
                        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
                        outBuf.append("<img style=\"margin-left:8px;\" src=\"").append(cpm.getImageURI("Menu_Right_Arrow")).append("\" alt=\"\"></img>\n");
                    } else {
                        outBuf.append("<span class=\"").append(baseMenuItem.getStyleClassPrefix());
                        outBuf.append(HtmlUtilMenu.getStyle(baseMenuItem, "MENU_ITEM_ARROW").getClassid());
                        outBuf.append("\">&gt;</span>");
                    }
                }
                outBuf.append("\n   </td>");
            }
        }
        return outBuf;
    }

    public static StringBuffer generateMenuItemStyleClass(StringBuffer inBuf, BaseMenuItem baseMenuItem, String url, Map defaultStyleMap) {
        StringBuffer outBuf = HtmlUtilMenu.getOutBuf(inBuf);
        outBuf.append(baseMenuItem.getStyleClassPrefix());
        if (!baseMenuItem.isEnabled()) {
            if (url == null) {
                outBuf.append(HtmlUtilMenu.getStyle(baseMenuItem, "MENU_ITEM_DISABLED").getClassid());
            } else {
                outBuf.append(HtmlUtilMenu.getStyle(baseMenuItem, "MENU_ITEM_LINK_DISABLED").getClassid());
            }
            return outBuf;
        }
        if (url == null) {
            outBuf.append(HtmlUtilMenu.getStyle(baseMenuItem, "MENU_ITEM").getClassid());
        } else {
            outBuf.append(HtmlUtilMenu.getStyle(baseMenuItem, "MENU_ITEM_LINK").getClassid());
        }
        return outBuf;
    }

    private static StringBuffer getOutBuf(StringBuffer inBuf) {
        if (inBuf == null) {
            return new StringBuffer();
        }
        return inBuf;
    }

    protected static String getMenuBarName(BaseMenuItem baseMenuItem) {
        if (baseMenuItem.getMenu() != null && baseMenuItem.getMenu().getMenuBar() != null) {
            return baseMenuItem.getMenu().getMenuBar().getId();
        }
        return baseMenuItem.getId();
    }

    private static StyleInfo getStyle(BaseMenuItem menuItem, String styleKey) {
        if (menuItem instanceof MenuItem) {
            return ((MenuItem)menuItem).getStyle(styleKey);
        }
        if (menuItem instanceof SelectorMenuItem) {
            return ((SelectorMenuItem)menuItem).getStyle(styleKey);
        }
        return null;
    }

    public static void writeOpenExternalSelectorScriptBegin(PrintWriter out, String url, int height, int width, int type) {
        if (url != null) {
            if (type == 0) {
                out.print(" onclick=");
            } else {
                out.print(" onenter=");
            }
            out.print("\"SelectorMenuBar_openExternalSelector('");
            out.print(Strings.escapeForJavaScript((String)url));
            out.print("','");
            out.print(width == 0 ? 450 : width);
            out.print("','");
            out.print(height == 0 ? 600 : height);
            out.print("','");
        }
    }

    public static void writeModalScriptAttr(PrintWriter out, boolean modal) {
        out.print("','");
        out.print(modal);
    }

    public static void writeOpenExternalSelectorScriptEnd(PrintWriter out, String itemId) {
        out.print("',");
        out.print("'");
        out.print(itemId);
        out.print("_dropper");
        out.print("'");
        out.print(");\"");
    }

    public static void writeEmptyDropScript(PrintWriter out, String itemId) {
        out.print(" onMouseOver=\"MenuBar_hidePop(null, event)\" onFocus=\"MenuBar_hidePop(null, event)\" ");
        HtmlUtilMenu.writeCommonOnKeyDownScript(out, itemId, itemId, itemId, itemId, null);
    }

    public static void writeDropClickScript(PrintWriter out, String itemId, boolean orientation, String nextMenuItemId, String previousMenuItemId, String nextMenuId, String previousMenuId, String subMenuId) {
        HtmlUtilMenu.writePopClickScript(out, itemId, orientation, 0);
        HtmlUtilMenu.writeCommonOnKeyDownScript(out, nextMenuItemId, previousMenuItemId, nextMenuId, previousMenuId, subMenuId);
    }

    public static void writeDropHoverScript(PrintWriter out, String itemId, boolean orientation, String nextMenuItemId, String previousMenuItemId, String nextMenuId, String previousMenuId, String subMenuId) {
        HtmlUtilMenu.writePopScript(out, itemId, orientation, 0);
        HtmlUtilMenu.writePopScript(out, itemId, orientation, 1);
        HtmlUtilMenu.writeCommonOnKeyDownScript(out, nextMenuItemId, previousMenuItemId, nextMenuId, previousMenuId, subMenuId);
    }

    public static void writeCommonOnKeyDownScript(PrintWriter out, String nextMenuItemId, String previousMenuItemId, String nextMenuId, String previousMenuId, String subMenuId) {
        out.print(" onkeydown=\"sas_MenuBar_navigateMenu(event,'");
        if (previousMenuItemId != null) {
            out.print(Strings.escapeForJavaScript((String)previousMenuItemId));
        }
        out.print("','");
        if (nextMenuItemId != null) {
            out.print(Strings.escapeForJavaScript((String)nextMenuItemId));
        }
        out.print("','");
        if (previousMenuId != null) {
            out.print(Strings.escapeForJavaScript((String)previousMenuId));
        }
        out.print("','");
        if (nextMenuId != null) {
            out.print(Strings.escapeForJavaScript((String)nextMenuId));
        }
        out.print("','");
        if (subMenuId != null) {
            out.print(Strings.escapeForJavaScript((String)subMenuId));
        }
        out.print("')\"");
    }

    public static void writePopClickScript(PrintWriter out, String itemId, boolean orientation, int type) {
        if (type == 0) {
            out.print("  onclick=\"MenuBar_showPopClick(");
        } else {
            out.print(" onenter=\"MenuBar_showPopClick(");
        }
        HtmlUtilMenu.writeCommonScript(out, itemId, orientation);
        out.print(",event);\"");
    }

    public static void writePopScript(PrintWriter out, String itemId, boolean orientation, int type) {
        if (type == 0) {
            out.print(" onmouseover=\"MenuBar_showPop(");
        } else {
            out.print(" onfocus=\"MenuBar_showPop(");
        }
        HtmlUtilMenu.writeCommonScript(out, itemId, orientation);
        out.print(",false,event);\"");
    }

    public static void writeSubPopScript(PrintWriter out, String itemId, int type) {
        if (type == 0) {
            out.print(" onmouseover=\"MenuBar_showPop('");
        } else {
            out.print(" onfocus=\"MenuBar_showPop('");
        }
        out.print(Strings.escapeForJavaScript((String)itemId));
        out.print("_sub");
        out.print("','");
        out.print(Strings.escapeForJavaScript((String)itemId));
        out.print("',false, true, event);\"");
    }

    public static void writeHideItemsScript(PrintWriter out, String itemId) {
        out.print(" onmouseover=\"MenuBar_hideMenuItems('");
        out.print(itemId);
        out.print("_dropper',event);\"");
    }

    public static void writeCommonScript(PrintWriter out, String itemId, boolean orientation) {
        out.print("'");
        out.print(itemId);
        out.print("_dropper");
        out.print("','");
        out.print(itemId);
        out.print("',");
        out.print(orientation);
    }

    public static void writeSubMenuStart(PrintWriter out, String itemId) {
        out.print("<div");
        HtmlUtil.writeMultiPartId(out, itemId, "_sub");
    }

    public static void writeDropdownStart(PrintWriter out, String itemId) {
        out.print("<div");
        HtmlUtil.writeMultiPartId(out, itemId, "_dropper");
    }

    public static void writeCommonDiv(PrintWriter out, String styleClassPrefix, Map styleMap) {
        out.print(" style=\"display:none;position:absolute;\"");
        HtmlUtil.writeStyleClass(out, styleClassPrefix, HtmlUtilMenu.getStyleClassId(styleMap, "MENU_ITEM_CONTAINER"));
        out.println(">\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
    }

    public static void writeDivider(PrintWriter out, String dividerImage, String styleClassPrefix, Map tdStyleMap, Map hrStyleMap, boolean enabled) {
        HtmlUtilMenu.writeDivider(out, dividerImage, styleClassPrefix, tdStyleMap, hrStyleMap, enabled, null);
    }

    @SASScope
    public static void writeDivider(PrintWriter out, String dividerImage, String styleClassPrefix, Map tdStyleMap, Map hrStyleMap, boolean enabled, String colspan) {
        out.print("   ");
        out.print("<td");
        if (colspan != null) {
            out.print(" colspan=\"" + colspan + "\" ");
        }
        HtmlUtil.writeStyleClass(out, styleClassPrefix, HtmlUtilMenu.getDependentStyleClass(tdStyleMap, null, enabled, false));
        out.print(">");
        if (dividerImage != null) {
            HtmlUtil.writeSimpleImageTag(out, dividerImage);
        } else {
            HtmlUtilMenu.writeSimpleHorizontalRowTag(out, styleClassPrefix, hrStyleMap);
        }
        out.println("</td>");
    }

    public static void writeSpanDivider(PrintWriter out, String styleClassPrefix, Map styleMap, String dividerText) {
        out.print("  <span align=\"center\" class=\"");
        HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
        out.print(HtmlUtilMenu.getStyleClassId(styleMap, "MENU_DIVIDER"));
        out.print("\">");
        out.print(dividerText);
        out.println("</span>");
    }

    public static void writeSpanSeparatorImage(PrintWriter out, String styleClassPrefix, Map styleMap, String separatorImage) {
        out.print("  <span align=\"center\" class=\"");
        HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
        out.print(HtmlUtilMenu.getStyleClassId(styleMap, "MENU_DIVIDER"));
        out.print("\"><img src='");
        out.print(separatorImage);
        out.println("' alt=\"\"></img></span>");
    }

    public static void writeTDSeparatorImage(PrintWriter out, String styleClassPrefix, Map styleMap, String separatorImage) {
        out.print("  <td align=\"center\" class=\"");
        HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
        out.print(HtmlUtilMenu.getStyleClassId(styleMap, "MENU_DIVIDER"));
        out.print("\"><img src='");
        out.print(separatorImage);
        out.println("' alt=\"\"></img></td>");
    }

    public static void writeTDDivider(PrintWriter out, String styleClassPrefix, Map styleMap, String dividerText) {
        out.print("  <td align=\"center\" class=\"");
        HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
        out.print(HtmlUtilMenu.getStyleClassId(styleMap, "MENU_DIVIDER"));
        out.print("\"><span>");
        out.print(dividerText);
        out.println("</span></td>");
    }

    public static void writeSimpleHorizontalRowTag(PrintWriter out, String styleClassPrefix, Map styleMap) {
        out.print("<hr class=\"");
        HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
        out.print(HtmlUtilMenu.getStyleClassId(styleMap, "MENU_ITEM_DIVIDER"));
        out.print("\"/>");
    }

    public static void writeItem(PrintWriter out, BaseMenuItem baseMenuItem, Map styleMap, String url, boolean anchorNeeded) {
        boolean enabled = baseMenuItem.isEnabled();
        String menuItemStyleClass = HtmlUtilMenu.getDependentStyleClass(styleMap, url, enabled, false);
        if (baseMenuItem.isDivider()) {
            HtmlUtilMenu.writeDivider(out, baseMenuItem.getMenu().getDividerImage(), baseMenuItem.getStyleClassPrefix(), styleMap, null, enabled);
        } else {
            if (baseMenuItem.isWrapped()) {
                out.print("  <td");
            } else {
                out.print("<td nowrap=\"nowrap\"");
            }
            if (baseMenuItem.getWidth() > 0) {
                out.print(" width=\"");
                out.print(baseMenuItem.getWidth());
                out.print("\"");
            } else if (baseMenuItem.getWidthPercentage() > 0) {
                out.print(" width=\"");
                out.print(baseMenuItem.getWidthPercentage());
                out.print("%\"");
            }
            if (baseMenuItem.getHeight() > 0) {
                out.print(" height=\"");
                out.print(baseMenuItem.getHeight());
                out.print("\"");
            } else if (baseMenuItem.getHeightPercentage() > 0) {
                out.print(" height=\"");
                out.print(baseMenuItem.getHeightPercentage());
                out.print("%\"");
            }
            if (baseMenuItem.getMenu().hasSubMenus() && !baseMenuItem.submenu) {
                out.print(" colspan=\"2\"");
            }
            out.print(" id=\"");
            out.print(baseMenuItem.getId());
            out.print("\" class=\"");
            out.print(menuItemStyleClass);
            out.print("\"");
            if (enabled) {
                if ((baseMenuItem instanceof MenuItem || baseMenuItem instanceof SelectorMenuItem) && anchorNeeded) {
                    baseMenuItem.setOnMouseOver(baseMenuItem.getOnMouseOver() + ";sas_MenuBar_highlightMenuItem(this);");
                }
                HtmlUtil.writeOnAttributes(out, baseMenuItem);
                if (baseMenuItem.getDynamicButtonArea() == 0) {
                    String rolloverImage;
                    String image = baseMenuItem.getImage();
                    if (image != null && (rolloverImage = baseMenuItem.getRolloverImage()) != null) {
                        HtmlUtil.writeOnMouseOver(out, baseMenuItem.getId(), baseMenuItem.getImageLocation(), rolloverImage);
                        HtmlUtil.writeOnMouseOut(out, baseMenuItem.getId(), baseMenuItem.getImageLocation(), image);
                    }
                } else {
                    HtmlUtil.writeButtonDynamicRootInfo(out, baseMenuItem);
                }
                if (!anchorNeeded) {
                    HtmlUtil.writeCustomAttributes(out, baseMenuItem.getCustomAttributes());
                }
            } else if (baseMenuItem instanceof MenuItem || baseMenuItem instanceof SelectorMenuItem) {
                baseMenuItem.setOnMouseOver(baseMenuItem.getOnMouseOver() + ";sas_MenuBar_highlightMenuItem(this);");
                HtmlUtil.writeOnAttributes(out, baseMenuItem);
            }
            out.print(">\n");
            HtmlUtil.writeCenterButtonText(out, baseMenuItem, baseMenuItem.getId(), 4, url, anchorNeeded);
            out.print("\n  </td>");
            if (baseMenuItem.submenu) {
                out.print("   <td  class=\"");
                out.print(menuItemStyleClass);
                out.print("\">");
                if (baseMenuItem.getMenu().getSubMenuImage() != null) {
                    out.print("<img src=\"");
                    out.print(baseMenuItem.getMenu().getSubMenuImage());
                    out.print("\" alt=\"\"></img>\n");
                } else {
                    HttpServletRequest request = baseMenuItem.getMenu().getRequest();
                    if (request != null) {
                        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
                        out.print("<img style=\"margin-left:8px;\" src=\"");
                        out.print(cpm.getImageURI("Menu_Right_Arrow"));
                        out.print("\" alt=\"\"></img>\n");
                    } else {
                        out.print("<span class=\"");
                        out.print(baseMenuItem.getStyleClassPrefix());
                        out.print(HtmlUtilMenu.getStyleClassId(styleMap, "MENU_ITEM_ARROW"));
                        out.print("\">&gt;</span>");
                    }
                }
                out.print("\n   </td>");
            }
            out.println();
        }
    }

    public static void writeTopLevelSpanStart(PrintWriter out, String styleClassPrefix, Map styleMap) {
        HtmlUtilMenu.writeTopLevelSpanStart(out, styleClassPrefix, styleMap, false);
    }

    public static void writeTopLevelSpanStart(PrintWriter out, String styleClassPrefix, Map styleMap, boolean wrap) {
        if (!wrap) {
            out.print("<span class=\"MenuBarActionContainer ");
        } else {
            out.print("<span class=\"");
        }
        HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
        out.print(HtmlUtilMenu.getStyleClassId(styleMap, "MENUBAR"));
        out.println("\">");
    }

    public static void writeTopLevelTableStart(PrintWriter out, String styleClassPrefix, Map styleMap, boolean wrap) {
        if (!wrap) {
            out.print("<table class=\"MenuBarActionContainer ");
        } else {
            out.print("<table class=\"");
        }
        HtmlUtil.writeStyleClassPrefix(out, styleClassPrefix);
        out.print(HtmlUtilMenu.getStyleClassId(styleMap, "MENUBAR"));
        out.println("\"><tr style=\"vertical-align:top\">");
    }

    public static String getDependentStyleClass(Map styleMap, String url, boolean enabled, boolean isMenu) {
        String classId = null;
        classId = !enabled ? (url == null ? HtmlUtilMenu.getStyleClassId(styleMap, isMenu ? "MENU_DISABLED" : "MENU_ITEM_DISABLED") : HtmlUtilMenu.getStyleClassId(styleMap, isMenu ? "MENU_LINK_DISABLED" : "MENU_ITEM_LINK_DISABLED")) : (url == null || url.equals("javascript: void 0;") ? HtmlUtilMenu.getStyleClassId(styleMap, isMenu ? "MENU" : "MENU_ITEM") : HtmlUtilMenu.getStyleClassId(styleMap, isMenu ? "MENU_LINK" : "MENU_ITEM_LINK"));
        return classId;
    }

    public static String getStyleClassId(Map styleMap, String styleKey) {
        StyleInfo styleInfo = null;
        if (styleMap != null) {
            styleInfo = (StyleInfo)styleMap.get(styleKey);
        }
        return styleInfo != null ? styleInfo.getClassid() : ((StyleInfo)defaultStyleMap.get(styleKey)).getClassid();
    }

    static {
        defaultStyleMap.put("MENUBAR", new ImmutableStyleInfo("menuBar"));
        defaultStyleMap.put("MENU", new ImmutableStyleInfo("menu"));
        defaultStyleMap.put("MENU_DISABLED", new ImmutableStyleInfo("menuDisabled"));
        defaultStyleMap.put("MENU_LINK", new ImmutableStyleInfo("menuLink"));
        defaultStyleMap.put("MENU_LINK_DISABLED", new ImmutableStyleInfo("menuLinkDisabled"));
        defaultStyleMap.put("MENU_DIVIDER", new ImmutableStyleInfo("menuDivider"));
        defaultStyleMap.put("MENU_ITEM", new ImmutableStyleInfo("menuItem"));
        defaultStyleMap.put("MENU_ITEM_DISABLED", new ImmutableStyleInfo("menuItemDisabled"));
        defaultStyleMap.put("MENU_ITEM_LINK", new ImmutableStyleInfo("menuItemLink"));
        defaultStyleMap.put("MENU_ITEM_LINK_DISABLED", new ImmutableStyleInfo("menuItemLinkDisabled"));
        defaultStyleMap.put("MENU_ITEM_CONTAINER", new ImmutableStyleInfo("menuItemContainer"));
        defaultStyleMap.put("MENU_ITEM_DIVIDER", new ImmutableStyleInfo("menuItemDivider"));
        defaultStyleMap.put("MENU_ITEM_ARROW", new ImmutableStyleInfo("menuItemArrow"));
    }
}

