/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.menubar.BaseMenu;
import com.sas.servlet.tbeans.menubar.BaseMenuBar;
import com.sas.servlet.tbeans.menubar.BaseMenuItem;
import com.sas.servlet.tbeans.menubar.html.HtmlUtilMenu;
import com.sas.servlet.tbeans.menubar.html.Menu;
import com.sas.servlet.tbeans.menubar.html.MenuBarStyleAreaKeysInterface;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public abstract class BaseHTMLMenuBar
extends BaseMenuBar
implements MenuBarStyleAreaKeysInterface,
ComplexStyleInterface {
    public static final String DEFAULT_LOOK = "Default";
    public static final String BANNER_GLOBALMENU_LOOK = "BannerGlobalMenu";
    private String look = "Default";
    @SASScope
    protected int lastTabIndex;
    private boolean useSpan;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo MenuBarContainerStyle = new ImmutableStyleInfo("menuBar");
    private static final ImmutableStyleInfo MenuStyle = new ImmutableStyleInfo("menu");
    private static final ImmutableStyleInfo MenuDisabledStyle = new ImmutableStyleInfo("menuDisabled");
    private static final ImmutableStyleInfo MenuLinkStyle = new ImmutableStyleInfo("menuLink");
    private static final ImmutableStyleInfo MenuLinkDisabledStyle = new ImmutableStyleInfo("menuLinkDisabled");
    private static final ImmutableStyleInfo MenuDividerStyle = new ImmutableStyleInfo("menuDivider");
    private static final ImmutableStyleInfo MenuItemStyle = new ImmutableStyleInfo("menuItem");
    private static final ImmutableStyleInfo MenuItemDisabledStyle = new ImmutableStyleInfo("menuItemDisabled");
    private static final ImmutableStyleInfo MenuItemLinkStyle = new ImmutableStyleInfo("menuItemLink");
    private static final ImmutableStyleInfo MenuItemLinkDisabledStyle = new ImmutableStyleInfo("menuItemLinkDisabled");
    private static final ImmutableStyleInfo MenuItemContainerStyle = new ImmutableStyleInfo("menuItemContainer");
    private static final ImmutableStyleInfo MenuItemDividerStyle = new ImmutableStyleInfo("menuItemDivider");
    private static final ImmutableStyleInfo MenuItemArrowStyle = new ImmutableStyleInfo("menuItemArrow");
    private Map componentStyleMap;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("MENUBAR", MenuBarContainerStyle);
            defaultStyleMap.put("MENU", MenuStyle);
            defaultStyleMap.put("MENU_DISABLED", MenuDisabledStyle);
            defaultStyleMap.put("MENU_LINK", MenuLinkStyle);
            defaultStyleMap.put("MENU_LINK_DISABLED", MenuLinkDisabledStyle);
            defaultStyleMap.put("MENU_DIVIDER", MenuDividerStyle);
            defaultStyleMap.put("MENU_ITEM", MenuItemStyle);
            defaultStyleMap.put("MENU_ITEM_DISABLED", MenuItemDisabledStyle);
            defaultStyleMap.put("MENU_ITEM_LINK", MenuItemLinkStyle);
            defaultStyleMap.put("MENU_ITEM_LINK_DISABLED", MenuItemLinkDisabledStyle);
            defaultStyleMap.put("MENU_ITEM_CONTAINER", MenuItemContainerStyle);
            defaultStyleMap.put("MENU_ITEM_DIVIDER", MenuItemDividerStyle);
            defaultStyleMap.put("MENU_ITEM_ARROW", MenuItemArrowStyle);
        }
    }

    public BaseHTMLMenuBar() {
        this.setId(Util.getName((String)"mb"));
        BaseHTMLMenuBar.setupDefaultStyleMap();
        this.componentStyleMap = new MapWithDefaults((Map)defaultStyleMap);
        this.setBorderWidth(0);
        this.setCellSpacing(0);
        this.setCellPadding(0);
        this.setWidthPercentage(0);
        this.setHeightPercentage(0);
        this.setWidth(0);
        this.setHeight(0);
        this.setSeparator("");
        this.setHorizontalOrientation(true);
        this.setStyleClassPrefix("");
        this.setFirstTabIndex(0);
        this.menuCounter = 1;
        this.setUseSpan(false);
    }

    @SASScope
    public boolean isUseSpan() {
        return this.useSpan;
    }

    @SASScope
    public void setUseSpan(boolean value) {
        this.useSpan = value;
    }

    @SASScope
    protected void writeHeader(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "MENUBAR", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        if (this.isUseSpan() && this.getHorizontalOrientation()) {
            HtmlUtilMenu.writeTopLevelSpanStart(out, this.getStyleClassPrefix(), this.getStyleMap());
        } else {
            out.print("<table id=\"");
            out.print(this.getId());
            out.print("\" border=\"");
            out.print(this.getBorderWidth());
            if (this.getWidth() > 0) {
                out.print("\" width=\"");
                out.print(this.getWidth());
            }
            if (this.getWidthPercentage() > 0) {
                out.print("\" width=\"");
                out.print(this.getWidthPercentage());
                out.print("%");
            }
            if (this.getHeight() > 0) {
                out.print("\" height=\"");
                out.print(this.getHeight());
            }
            if (this.getHeightPercentage() > 0) {
                out.print("\" height=\"");
                out.print(this.getHeightPercentage());
                out.print("%");
            }
            out.print("\" cellspacing=\"");
            out.print(this.getCellSpacing());
            out.print("\" cellpadding=\"");
            out.print(this.getCellPadding());
            out.print("\"");
            out.print(" class=\"");
            out.print(this.getStyleClassPrefix());
            out.print(this.getStyle("MENUBAR").getClassid());
            out.print("\"");
            out.println("><tr>");
        }
    }

    @SASScope
    protected void writeFooter(PrintWriter out) {
        if (this.isUseSpan() && this.getHorizontalOrientation()) {
            out.println("</span>");
        } else {
            out.println("</tr></table>");
        }
    }

    @SASScope
    protected void writeMenu(PrintWriter out) throws IOException {
        this.setDefaultMenuType();
        int i = 1;
        int currentCount = this.getFirstTabIndex();
        ArrayList menus = this.getMenus();
        for (int j = 0; j < menus.size(); ++j) {
            boolean menuSeparator = false;
            Menu menu = (Menu)menus.get(j);
            if (this.getLook().equalsIgnoreCase(BANNER_GLOBALMENU_LOOK)) {
                menu.setPopupMenuIndicatorImageKey("Menu_Down_Arrow_Banner");
            }
            menu.setRequest(this.getRequest());
            menu.setResponse(this.getResponse());
            menu.setLocale(this.getLocale());
            if (menu.getTarget() == null) {
                menu.setTarget(this.getTarget());
            }
            if (menu.getStyleClassPrefix() == null || menu.getStyleClassPrefix().length() < 1) {
                menu.setStyleClassPrefix(this.getStyleClassPrefix());
            }
            if (menu.isDivider()) {
                menuSeparator = true;
            }
            if (i > 1) {
                String separatorString = menuSeparator && menu.getCustomAttributes() != null ? menu.getCustomAttributes() : (menuSeparator ? "&#160;" : (this.getSeparatorImage() != null ? "<img src='" + this.getSeparatorImage() + "' alt=\"\"></img>" : this.getSeparator()));
                if (menuSeparator || this.getSeparator() != null && this.getSeparator().length() > 0 || this.getSeparatorImage() != null) {
                    if (!this.getHorizontalOrientation()) {
                        out.println("<tr>");
                    }
                    if (this.isUseSpan() && this.getHorizontalOrientation()) {
                        HtmlUtilMenu.writeSpanDivider(out, this.getStyleClassPrefix(), this.getStyleMap(), separatorString);
                    } else {
                        HtmlUtilMenu.writeTDDivider(out, this.getStyleClassPrefix(), this.getStyleMap(), separatorString);
                    }
                    if (!this.getHorizontalOrientation()) {
                        out.println("</tr>");
                    }
                }
            }
            if (!menuSeparator) {
                if (menu.getTemplate() == null && this.getTemplate() != null) {
                    menu.setTemplate(this.getTemplate());
                }
                if (menu.getTemplateFileName() == null && this.getTemplateFileName() != null) {
                    menu.setTemplateFileName(this.getTemplateFileName());
                } else if (menu.getTemplateKey() == null && this.getTemplateKey() != null) {
                    menu.setTemplateKey(this.getTemplateKey());
                }
                if (menu.getTemplateDictionary() == null && this.getTemplateDictionary() != null) {
                    menu.setTemplateDictionary(this.getTemplateDictionary());
                }
                menu.setMenuBar(this);
                if (!this.getHorizontalOrientation() && i > 1) {
                    out.println("<tr>");
                }
                if (currentCount > 0) {
                    menu.setTabIndex(currentCount);
                    ++currentCount;
                    int next = this.getFirstTabIndex();
                    if (menus.size() > j + 1) {
                        Menu nextMenu = (Menu)menus.get(j + 1);
                        next = Integer.parseInt(nextMenu.getId());
                    }
                    int prev = 0;
                    if (menus.size() > j - 1 && j > 0) {
                        Menu prevMenu = (Menu)menus.get(j - 1);
                        prev = Integer.parseInt(prevMenu.getId());
                    }
                    menu.nextTabIndex = next;
                    menu.previousTabIndex = prev;
                }
                menu.write(out);
                if (!this.getHorizontalOrientation() && menus.size() > i) {
                    out.println("</tr>");
                }
            }
            ++i;
        }
    }

    @SASScope
    protected void writeMenuItems(PrintWriter out) throws IOException {
        ArrayList menus = this.getMenus();
        for (int j = 0; j < menus.size(); ++j) {
            Menu menu = (Menu)menus.get(j);
            if (menu.getMenuType() != 5 && menu.getMenuType() != 1 || !menu.isEnabled()) continue;
            menu.setRequest(this.getRequest());
            menu.writeDropdown(out);
        }
    }

    @SASScope
    protected void setMenuItemsId(BaseMenu menuItem) {
        int numMenuItems = menuItem.count();
        if (numMenuItems > 0) {
            BaseMenuItem nextMenu = null;
            int menuItemNumber = 0;
            ArrayList menuItems = menuItem.getMenuItems();
            for (int i = 0; i < numMenuItems; ++i) {
                BaseMenuItem mitem = (BaseMenuItem)menuItems.get(i);
                if (!mitem.isDivider()) {
                    ++menuItemNumber;
                    if (mitem.getId() == null || mitem.getId().length() == 0) {
                        mitem.setId(menuItem.getId() + "_" + "mi" + menuItemNumber);
                        ++this.menuCounter;
                    }
                    if (i == 0) {
                        nextMenu = mitem;
                    }
                    mitem.setPreviousMenu(menuItem);
                    mitem.setNextMenu(menuItem.getNextMenu());
                    mitem.setPreviousMenuItem(this.getPreviousValidMenuItem(menuItems, i - 1, 0));
                    mitem.setNextMenuItem(this.getNextValidMenuItem(menuItems, i + 1, numMenuItems));
                }
                if (!(mitem instanceof BaseMenu)) continue;
                BaseMenu menu = (BaseMenu)mitem;
                menu.setMenuBar(this);
                this.setMenuItemsId(menu);
            }
            menuItem.setNextMenu(nextMenu);
        }
    }

    @SASScope
    protected void assignId() {
        ArrayList menus = this.getMenus();
        if (menus == null) {
            return;
        }
        int numMenus = menus.size();
        if (numMenus > 0) {
            int menuNumber = 0;
            for (int i = 0; i < numMenus; ++i) {
                Menu menu = (Menu)menus.get(i);
                if (menu.isDivider()) continue;
                ++menuNumber;
                if (menu.getId() == null || menu.getId().length() == 0) {
                    menu.setId(this.getId() + "_" + "m" + menuNumber);
                    ++this.menuCounter;
                }
                if (i == 0) {
                    menu.setPreviousMenu((Menu)menus.get(numMenus - 1));
                } else {
                    menu.setPreviousMenu((Menu)menus.get(i - 1));
                }
                if (i == numMenus - 1) {
                    menu.setNextMenu((Menu)menus.get(0));
                } else {
                    menu.setNextMenu((Menu)menus.get(i + 1));
                }
                BaseMenuItem menuNextMenuItem = null;
                BaseMenuItem menuPreviousMenuItem = null;
                ArrayList menuItems = menu.getMenuItems();
                if (menuItems != null && menuItems.size() > 0) {
                    int menuItemNumber = 0;
                    int numMenuItems = menuItems.size();
                    for (int j = 0; j < numMenuItems; ++j) {
                        if (!(menuItems.get(j) instanceof BaseMenuItem)) continue;
                        BaseMenuItem menuItem = (BaseMenuItem)menuItems.get(j);
                        menuItem.setRequest(this.getRequest());
                        menuItem.setResponse(this.getResponse());
                        menuItem.setLocale(this.getLocale());
                        if (!menuItem.isDivider()) {
                            ++menuItemNumber;
                            if (menuItem.getId() == null || menuItem.getId().length() == 0) {
                                menuItem.setId(menu.getId() + "_" + "mi" + menuItemNumber);
                                ++this.menuCounter;
                            }
                            menuItem.setPreviousMenu(menu.getPreviousMenu());
                            menuItem.setNextMenu(menu.getNextMenu());
                            menuItem.setPreviousMenuItem(this.getPreviousValidMenuItem(menuItems, j - 1, 0));
                            menuItem.setNextMenuItem(this.getNextValidMenuItem(menuItems, j + 1, numMenuItems));
                            if (menuNextMenuItem == null) {
                                menuNextMenuItem = menuItem;
                            }
                            menuPreviousMenuItem = menuItem;
                        }
                        if (!(menuItem instanceof BaseMenu)) continue;
                        BaseMenu tempmenu = (BaseMenu)menuItem;
                        tempmenu.setMenuBar(this);
                        this.setMenuItemsId(tempmenu);
                    }
                }
                menu.setNextMenuItem(menuNextMenuItem);
                menu.setPreviousMenuItem(menuPreviousMenuItem);
            }
        }
    }

    public void addSeparator() {
        Menu _menu = null;
        _menu = new Menu();
        ArrayList<Menu> menus = this.getMenus();
        if (menus == null) {
            menus = new ArrayList<Menu>();
        }
        menus.add(_menu);
    }

    public void addSeparator(String separator) {
        Menu _menu = null;
        _menu = new Menu();
        _menu.setCustomAttributes(separator);
        ArrayList<Menu> menus = this.getMenus();
        if (menus == null) {
            menus = new ArrayList<Menu>();
        }
        menus.add(_menu);
    }

    @SASScope
    protected void setDefaultMenuType() {
        ArrayList menus = this.getMenus();
        if (this.getMenuType() == 4 || this.getMenuType() == 3 || menus == null) {
            return;
        }
        for (int i = 0; i < menus.size(); ++i) {
            Menu menu = (Menu)menus.get(i);
            if (menu.count() <= 0) continue;
            if (this.getMenuType() != 5 && this.getMenuType() != 1) {
                this.setMenuType(1);
                return;
            }
            return;
        }
        this.setMenuType(2);
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    public void setStyleMap(Map styleMap) {
        this.componentStyleMap = styleMap;
    }

    private StyleInfo getStyle(String value) {
        Map defaultMap = this.getStyleMap();
        if (defaultMap.get(value) != null) {
            return (StyleInfo)defaultMap.get(value);
        }
        return (StyleInfo)defaultStyleMap.get(value);
    }

    private BaseMenuItem getNextValidMenuItem(ArrayList menuItems, int beginIndex, int endIndex) {
        BaseMenuItem returnMenuItem = null;
        for (int i = beginIndex; i < endIndex; ++i) {
            BaseMenuItem mi;
            Object item = menuItems.get(i);
            if (!(item instanceof BaseMenuItem) || (mi = (BaseMenuItem)item).isDivider()) continue;
            returnMenuItem = mi;
            break;
        }
        if (returnMenuItem == null && beginIndex != 0) {
            return this.getNextValidMenuItem(menuItems, 0, beginIndex);
        }
        return returnMenuItem;
    }

    private BaseMenuItem getPreviousValidMenuItem(ArrayList menuItems, int beginIndex, int endIndex) {
        BaseMenuItem returnMenuItem = null;
        for (int i = beginIndex; i >= endIndex; --i) {
            BaseMenuItem mi;
            Object item = menuItems.get(i);
            if (!(item instanceof BaseMenuItem) || (mi = (BaseMenuItem)item).isDivider()) continue;
            returnMenuItem = mi;
            break;
        }
        if (returnMenuItem == null && beginIndex != menuItems.size() - 1) {
            return this.getPreviousValidMenuItem(menuItems, menuItems.size() - 1, beginIndex + 1);
        }
        return returnMenuItem;
    }

    @SASScope
    public String getLook() {
        return this.look;
    }

    @SASScope
    public void setLook(String look) {
        this.look = look;
        if (look.equalsIgnoreCase(BANNER_GLOBALMENU_LOOK)) {
            this.setSeparator("|");
            this.setMenuType(5);
            this.getStyleMap().put("MENU_LINK", new StyleInfo("bannerGlobalMenuLink", MenuLinkStyle.getStyle()));
            this.getStyleMap().put("MENU", new StyleInfo("bannerGlobalMenu", MenuStyle.getStyle()));
            this.getStyleMap().put("MENU_DIVIDER", new StyleInfo("bannerGlobalMenuDivider", MenuDividerStyle.getStyle()));
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(BaseHTMLMenuBar.class, "MENUBAR");
    }
}

