/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.TemplateInterface;
import com.sas.servlet.tbeans.TemplateKeyInterface;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.menubar.BaseMenu;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.util.Strings;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;

@SASScope(value="ALL")
public abstract class BaseMenuItem
extends BaseButton
implements TemplateInterface,
TemplateKeyInterface {
    private BaseMenu menu;
    private String template;
    private boolean selected;
    private HashMap templateDictionary;
    private String templateFileName;
    private String templateLocation;
    private boolean defaultURLSuppressed;
    private BaseMenuItem nextMenu;
    private BaseMenuItem previousMenu;
    private BaseMenuItem nextMenuItem;
    private BaseMenuItem previousMenuItem;
    private String templateKey;
    public boolean submenu;

    @SASScope
    public void setMenu(BaseMenu menu) {
        this.menu = menu;
    }

    public BaseMenu getMenu() {
        return this.menu;
    }

    @SASScope
    protected String getMenuBarName() {
        if (this.getMenu() != null && this.getMenu().getMenuBar() != null) {
            return this.getMenu().getMenuBar().getId();
        }
        return this.getId();
    }

    @SASScope
    protected BaseButton setButtonProperties(BaseButton button) {
        button.setId(this.getId());
        button.setImageLocation(this.getImageLocation());
        button.setEnabled(this.isEnabled());
        button.setTarget(this.getTarget());
        button.setAccessKey(this.getAccessKey());
        button.setWrap(this.isWrapped());
        button.setOnClick(this.getOnClick());
        button.setOnKeyDown(this.getOnKeyDown());
        button.setOnKeyPress(this.getOnKeyPress());
        button.setOnKeyUp(this.getOnKeyUp());
        button.setOnMouseOut(this.getOnMouseOut());
        button.setOnMouseOver(this.getOnMouseOver());
        button.setOnMouseDown(this.getOnMouseDown());
        button.setOnMouseUp(this.getOnMouseUp());
        button.setTitle(this.getTitle());
        button.setAccessKey(this.getAccessKey());
        button.setLeftImage(this.getLeftImage());
        button.setRightImage(this.getRightImage());
        button.getImageKeyConfig().setLeftImageKey(this.getImageKeyConfig().getLeftImageKey());
        button.getImageKeyConfig().setRightImageKey(this.getImageKeyConfig().getRightImageKey());
        button.setBottomImage(this.getBottomImage());
        button.setBottomRightImage(this.getBottomRightImage());
        button.setBottomLeftImage(this.getBottomLeftImage());
        button.getImageKeyConfig().setBottomImageKey(this.getImageKeyConfig().getBottomImageKey());
        button.getImageKeyConfig().setBottomRightImageKey(this.getImageKeyConfig().getBottomRightImageKey());
        button.getImageKeyConfig().setBottomLeftImageKey(this.getImageKeyConfig().getBottomLeftImageKey());
        button.setTopImage(this.getTopImage());
        button.setTopLeftImage(this.getTopLeftImage());
        button.setTopRightImage(this.getTopRightImage());
        button.getImageKeyConfig().setTopImageKey(this.getImageKeyConfig().getTopImageKey());
        button.getImageKeyConfig().setTopLeftImageKey(this.getImageKeyConfig().getTopLeftImageKey());
        button.getImageKeyConfig().setTopRightImageKey(this.getImageKeyConfig().getTopRightImageKey());
        button.setCustomAttributes(this.getCustomAttributes());
        button.setHeight(this.getHeight());
        button.setHeightPercentage(this.getHeightPercentage());
        button.setWidth(this.getWidth());
        button.setWidthPercentage(this.getWidthPercentage());
        button.setImagePosition(this.getImagePosition());
        button.setTabIndex(this.getTabIndex());
        button.setAlternateText(this.getAlternateText());
        button.setDisabledAlternateText(this.getDisabledAlternateText());
        button.setDisabledImage(this.getDisabledImage());
        button.setDisabledImageKey(this.getDisabledImageKey());
        button.setRolloverImage(this.getRolloverImage());
        button.setRolloverImageKey(this.getRolloverImageKey());
        button.setVerifyEnabled(false);
        return button;
    }

    @Override
    public String getDefaultTemplate() {
        return null;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public void setTemplate(File file) {
        this.setTemplate(TemplateSupport.getStringValue(file));
    }

    public void setTemplate(InputStreamReader isr) {
        this.setTemplate(TemplateSupport.getStringValue(isr));
    }

    @Override
    public void setTemplateLocation(String location2) {
        this.templateLocation = location2;
    }

    @Override
    public String getTemplateLocation() {
        if (this.templateLocation != null) {
            return this.templateLocation;
        }
        return ComponentPropertyManager.getInstance(this.getRequest()).getTemplateLocation();
    }

    @Override
    public void setTemplateFileName(String file) {
        this.templateFileName = file;
    }

    @Override
    public String getTemplateFileName() {
        return this.templateFileName;
    }

    @Override
    @SASScope
    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }

    @Override
    @SASScope
    public String getTemplateKey() {
        return this.templateKey;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public HashMap getTemplateDictionary() {
        return this.templateDictionary;
    }

    @Override
    public void setTemplateDictionary(HashMap dictionary) {
        this.templateDictionary = dictionary;
    }

    @SASScope
    protected String replaceQuotes(String value) {
        if (value != null) {
            char[] quote1 = new char[]{'\"'};
            String[] quote2 = new String[]{"&quot;"};
            return Strings.replace((String)value, (char[])quote1, (String[])quote2);
        }
        return null;
    }

    public boolean isDivider() {
        return this.getLabel() == null && this.getImage() == null && this.getImageKey() == null;
    }

    @SASScope
    protected boolean isSimpleMenu() {
        if (this.getLeftImage() != null || this.getRightImage() != null || this.getTopImage() != null || this.getBottomImage() != null || this.getTopRightImage() != null || this.getTopLeftImage() != null || this.getBottomLeftImage() != null || this.getBottomRightImage() != null) {
            return false;
        }
        return this.getImageKeyConfig().getLeftImageKey() == null && this.getImageKeyConfig().getRightImageKey() == null && this.getImageKeyConfig().getTopImageKey() == null && this.getImageKeyConfig().getBottomImageKey() == null && this.getImageKeyConfig().getTopRightImageKey() == null && this.getImageKeyConfig().getTopLeftImageKey() == null && this.getImageKeyConfig().getBottomLeftImageKey() == null && this.getImageKeyConfig().getBottomRightImageKey() == null;
    }

    @SASScope
    protected String getCurrentURL() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getURL();
    }

    @SASScope
    public boolean isDefaultURLSuppressed() {
        return this.defaultURLSuppressed;
    }

    @SASScope
    public void setDefaultURLSuppressed(boolean value) {
        this.defaultURLSuppressed = value;
    }

    public BaseMenuItem getNextMenu() {
        return this.nextMenu;
    }

    public void setNextMenu(BaseMenuItem nextMenuId) {
        this.nextMenu = nextMenuId;
    }

    public BaseMenuItem getNextMenuItem() {
        return this.nextMenuItem;
    }

    public void setNextMenuItem(BaseMenuItem nextMenuItemId) {
        this.nextMenuItem = nextMenuItemId;
    }

    public BaseMenuItem getPreviousMenu() {
        return this.previousMenu;
    }

    public void setPreviousMenu(BaseMenuItem previousMenuId) {
        this.previousMenu = previousMenuId;
    }

    public BaseMenuItem getPreviousMenuItem() {
        return this.previousMenuItem;
    }

    public void setPreviousMenuItem(BaseMenuItem previousMenuItemId) {
        this.previousMenuItem = previousMenuItemId;
    }
}

