/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.menubar.BaseMenuBar;
import com.sas.servlet.tbeans.menubar.BaseMenuItem;
import com.sas.servlet.tbeans.menubar.BaseSelectorMenuItem;
import java.util.ArrayList;

@SASScope(value="ALL")
public abstract class BaseMenu
extends BaseMenuItem {
    private String dividerImage;
    private BaseMenu menu;
    private BaseMenuBar menubar;
    private ArrayList menuItems;
    private int menuType;
    private BaseSelectorMenuItem selectorItem;
    private String subMenuImage;
    public int nextTabIndex;
    public int previousTabIndex;

    public void add(BaseMenu submenu) {
        this.menu = submenu;
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        submenu.setMenu(this);
        this.menuItems.add(submenu);
    }

    public void add(BaseMenuItem menuItem) {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        menuItem.setMenu(this);
        this.menuItems.add(menuItem);
    }

    public void addSeparator() {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        this.menuItems.add(new ArrayList());
    }

    public int count() {
        if (this.menuItems == null) {
            return 0;
        }
        return this.menuItems.size();
    }

    @Override
    @SASScope
    protected String getCurrentURL() {
        if (!this.isEnabled() || !this.isDefaultURLSuppressed() && this.getMenuType() == 4) {
            return null;
        }
        if (this.getURL() == null && this.count() > 0) {
            return "javascript: void(0)";
        }
        return this.getURL();
    }

    @SASScope
    protected int getDefaultMenuType() {
        if (this.getMenuBar() != null) {
            return this.getMenuBar().getMenuType();
        }
        return 1;
    }

    public String getDividerImage() {
        return this.dividerImage;
    }

    public BaseMenuBar getMenuBar() {
        return this.menubar;
    }

    @Override
    @SASScope
    protected String getMenuBarName() {
        if (this.getMenuBar() != null) {
            return this.getMenuBar().getName();
        }
        return this.getName();
    }

    public ArrayList getMenuItems() {
        return this.menuItems;
    }

    public int getMenuType() {
        if (this.menuType < 1) {
            return this.getDefaultMenuType();
        }
        return this.menuType;
    }

    public BaseSelectorMenuItem getSelectorMenuItem() {
        return this.selectorItem;
    }

    public String getSubMenuImage() {
        return this.subMenuImage;
    }

    public boolean hasSubMenus() {
        ArrayList menuItems = this.getMenuItems();
        for (int i = 0; i < menuItems.size(); ++i) {
            if (!(menuItems.get(i) instanceof BaseMenu)) continue;
            return true;
        }
        return false;
    }

    public void setDividerImage(String image) {
        this.dividerImage = image;
    }

    @SASScope
    public void setMenuBar(BaseMenuBar value) {
        this.menubar = value;
    }

    public void setMenuType(int type) {
        this.menuType = type;
    }

    public void setSelectorMenuItem(BaseSelectorMenuItem menuItem) {
        menuItem.setMenu(this);
        this.selectorItem = menuItem;
    }

    public void setSubMenuImage(String image) {
        this.subMenuImage = image;
    }
}

