/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.itemlistmanager;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.models.itemlistmanager.DeleteRowInterface;
import com.sas.models.itemlistmanager.DeleteRowsInterface;
import com.sas.models.itemlistmanager.InsertRowInterface;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.models.itemlistmanager.MoveRowInterface;
import com.sas.servlet.tbeans.AJAXControllerURLInterface;
import com.sas.servlet.tbeans.BaseActionTransformation2;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseCompositeTransformation2;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Image;
import com.sas.servlet.tbeans.itemlistmanager.AbstractItemListManagerKeysInterface;
import com.sas.servlet.tbeans.itemlistmanager.ItemListManagerStyleKeysInterface;
import com.sas.servlet.tbeans.itemlistmanager.ItemListManagerTableView;
import com.sas.servlet.tbeans.itemlistmanager.RB;
import com.sas.servlet.tbeans.navigationbar.BaseNavigationBar;
import com.sas.servlet.tbeans.navigationbar.html.TableColumnNavigationBar;
import com.sas.servlet.tbeans.navigationbar.html.TableRowNavigationBar;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.TableCellEditor;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.ajax.AJAXTableController;
import com.sas.servlet.tbeans.tableview.html.CellContentsNoRowsRenderer;
import com.sas.servlet.tbeans.tableview.html.NonEditableTableCellEditor;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.Dimension;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public abstract class AbstractItemListManager
extends BaseCompositeTransformation2
implements AbstractItemListManagerKeysInterface,
ItemListManagerStyleKeysInterface,
ItemListManagerViewerInterface,
AJAXControllerURLInterface {
    public static final String RB_KEY = "AbstractItemListManager.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "AbstractItemListManager.html";
    private static final ImmutableStyleInfo ItemListManagerContainerStyle = new ImmutableStyleInfo("itemListManagerContainer");
    private static final ImmutableStyleInfo ItemListManagerTableContainerStyle = new ImmutableStyleInfo("itemListManagerTableContainer");
    private static final ImmutableStyleInfo ItemListManagerVerticalButtonContainerStyle = new ImmutableStyleInfo("itemListManagerVerticalButtonContainer");
    private static final ImmutableStyleInfo ItemListManagerHorizontalButtonContainerStyle = new ImmutableStyleInfo("itemListManagerHorizontalButtonContainer");
    private static final ImmutableStyleInfo ItemListManagerNavBarStyle = new ImmutableStyleInfo("tableToolBar");
    public static final String ITEMLISTMANAGER_ID = "ITEMLISTMANAGER_ID";
    public static final String VERTICAL_BUTTONS = "VERTICAL_BUTTONS";
    public static final String HORIZONTAL_BUTTONS = "HORIZONTAL_BUTTONS";
    public static final TableCellEditor NON_EDITABLE_CELL_EDITOR = new NonEditableTableCellEditor();
    protected String imageLocation;
    private static final String DEFAULT_REMOTE_SCRIPT_URL = "/MethodInvocationServlet";
    protected ItemListManagerTableView tableView;
    protected BaseButton addButton;
    protected BaseButton deleteButton;
    protected BaseButton moveUpButton;
    protected BaseButton moveDownButton;
    protected List buttonsVertical;
    protected List buttonsHorizontal;
    protected AJAXTableController controller;
    protected TableModelListener tableModelListener;
    private List hiddenColumns;
    private static HashMap defaultStyleMap;
    private MapWithDefaults componentStyleMap;
    protected Map buttonJSFunctionMap;
    private String rowSelectionListenerFunction;
    protected HashMap cellEditorMap;
    protected HashMap cellRendererMap;
    protected String defaultHorizontalDividerImage = null;
    protected String defaultVerticalDividerImage = null;
    protected String defaultHorizontalDividerImageKey = "Menu_Divider";
    protected String defaultVerticalDividerImageKey = "Menu_Divider_Horizontal";
    private int selectionMode;
    private String preCommitFunction;
    private String postCommitFunction;
    private String onUpdate;
    protected int maxValues;
    protected int minValues;
    protected boolean clientSideSelection;

    public AbstractItemListManager() {
        this.setId(Util.getName((String)"_ilm"));
        this.cellEditorMap = new HashMap();
        this.cellRendererMap = new HashMap();
        this.buttonsVertical = new ArrayList();
        this.buttonsHorizontal = new ArrayList();
        this.buttonJSFunctionMap = new HashMap();
        this.hiddenColumns = new ArrayList();
        this.selectionMode = 2;
        this.clientSideSelection = false;
        this.minValues = 0;
        this.maxValues = -1;
        this.setTemplateKey("Abstract_Item_List_Manager");
        this.componentStyleMap = new MapWithDefaults(AbstractItemListManager.getDefaultStyleMap());
        this.tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AbstractItemListManager.this.processTableChangedEvent(e);
            }
        };
        this.createComponents();
        this.setRowPageSize(-1);
        this.setColumnPageSize(-1);
        this.addPredefinedButtons();
    }

    protected void processTableChangedEvent(TableModelEvent e) {
        if (this.controller != null) {
            // empty if block
        }
    }

    protected void createComponents() {
        this.tableView = new ItemListManagerTableView();
        this.tableView.setLockColumnHeaders(true);
        this.tableView.setPartialRefreshActionsEnabled(true);
        this.tableView.setPartialRefreshProxy(this.tableView);
        ((CellContentsNoRowsRenderer)this.tableView.getNoRowsRenderer()).setText("");
        this.tableView.setCellEditorClassificationMap(this.cellEditorMap);
        this.tableView.setCellRendererClassificationMap(this.cellRendererMap);
        this.tableView.setId(this.getId() + "_ItemTable");
        this.tableView.getEditController().setEditEnabled(true);
        this.tableView.getEditController().setEditColumnVisible(false);
        this.tableView.getEditController().setEditRowVisible(false);
        this.tableView.setRowHeaderVisible(false);
        this.setComponent("ITEMLISTMANAGER_TABLE", this.tableView);
        this.setComponent("ITEMLISTMANAGER_COLUMN_NAVIGATIONBAR", this.getDefaultColumnNavigationBar());
        this.setComponent("ITEMLISTMANAGER_ROW_NAVIGATIONBAR", this.getDefaultRowNavigationBar());
        this.addButton = this.createBaseButton();
        this.addButton.setId(this.getId() + "_Add");
        this.deleteButton = this.createBaseButton();
        this.deleteButton.setId(this.getId() + "_Delete");
        this.moveUpButton = this.createBaseButton();
        this.moveUpButton.setId(this.getId() + "_Up");
        this.moveDownButton = this.createBaseButton();
        this.moveDownButton.setId(this.getId() + "_Down");
        this.setComponent("ITEMLISTMANAGER_ADD_BUTTON", this.addButton);
        this.setComponent("ITEMLISTMANAGER_DELETE_BUTTON", this.deleteButton);
        this.setComponent("ITEMLISTMANAGER_DOWN_BUTTON", this.moveDownButton);
        this.setComponent("ITEMLISTMANAGER_UP_BUTTON", this.moveUpButton);
    }

    protected BaseNavigationBar getDefaultColumnNavigationBar() {
        TransformationInterface table = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (table instanceof BaseTableView) {
            TableColumnNavigationBar cnb = new TableColumnNavigationBar((BaseTableView)table);
            cnb.setId(this.getId() + "_cnb");
            cnb.setPartialRefreshActionsEnabled(true);
            cnb.setPartialRefreshProxy(this);
            return cnb;
        }
        return null;
    }

    protected BaseNavigationBar getDefaultRowNavigationBar() {
        TransformationInterface table = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (table instanceof BaseTableView) {
            TableRowNavigationBar rnb = new TableRowNavigationBar((BaseTableView)table);
            rnb.setId(this.getId() + "_rnb");
            rnb.setPartialRefreshActionsEnabled(true);
            rnb.setPartialRefreshProxy(this);
            return rnb;
        }
        return null;
    }

    protected void addPredefinedButtons() {
        this.addButton(this.getPredefinedButton(BUTTON_ADD), 0, 0);
        this.addButton(this.getPredefinedButton(BUTTON_DELETE), 0, 1);
        this.addButton(this.getPredefinedButton(BUTTON_SPACER), 0, 2);
        this.addButton(this.getPredefinedButton(BUTTON_MOVE_UP), 0, 3);
        this.addButton(this.getPredefinedButton(BUTTON_MOVE_DOWN), 0, 4);
    }

    public abstract Object getModel();

    public String getImageLocation() {
        if (this.imageLocation != null) {
            return this.imageLocation;
        }
        return ComponentPropertyManager.getInstance(this.getRequest()).getImageLocation();
    }

    private static Map getDefaultStyleMap() {
        if (defaultStyleMap == null) {
            defaultStyleMap = new HashMap();
            StyleInfo itemListManagerNewButtonContainerStyle = new StyleInfo("ItemListManagerNewButtonContainer");
            StyleInfo itemListManagerDeleteButtonContainerStyle = new StyleInfo("ItemListManagerDeleteButtonContainer");
            StyleInfo itemListManagerUpButtonContainerStyle = new StyleInfo("ItemListManagerUpButtonContainer");
            StyleInfo itemListManagerDownButtonContainerStyle = new StyleInfo("ItemListManagerDownButtonContainer");
            defaultStyleMap.put("ITEMLISTMANAGER_CONTAINER", ItemListManagerContainerStyle);
            defaultStyleMap.put("ITEMLISTMANAGER_TABLE_CONTAINER", ItemListManagerTableContainerStyle);
            defaultStyleMap.put("ITEMLISTMANAGER_VERTICAL_BUTTON_CONTAINER", ItemListManagerVerticalButtonContainerStyle);
            defaultStyleMap.put("ITEMLISTMANAGER_HORIZONTAL_BUTTON_CONTAINER", ItemListManagerHorizontalButtonContainerStyle);
            defaultStyleMap.put("ITEMLISTMANAGER_NEW_BUTTON_CONTAINER", itemListManagerNewButtonContainerStyle);
            defaultStyleMap.put("ITEMLISTMANAGER_DELETE_BUTTON_CONTAINER", itemListManagerDeleteButtonContainerStyle);
            defaultStyleMap.put("ITEMLISTMANAGER_UP_BUTTON_CONTAINER", itemListManagerUpButtonContainerStyle);
            defaultStyleMap.put("ITEMLISTMANAGER_DOWN_BUTTON_CONTAINER", itemListManagerDownButtonContainerStyle);
            defaultStyleMap.put("ITEMLISTMANAGER_NAVBAR_STYLE", ItemListManagerNavBarStyle);
        }
        return defaultStyleMap;
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    public boolean isTableCellEditingEnabled() {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            return tableView.getEditController().isEditEnabled();
        }
        return false;
    }

    public void setTableCellEditingEnabled(boolean isCellEditEnabled) {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            tableView.getEditController().setEditEnabled(isCellEditEnabled);
        }
    }

    public TableCellEditor getCellEditor(String classification) {
        return (TableCellEditor)this.cellEditorMap.get(classification);
    }

    public void setCellEditor(String classification, TableCellEditor editor) {
        this.cellEditorMap.put(classification, editor);
    }

    public void setNonEditableCellEditor(String classification) {
        this.setCellEditor(classification, NON_EDITABLE_CELL_EDITOR);
    }

    public void setCellRenderer(String classification, TableCellRenderer renderer) {
        this.cellRendererMap.put(classification, renderer);
    }

    public TableCellRenderer getCellRenderer(String classification) {
        return (TableCellRenderer)this.cellRendererMap.get(classification);
    }

    public String getDefaultHorizontalDividerImage() {
        return this.defaultHorizontalDividerImage;
    }

    public void setDefaultHorizontalDividerImage(String image) {
        this.defaultHorizontalDividerImage = image;
    }

    public String getDefaultVerticalDividerImage() {
        return this.defaultVerticalDividerImage;
    }

    public void setDefaultVerticalDividerImage(String image) {
        this.defaultVerticalDividerImage = image;
    }

    public void addButton(Object button, int location2, int index) {
        if (button != null) {
            switch (location2) {
                case 0: {
                    if (BUTTON_SPACER.equals(button) && this.buttonsVertical.contains(button)) {
                        throw new IllegalArgumentException("Only one spacer button is allowed for a given location.");
                    }
                    this.buttonsVertical.add(index, button);
                    break;
                }
                case 1: {
                    if (BUTTON_SPACER.equals(button) && this.buttonsHorizontal.contains(button)) {
                        throw new IllegalArgumentException("Only one spacer button is allowed for a given location.");
                    }
                    this.buttonsHorizontal.add(index, button);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid location specified.");
                }
            }
        }
    }

    public void removeButton(Object button) {
        while (this.buttonsVertical.contains(button)) {
            this.buttonsVertical.remove(button);
        }
        while (this.buttonsHorizontal.contains(button)) {
            this.buttonsHorizontal.remove(button);
        }
    }

    public void removeButton(int index, int location2) {
        List buttonList = null;
        if (location2 == 0) {
            buttonList = this.buttonsVertical;
        } else if (location2 == 1) {
            buttonList = this.buttonsHorizontal;
        } else {
            throw new IllegalArgumentException("Invalid location specified for removing button");
        }
        int size = buttonList.size();
        if (size <= 0 || index < 0 || index >= size) {
            throw new IllegalArgumentException("Invalid index specified for removing button");
        }
        buttonList.remove(index);
    }

    public void removeAllButtons(int location2) {
        if (location2 == 0) {
            this.buttonsVertical.clear();
        } else if (location2 == 1) {
            this.buttonsHorizontal.clear();
        } else {
            throw new IllegalArgumentException("Invalid button location specified.");
        }
    }

    protected BaseButton createBaseButton() {
        Button button = new Button();
        button.setButtonType(3);
        button.setWrap(false);
        button.setWidthPercentage(100);
        return button;
    }

    public Object getPredefinedButton(Object button) {
        if (button == BUTTON_ADD) {
            return this.addButton;
        }
        if (button == BUTTON_DELETE) {
            return this.deleteButton;
        }
        if (button == BUTTON_MOVE_UP) {
            return this.moveUpButton;
        }
        if (button == BUTTON_MOVE_DOWN) {
            return this.moveDownButton;
        }
        if (button == BUTTON_SPACER || button == BUTTON_DIVIDER || button == BUTTON_EXPANDING_SPACER) {
            return button;
        }
        return null;
    }

    protected void setLocaleDependentProperties(Object predefinedButton, Locale locale) {
        Object obj = this.getPredefinedButton(predefinedButton);
        if (obj instanceof BaseButton) {
            BaseButton button = (BaseButton)obj;
            String label = this.getButtonLabel(predefinedButton, locale);
            String imageKey = null;
            String imageName = this.getButtonImage(predefinedButton, locale);
            if (imageName == null) {
                imageKey = this.getButtonImageKey(predefinedButton);
            }
            String disabledImageKey = null;
            String disabledImageName = this.getButtonDisabledImage(predefinedButton, locale);
            if (disabledImageName == null) {
                disabledImageKey = this.getButtonDisabledImageKey(predefinedButton);
            }
            String title = this.getButtonTitle(predefinedButton, locale);
            if (button.getImage() == null && button.getLabel() == null) {
                ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
                button.setLabel(label);
                if (imageName != null) {
                    button.setImage(this.getImageLocation() + imageName);
                } else if (imageKey != null) {
                    button.setImageKey(imageKey);
                    button.setImageLocation(this.imageLocation);
                }
                if (button.getDisabledImage() == null) {
                    if (disabledImageName != null) {
                        button.setDisabledImage(this.getImageLocation() + disabledImageName);
                    } else if (disabledImageKey != null) {
                        button.setDisabledImageKey(disabledImageKey);
                        button.setImageLocation(this.imageLocation);
                    }
                }
            }
            if (button.getTitle() == null && title != null) {
                button.setTitle(title);
            }
        }
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this.setLocaleDependentProperties(BUTTON_ADD, locale);
        this.setLocaleDependentProperties(BUTTON_DELETE, locale);
        this.setLocaleDependentProperties(BUTTON_MOVE_UP, locale);
        this.setLocaleDependentProperties(BUTTON_MOVE_DOWN, locale);
    }

    protected String getButtonLabel(Object button, Locale locale) {
        String label = null;
        if (button == BUTTON_ADD) {
            return RB.getStringResource(RB_KEY, "AddButtonLabel.txt", locale);
        }
        if (button == BUTTON_DELETE) {
            return RB.getStringResource(RB_KEY, "DeleteButtonLabel.txt", locale);
        }
        return label;
    }

    protected String getButtonImage(Object button, Locale locale) {
        return null;
    }

    protected String getButtonImageKey(Object button) {
        if (button == BUTTON_MOVE_UP) {
            return "Arrow_Up_Default";
        }
        if (button == BUTTON_MOVE_DOWN) {
            return "Arrow_Down_Default";
        }
        return null;
    }

    protected String getButtonDisabledImage(Object button, Locale locale) {
        return null;
    }

    protected String getButtonDisabledImageKey(Object button) {
        if (button == BUTTON_MOVE_UP) {
            return "Arrow_Up_Inactive";
        }
        if (button == BUTTON_MOVE_DOWN) {
            return "Arrow_Down_Inactive";
        }
        return null;
    }

    protected String getButtonTitle(Object button, Locale locale) {
        if (button == BUTTON_ADD) {
            return com.sas.swing.visuals.itemlistmanager.RB.getStringResource((String)"AbstractItemListManagerPanel.", (String)"addToolTip.txt", (Locale)locale);
        }
        if (button == BUTTON_DELETE) {
            return com.sas.swing.visuals.itemlistmanager.RB.getStringResource((String)"AbstractItemListManagerPanel.", (String)"deleteToolTip.txt", (Locale)locale);
        }
        if (button == BUTTON_MOVE_UP) {
            return com.sas.swing.visuals.itemlistmanager.RB.getStringResource((String)"AbstractItemListManagerPanel.", (String)"moveUpToolTip.txt", (Locale)locale);
        }
        if (button == BUTTON_MOVE_DOWN) {
            return com.sas.swing.visuals.itemlistmanager.RB.getStringResource((String)"AbstractItemListManagerPanel.", (String)"moveDownToolTip.txt", (Locale)locale);
        }
        return null;
    }

    public void setRowPageSize(int rows) {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            tableView.setRowPageSize(rows);
        }
    }

    public void clearSelectedRows() {
        if (this.controller != null && this.controller.getRowSelections() != null) {
            ListSelectionModel selectionModel = this.controller.getRowSelections();
            selectionModel.clearSelection();
        }
    }

    public void addRowSelectionInterval(int startIndex, int endIndex) {
        if (this.controller != null && this.controller.getRowSelections() != null) {
            ListSelectionModel selectionModel = this.controller.getRowSelections();
            selectionModel.addSelectionInterval(startIndex, endIndex);
        }
    }

    public void setRowSelectionInterval(int startIndex, int endIndex) {
        if (this.controller != null && this.controller.getRowSelections() != null) {
            ListSelectionModel selectionModel = this.controller.getRowSelections();
            selectionModel.clearSelection();
            selectionModel.addSelectionInterval(startIndex, endIndex);
        }
    }

    public int[] getSelectedRowIndices() {
        int[] selectedRows = this.controller != null ? this.controller.getSelectedRows() : new int[]{};
        return selectedRows;
    }

    public int getSelectedRowCount() {
        int count = this.controller != null ? this.controller.getSelectedRowCount() : 0;
        return count;
    }

    public int getRowCount() {
        int count = 0;
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            return tableView.getRowCount();
        }
        return count;
    }

    public void setRowSelectionAllowed(boolean rowSelectionAllowed) {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o == null || !(o instanceof TableView)) {
            throw new IllegalStateException("No tableView component available in ItemListManager");
        }
        TableView tableView = (TableView)o;
    }

    public void setRowSelectionMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("The selection mode must be one of the values defined in javax.swing.ListSelectionModel.");
        }
        this.selectionMode = mode;
    }

    public int getRowSelectionMode() {
        return this.selectionMode;
    }

    public void setColumnPageSize(int columns) {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            tableView.setColumnPageSize(columns);
        }
    }

    public void setColumnVisible(int columnIndex, boolean visible) {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            TableColumnModel tableColumnModel = tableView.getColumnModel();
            if (!visible) {
                int size = tableColumnModel.getColumnCount();
                for (int i = 0; i < size; ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    if (tableColumn.getModelIndex() != columnIndex) continue;
                    tableColumnModel.removeColumn(tableColumn);
                    this.hiddenColumns.add(tableColumn);
                    break;
                }
            } else {
                int size = this.hiddenColumns.size();
                for (int i = 0; i < size; ++i) {
                    TableColumn tableColumn = (TableColumn)this.hiddenColumns.get(i);
                    if (tableColumn.getModelIndex() != columnIndex) continue;
                    this.hiddenColumns.remove(tableColumn);
                    tableColumnModel.addColumn(tableColumn);
                    int colCount = tableColumnModel.getColumnCount();
                    tableColumnModel.moveColumn(colCount - 1, columnIndex);
                }
            }
        } else {
            throw new IllegalStateException("No tableView component available in ItemListManager");
        }
    }

    public void showAllColumns() {
        int size = this.hiddenColumns.size();
        for (int i = 0; i < size; ++i) {
            TableColumn tableColumn = (TableColumn)this.hiddenColumns.get(i);
            this.setColumnVisible(tableColumn.getModelIndex(), true);
        }
    }

    public void moveColumn(int oldIndex, int newIndex) {
        this.tableView.getColumnModel().moveColumn(oldIndex, newIndex);
    }

    public int getViewColumnIndex(int modelColumnIndex) {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            TableColumnModel cm = tableView.getColumnModel();
            int columnCount = tableView.getColumnCount();
            for (int column = 0; column < columnCount; ++column) {
                if (cm.getColumn(column).getModelIndex() != modelColumnIndex) continue;
                return column;
            }
        }
        return -1;
    }

    public int getModelColumnIndex(int viewColumnIndex) {
        if (viewColumnIndex < 0) {
            return viewColumnIndex;
        }
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            return tableView.getColumnModel().getColumn(viewColumnIndex).getModelIndex();
        }
        return -1;
    }

    public int getColumnWidth(int column) {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o != null && o instanceof TableView) {
            TableView tableView = (TableView)o;
            TableColumnModel tableColumnModel = tableView.getColumnHeader().getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(column);
            return tableColumn.getSize();
        }
        throw new IllegalStateException("No tableView component available in ItemListManager");
    }

    public void setColumnWidth(int column, int width) {
        TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
        if (o == null || !(o instanceof TableView)) {
            throw new IllegalStateException("No tableView component available in ItemListManager");
        }
        TableView tableView = (TableView)o;
        int viewColumn = this.getViewColumnIndex(column);
        TableColumnModel tableColumnModel = tableView.getColumnHeader().getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(viewColumn);
        tableColumn.setSize(width);
    }

    protected String getButtonJavascriptFunction(Object predefinedButton) {
        String function = null;
        if (predefinedButton == BUTTON_ADD) {
            function = "add";
        } else if (predefinedButton == BUTTON_DELETE) {
            function = "remove";
        } else if (predefinedButton == BUTTON_MOVE_UP) {
            function = "moveUp";
        } else if (predefinedButton == BUTTON_MOVE_DOWN) {
            function = "moveDown";
        }
        return function;
    }

    protected String getButtonOnClick(Object predefinedButton) {
        String function = this.getButtonJavascriptFunction(predefinedButton);
        String preFunction = null;
        if (function != null) {
            preFunction = "pre" + function.substring(0, 1).toUpperCase() + function.substring(1, function.length());
        }
        StringBuffer js = new StringBuffer();
        js.append("if ( " + this.getId() + "." + preFunction + "( ) ) { ");
        if (this.getButtonPreFunction(predefinedButton) != null) {
            js.append("if (" + this.getButtonPreFunction(predefinedButton) + ") ");
        }
        js.append(" " + this.getId() + "." + function + "(event );");
        js.append(" }");
        if (this.getButtonPostFunction(predefinedButton) != null) {
            js.append("\n");
            js.append(this.getButtonPostFunction(predefinedButton) + ";");
        }
        return js.toString();
    }

    public void setRowSelectionListenerFunction(String function) {
        this.rowSelectionListenerFunction = function;
    }

    public String getRowSelectionListenerFunction() {
        return this.rowSelectionListenerFunction;
    }

    public void setPreCommitListenerFunction(String function) {
        this.preCommitFunction = function;
    }

    public String getPreCommitListenerFunction() {
        return this.preCommitFunction;
    }

    public void setPostCommitListenerFunction(String function) {
        this.postCommitFunction = function;
    }

    public String getPostCommitListenerFunction() {
        return this.postCommitFunction;
    }

    public void setButtonPreFunction(Object predefinedButton, String function) {
        String[] functionList = (String[])this.buttonJSFunctionMap.get(predefinedButton);
        if (functionList == null) {
            functionList = new String[]{null, null};
            this.buttonJSFunctionMap.put(predefinedButton, functionList);
        }
        functionList[0] = function;
    }

    public String getButtonPreFunction(Object predefinedButton) {
        String[] functionList = (String[])this.buttonJSFunctionMap.get(predefinedButton);
        return functionList != null ? functionList[0] : null;
    }

    public void setButtonPostFunction(Object predefinedButton, String function) {
        String[] functionList = (String[])this.buttonJSFunctionMap.get(predefinedButton);
        if (functionList == null) {
            functionList = new String[]{null, null};
            this.buttonJSFunctionMap.put(predefinedButton, functionList);
        }
        functionList[1] = function;
    }

    public String getButtonPostFunction(Object predefinedButton) {
        String[] functionList = (String[])this.buttonJSFunctionMap.get(predefinedButton);
        return functionList != null ? functionList[1] : null;
    }

    public void prepareForWrite() {
        HttpServletRequest request;
        this.flushActionProvider();
        if (this.isPartialRefreshActionsEnabled() && (request = this.getRequest()) != null) {
            ComponentSessionManager.getSessionManager(request).put(this.getId(), this);
        }
        this.prepareTableForWrite();
        this.prepareButtonsForWrite();
        this.prepareTemplateDictionaryForWrite();
    }

    protected void prepareTemplateDictionaryForWrite() {
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put(ITEMLISTMANAGER_ID, this.getId());
        dictionary.put(VERTICAL_BUTTONS, this.writeVerticalButtonGroup());
        dictionary.put(HORIZONTAL_BUTTONS, this.writeHorizontalButtonGroup());
    }

    protected void prepareButtonsForWrite() {
        this.addButton.setOnMouseUp(this.getButtonOnClick(BUTTON_ADD));
        this.addButton.setOnKeyUp(this.getButtonOnClick(BUTTON_ADD));
        this.deleteButton.setOnMouseUp(this.getButtonOnClick(BUTTON_DELETE));
        this.deleteButton.setOnKeyUp(this.getButtonOnClick(BUTTON_DELETE));
        this.moveUpButton.setOnMouseUp(this.getButtonOnClick(BUTTON_MOVE_UP));
        this.moveUpButton.setOnKeyUp(this.getButtonOnClick(BUTTON_MOVE_UP));
        this.moveDownButton.setOnMouseUp(this.getButtonOnClick(BUTTON_MOVE_DOWN));
        this.moveDownButton.setOnKeyUp(this.getButtonOnClick(BUTTON_MOVE_DOWN));
    }

    protected void prepareTableForWrite() {
        TableView tableView = (TableView)this.getComponent("ITEMLISTMANAGER_TABLE");
        if (this.controller == null) {
            this.controller = AJAXTableController.save(tableView, this.getRequest());
            this.controller.setUpdateRowSelections(true);
            this.controller.getRowSelections().setSelectionMode(this.selectionMode);
            this.controller.setUpdateMode(AJAXTableController.UpdateEntireTable);
            this.controller.setContainerId(tableView.getContainerId());
        }
        if (tableView != null && !tableView.getFeatures().contains(this.controller)) {
            tableView.getFeatures().add(this.controller);
        }
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        this.writeJavaScriptIncludes(out);
        this.prepareForWrite();
        this.writeTemplate(this, null, out);
        this.writeFastClickProtection(out);
        this.writeJavaScript(out);
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        if (request != null) {
            ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        }
    }

    @Override
    public void setId(String value) {
        if (value != null && this.getRequest() != null) {
            String previousId = this.getId();
            if (previousId != null && ComponentSessionManager.getSessionManager(this.getRequest()).containsKey(previousId)) {
                ComponentSessionManager.getSessionManager(this.getRequest()).remove(previousId);
            }
            ComponentSessionManager.getSessionManager(this.getRequest()).put(value, this);
        }
        super.setId(value);
    }

    private void writeFastClickProtection(PrintWriter out) throws IOException {
        out.println(JavaScriptIncludeHandler.getStartScript());
        String processText = "Processing";
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' ) ");
        out.println(" { ");
        out.println(" sas_FastClick_createFastClickManager(null,\"" + processText + "\");");
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    protected String writeVerticalButtonGroup() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.buttonsVertical.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof TransformationInterface) {
                TransformationInterface tbean = (TransformationInterface)obj;
                if (!tbean.isVisible()) continue;
                sb.append("<tr><td>");
                sb.append(tbean.toString());
                sb.append("</td></tr>");
                if (!iter.hasNext()) continue;
                sb.append("<tr><td><span class=\"selectorVerticalButtonSpacer\">&#160;</span></td></tr>");
                continue;
            }
            if (obj == BUTTON_DIVIDER) {
                String imageURI = null;
                if (this.getDefaultVerticalDividerImage() != null) {
                    imageURI = this.getImageLocation() + this.getDefaultHorizontalDividerImage();
                } else if (this.getDefaultVerticalDividerImageKey() != null) {
                    imageURI = ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(this.getDefaultHorizontalDividerImageKey(), this.imageLocation);
                }
                Image image = new Image(this.getId() + "_vertical_divider", imageURI);
                image.setVerticalSpace(10);
                sb.append("<tr><td>");
                sb.append("<div align=\"center\">");
                sb.append(image.toString());
                sb.append("<div>");
                sb.append("</td></tr>");
                if (!iter.hasNext()) continue;
                sb.append("<tr><td><span class=\"selectorVerticalButtonSpacer\">&#160;</span></td></tr>");
                continue;
            }
            if (obj == BUTTON_SPACER) {
                sb.append("<tr><td height=\"100%\"><div valign=\"bottom\">&#160;</div></td></tr>");
                if (!iter.hasNext()) continue;
                sb.append("<tr><td><span class=\"selectorVerticalButtonSpacer\">&#160;</span></td></tr>");
                continue;
            }
            if (obj == null) continue;
            sb.append("<tr><td>");
            sb.append(obj.toString());
            sb.append("</td></tr>");
            if (!iter.hasNext()) continue;
            sb.append("<tr><td><span class=\"selectorVerticalButtonSpacer\">&#160;</span></td></tr>");
        }
        sb.append("</td></tr>");
        return sb.toString();
    }

    protected String writeHorizontalButtonGroup() {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr><td><table align=\"left\" cellspacing=\"0\" cellpadding=\"0\" >");
        sb.append("<tr>");
        Iterator iter = this.buttonsHorizontal.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof TransformationInterface) {
                TransformationInterface tbean = (TransformationInterface)obj;
                if (!tbean.isVisible()) continue;
                sb.append("<td>");
                sb.append(tbean.toString());
                sb.append("</td>");
                if (!iter.hasNext()) continue;
                sb.append("<td><span class=\"selectorButtonSpacer\">&#160;</span></td>");
                continue;
            }
            if (obj == BUTTON_DIVIDER) {
                String imageURI = null;
                if (this.getDefaultHorizontalDividerImage() != null) {
                    imageURI = this.getImageLocation() + this.getDefaultHorizontalDividerImage();
                } else if (this.getDefaultHorizontalDividerImageKey() != null) {
                    imageURI = ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(this.getDefaultHorizontalDividerImageKey(), this.imageLocation);
                }
                Image image = new Image(this.getId() + "_horizontal_divider", imageURI);
                image.setHorizontalSpace(10);
                sb.append("<td>");
                sb.append(image.toString());
                sb.append("</td>");
                if (!iter.hasNext()) continue;
                sb.append("<td><span class=\"selectorButtonSpacer\">&#160;</span></td>");
                continue;
            }
            if (obj == BUTTON_SPACER) {
                sb.append("</tr></td></table>");
                sb.append("<td><table align=\"right\" cellspacing=\"0\" cellpadding=\"0\" >");
                sb.append("<tr>");
                sb.append("<td><div width=\"100%\">&#160;</div></td>");
                if (!iter.hasNext()) continue;
                sb.append("<td><span class=\"selectorButtonSpacer\">&#160;</span></td>");
                continue;
            }
            if (obj == null) continue;
            sb.append("<td>");
            sb.append(obj.toString());
            sb.append("</td>");
            if (!iter.hasNext()) continue;
            sb.append("<td><span class=\"selectorButtonSpacer\">&#160;</span></td>");
        }
        sb.append("</tr>");
        sb.append("</table></td></tr>");
        return sb.toString();
    }

    protected void writeJavaScriptIncludes(PrintWriter out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "ITEMLISTMANAGER", this.getRequest());
    }

    protected void writeConstructorJavaScript(PrintWriter out) {
        BaseActionTransformation2 tableView = (BaseActionTransformation2)this.getComponent("ITEMLISTMANAGER_TABLE");
        out.println("" + this.getId() + " = new sas_ItemListManager('" + this.getId() + "', '" + tableView.getContainerId() + "');");
    }

    public String getTableControllerJavaScript() {
        String script = null;
        if (this.controller != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getRowSelectionListenerJavascript());
            script = sb.toString();
        }
        return script;
    }

    protected String getRowSelectionListenerJavascript() {
        StringBuffer sb = new StringBuffer();
        TableView tableView = (TableView)this.getComponent("ITEMLISTMANAGER_TABLE");
        sb.append("if (" + this.getId() + ".controller != " + tableView.getId() + "_Obj) {");
        sb.append(this.getId() + ".controller=" + tableView.getId() + "_Obj;\n");
        sb.append(this.getId() + ".controller.addRowSelectionListener(" + this.getId() + ".selectionChanged, " + this.getId() + ");\n");
        String rowSelectionListener = this.getRowSelectionListenerFunction();
        if (rowSelectionListener != null && rowSelectionListener.length() > 0) {
            sb.append(this.getId() + ".controller.addRowSelectionListener(eval('" + rowSelectionListener + "'), null);\n");
        }
        sb.append("}");
        return sb.toString();
    }

    protected String getCommitListenerJavascript() {
        StringBuffer sb = new StringBuffer();
        TableView tableView = (TableView)this.getComponent("ITEMLISTMANAGER_TABLE");
        String preCommitListener = this.getPreCommitListenerFunction();
        String postCommitListener = this.getPostCommitListenerFunction();
        if (preCommitListener != null && preCommitListener.length() > 0) {
            sb.append(this.getId() + ".controller.addPreCommitListener(eval('" + preCommitListener + "'), null);\n");
        }
        if (postCommitListener != null && postCommitListener.length() > 0) {
            sb.append(this.getId() + ".controller.addCommitListener(eval('" + postCommitListener + "'), null);\n");
        }
        return sb.toString();
    }

    protected void writeJavaScript(PrintWriter out) {
        TableView tableView = (TableView)this.getComponent("ITEMLISTMANAGER_TABLE");
        String id = this.getId();
        String rowSelectionListener = this.getRowSelectionListenerFunction();
        out.println(JavaScriptIncludeHandler.getStartScript());
        this.writeConstructorJavaScript(out);
        String ajaxControllerURL = this.getAJAXControllerURL();
        out.println(id + ".ilmUrl = \"" + ajaxControllerURL + (ajaxControllerURL.indexOf("?") == -1 ? "?" : "&") + "CLASS_PARAMETER=" + this.getClass().getName() + "\";");
        out.println(this.getRowSelectionListenerJavascript());
        if (this.getPreCommitListenerFunction() != null || this.getPostCommitListenerFunction() != null) {
            out.println(this.getCommitListenerJavascript());
        }
        String xmlString = AbstractItemListManager.writeAJAXResponseXML(new String[]{AbstractItemListManager.getButtonState(this)});
        out.println("var xmlString='" + xmlString + "';");
        out.println("sas_ItemListManager_UpdateButtonsFromXMLString(xmlString, " + this.getId() + ");");
        if (this.getOnUpdate() != null) {
            out.println(id + ".onUpdateEvent = \"" + this.getOnUpdate() + "\";");
        }
        out.println(" " + this.getId() + ".localSelection=" + this.clientSideSelection + ";");
        out.println(" " + this.getId() + ".minValueCount=" + this.getMinimumValueCount() + ";");
        out.println(" " + this.getId() + ".maxValueCount=" + this.getMaximumValueCount() + ";");
        int rowCount = tableView == null ? -1 : tableView.getRowCount();
        out.println(" " + this.getId() + ".rowCount=" + rowCount + ";");
        out.println(" " + this.getId() + ".updateComponent();");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    protected static AbstractItemListManager getItemListManager(HttpServletRequest request) {
        AbstractItemListManager ilm;
        String id = request.getParameter("ilmId");
        if (id != null && (ilm = (AbstractItemListManager)ComponentSessionManager.getSessionManager(request).get(id)) != null) {
            return ilm;
        }
        return null;
    }

    protected static Object[] getParameterValue(HttpServletRequest request) {
        return request.getParameterValues("ilmRowValue");
    }

    public static void refresh_AddRow(Object[] values, HttpServletRequest request, HttpServletResponse response) {
        AbstractItemListManager ilm = AbstractItemListManager.getItemListManager(request);
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null);
        if (ilm != null && ilm.getModel() != null) {
            try {
                AbstractItemListManager.commitUncommittedValues(ilm, request);
                TableView tableView = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                TableModel model = AbstractItemListManager.getILMTableModel(ilm);
                int newSelectedRowIndex = -1;
                if (model instanceof InsertRowInterface) {
                    InsertRowInterface insertModel = (InsertRowInterface)model;
                    int row = ilm.getRowCount();
                    if (insertModel.canInsertRow(row)) {
                        logger.debug("ajax_AddRow: attempt insert row at: " + row);
                        newSelectedRowIndex = values == null ? insertModel.insertRow(row) : insertModel.insertRow(values, row);
                        logger.debug("ajax_AddRow: row inserted at : " + newSelectedRowIndex);
                    } else {
                        logger.debug("ajax_AddRow: model doesn't support insert row at: " + row);
                    }
                } else if (model instanceof DefaultTableModel) {
                    DefaultTableModel dataModel = (DefaultTableModel)model;
                    Object[] rowData = values != null ? values : new Object[]{};
                    dataModel.addRow(rowData);
                    newSelectedRowIndex = dataModel.getRowCount() - 1;
                }
                ilm.clearSelectedRows();
                if (newSelectedRowIndex != -1) {
                    ilm.addRowSelectionInterval(newSelectedRowIndex, newSelectedRowIndex);
                }
                int endRow = tableView.getEndRow();
                if (newSelectedRowIndex != -1 && endRow != -1 && newSelectedRowIndex > endRow && tableView.isGotoRowSupported()) {
                    tableView.gotoRow(newSelectedRowIndex + 1);
                }
                response.setContentType("text/xml");
                String tableHTML = AbstractItemListManager.getTableHTML(request, response, tableView);
                StringBuffer sb = new StringBuffer();
                sb.append(JavaScriptIncludeHandler.getStartScript());
                sb.append(ilm.getTableControllerJavaScript());
                int rowCount = tableView == null ? -1 : tableView.getRowCount();
                sb.append(ilm.getId() + ".rowCount=" + rowCount + ";");
                sb.append(ilm.getId() + ".updateComponent();");
                sb.append(JavaScriptIncludeHandler.getEndScript(null));
                String script = sb.toString();
                String xml = AbstractItemListManager.writeAJAXResponseXML(new String[]{AbstractItemListManager.getTableXML(tableHTML), AbstractItemListManager.getButtonState(ilm), script, AbstractItemListManager.getActionTypeXML("ADD_ROW"), ilm.getNavBarXML("rowNavBar", request, response)});
                PrintWriter out = response.getWriter();
                out.println(xml);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void ajax_AddRow(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager ilm = AbstractItemListManager.getItemListManager(request);
        if (ilm != null && ilm.getModel() != null) {
            AbstractItemListManager.commitUncommittedValues(ilm, request);
            AbstractItemListManager.refresh_AddRow(AbstractItemListManager.getParameterValue(request), request, response);
        }
    }

    protected static String getTableHTML(HttpServletRequest request, HttpServletResponse response, TableView table) {
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        try {
            table.writePartialRefresh(request, response, pw);
        }
        catch (Exception ex) {
            out.write("ERROR: " + ex.getMessage() + "\n");
            RuntimeException rte = new RuntimeException(ex.getMessage());
            rte.setStackTrace(ex.getStackTrace());
            throw rte;
        }
        String tableHTML = out.toString();
        return tableHTML;
    }

    public static void ajax_RefreshView(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager ilm = AbstractItemListManager.getItemListManager(request);
        if (ilm != null && ilm.getModel() != null) {
            try {
                response.setContentType("text/xml");
                TableView tableView = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                String tableHTML = AbstractItemListManager.getTableHTML(request, response, tableView);
                StringBuffer sb = new StringBuffer();
                sb.append(JavaScriptIncludeHandler.getStartScript());
                sb.append(ilm.getTableControllerJavaScript());
                int rowCount = tableView == null ? -1 : tableView.getRowCount();
                sb.append(ilm.getId() + ".rowCount=" + rowCount + ";");
                sb.append(ilm.getId() + ".updateButtonState();");
                sb.append(JavaScriptIncludeHandler.getEndScript(null));
                String script = sb.toString();
                String xml = AbstractItemListManager.writeAJAXResponseXML(new String[]{AbstractItemListManager.getTableXML(tableHTML), script, AbstractItemListManager.getButtonState(ilm), ilm.getNavBarXML("rowNavBar", request, response)});
                PrintWriter out = response.getWriter();
                out.println(xml);
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void ajax_GetValues(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager ilm = AbstractItemListManager.getItemListManager(request);
        if (ilm != null && ilm.getModel() != null) {
            try {
                response.setContentType("text/xml");
                TableModel ilmModel = (TableModel)ilm.getModel();
                StringBuffer sb = new StringBuffer();
                int c = ilmModel.getRowCount();
                sb.append("<values size=\"" + c + "\">");
                for (int i = 0; i < c; ++i) {
                    String vTxt = Strings.escapeForJavaScript((String)String.valueOf(ilmModel.getValueAt(i, 0)));
                    sb.append("<value>" + vTxt + "</value>");
                }
                sb.append("</values>");
                String script = sb.toString();
                String xml = AbstractItemListManager.writeAJAXResponseXML(new String[]{script});
                PrintWriter out = response.getWriter();
                out.println(xml);
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void ajax_MoveSelectedRowsDown(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null);
        AbstractItemListManager ilm = AbstractItemListManager.getItemListManager(request);
        if (ilm != null && ilm.getModel() != null) {
            try {
                int i;
                int[] selectedRows;
                AbstractItemListManager.commitUncommittedValues(ilm, request);
                TableView tableView = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                String rowSelectionParam = request.getParameter("rows");
                if (ilm.isClientSideSelection() && rowSelectionParam != null) {
                    selectedRows = AbstractItemListManager.getIntsFromParameter(rowSelectionParam);
                    Arrays.sort(selectedRows);
                } else {
                    selectedRows = ilm.getSelectedRowIndices();
                }
                Object[] selectedRowGroups = TableViewUtil.getSelectedRowGroups((int[])selectedRows);
                ArrayList<Dimension> newRowSelections = new ArrayList<Dimension>();
                int targetRow = -1;
                for (i = 0; i < selectedRowGroups.length; ++i) {
                    Dimension rows = (Dimension)selectedRowGroups[i];
                    int startRow = tableView.getStartRow();
                    int endRow = tableView.getEndRow();
                    int currentRow = tableView.getCurrentRow();
                    logger.debug("ajax_MoveSelectedRowsDown: start: " + rows.width + " end: " + rows.height);
                    targetRow = AbstractItemListManager.moveRowsDown(AbstractItemListManager.getILMTableModel(ilm), rows.width, rows.height);
                    tableView.setStartRow(startRow);
                    tableView.setEndRow(endRow);
                    tableView.setCurrentRow(currentRow);
                    logger.debug("ajax_MoveSelectedRowsDown: moved to destination: " + targetRow);
                    if (targetRow == -1) continue;
                    newRowSelections.add(new Dimension(targetRow, targetRow + (rows.height - rows.width)));
                }
                ilm.clearSelectedRows();
                for (i = 0; i < newRowSelections.size(); ++i) {
                    Dimension rowRange = (Dimension)newRowSelections.get(i);
                    ilm.addRowSelectionInterval(rowRange.width, rowRange.height);
                }
                int endRow = tableView.getEndRow();
                if (targetRow != -1 && endRow != -1 && targetRow > endRow && tableView.isGotoRowSupported()) {
                    tableView.gotoRow(targetRow + 1);
                }
                response.setContentType("text/xml");
                String tableHTML = AbstractItemListManager.getTableHTML(request, response, tableView);
                StringBuffer sb = new StringBuffer();
                sb.append(JavaScriptIncludeHandler.getStartScript());
                sb.append(ilm.getTableControllerJavaScript());
                sb.append(JavaScriptIncludeHandler.getEndScript(null));
                String script = sb.toString();
                String xml = AbstractItemListManager.writeAJAXResponseXML(new String[]{AbstractItemListManager.getTableXML(tableHTML), AbstractItemListManager.getButtonState(ilm), script, AbstractItemListManager.getActionTypeXML("MOVE_DOWN"), ilm.getNavBarXML("rowNavBar", request, response)});
                PrintWriter out = response.getWriter();
                out.println(xml);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static boolean commitUncommittedValues(AbstractItemListManager ilm, HttpServletRequest request) {
        if (ilm.isTableCellEditingEnabled()) {
            boolean edit;
            String editParm = request.getParameter("edit");
            boolean bl = edit = editParm != null && !editParm.equals("");
            if (edit) {
                TableView table = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                HashMap<String, String> uncommitted = new HashMap<String, String>(1, 5.0f);
                String value = edit ? request.getParameter(editParm) : null;
                uncommitted.put(editParm, value);
                table.setUncommittedValues(uncommitted);
                table.commit();
                table.setUncommittedValues(null);
                return true;
            }
        }
        return false;
    }

    public static void ajax_MoveSelectedRowsUp(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null);
        AbstractItemListManager ilm = AbstractItemListManager.getItemListManager(request);
        if (ilm != null && ilm.getModel() != null) {
            try {
                int i;
                int[] selectedRows;
                AbstractItemListManager.commitUncommittedValues(ilm, request);
                TableView tableView = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                String rowSelectionParam = request.getParameter("rows");
                if (ilm.isClientSideSelection() && rowSelectionParam != null) {
                    selectedRows = AbstractItemListManager.getIntsFromParameter(rowSelectionParam);
                    Arrays.sort(selectedRows);
                } else {
                    selectedRows = ilm.getSelectedRowIndices();
                }
                Object[] selectedRowGroups = TableViewUtil.getSelectedRowGroups((int[])selectedRows);
                ArrayList<Dimension> newRowSelections = new ArrayList<Dimension>();
                int targetRow = -1;
                for (i = 0; i < selectedRowGroups.length; ++i) {
                    Dimension rows = (Dimension)selectedRowGroups[i];
                    logger.debug("ajax_MoveSelectedRowsUp: start: " + rows.width + " end: " + rows.height);
                    int startRow = tableView.getStartRow();
                    int endRow = tableView.getEndRow();
                    int currentRow = tableView.getCurrentRow();
                    targetRow = AbstractItemListManager.moveRowsUp(AbstractItemListManager.getILMTableModel(ilm), rows.width, rows.height);
                    tableView.setStartRow(startRow);
                    tableView.setEndRow(endRow);
                    tableView.setCurrentRow(currentRow);
                    logger.debug("ajax_MoveSelectedRowsUp: moved to destination: " + targetRow);
                    if (targetRow == -1) continue;
                    newRowSelections.add(new Dimension(targetRow, targetRow + (rows.height - rows.width)));
                }
                ilm.clearSelectedRows();
                for (i = 0; i < newRowSelections.size(); ++i) {
                    Dimension rowRange = (Dimension)newRowSelections.get(i);
                    ilm.addRowSelectionInterval(rowRange.width, rowRange.height);
                }
                int startRow = tableView.getStartRow();
                if (targetRow != -1 && startRow != -1 && targetRow < startRow) {
                    tableView.pageBackwardRows();
                }
                response.setContentType("text/xml");
                String tableHTML = AbstractItemListManager.getTableHTML(request, response, tableView);
                StringBuffer sb = new StringBuffer();
                sb.append(JavaScriptIncludeHandler.getStartScript());
                sb.append(ilm.getTableControllerJavaScript());
                sb.append(JavaScriptIncludeHandler.getEndScript(null));
                String script = sb.toString();
                String xml = AbstractItemListManager.writeAJAXResponseXML(new String[]{AbstractItemListManager.getTableXML(tableHTML), AbstractItemListManager.getButtonState(ilm), script, AbstractItemListManager.getActionTypeXML("MOVE_UP"), ilm.getNavBarXML("rowNavBar", request, response)});
                PrintWriter out = response.getWriter();
                out.println(xml);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static int moveRowsUp(Object model, int rowStart, int rowEnd) {
        if (model instanceof MoveRowInterface) {
            MoveRowInterface moveModel = (MoveRowInterface)model;
            if (moveModel.canMoveRow(rowStart, rowEnd, rowStart - 1)) {
                int targetRow = moveModel.moveRowRange(rowStart, rowEnd, rowStart - 1);
                return targetRow;
            }
        } else if (model instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)model;
            defaultTableModel.moveRow(rowStart, rowEnd, rowStart - 1);
            return rowStart - 1;
        }
        return -1;
    }

    protected static int moveRowsDown(Object model, int rowStart, int rowEnd) {
        if (model instanceof MoveRowInterface) {
            MoveRowInterface moveModel = (MoveRowInterface)model;
            if (moveModel.canMoveRow(rowStart, rowEnd, rowStart + 1)) {
                int targetRow = moveModel.moveRowRange(rowStart, rowEnd, rowStart + 1);
                return targetRow;
            }
        } else if (model instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)model;
            defaultTableModel.moveRow(rowStart, rowEnd, rowStart + 1);
            return rowStart + 1;
        }
        return -1;
    }

    public static int[] getIntsFromParameter(String str) {
        int[] ret = null;
        if (str != null) {
            String[] parms = str.split(",");
            ret = new int[parms.length];
            for (int i = 0; i < parms.length; ++i) {
                int val;
                String parm = parms[i];
                ret[i] = val = parm == null ? -1 : Integer.parseInt(parm);
            }
        }
        return ret;
    }

    public static void ajax_DeleteSelectedRows(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager ilm = AbstractItemListManager.getItemListManager(request);
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null);
        if (ilm != null && ilm.getModel() != null) {
            try {
                int[] selectedRows;
                TableView tableView = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                TableModel model = AbstractItemListManager.getILMTableModel(ilm);
                String rowSelectionParam = request.getParameter("rows");
                if (ilm.isClientSideSelection() && rowSelectionParam != null) {
                    selectedRows = AbstractItemListManager.getIntsFromParameter(rowSelectionParam);
                    Arrays.sort(selectedRows);
                } else {
                    selectedRows = ilm.getSelectedRowIndices();
                }
                if (model instanceof DeleteRowsInterface) {
                    DeleteRowsInterface deleteModel = (DeleteRowsInterface)model;
                    deleteModel.deleteRows(selectedRows);
                } else {
                    for (int i = selectedRows.length - 1; i >= 0; --i) {
                        if (model instanceof DeleteRowInterface) {
                            DeleteRowInterface deleteModel = (DeleteRowInterface)model;
                            if (!deleteModel.canDeleteRow(selectedRows[i])) continue;
                            deleteModel.deleteRow(selectedRows[i]);
                            continue;
                        }
                        if (!(model instanceof DefaultTableModel)) continue;
                        DefaultTableModel dataModel = (DefaultTableModel)model;
                        dataModel.removeRow(selectedRows[i]);
                    }
                }
                ilm.clearSelectedRows();
                int rowCount = ilm.getRowCount();
                if (rowCount > 0 && selectedRows.length > 0) {
                    int newRowSelection = selectedRows[0];
                    if (newRowSelection >= rowCount) {
                        --newRowSelection;
                    }
                    ilm.addRowSelectionInterval(newRowSelection, newRowSelection);
                }
                response.setContentType("text/xml");
                String tableHTML = AbstractItemListManager.getTableHTML(request, response, tableView);
                StringBuffer sb = new StringBuffer();
                sb.append(JavaScriptIncludeHandler.getStartScript());
                sb.append(ilm.getTableControllerJavaScript());
                rowCount = tableView == null ? -1 : tableView.getRowCount();
                sb.append(ilm.getId() + ".rowCount=" + rowCount + ";");
                sb.append(ilm.getId() + ".updateComponent();");
                sb.append(JavaScriptIncludeHandler.getEndScript(null));
                String script = sb.toString();
                String xml = AbstractItemListManager.writeAJAXResponseXML(new String[]{AbstractItemListManager.getTableXML(tableHTML), AbstractItemListManager.getButtonState(ilm), script, ilm.getNavBarXML("rowNavBar", request, response)});
                PrintWriter out = response.getWriter();
                out.println(xml);
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static String getButtonState(AbstractItemListManager ilm) {
        String buttonState = "";
        try {
            Class[] types = new Class[]{AbstractItemListManager.class};
            Method method = ilm.getClass().getMethod("getButtonEnabledStateXML", types);
            buttonState = "<buttons>" + method.invoke((Object)ilm, ilm) + "</buttons>";
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return buttonState;
    }

    protected static TableModel getILMTableModel(AbstractItemListManager ilm) {
        TransformationInterface tableObj;
        TableModel tableModel = null;
        if (ilm != null && (tableObj = ilm.getComponent("ITEMLISTMANAGER_TABLE")) instanceof TableView) {
            tableModel = ((TableView)tableObj).getModel();
        }
        return tableModel;
    }

    public static String getButtonEnabledStateXML(AbstractItemListManager ilm) {
        String buttonsEnabledState = "";
        boolean isAddEnabled = false;
        boolean isDeleteEnabled = false;
        boolean isUpEnabled = false;
        boolean isDownEnabled = false;
        if (ilm != null && ilm.getModel() != null) {
            TableModel model = AbstractItemListManager.getILMTableModel(ilm);
            int[] selectedRows = ilm.getSelectedRowIndices();
            int selectedRowCount = selectedRows.length;
            int rowCount = ilm.getRowCount();
            isAddEnabled = true;
            isDeleteEnabled = selectedRowCount > 0 && rowCount > 0;
            isUpEnabled = selectedRowCount > 0 && rowCount > 0;
            isDownEnabled = selectedRowCount > 0 && rowCount > 0;
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                if (model instanceof MoveRowInterface) {
                    MoveRowInterface moveModel = (MoveRowInterface)model;
                    if (isUpEnabled && !moveModel.canMoveRow(row, row, row - 1)) {
                        isUpEnabled = false;
                    }
                    if (isDownEnabled && !moveModel.canMoveRow(row, row, row + 1)) {
                        isDownEnabled = false;
                    }
                } else if (model instanceof DefaultTableModel) {
                    if (isUpEnabled && row == 0) {
                        isUpEnabled = false;
                    }
                    if (isDownEnabled && row >= rowCount - 1) {
                        isDownEnabled = false;
                    }
                }
                if (isAddEnabled && model instanceof InsertRowInterface && !((InsertRowInterface)model).canInsertRow(selectedRows[i])) {
                    isAddEnabled = false;
                }
                if (!isDeleteEnabled || !(model instanceof DeleteRowInterface) || ((DeleteRowInterface)model).canDeleteRow(selectedRows[i])) continue;
                isDeleteEnabled = false;
            }
            buttonsEnabledState = AbstractItemListManager.writeButtonXML("UP_Button", Boolean.toString(isUpEnabled));
            buttonsEnabledState = buttonsEnabledState + AbstractItemListManager.writeButtonXML("DOWN_Button", Boolean.toString(isDownEnabled));
            buttonsEnabledState = buttonsEnabledState + AbstractItemListManager.writeButtonXML("ADD_Button", Boolean.toString(isAddEnabled));
            buttonsEnabledState = buttonsEnabledState + AbstractItemListManager.writeButtonXML("DELETE_Button", Boolean.toString(isDeleteEnabled));
        }
        return buttonsEnabledState;
    }

    protected static String writeButtonXML(String buttonID, String enabledState) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(buttonID);
        sb.append(" enabled=\"" + enabledState + "\"");
        sb.append(">");
        sb.append(enabledState);
        sb.append("</");
        sb.append(buttonID);
        sb.append(">");
        return sb.toString();
    }

    protected static String getTableXML(String tableHTML) {
        StringBuffer sb = new StringBuffer();
        if (tableHTML != null && tableHTML.length() > 0) {
            sb.append("<ILMTableContent>");
            sb.append(BaseUtil.replaceXMLSpecialCharacters(tableHTML));
            sb.append("</ILMTableContent>");
        }
        return sb.toString();
    }

    protected String getNavBarXML(String type, HttpServletRequest request, HttpServletResponse response) {
        String navBarHtml = null;
        BaseNavigationBar navBar = null;
        if ("rowNavBar".equals(type)) {
            navBar = (BaseNavigationBar)this.getComponent("ITEMLISTMANAGER_ROW_NAVIGATIONBAR");
        } else if ("columnNavBar".equals(type)) {
            navBar = (BaseNavigationBar)this.getComponent("ITEMLISTMANAGER_COLUMN_NAVIGATIONBAR");
        }
        if (navBar == null || !navBar.isVisible()) {
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(type);
            sb.append(">");
            sb.append("</");
            sb.append(type);
            sb.append(">");
            navBarHtml = sb.toString();
            return navBarHtml;
        }
        navBar.setRequest(request);
        navBar.setResponse(response);
        navBarHtml = navBar.toString();
        String navBarXML = navBarHtml != null && navBarHtml.length() > 0 ? AbstractItemListManager.getCDATA_XML(type, navBarHtml) : null;
        return navBarXML;
    }

    protected static String getCDATA_XML(String tagName, String html) {
        StringBuffer sb = new StringBuffer();
        if (html != null && html.length() > 0) {
            sb.append("<" + tagName + ">");
            sb.append(BaseUtil.replaceXMLSpecialCharacters(html));
            sb.append("</" + tagName + ">");
        }
        return sb.toString();
    }

    protected static String getActionTypeXML(String action) {
        StringBuffer sb = new StringBuffer();
        if (action != null && action.length() > 0) {
            sb.append("<actionType name=\"" + action + "\"");
            sb.append("></actionType>");
        }
        return sb.toString();
    }

    protected static String writeAJAXResponseXML(String[] xmlElements) {
        StringBuffer sb = new StringBuffer();
        if (xmlElements != null && xmlElements.length > 0) {
            sb.append("<?xml version=\"1.0\"?>");
            sb.append("<request>");
            for (int i = 0; i < xmlElements.length; ++i) {
                if (xmlElements[i] == null) continue;
                sb.append(xmlElements[i]);
            }
            sb.append("</request>");
        }
        return sb.toString();
    }

    public static void ajax_RefreshButtonState(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager ilm = AbstractItemListManager.getItemListManager(request);
        try {
            if (ilm != null) {
                PrintWriter out = response.getWriter();
                response.setContentType("text/xml");
                String xml = AbstractItemListManager.writeAJAXResponseXML(new String[]{AbstractItemListManager.getButtonState(ilm)});
                out.println(xml);
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider provider) {
        super.setActionProvider(provider);
        if (this.tableView != null) {
            this.tableView.setActionProvider(null);
        }
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setMinimumValueCount(int min) {
        if (min < 0) {
            min = 0;
        }
        if (this.minValues != min) {
            int oldValue = this.minValues;
            this.minValues = min;
            this.firePropertyChange("minValues", oldValue, this.minValues);
        }
    }

    public int getMinimumValueCount() {
        return this.minValues;
    }

    public void setMaximumValueCount(int max) {
        if (max < -1) {
            max = -1;
        }
        if (this.maxValues != max) {
            int oldValue = this.maxValues;
            this.maxValues = max;
            this.firePropertyChange("maxValues", oldValue, this.maxValues);
        }
    }

    public int getMaximumValueCount() {
        return this.maxValues;
    }

    public String getDefaultHorizontalDividerImageKey() {
        return this.defaultHorizontalDividerImageKey;
    }

    public void setDefaultHorizontalDividerImageKey(String defaultHorizontalDividerImageKey) {
        this.defaultHorizontalDividerImageKey = defaultHorizontalDividerImageKey;
    }

    public String getDefaultVerticalDividerImageKey() {
        return this.defaultVerticalDividerImageKey;
    }

    public void setDefaultVerticalDividerImageKey(String defaultVerticalDividerImageKey) {
        this.defaultVerticalDividerImageKey = defaultVerticalDividerImageKey;
    }

    public void setClientSideSelection(boolean value) {
        if (this.clientSideSelection != value) {
            this.clientSideSelection = value;
        }
        if (this.controller != null && this.controller.isUpdateRowSelections() == this.clientSideSelection) {
            this.controller.setUpdateRowSelections(!this.clientSideSelection);
        }
    }

    public boolean isClientSideSelection() {
        return this.clientSideSelection;
    }

    static {
        JavaScriptIncludeHandler.addAlias(AbstractItemListManager.class, "ITEMLISTMANAGER");
    }
}

