/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.ipage.iform;

import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.ipage.iform.BaseIFormElement;
import com.sas.servlet.tbeans.ipage.iform.IForm;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;

public class IFormTextEntry
extends BaseIFormElement {
    private String format;
    private String value;

    public IFormTextEntry() {
        this(Util.getName((String)"IFormTextEntry"));
    }

    public IFormTextEntry(String name) {
        this(name, "");
    }

    public IFormTextEntry(String name, String prompt) {
        this(name, prompt, "");
    }

    public IFormTextEntry(String name, String prompt, String format) {
        this.setName(name);
        this.setPrompt(prompt);
        this.setFormat(format);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void writeHeader(PrintWriter out) throws IOException {
        if (this.getBrowserType() == 3) {
            out.write("<entry");
            String f = this.getFormat();
            if (this.value != null && this.value.length() > 0) {
                out.write(" default=\"");
                out.write(this.value);
                out.write("\"");
            }
            if (f != null && f.length() > 0) {
                out.write(" format=\"");
                out.write(f);
                out.write("\"");
            }
        }
        super.writeHeader(out);
    }

    @Override
    public void writeBase(PrintWriter out) throws IOException {
        IForm f;
        super.writeBase(out);
        if (this.getBrowserType() == 1 || this.getBrowserType() == 2) {
            String f2;
            out.write("<input");
            out.write(" name=\"");
            out.write(this.getName());
            out.write("\"");
            if (this.value != null && this.value.length() > 0) {
                out.write(" value=\"");
                out.write(this.value);
                out.write("\"");
            }
            if ((f2 = this.getFormat()) != null && f2.length() > 0) {
                out.write(" format=\"");
                out.write(f2);
                out.write("\"");
            }
            out.write("/>");
            out.write("\n</p>\n");
        } else if (this.getBrowserType() == 4 && (f = this.getParentIForm()) != null) {
            TextEntry t = new TextEntry(this.getName(), this.getValue());
            t.setRequest(this.getRequest());
            t.setResponse(this.getResponse());
            t.setLocale(this.getLocale());
            f.setHTMLTableRow(this.getPrompt(), t, this.getOptionLabel(), this.getOptionURL());
        }
    }

    @Override
    public void writeFooter(PrintWriter out) throws IOException {
        if (this.getBrowserType() == 3) {
            out.write("</entry>\n");
        } else {
            super.writeFooter(out);
        }
    }
}

