/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.ipage.iform;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.ipage.BaseIPage;
import com.sas.servlet.tbeans.ipage.iform.BaseIFormElement;
import com.sas.servlet.tbeans.ipage.iform.IFormHidden;
import com.sas.servlet.tbeans.ipage.iform.RB;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.table.DefaultTableModel;

@SASScope(value="ALL")
public class IForm
extends BaseIPage {
    @SASScope
    public static final String RB_KEY = "IForm.";
    public static final String DEFAULT_METHOD = "post";
    private String method;
    private String action;
    private String actionLabel;
    private Vector elements = new Vector();
    private Vector hiddenElements = new Vector();
    private DefaultTableModel tableModel;

    public IForm() {
        this(Util.getName((String)"IForm"), null, null);
    }

    public IForm(HttpServletRequest request, HttpServletResponse response) {
        this(Util.getName((String)"IForm"), request, response);
    }

    public IForm(String name, HttpServletRequest request, HttpServletResponse response) {
        this.setName(name);
        this.setAction("");
        this.setMethod(DEFAULT_METHOD);
        if (request != null) {
            this.setRequest(request);
        }
        if (response != null) {
            this.setResponse(response);
        }
        this.tableModel = null;
    }

    @Override
    public void writeBase(PrintWriter out) throws IOException {
        super.writeBase(out);
        if (this.elements.size() > 0) {
            Enumeration elementsEnum = this.elements.elements();
            Form htmlForm = null;
            if (this.getBrowserType() == 4) {
                htmlForm = new Form(this.getName());
                htmlForm.setMethod(this.getMethod());
                htmlForm.setAction(this.getAction());
                htmlForm.setRequest(this.getRequest());
                htmlForm.setResponse(this.getResponse());
                htmlForm.setLocale(this.getLocale());
                htmlForm.writeHeader(out);
                this.tableModel = new DefaultTableModel();
                this.tableModel.setColumnCount(3);
            }
            BaseIFormElement current = null;
            BaseIFormElement next = null;
            while (elementsEnum.hasMoreElements() || next != null) {
                current = next == null ? (BaseIFormElement)elementsEnum.nextElement() : next;
                String elementTitle = current.getTitle();
                String elementOptionURL = current.getOptionURL();
                String elementOptionLabel = current.getOptionLabel();
                if (elementTitle == null || elementTitle.length() == 0) {
                    current.setTitle(this.getTitle());
                }
                if (elementOptionLabel == null && elementOptionURL == null && this.getOptionLabel() != null && this.getOptionURL() != null && this.getBrowserType() != 4) {
                    current.addOption(this.getOptionLabel(), this.getOptionURL());
                }
                current.setBrowserType(this.getBrowserType());
                if (this.getBrowserType() == 1 || this.getBrowserType() == 2 || this.getBrowserType() == 3) {
                    IFormHidden iFormHidden = new IFormHidden(current.getName(), "$" + current.getName(), false);
                    iFormHidden.setRequest(this.getRequest());
                    iFormHidden.setResponse(this.getResponse());
                    iFormHidden.setLocale(this.getLocale());
                    this.add(iFormHidden);
                }
                if (elementsEnum.hasMoreElements()) {
                    next = (BaseIFormElement)elementsEnum.nextElement();
                    if (this.getBrowserType() == 1 || this.getBrowserType() == 2 || this.getBrowserType() == 3) {
                        current.setAcceptURL("#" + next.getName());
                    }
                    current.write(out);
                    continue;
                }
                next = null;
                if (this.getBrowserType() == 1 || this.getBrowserType() == 2 || this.getBrowserType() == 3) {
                    current.setAcceptURL(this.getAction());
                    if (this.getActionLabel() != null && this.getActionLabel().length() > 0) {
                        current.setAcceptLabel(this.getActionLabel());
                    } else {
                        current.setAcceptLabel(null);
                    }
                }
                current.write(out, true);
            }
            if (this.getBrowserType() == 4) {
                TableView t = new TableView();
                t.setFormEnabled(false);
                t.setAllActionsVisible(false);
                t.setRequest(this.getRequest());
                t.setResponse(this.getResponse());
                t.setLocale(this.getLocale());
                DefaultTableCellRenderer r1 = new DefaultTableCellRenderer();
                r1.setHorizontalAlignment(4);
                r1.setVerticalAlignment(1);
                TableCellContentsRenderer cRen = r1.getTableCellContentsRenderer();
                if (cRen instanceof Label) {
                    ((Label)((Object)cRen)).setEncodeText(false);
                }
                t.setCellRenderer(-1, 1, r1);
                r1 = new DefaultTableCellRenderer();
                r1.setVerticalAlignment(1);
                cRen = r1.getTableCellContentsRenderer();
                if (cRen instanceof Label) {
                    ((Label)((Object)cRen)).setEncodeText(false);
                }
                t.setCellRenderer(-1, 3, r1);
                r1 = new DefaultTableCellRenderer();
                cRen = r1.getTableCellContentsRenderer();
                if (cRen instanceof Label) {
                    ((Label)((Object)cRen)).setEncodeText(false);
                }
                t.setCellRenderer(-1, -1, r1);
                t.setColumnHeaderVisible(false);
                t.setRowHeaderVisible(false);
                t.setModel(this.tableModel);
                t.setCellSpacing(3);
                t.write(out);
                this.writeHiddenElements(out);
                out.write("<br><p>");
                if (this.getActionLabel() != null && this.getActionLabel().length() > 0) {
                    out.write("<input type=\"submit\" value=\"" + this.getActionLabel() + "\">\n");
                } else {
                    out.write("<input type=\"submit\" value=\"");
                    out.write(RB.getStringResource(RB_KEY, "submit.txt", this.getLocale()));
                    out.write("\">\n");
                }
                out.write("</p>");
                if (this.getOptionLabel() != null && this.getOptionLabel().length() > 0 && this.getOptionURL() != null && this.getOptionURL().length() > 0) {
                    out.write("<a href=\"" + this.getOptionURL() + "\">" + this.getOptionLabel() + "</a>");
                }
                htmlForm.writeFooter(out);
            }
        }
    }

    public void writeHiddenElements(PrintWriter out) throws IOException {
        Enumeration hiddenElementsEnum = this.hiddenElements.elements();
        while (hiddenElementsEnum.hasMoreElements()) {
            IFormHidden h = (IFormHidden)hiddenElementsEnum.nextElement();
            h.setBrowserType(this.getBrowserType());
            h.write(out);
            if (this.getBrowserType() != 3 || !hiddenElementsEnum.hasMoreElements()) continue;
            out.write("&amp;");
        }
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public BaseIFormElement add(BaseIFormElement element) {
        element.setParentIForm(this);
        if (element instanceof IFormHidden) {
            this.hiddenElements.add(element);
        } else {
            this.elements.add(element);
        }
        return element;
    }

    void setHTMLTableRow(String prompt, BaseTransformation element, String optionLabel, String optionURL) {
        if (this.tableModel != null) {
            Vector<Object> v = new Vector<Object>();
            if (prompt != null && prompt.length() > 0) {
                v.add(prompt);
            } else {
                v.add("&#160;");
            }
            v.add(element);
            if (optionLabel != null && optionLabel.length() > 0 && optionURL != null && optionURL.length() > 0) {
                v.add("<a href=\"" + optionURL + "\">" + optionLabel + "</a>");
            }
            this.tableModel.addRow(v);
        }
    }
}

