/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.ipage;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ipage.BaseIPage;
import com.sas.servlet.tbeans.ipage.RB;
import com.sas.servlet.util.BaseUtil;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ListModel;

@SASScope(value="ALL")
public class IMenu
extends BaseIPage {
    @SASScope
    public static final String RB_KEY = "IMenu.";
    public static final String MORE_MENU_NAME = "moreSubMenu";
    public static final String DEFAULT_MENU_MARKER = "##";
    public static final int DEFAULT_MAX_ITEMS = 9;
    private ListModel URLModel;
    private ListModel model;
    private String preMenuText = "";
    private String postMenuText = "";
    private String URLFormat;
    private int startIndex = 0;
    private int endIndex = -1;
    private int maxItems = 9;
    private String moreURL = "";
    private String moreLabel = RB.getStringResource("IMenu.", "moreMenu.txt", this.getLocale());
    private StringBuffer endData;

    public IMenu() {
        this(Util.getName((String)"IMenu"), null, null);
    }

    public IMenu(HttpServletRequest request, HttpServletResponse response) {
        this(Util.getName((String)"IMenu"), request, response);
    }

    public IMenu(String name, HttpServletRequest request, HttpServletResponse response) {
        if (request != null) {
            this.setRequest(request);
        }
        if (response != null) {
            this.setResponse(response);
        }
        this.setName(name);
    }

    public void setModel(ListModel model) {
        this.model = model;
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setURLModel(ListModel URLModel) {
        this.URLModel = URLModel;
    }

    public ListModel getURLModel() {
        return this.URLModel;
    }

    public void setPreMenuText(String value) {
        this.preMenuText = value;
    }

    public void setPostMenuText(String value) {
        this.postMenuText = value;
    }

    public String getPreMenuText() {
        return this.preMenuText;
    }

    public String getPostMenuText() {
        return this.postMenuText;
    }

    public void setStartIndex(int value) {
        this.startIndex = value;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setEndIndex(int value) {
        this.endIndex = value;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setMoreURL(String value) {
        this.moreURL = value;
    }

    public String getMoreURL() {
        return this.moreURL;
    }

    public void setMoreLabel(String moreLabel) {
        this.moreLabel = moreLabel;
    }

    public String getMoreLabel() {
        return this.moreLabel;
    }

    public void setMaxItemsDisplayed(int value) {
        this.maxItems = value;
    }

    public int getMaxItemsDisplayed() {
        return this.maxItems;
    }

    public void setURLFormat(String format) {
        this.URLFormat = format;
    }

    public String getURLFormat() {
        return this.URLFormat;
    }

    @Override
    public void writeBase(PrintWriter out) throws IOException {
        IMenu subMenu;
        super.writeBase(out);
        boolean hasMoreMenu = false;
        ListModel m = this.getModel();
        ListModel menuURLModel = this.getURLModel();
        if (m == null) {
            throw new IOException(RB.getStringResource(RB_KEY, "noModelSet.txt", this.getLocale()));
        }
        if (menuURLModel == null) {
            menuURLModel = this.model;
        }
        int bType = this.getBrowserType();
        if (this.getPreMenuText() != null) {
            this.setPreMenuText(BaseUtil.replaceSpecialCharacters(this.getPreMenuText(), bType));
        }
        if (this.getPostMenuText() != null) {
            this.setPostMenuText(BaseUtil.replaceSpecialCharacters(this.getPostMenuText(), bType));
        }
        if (m.getSize() < this.getEndIndex() || this.getEndIndex() == -1) {
            this.setEndIndex(this.model.getSize());
        }
        if (this.getEndIndex() - this.getStartIndex() < this.getMaxItemsDisplayed() || bType == 4) {
            subMenu = null;
            if (!this.getMoreURL().equals("")) {
                hasMoreMenu = true;
            }
        } else {
            hasMoreMenu = true;
            subMenu = this.getMoreURL().equals("") ? this.createSubMenu() : null;
        }
        this.writeBeginMarkup(out);
        String url = "";
        String menuItem = "";
        this.endData = new StringBuffer("");
        String htmlData = "";
        for (int offset = this.getStartIndex(); offset >= 0 && offset < this.getEndIndex(); ++offset) {
            htmlData = "";
            menuItem = (String)m.getElementAt(offset);
            Object urlObject = menuURLModel.getElementAt(offset);
            if (urlObject != null) {
                if (urlObject instanceof BaseIPage) {
                    if (bType == 4) {
                        htmlData = ((BaseIPage)urlObject).toString();
                    } else {
                        this.endData.append(((BaseIPage)urlObject).toString());
                        url = "#" + ((BaseIPage)urlObject).getName();
                    }
                } else {
                    url = urlObject.toString();
                }
            }
            this.writeMenuItem(out, menuItem, url, htmlData);
        }
        if (hasMoreMenu) {
            htmlData = "";
            menuItem = this.getMoreLabel();
            if (this.getMoreURL().equals("")) {
                if (subMenu != null) {
                    if (bType == 4) {
                        htmlData = subMenu.toString();
                    } else {
                        url = "#" + subMenu.getName();
                        this.endData.append(subMenu.toString());
                    }
                } else {
                    url = "";
                }
            } else {
                url = this.getMoreURL();
            }
            hasMoreMenu = false;
            this.writeMenuItem(out, menuItem, url, htmlData);
        }
        this.writeEndMarkup(out);
    }

    private void writeBeginMarkup(PrintWriter out) {
        int bType = this.getBrowserType();
        if (bType == 1 || bType == 2) {
            out.write("<card");
            if (this.getName() != null) {
                out.write(" id=\"");
                out.write(this.getName());
                out.write("\"");
            }
            if (this.getTitle() != null) {
                out.write(" title=\"");
                out.write(this.getTitle());
                out.write("\"");
            }
            out.write(">\n");
            if (bType == 1 && this.getTitle() != null) {
                out.write("<p align=\"center\">\n");
                out.write(this.getTitle());
                out.write("</p>\n");
                out.write("<p align=\"left\">\n");
            } else {
                out.write("<p>\n");
            }
            if (this.getPreMenuText() != null) {
                out.write(this.resolveNewLine(this.getPreMenuText(), "\n"));
            }
            if (bType == 1 && this.getModel().getSize() > 0) {
                out.write("<select>\n");
            }
        } else if (bType == 3) {
            out.write("<choice");
            if (this.getName() != null) {
                out.write(" name=\"");
                out.write(this.getName());
                out.write("\"");
            }
            if (this.getTitle() != null) {
                out.write(" title=\"");
                out.write(this.getTitle());
                out.write("\"");
            }
            out.write(">\n");
            if (this.getTitle() != null) {
                out.write("<center>");
                out.write(this.getTitle());
                out.write("\n");
            }
            if (this.getPreMenuText() != null) {
                if (this.getTitle() != null) {
                    out.write("<wrap>");
                }
                out.write(this.resolveNewLine(this.getPreMenuText(), "\n"));
            }
        } else {
            if (this.getPreMenuText() != null) {
                out.write(this.resolveNewLine(this.getPreMenuText(), "\n"));
            }
            out.write("<dl>");
        }
    }

    private void writeEndMarkup(PrintWriter out) {
        int bType = this.getBrowserType();
        if (bType == 1 || bType == 2) {
            if (bType == 1 && this.getModel().getSize() > 0) {
                out.write("</select>\n");
            }
            if (this.getPostMenuText() != null) {
                out.write(this.resolveNewLine(this.getPostMenuText(), "\n"));
            }
            out.write("\n</p>\n</card>\n");
            out.write(this.endData.toString());
        } else if (bType == 3) {
            out.write("\n</choice>\n");
            out.write(this.endData.toString());
        } else {
            out.write("</dl>\n");
            boolean postMenuTextWritten = false;
            if (this.getPostMenuText() != null && this.getPostMenuText().length() > 0) {
                postMenuTextWritten = true;
                out.write(this.resolveNewLine(this.getPostMenuText(), "\n"));
            }
            if (this.getOptionLabel() != null && this.getOptionLabel().length() > 0 && this.getOptionURL() != null && this.getOptionURL().length() > 0) {
                if (postMenuTextWritten) {
                    out.write("<br>");
                }
                out.write("<a href=\"" + this.getOptionURL() + "\">" + this.getOptionLabel() + "</a>");
            }
        }
    }

    private IMenu createSubMenu() {
        IMenu subMenu = new IMenu(this.getRequest(), this.getResponse());
        subMenu.setURLFormat(this.getURLFormat());
        subMenu.setMaxItemsDisplayed(this.getMaxItemsDisplayed());
        subMenu.setModel(this.getModel());
        subMenu.setURLModel(this.getURLModel());
        subMenu.setStartIndex(this.getStartIndex() + this.getMaxItemsDisplayed());
        subMenu.setEndIndex(this.getEndIndex());
        this.setEndIndex(this.getStartIndex() + this.getMaxItemsDisplayed());
        int moreSubMenuEnd = this.getName().indexOf(MORE_MENU_NAME);
        int subMenuNum = 1;
        if (moreSubMenuEnd > -1) {
            subMenuNum = new Integer(this.getName().substring(moreSubMenuEnd + MORE_MENU_NAME.length()));
            ++subMenuNum;
        }
        subMenu.setName(MORE_MENU_NAME + subMenuNum);
        if (subMenuNum == 1 && this.getTitle() != null) {
            subMenu.setTitle(this.getTitle() + " " + RB.getStringResource(RB_KEY, "continued.txt", this.getLocale()));
        } else {
            subMenu.setTitle(this.getTitle());
        }
        return subMenu;
    }

    @SASScope
    protected void writeMenuItem(PrintWriter out, String menuItem, String url, String htmlData) throws IOException {
        int markerIndex;
        String urlFormat = this.getURLFormat();
        int bType = this.getBrowserType();
        menuItem = BaseUtil.replaceSpecialCharacters(menuItem, bType);
        if (urlFormat != null && !menuItem.equals(this.getMoreLabel()) && (markerIndex = urlFormat.indexOf(DEFAULT_MENU_MARKER)) > -1) {
            url = urlFormat.substring(0, markerIndex) + URLEncoder.encode(url, BaseUtil.getInputCharacterEncoding(this.getRequest())) + urlFormat.substring(markerIndex + DEFAULT_MENU_MARKER.length(), urlFormat.length());
        }
        url = BaseUtil.replaceSpecialCharacters(url, bType);
        if (bType == 1) {
            out.write("<option onpick=\"");
            out.write(url);
            out.write("\">");
            out.write(menuItem);
            out.write("</option>\n");
        } else if (bType == 2) {
            out.write("<a href=\"");
            out.write(url);
            out.write("\">");
            out.write(menuItem);
            out.write("</a><br/>\n");
        } else if (bType == 3) {
            out.write("\n<ce task=go dest=\"");
            out.write(url);
            out.write("\">");
            out.write(menuItem);
        } else if (htmlData.equals("")) {
            out.write("<dt>");
            out.write("<a href=\"");
            out.write(url);
            out.write("\">");
            out.write(menuItem);
            out.write("</a><br>\n");
        } else {
            out.write("<dt>");
            out.write(menuItem);
            out.write("<dd>");
            out.write(htmlData);
            out.write("\n");
        }
    }
}

