/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.ipage;

import com.sas.beans.Util;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ClientInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseIPage
extends BaseTransformation {
    public static final String WML_PROLOG = "<?xml version=\"1.0\"?>\n<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">\n";
    public static final String HTML_PROLOG = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n";
    private String title;
    private String optionLabel;
    private String optionURL;
    private int cacheTimeToLive = -1;
    private int browserType;

    public BaseIPage() {
        this.setBrowserType(4);
        this.setTagProlog(HTML_PROLOG);
    }

    @Override
    public void setId(String value) {
        this.setId(value, true);
    }

    private void setId(String value, boolean replace) {
        if (replace) {
            super.setId(value.replace(' ', '_').replace('\t', '_'));
        } else {
            super.setId(value);
        }
    }

    @Override
    public void setName(String value) {
        this.setName(value, true);
    }

    public void setName(String value, boolean replace) {
        if (replace) {
            super.setName(value.replace(' ', '_').replace('\t', '_'));
        } else {
            super.setName(value);
        }
    }

    public void setBrowserType(int browserType) {
        this.browserType = browserType;
    }

    public int getBrowserType() {
        return this.browserType;
    }

    @Override
    public void setStyle(String style) {
    }

    @Override
    public void setStyleClass(String styleClass) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setRequest(HttpServletRequest request) {
        block8: {
            super.setRequest(request);
            if (request == null) break block8;
            clientInfo = new ClientInfo(request);
            accept = clientInfo.getAccept();
            if (accept == null) ** GOTO lbl-1000
            if (accept.indexOf("text/html") > -1) {
                prolog = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n";
                this.setBrowserType(4);
            } else if (clientInfo.isWML()) {
                prolog = "<?xml version=\"1.0\"?>\n<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">\n";
                if (clientInfo.isUP()) {
                    this.setBrowserType(1);
                } else {
                    this.setBrowserType(2);
                }
            } else if (clientInfo.isHDML()) {
                prolog = "";
                this.setBrowserType(3);
            } else {
                prolog = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n";
                this.setBrowserType(4);
            }
            this.setTagProlog(prolog);
        }
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        super.setResponse(response);
        if (response != null) {
            int bType = this.getBrowserType();
            if (bType == 1 || bType == 2) {
                response.setContentType("text/vnd.wap.wml");
            } else if (bType == 3) {
                response.setContentType("text/x-hdml");
            } else {
                response.setContentType("text/html");
            }
        }
    }

    public String resolveNewLine(String s, String newLine) {
        int bType = this.getBrowserType();
        String br = bType == 1 || bType == 2 ? "<br/>" : "<br>";
        int index = s.indexOf(newLine);
        if (index != -1) {
            String before = s.substring(0, index);
            String after = s.substring(index + newLine.length());
            after = this.resolveNewLine(after, newLine);
            s = before + br + after;
        }
        return s;
    }

    public void writeBase(Writer out) throws IOException {
        this.writeBase(new PrintWriter(out));
    }

    public void writeBase(PrintWriter out) throws IOException {
        if (this.getTitle() != null) {
            this.setTitle(BaseUtil.replaceSpecialCharacters(this.getTitle(), this.getBrowserType()));
        }
        if (this.getName() != null) {
            this.setName(BaseUtil.replaceSpecialCharacters(this.getName(), this.getBrowserType()));
        }
    }

    public void writeBase(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.write(o);
        o.flush();
    }

    public void writeHeader(Writer out) throws IOException {
        this.writeHeader(new PrintWriter(out));
    }

    public void writeHeader(PrintWriter out) throws IOException {
        int bType;
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        if ((bType = this.getBrowserType()) == 1 || bType == 2) {
            out.write("<wml>\n");
            if (this.getCacheTimeToLive() > -1) {
                out.write("<head>\n<meta http-equiv=\"Cache-Control\" content=\"max-age=" + this.getCacheTimeToLive() + "\" />\n</head>\n");
            }
            out.write("<template>\n");
            out.write("<do type=\"prev\">\n<prev/>\n</do>\n");
            if (this.optionLabel != null && this.optionLabel.length() > 0 && this.optionURL != null && this.optionURL.length() > 0) {
                out.write("<do type=\"options\" label=\"");
                out.write(this.optionLabel);
                out.write("\" name=\"");
                out.write(this.optionLabel);
                out.write("\">\n<go href=\"");
                out.write(this.optionURL);
                out.write("\"/>\n</do>\n");
            }
            out.write("</template>\n");
        } else if (bType == 3) {
            out.write("<hdml version=\"3.0\" public=\"true\"");
            if (this.getCacheTimeToLive() > -1) {
                out.write(" ttl=\"" + this.getCacheTimeToLive() + "\"");
            }
            out.write(">\n");
            if (this.optionLabel != null && this.optionLabel.length() > 0 && this.optionURL != null && this.optionURL.length() > 0) {
                out.write("<action type=\"soft1\" task=\"go\" label=\"");
                out.write(this.optionLabel);
                out.write("\" dest=\"");
                out.write(this.optionURL);
                out.write("\">\n");
            }
        } else {
            ClientInfo clientInfo;
            HttpServletRequest req;
            out.write("<html>\n");
            boolean headWritten = false;
            if (this.getTitle() != null) {
                out.write("<head>\n");
                headWritten = true;
                out.write("<title>\n");
                out.write(this.getTitle());
                out.write("\n</title>\n");
            }
            if ((req = this.getRequest()) != null && (clientInfo = new ClientInfo(req)).isPalmVII()) {
                if (!headWritten) {
                    out.write("<head>\n");
                    headWritten = true;
                }
                out.write("<meta name=\"palmcomputingplatform\" content=\"true\">\n");
            }
            if (this.getCacheTimeToLive() > -1) {
                if (!headWritten) {
                    out.write("<head>\n");
                    headWritten = true;
                }
                out.write("<meta http-equiv=\"Cache-Control\" content=\"max-age=" + this.getCacheTimeToLive() + "\" />\n");
            }
            if (headWritten) {
                out.write("</head>\n");
            }
            out.write("<body>\n");
        }
    }

    public void writeHeader(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.write(o);
        o.flush();
    }

    public void writeFooter(Writer out) throws IOException {
        this.writeFooter(new PrintWriter(out));
    }

    public void writeFooter(PrintWriter out) throws IOException {
        int bType = this.getBrowserType();
        if (bType == 1 || bType == 2) {
            out.write("</wml>\n");
        } else if (bType == 3) {
            out.write("</hdml>\n");
        } else {
            out.write("\n</body>\n");
            out.write("</html>\n");
        }
        String epilog = this.getTagEpilog();
        if (epilog != null) {
            out.write(epilog);
        }
    }

    public void writeFooter(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.write(o);
        o.flush();
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        this.writeHeader(out);
        super.write(out);
        this.writeBase(out);
        this.writeFooter(out);
        this.cleanUpResources();
    }

    @Override
    public String toString() {
        if (Util.isDesignTime()) {
            return super.toString();
        }
        StringWriter out = new StringWriter();
        try {
            this.writeBase(out);
        }
        catch (Exception ex) {
            out.write("ERROR: " + ex.getMessage() + "\n");
        }
        return out.toString();
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setCacheTimeToLive(int seconds) {
        this.cacheTimeToLive = seconds;
    }

    public int getCacheTimeToLive() {
        return this.cacheTimeToLive;
    }

    public void addOption(String optionLabel, String optionURL) {
        this.optionLabel = optionLabel;
        this.optionURL = optionURL;
    }

    public String getOptionLabel() {
        return this.optionLabel;
    }

    public String getOptionURL() {
        return this.optionURL;
    }
}

