/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.html.HtmlUtil;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.html.TreeViewStyleKeysInterface;
import com.sas.servlet.tbeans.models.Attribute;
import com.sas.servlet.tbeans.models.TreeNodeExpandInterface;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.tbeans.models.TreeNodeOnContextMenuInterface;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

@SASScope
public class TreeViewFull
implements TreeViewStyleKeysInterface {
    public static final String RB_KEY = "TreeView.";
    public static final int FULL = 1;
    public static final int PROGRESSIVE = 0;
    public static final int FULLYEXPANDED = 1;
    public static final int FULLYCOLLAPSED = 0;
    public static final int DYNAMIC = 2;
    public static final int IFRAME = 1;
    public static final int AJAX = 0;
    private static final String NODENAME_ROOT = "sas_TreeView_level";
    private static char[] quote1 = new char[]{'\"', '\\', '\n'};
    private static String[] quote2 = new String[]{"\\\"", "\\\\", "\\n"};
    private static final String[] nodeLevelNames = new String[10];
    private TreeView tree;

    public TreeViewFull(TreeView tree) {
        this.tree = tree;
    }

    public static String reformatTreeText(String tText) {
        if (tText == null) {
            return null;
        }
        String val = Strings.replace((String)tText, (char[])quote1, (String[])quote2);
        return val;
    }

    @SASScope
    public static String escapeTreeText(String tText) {
        if (tText == null) {
            return null;
        }
        String val = tText;
        if (val.indexOf("<script") != -1 || val.indexOf("</script>") != -1) {
            val = Strings.quoteForXML((String)val);
        }
        val = Strings.escapeForJavaScript((String)val, (boolean)true);
        return val;
    }

    void writeJavaScript(PrintWriter out, TreeNodeInterface root) throws IOException {
        boolean delayExecution = this.tree.isDelayExecutionEnabled();
        StringBuffer js = new StringBuffer(1024);
        if (delayExecution) {
            js.append("<div id=\"").append(this.tree.getId()).append("_DIV\" name=\"").append(this.tree.getId());
            js.append("\" class=\"").append(this.tree.getStyleClassPrefix()).append(this.tree.getStyleClass("TREEVIEW_PANE"));
            js.append("\" style=\"-moz-user-select: none;\">&#160;</div>\n");
        }
        js.append(JavaScriptIncludeHandler.getStartScript());
        if (delayExecution) {
            js.append("divEl = document.getElementById('").append(this.tree.getId()).append("_DIV');\n");
            js.append("divEl.innerHTML = \"\";\n");
            js.append("\n");
            js.append("function drawTree(documentParent){\n");
        }
        RemoteScriptForm rsForm = this.createNodesAndTree(js, root);
        if (delayExecution) {
            js.append("}\n");
        }
        js.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(js);
        if (rsForm != null && rsForm.isVisible() && this.tree.isFormEnabled()) {
            rsForm.write(out);
        }
    }

    @SASScope
    public void setSelectedNodesPathExpanded() {
        ListModel selectedNodes = this.tree.getSelectedNodes();
        if (selectedNodes == null) {
            return;
        }
        int selNodesSize = selectedNodes.getSize();
        if (selNodesSize > 0) {
            for (int i = 0; i < selNodesSize; ++i) {
                for (TreeNodeInterface selectedNode = selectedNodes.getElementAt(i) instanceof TreeNodeInterface ? (TreeNodeInterface)selectedNodes.getElementAt(i) : TreeView.findNode(selectedNodes.getElementAt(i).toString(), this.tree.getRoot()); selectedNode != null && selectedNode.getParent() != null; selectedNode = (TreeNodeInterface)selectedNode.getParent()) {
                    selectedNode.setExpanded(true);
                }
            }
        }
    }

    public void createNodesAndTree(StringBuffer js) {
        this.createNodesAndTree(js, this.tree.getRootFromModel());
    }

    public RemoteScriptForm createNodesAndTree(StringBuffer js, TreeNodeInterface root) {
        this.setSelectedNodesPathExpanded();
        this.createNodes(js, root);
        this.createTree(js);
        RemoteScriptForm rsForm = null;
        if (this.tree.getNodeLoading() == 2) {
            rsForm = (RemoteScriptForm)this.tree.getRemoteScriptForm();
            rsForm.setStyle("display:none");
            TreeViewFull.setPropertyQuoted(js, this.tree.getId(), "_Obj.rsForm=", rsForm.getName());
        }
        return rsForm;
    }

    public void createTree(StringBuffer js) {
        String treename = this.tree.getId();
        String rootname = this.getNodeLevelName(0);
        js.append(treename).append(" = ").append(treename).append("_Obj = new sas_TreeView(").append(rootname).append(",'").append(treename).append("');\n");
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.componentType = ", this.tree.getJSTreeType());
        TreeViewFull.setProperty(js, treename, "_Obj.multipleSelections = ", this.tree.getMultipleSelections() ? "true" : "false");
        TreeViewFull.setProperty(js, treename, "_Obj.isFolderExpandCollapseEnabled = false", !this.tree.isFolderExpandCollapseEnabled());
        TreeViewFull.setProperty(js, treename, "_Obj.isRootVisible=false", !this.tree.isRootNodeVisible());
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.frame = ", this.tree.getTarget());
        TreeViewFull.setProperty(js, treename, "_Obj.useIcons=false", !this.tree.isImageVisible());
        TreeViewFull.setProperty(js, treename, "_Obj.useURLLinks=false", !this.tree.isUsingURLLinks());
        TreeViewFull.setProperty(js, treename, "_Obj.usePlusMinusLines=false", !this.tree.isUsePlusMinusLines());
        TreeViewFull.setProperty(js, treename, "_Obj.nodeSelectionVisible=false", !this.tree.isNodeSelectionVisible());
        TreeViewFull.setProperty(js, treename, "_Obj.isCheckboxSelectionMode=true", this.tree.isCheckboxSelectionMode());
        TreeViewFull.setProperty(js, treename, "_Obj.isRadioboxSelectionMode=true", this.tree.isRadioboxSelectionMode());
        TreeViewFull.setProperty(js, treename, "_Obj.isOnlyLeavesSelectable=true", this.tree.isOnlyLeavesSelectable());
        TreeViewFull.setProperty(js, treename, "_Obj.useIndicatorImages=true", this.tree.getSelectionMode() == 6 || this.tree.getSelectionMode() == 7);
        TreeViewFull.setProperty(js, treename, "_Obj.isSelectionRequired=true", this.tree.isSelectionRequired());
        TreeViewFull.setProperty(js, treename, "_Obj.renderUsingDivs=true", this.tree.isRenderUsingDivs());
        TreeViewFull.setProperty(js, treename, "_Obj.preselectNodeFunction=", this.tree.getPreSelectNodeFunctionName());
        TreeViewFull.setProperty(js, treename, "_Obj.postselectNodeFunction=", this.tree.getPostSelectNodeFunctionName());
        TreeViewFull.setProperty(js, treename, "_Obj.preOnContextMenuFunction=", this.tree.getPreOnContextMenuFunctionName());
        TreeViewFull.setProperty(js, treename, "_Obj.postOnContextMenuFunction=", this.tree.getPostOnContextMenuFunctionName());
        TreeViewFull.setProperty(js, treename, "_Obj.selectNodeFunction=", this.tree.getSelectNodeFunctionName());
        TreeViewFull.setProperty(js, treename, "_Obj.deselectNodeFunction=", this.tree.getDeselectNodeFunctionName());
        TreeViewFull.setProperty(js, treename, "_Obj.nodeRenderer=", this.tree.getNodeRendererFunctionName());
        TreeViewFull.setProperty(js, treename, "_Obj.preExpandNodeFunction=", this.tree.getPreExpandNodeFunctionName());
        TreeViewFull.setProperty(js, treename, "_Obj.postExpandNodeFunction=", this.tree.getPostExpandNodeFunctionName());
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.imageLoc = ", this.tree.getImageLocation());
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.tree.getRequest());
        String blankImageName = cpm.getImageName("Blank");
        if (!this.tree.isUsePlusMinus()) {
            TreeViewFull.setProperty(js, treename, "_Obj.blankImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.lastNodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.firstNodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.plusLastNodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.minusLastNodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.vertLineImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.nodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.plusNodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.minusNodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.missingRootPlusNodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.missingRootMinusNodeImage = \"" + blankImageName + "\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hconlyNodeMinusNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hconlyNodePlusNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hconlyNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcblankImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hclastNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcfirstNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcplusLastNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcminusLastNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcvertLineImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcnodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcplusNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcminusNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcmissingRootPlusNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcmissingRootMinusNodeImage = \"&nbsp;\"", true);
        } else {
            TreeViewFull.setProperty(js, treename, "_Obj.hconlyNodeMinusNodeImage = \"&ndash;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hconlyNodePlusNodeImage = \"+\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hconlyNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcblankImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hclastNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcfirstNodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcplusLastNodeImage = \"+\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcminusLastNodeImage = \"&ndash;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcvertLineImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcnodeImage = \"&nbsp;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcplusNodeImage = \"+\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcminusNodeImage = \"&ndash;\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcmissingRootPlusNodeImage = \"+\"", true);
            TreeViewFull.setProperty(js, treename, "_Obj.hcmissingRootMinusNodeImage = \"&ndash;\"", true);
            if (!this.tree.isUsePlusMinusLines()) {
                String plusImageName = cpm.getImageName("Plus_No_Lines");
                String minusImageName = cpm.getImageName("Minus_No_Lines");
                TreeViewFull.setProperty(js, treename, "_Obj.blankImage = \"" + blankImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.lastNodeImage = \"" + blankImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.firstNodeImage = \"" + blankImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.plusLastNodeImage = \"" + plusImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.minusLastNodeImage = \"" + minusImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.vertLineImage = \"" + blankImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.nodeImage = \"" + blankImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.plusNodeImage = \"" + plusImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.minusNodeImage = \"" + minusImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.missingRootPlusNodeImage = \"" + plusImageName + "\"", true);
                TreeViewFull.setProperty(js, treename, "_Obj.missingRootMinusNodeImage = \"" + minusImageName + "\"", true);
            } else {
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.blankImage = ", this.getImageName(null, "Blank"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.firstNodeImage = ", this.getImageName("FIRST_NODE", "First_Node"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.lastNodeImage = ", this.getImageName("LAST_NODE", "Last_Node"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.plusLastNodeImage = ", this.getImageName("PLUS_LAST_NODE", "Plus_Last_Node"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.minusLastNodeImage = ", this.getImageName("MINUS_LAST_NODE", "Minus_Last_Node"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.vertLineImage = ", this.getImageName("VERTICAL_LINE", "Vert_Line"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.nodeImage = ", this.getImageName("NODE", "Node"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.plusNodeImage = ", this.getImageName("PLUS_NODE", "Plus_Node"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.minusNodeImage = ", this.getImageName("MINUS_NODE", "Minus_Node"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.missingRootPlusNodeImage = ", this.getImageName("MISSING_ROOT_PLUS_NODE", "Missing_Root_Plus_Node"));
                TreeViewFull.setPropertyQuoted(js, treename, "_Obj.missingRootMinusNodeImage = ", this.getImageName("MISSING_ROOT_MINUS_NODE", "Missing_Root_Minus_Node"));
            }
        }
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.onlyNodeImage = ", this.getImageName(null, "Blank"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.onlyNodePlusNodeImage = ", this.getImageName("PLUS_ONLY_NODE", "Only_Node_Plus"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.onlyNodeMinusNodeImage = ", this.getImageName("MINUS_ONLY_NODE", "Only_Node_Minus"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.openFolderImage = ", this.getImageName(null, "Tree_View_Folder"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.closedFolderImage = ", this.getImageName(null, "Tree_View_Folder"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.disabledFolderImage = ", this.getImageName(null, "Folder_Disabled"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.leafImage = ", this.getImageName("LEAF_ICON", "Tree_View_Leaf_Node"));
        js.append(treename).append("_Obj.cbStateImages=new Array(");
        js.append("\t\"" + this.getImageName("INDICATOR_NO_CHILDREN", "Tree_View_Empty") + "\",\n");
        js.append("\t\"" + this.getImageName("INDICATOR_SOME_CHILDREN", "Tree_View_Some_Children") + "\",\n");
        js.append("\t\"" + this.getImageName("INDICATOR_ALL_CHILDREN", "Tree_View_Children") + "\",\n");
        js.append("\t\"" + this.getImageName("INDICATOR_SELF_NO_CHILDREN", "Tree_View_Node") + "\",\n");
        js.append("\t\"" + this.getImageName(null, "Tree_View_Node_Some_Children") + "\",\n");
        js.append("\t\"" + this.getImageName("INDICATOR_SELF_ALL_CHILDREN", "Tree_View_Node_Children") + "\",\n");
        js.append("\t\"" + this.getImageName(null, "Checkbox_16_Empty") + "\",\n");
        js.append("\t\"" + this.getImageName(null, "Checkbox_16_Partial") + "\",\n");
        js.append("\t\"" + this.getImageName(null, "Checkbox_16_Checked") + "\"\n");
        js.append(");\n");
        js.append(treename).append("_Obj.indicatorImages=").append(treename).append("_Obj.cbStateImages.concat();\n");
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.indicatorImages[0] = ", this.getImageName("INDICATOR_NO_CHILDREN", "Tree_View_Empty"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.indicatorImages[1] = ", this.getImageName("INDICATOR_SOME_CHILDREN", "Tree_View_Some_Children"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.indicatorImages[2] = ", this.getImageName("INDICATOR_ALL_CHILDREN", "Tree_View_Children"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.indicatorImages[3] = ", this.getImageName("INDICATOR_SELF_NO_CHILDREN", "Tree_View_Node"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.indicatorImages[4] = ", this.getImageName("INDICATOR_SOME_CHILDREN", "Tree_View_Some_Children"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.indicatorImages[5] = ", this.getImageName("INDICATOR_SELF_ALL_CHILDREN", "Tree_View_Node_Children"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.treeViewEmptyImageName = ", this.getImageName("INDICATOR_NO_CHILDREN", "Tree_View_Empty"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.grayTreeViewImageName = ", this.getImageName(null, "Gray_tree_view"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.styleClassPrefix = ", this.tree.getStyleClassPrefix());
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.imageStyleClass=", this.tree.getStyleClass("TREEVIEW_IMAGE"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.textStyleClass=", this.tree.getStyleClass("TREEVIEW_TEXT"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.selectedStyleClass=", this.tree.getStyleClass("TREEVIEW_SELECTED"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.disabledStyleClass=", this.tree.getStyleClass("TREEVIEW_DISABLED"));
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.paneStyleClass=", this.tree.getStyleClass("TREEVIEW_PANE"));
        if (this.tree.isRenderUsingDivs()) {
            TreeViewFull.setPropertyQuoted(js, treename, "_Obj.treeImageSpaceStyleClass=", this.tree.getStyleClass("TREEVIEW_DIV_IMAGE_SPACE"));
        } else {
            TreeViewFull.setPropertyQuoted(js, treename, "_Obj.treeImageSpaceStyleClass=", this.tree.getStyleClass("TREEVIEW_IMAGE_SPACE"));
        }
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.onChange=", this.tree.getOnChange());
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.onBlur=", this.tree.getOnBlur());
        TreeViewFull.setPropertyQuoted(js, treename, "_Obj.onFocus=", this.tree.getOnFocus());
        TreeViewFull.setProperty(js, treename, "_Obj.RSCRIPT=true;", this.tree.getNodeLoading() == 2);
        js.append(treename).append("_Obj.paint(").append(rootname).append(");\n");
        if (this.tree.getSelectedNodes() != null) {
            this.writeSelectedNodes(js);
            js.append("for (i=0; i < ").append(treename).append("_Obj.selectedNodes.length; i++)\n");
            js.append("{\n");
            js.append("   var node = ").append(treename).append("_Obj.getNode(").append(treename).append("_Obj.selectedNodes[i]);\n");
            js.append("   if(node == null)\n");
            js.append("      continue;\n");
            js.append("   sas_TreeView_expandTo(node);\n");
            if (this.tree.isCheckboxSelectionMode() || this.tree.isRadioboxSelectionMode()) {
                js.append("   sas_TreeView_cbCheck(node, true);\n");
                js.append("   if (i == ").append(treename).append("_Obj.selectedNodes.length-1)\n");
                js.append("   {\n");
                js.append("      ").append(treename).append("_Obj.selections.appendNode(node);\n");
                js.append("       sas_TreeView_focusTo(node);\n");
                js.append("   }\n");
            } else {
                js.append("   ").append(treename).append("_Obj.selections.appendNode(node);\n");
                js.append("   if (i == ").append(treename).append("_Obj.selectedNodes.length-1)\n");
                js.append("   sas_TreeView_scrollIntoView(node);\n");
            }
            js.append("}\n");
        }
        if (this.tree.getExpansionLevel() == 1) {
            js.append(this.tree.getId()).append("_Obj.expandAll();\n");
        } else if (this.tree.getInitialExpansionLevel() >= -1 && this.tree.getNodeLoading() != 2) {
            js.append(this.tree.getId()).append("_Obj.expandToLevel(").append(this.tree.getInitialExpansionLevel()).append(");\n");
        }
    }

    private String getImageName(String treeImageKey, String webImageKey) {
        String nonDefaultImageName;
        String string = nonDefaultImageName = treeImageKey == null ? null : this.tree.getNonDefaultImageName(treeImageKey);
        if (nonDefaultImageName != null) {
            return nonDefaultImageName;
        }
        return ComponentPropertyManager.getInstance(this.tree.getRequest()).getImageName(webImageKey);
    }

    public void createNodes(StringBuffer js, TreeNodeInterface root) {
        this.createNodes(js, 0, root);
    }

    public void createNodes(StringBuffer js) {
        TreeNodeInterface root = this.tree.getRoot();
        if (root == null) {
            root = this.tree.getRootFromModel();
        }
        this.createNodes(js, root);
    }

    private void createNodes(StringBuffer js, int level, TreeNodeInterface node) {
        if (level == 0 && this.tree.getNodeLoading() == 2 && this.tree.getInitialExpansionLevel() >= -1) {
            this.tree.expandNode(this.tree.getRootFromModel(), 0, this.tree.getInitialExpansionLevel() - 1);
        }
        this.writeJavaScriptNodeCode(js, node, this.getNodeLevelName(level));
        if (level > 0) {
            js.append(this.getNodeLevelName(level - 1));
            js.append(".addChild(").append(this.getNodeLevelName(level));
            js.append(");\n");
        } else {
            node.setExpanded(true);
        }
        if (this.tree.getNodeLoading() == 2 && level > 0 && !node.isExpanded()) {
            return;
        }
        this.createNodeChildren(js, level, node);
    }

    private void createNodeChildren(StringBuffer js, int level, TreeNodeInterface node) {
        int nKids = node.getChildCount();
        for (int i = 0; i < nKids; ++i) {
            TreeNodeInterface childNode = this.getChild(node, i);
            if (childNode == null) continue;
            this.createNodes(js, level + 1, childNode);
        }
    }

    private TreeNodeInterface getChild(TreeNodeInterface node, int i) {
        TreeNodeInterface childNode = null;
        TreeNode child = node.getChildAt(i);
        if (child instanceof TreeNodeInterface) {
            childNode = (TreeNodeInterface)child;
        } else if (child != null) {
            childNode = new TreeView.TreeNodeAdaptor(this.tree.getModel(), child, node.getName() + "_" + i, this.tree.transform);
        }
        return childNode;
    }

    private void writeSelectedNodes(StringBuffer js) {
        js.append(this.tree.getId()).append("_Obj.selectedNodes = new Array(");
        ListModel selectedNodes = this.tree.getSelectedNodes();
        for (int i = 0; i < selectedNodes.getSize(); ++i) {
            String name = null;
            name = selectedNodes.getElementAt(i) instanceof TreeNodeInterface ? ((TreeNodeInterface)selectedNodes.getElementAt(i)).getName() : selectedNodes.getElementAt(i).toString();
            js.append("\"").append(TreeViewFull.escapeTreeText(name)).append("\"");
            if (i >= selectedNodes.getSize() - 1) continue;
            js.append(",");
        }
        js.append(");\n");
    }

    public void writeJavaScriptNodeConstructorCode(StringBuffer sb, TreeNodeInterface node, String nodeName) {
        sb.append(nodeName);
        sb.append("= new sas_TreeView_Node({");
        boolean firstArg = true;
        if (node.getText() != null) {
            firstArg = TreeViewFull.addCtor(sb, "text", TreeViewFull.escapeTreeText(node.getText()), firstArg);
        }
        if (node.getURL() != null) {
            firstArg = TreeViewFull.addCtor(sb, "value", TreeViewFull.escapeTreeText(TreeView.getThreadLocalTrimURL() ? node.getURL().trim() : node.getURL()), firstArg);
        }
        if (node.getTarget() != null) {
            firstArg = TreeViewFull.addCtor(sb, "target", node.getTarget(), firstArg);
        }
        if (node.getTitle() != null) {
            firstArg = TreeViewFull.addCtor(sb, "title", TreeViewFull.escapeTreeText(node.getTitle()), firstArg);
        }
        firstArg = TreeViewFull.addCtor(sb, "iconSrc", node.getDefaultImage(), firstArg);
        firstArg = TreeViewFull.addCtor(sb, "expIconSrc", node.getExpandedImage(), firstArg);
        firstArg = TreeViewFull.addCtor(sb, "disIconSrc", node.getDisabledImage(), firstArg);
        firstArg = TreeViewFull.addCtor(sb, "nodeId", TreeViewFull.escapeTreeText(node.getName()), firstArg);
        sb.append("});\n");
    }

    public String getJavaScriptNodeCode(TreeNodeInterface node, String nodename) {
        StringBuffer js = new StringBuffer();
        this.writeJavaScriptNodeCode(js, node, nodename);
        return js.toString();
    }

    public void writeJavaScriptNodeCode(StringBuffer js, TreeNodeInterface node, String nodename) {
        List attributes;
        if (this.tree.getNodeLoading() == 2) {
            if (this.tree.nodeMap == null) {
                this.tree.nodeMap = new HashMap();
            }
            this.tree.nodeMap.put(node.getName(), node);
        }
        this.writeJavaScriptNodeConstructorCode(js, node, nodename);
        if (node.getSourceParent() != null) {
            TreeViewFull.setProperty(js, nodename, ".sourceParent=", "sas_TreeView_basicFindNode(\"" + TreeViewFull.escapeTreeText(node.getSourceParent().getName()) + "\")");
        }
        if (this.tree.getNodeLoading() == 2) {
            TreeViewFull.setProperty(js, nodename, ".isFolder=true", !this.tree.isAutoChildrenVerify() || !node.isLeaf());
        } else {
            TreeViewFull.setProperty(js, nodename, ".isFolder=true", !this.tree.getModel().isLeaf(node) && node.getChildCount() == 0);
        }
        TreeViewFull.setProperty(js, nodename, ".isExpanded=true", node.isExpanded());
        TreeViewFull.setPropertyQuoted(js, nodename, ".nodeType=", TreeViewFull.escapeTreeText(node.getNodeType()));
        TreeViewFull.setProperty(js, nodename, ".isEnabled=false", !node.isEnabled());
        TreeViewFull.setProperty(js, nodename, ".renderer=", node.getRendererFunctionName());
        TreeViewFull.setProperty(js, nodename, ".selectNodeFunction=", node.getSelectNodeFunctionName());
        TreeViewFull.setProperty(js, nodename, ".deselectNodeFunction=", node.getDeselectNodeFunctionName());
        TreeViewFull.setProperty(js, nodename, ".preselectNodeFunction=", node.getPreSelectNodeFunctionName());
        TreeViewFull.setProperty(js, nodename, ".postselectNodeFunction=", node.getPostSelectNodeFunctionName());
        if (node instanceof TreeNodeOnContextMenuInterface) {
            TreeViewFull.setProperty(js, nodename, ".preOnContextMenuFunction=", ((TreeNodeOnContextMenuInterface)((Object)node)).getPreOnContextMenuFunctionName());
            TreeViewFull.setProperty(js, nodename, ".postOnContextMenuFunction=", ((TreeNodeOnContextMenuInterface)((Object)node)).getPostOnContextMenuFunctionName());
        }
        if (node instanceof TreeNodeExpandInterface) {
            TreeViewFull.setProperty(js, nodename, ".preExpandNodeFunction=", ((TreeNodeExpandInterface)((Object)node)).getPreExpandNodeFunctionName());
            TreeViewFull.setProperty(js, nodename, ".postExpandNodeFunction=", ((TreeNodeExpandInterface)((Object)node)).getPostExpandNodeFunctionName());
        }
        TreeViewFull.setPropertyQuoted(js, nodename, ".imageLoc=", node.getImageLocation());
        TreeViewFull.setPropertyQuoted(js, nodename, ".styleClassPrefix=", node.getStyleClassPrefix());
        TreeViewFull.setPropertyQuoted(js, nodename, ".imageStyleClass=", this.tree.getStyleClass(node, "TREEVIEW_IMAGE"));
        TreeViewFull.setPropertyQuoted(js, nodename, ".textStyleClass=", this.tree.getStyleClass(node, "TREEVIEW_TEXT"));
        TreeViewFull.setPropertyQuoted(js, nodename, ".selectedStyleClass=", this.tree.getStyleClass(node, "TREEVIEW_SELECTED"));
        TreeViewFull.setPropertyQuoted(js, nodename, ".disabledStyleClass=", this.tree.getStyleClass(node, "TREEVIEW_DISABLED"));
        TreeViewFull.setProperty(js, nodename, ".childrenCreated=true", node.isExpanded());
        if (this.tree.getAttributeGenerator() != null && (attributes = this.tree.getAttributeGenerator().getAttributes(node)) != null) {
            for (Attribute att : attributes) {
                js.append(nodename).append(".addAttribute(\"").append(TreeViewFull.escapeTreeText(att.getName())).append("\", \"").append(TreeViewFull.escapeTreeText(att.getValue())).append("\");\n");
            }
        }
    }

    static boolean addCtor(StringBuffer js, String property, String value, boolean firstArg) {
        if (value == null) {
            return firstArg;
        }
        if (!firstArg) {
            js.append(", ");
        }
        js.append(property).append(":\"").append(value).append("\"");
        return false;
    }

    static void setProperty(StringBuffer javaScript, String nodename, String propertySetter, boolean value) {
        if (value) {
            javaScript.append(nodename).append(propertySetter).append(";\n");
        }
    }

    static void setProperty(StringBuffer javaScript, String nodename, String property, String value) {
        if (value != null) {
            javaScript.append(nodename).append(property).append(value).append(";\n");
        }
    }

    static void setPropertyQuoted(StringBuffer javaScript, String nodename, String property, String value) {
        if (value != null) {
            javaScript.append(nodename).append(property).append("\"").append(value).append("\";\n");
        }
    }

    public void expandToNode(StringBuffer sb, TreeNode node) {
        DefaultTreeModel tmodel = (DefaultTreeModel)this.tree.getModel();
        TreeView.TreeNodeAdaptor curnode = (TreeView.TreeNodeAdaptor)this.tree.getRoot();
        TreeNode[] path = tmodel.getPathToRoot(node);
        sb.append("sas_TreeView_node = sas_TreeView_tree.root;\n");
        for (int p = 1; p < path.length; ++p) {
            int ci = tmodel.getIndexOfChild(curnode.getSourceNode(), path[p]);
            TreeView.TreeNodeAdaptor child = (TreeView.TreeNodeAdaptor)curnode.getChildNoLoad(ci);
            if (child == null) {
                this.createChildren(sb, curnode);
                child = (TreeView.TreeNodeAdaptor)curnode.getChildAt(ci);
            }
            sb.append("sas_TreeView_tree.setNodeState(sas_TreeView_node,true);\n");
            sb.append("sas_TreeView_node = sas_TreeView_node.children[" + ci + "];\n");
            curnode = child;
        }
    }

    private void createChildren(StringBuffer sb, TreeNodeInterface node) {
        for (int c = 0; c < node.getChildCount(); ++c) {
            try {
                TreeNodeInterface child = (TreeNodeInterface)node.getChildAt(c);
                this.writeJavaScriptNodeCode(sb, child, "child");
                sb.append("sas_TreeView_node.addNode(child);\n");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getNodeLevelName(int i) {
        if (i < 0 || i > 9) {
            return NODENAME_ROOT + i;
        }
        return nodeLevelNames[i];
    }

    public void saveToList(ArrayList treestates, int treenum) {
        TreeState.saveToList(treestates, treenum, this.tree);
    }

    public boolean loadFrom(ArrayList treestates, int treenumint) {
        return TreeState.loadFrom(treestates, treenumint, this.tree);
    }

    static {
        for (int i = 0; i < 10; ++i) {
            TreeViewFull.nodeLevelNames[i] = NODENAME_ROOT + i;
        }
    }

    @SASScope
    static class TreeState {
        TreeModel treeModel = null;
        TreeNodeInterface root = null;
        HashMap nodeMap = null;

        TreeState() {
        }

        TreeState(TreeView tv) {
            this.getFrom(tv);
        }

        void getFrom(TreeView tv) {
            this.treeModel = tv.getModel();
            this.root = tv.getRoot();
            this.nodeMap = tv.nodeMap;
        }

        void restoreTo(TreeView tv) {
            tv.setModel(this.treeModel);
            tv.nodeMap = this.nodeMap;
            tv.setRoot(this.root);
        }

        static void saveToList(ArrayList treestates, int treenum, TreeView tv) {
            if (treenum >= 0) {
                for (int fill = treestates.size(); fill <= treenum; ++fill) {
                    treestates.add(new TreeState());
                }
                TreeState treeState = (TreeState)treestates.get(treenum);
                treeState.getFrom(tv);
            }
        }

        static boolean loadFrom(ArrayList treestates, int treenumint, TreeView tv) {
            TreeState treeState = null;
            if (treenumint < treestates.size()) {
                treeState = (TreeState)treestates.get(treenumint);
                TreeModel model = null;
                if (treeState != null) {
                    model = treeState.treeModel;
                }
                if (model != null) {
                    treeState.restoreTo(tv);
                    return true;
                }
            }
            return false;
        }
    }

    @SASScope
    public static class RemoteScriptForm
    extends Form {
        private String iframeName;
        private String remoteScriptURL = "MethodInvocationServlet";
        private BaseTransformation sourceTBean;
        private List hiddenParms = new Vector();

        public RemoteScriptForm() {
        }

        public RemoteScriptForm(String name) {
            super(name);
            this.setAction(null);
        }

        public RemoteScriptForm(BaseTransformation tbean) {
            this(tbean.getId() + "_RSForm");
            this.setVisible(true);
            this.setSourceTBean(tbean);
        }

        private void initWithTBean() {
            if (this.getRequest() == null) {
                this.setRequest(this.getSourceTBean().getRequest());
            }
            if (this.getResponse() == null) {
                this.setResponse(this.getSourceTBean().getResponse());
            }
            if (this.getAction() == null) {
                this.setAction(this.getRemoteScriptURL());
            }
        }

        @Override
        public void write(PrintWriter out) throws IOException {
            this.initWithTBean();
            if (this.getTarget() == null || this.getTarget().length() == 0) {
                this.setTarget(this.getIframeName());
            }
            this.writeHeader(out);
            this.writeHiddenFields(out);
            this.writeFooter(out);
            this.writeRemoteScriptFrame(out);
            this.cleanUpResources();
        }

        protected void writeHiddenFields(PrintWriter out) {
            this.writeHiddenField(out, "CLASS_PARAMETER", this.getSourceTBean().getClass().getName());
            for (int i = 0; i < this.hiddenParms.size(); ++i) {
                String[] pair = (String[])this.hiddenParms.get(i);
                this.writeHiddenField(out, pair[0], pair[1]);
            }
            this.writeHiddenField(out, "sas_charEncoding", BaseUtil.getOutputCharacterEncoding(this.getRequest()));
        }

        private void writeHiddenField(PrintWriter out, String name, String value) {
            Hidden.writeElement(out, null, name, value, true);
        }

        public void writeRemoteScriptFrame(PrintWriter out) throws IOException {
            if (this.getTarget() == null || this.getTarget().length() == 0) {
                return;
            }
            HtmlUtil.writeHiddenIFrame(out, this.getIframeName(), this.getRequest());
        }

        public String getRemoteScriptURL() {
            if (this.getRequest() != null) {
                StringBuffer urlString = new StringBuffer();
                urlString.append(this.getRequest().getContextPath()).append("/").append(this.remoteScriptURL);
                return urlString.toString();
            }
            return this.remoteScriptURL;
        }

        public void setRemoteScriptURL(String url) {
            this.remoteScriptURL = url;
        }

        public String getIframeName() {
            if (this.iframeName == null) {
                this.iframeName = this.getSourceTBean().getId() + "_RSIFrame";
            }
            return this.iframeName;
        }

        public void setIframeName(String iframeName) {
            this.iframeName = iframeName;
        }

        public BaseTransformation getSourceTBean() {
            return this.sourceTBean;
        }

        public void setSourceTBean(BaseTransformation transformation) {
            this.sourceTBean = transformation;
        }

        public void addParm(String name, String value) {
            this.hiddenParms.add(new String[]{name, value});
        }
    }
}

