/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.models.TreeNode;
import com.sas.servlet.tbeans.models.TreeTableNode;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

@SASScope
class TreeTableModelAdapter
implements TableModel,
SortableInterface {
    private TreeTableNode _root;
    private List _columns;
    private int _curIndex;
    private TreeTableNode _curNode;
    private List _treeList;
    private SortableInterface _sorter;

    public TreeTableModelAdapter(TreeTableNode root, List columns) {
        this._root = root;
        this._columns = columns;
        this.resetIndex();
    }

    @Override
    public int getRowCount() {
        int ret = this.getRowCount(this._root) - 1;
        return ret;
    }

    private int getRowCount(TreeNode node) {
        int count = 1;
        if (node.isExpanded()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode nextNode = (TreeNode)node.getChildAt(i);
                count += this.getRowCount(nextNode);
            }
        }
        return count;
    }

    @Override
    public int getColumnCount() {
        return this._columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this._columns.get(columnIndex).toString();
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.getNodeAt(rowIndex);
        if (columnIndex == 0) {
            if (this._treeList != null) {
                return this._treeList.get(rowIndex);
            }
            return this._curNode.getText();
        }
        return this._curNode.getColumn(columnIndex - 1);
    }

    private TreeNode getNodeAt(int rowIndex) {
        if (this._curIndex > rowIndex) {
            this.resetIndex();
        }
        while (this._curIndex < rowIndex) {
            this._curNode = this._curNode == null ? this._root : this.getNextNode(this._curNode);
            ++this._curIndex;
        }
        return this._curNode;
    }

    private TreeTableNode getNextNode(TreeTableNode curNode) {
        if (curNode.isExpanded() && curNode.getChildCount() > 0) {
            return (TreeTableNode)curNode.getChildAt(0);
        }
        return this.getNextNodeFromLastChild(curNode);
    }

    private TreeTableNode getNextNodeFromLastChild(TreeTableNode curNode) {
        TreeTableNode next = (TreeTableNode)curNode.getNextSibling();
        if (next != null) {
            return next;
        }
        return this.getNextNodeFromLastChild((TreeTableNode)curNode.getParent());
    }

    private void resetIndex() {
        this._curIndex = 0;
        this._curNode = this._root;
        if (this._curNode.getChildCount() > 0) {
            this._curNode = (TreeTableNode)this._root.getChildAt(0);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public List getColumns() {
        return this._columns;
    }

    public TreeTableNode getRoot() {
        return this._root;
    }

    public List getTreeList() {
        return this._treeList;
    }

    public void setColumns(List list) {
        this._columns = list;
    }

    public void setRoot(TreeTableNode node) {
        this._root = node;
    }

    public void setTreeList(List list) {
        this._treeList = list;
    }

    public String[] getSortedColumns() {
        return this._sorter.getSortedColumns();
    }

    public int[] getSortedDirections() {
        return this._sorter.getSortedDirections();
    }

    public boolean isColumnSortable(String columnName) {
        return this._sorter.isColumnSortable(columnName);
    }

    public boolean isSortAllowed() {
        return this._sorter.isSortAllowed();
    }

    public void setSortAllowed(boolean allowed) {
        this._sorter.setSortAllowed(allowed);
    }

    public void sort(String[] columnNames, int[] direction) throws SortException {
        this._sorter.sort(columnNames, direction);
    }

    public SortableInterface getSorter() {
        return this._sorter;
    }

    public void setSorter(SortableInterface sorter) {
        this._sorter = sorter;
    }
}

