/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.html.TreeViewFull;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ListModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

@SASScope
public class TreeExpandAction {
    TreeView _tree;
    boolean _useIFrame = false;

    public TreeExpandAction(TreeView tree) {
        this._tree = tree;
    }

    public void expand(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        out.println("");
        String nodename = request.getParameter("childrenOf");
        String nodeState = request.getParameter("nodeState");
        boolean fullExpansion = "".equals(request.getParameter("fullExpansion"));
        boolean findNode = "".equals(request.getParameter("findNode"));
        boolean childrenCreated = "true".equalsIgnoreCase(request.getParameter("childrenCreated"));
        TreeView tv = this._tree;
        TreeViewFull tvf = new TreeViewFull(tv);
        TreeNodeInterface root = tv.getRoot();
        TreeNodeInterface node = tv.findNode(nodename);
        if (node == null) {
            node = TreeView.findNode(nodename, root);
        }
        if (node == null) {
            return;
        }
        if (nodeState != null) {
            if (nodeState.equals("collapse")) {
                node.setExpanded(false);
                return;
            }
            if (nodeState.equals("expand")) {
                if (fullExpansion) {
                    this.setFullExpanded(node);
                } else {
                    node.setExpanded(true);
                }
            } else if (node.isExpanded()) {
                node.setExpanded(false);
            } else {
                node.setExpanded(true);
            }
        }
        ListModel selected = null;
        if (tv.isCheckboxSelectionMode() || tv.isRadioboxSelectionMode()) {
            selected = tv.getSelectedNodes();
        }
        this.writeStart(out);
        if (findNode) {
            DefaultTreeModel nModel = new DefaultTreeModel(root);
            TreeNode[] path = nModel.getPathToRoot(node);
            if (path != null && path.length > 0) {
                Object[] wKids = request.getParameterValues("wKids");
                String nName = null;
                for (int i = 0; i < path.length; ++i) {
                    TreeNodeInterface dNext = (TreeNodeInterface)path[i];
                    nName = dNext.getName();
                    if (Util.arrayContains((Object[])wKids, (Object)nName)) continue;
                    this.writeJsSubtreeCode(out, nName, tvf, dNext, selected, false);
                }
                out.println("sas_TreeView_selectNode(" + this._tree.getId() + "_Obj.getNode(\"" + TreeViewFull.escapeTreeText(nodename) + "\"));");
            }
        } else {
            Vector toCreate = new Vector();
            Vector toExpand = new Vector();
            if (fullExpansion) {
                String[] wKids = request.getParameterValues("wKids");
                this.getNodesToCreateExpand(node, toCreate, toExpand, node.getName(), wKids);
            } else {
                this.getNodesToCreateExpand(node, toCreate, toExpand, node.getName(), fullExpansion, childrenCreated);
            }
            for (TreeNodeInterface next : toCreate) {
                this.writeJsSubtreeCode(out, next.getName(), tvf, next, selected, fullExpansion);
            }
            if (node.isExpanded()) {
                for (TreeNodeInterface next : toExpand) {
                    String nName = Util.getName((String)"e");
                    out.println("var " + nName + "=" + this._tree.getId() + "_Obj.getNode(\"" + TreeViewFull.escapeTreeText(next.getName()) + "\");");
                    out.println(nName + ".tree.setNodeState(" + nName + ",true);");
                }
            }
        }
        this.writeEnd(out);
    }

    private void writeStart(PrintWriter out) {
        if (!this._useIFrame) {
            return;
        }
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("with (window.parent) {");
    }

    private void writeEnd(PrintWriter out) {
        if (!this._useIFrame) {
            return;
        }
        out.println("}");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private void getNodesToCreateExpand(TreeNodeInterface node, Vector toCreate, Vector toExpand, String eIgnore, boolean fullExpansion, boolean childrenCreated) {
        int nKids = node.getChildCount();
        if (nKids > 0) {
            if (childrenCreated) {
                if (!eIgnore.equals(node.getName())) {
                    toExpand.add(node);
                }
            } else {
                toCreate.add(node);
            }
        }
        TreeNodeInterface kid = null;
        for (int i = 0; i < nKids; ++i) {
            kid = (TreeNodeInterface)node.getChildAt(i);
            if (!fullExpansion && !kid.isExpanded()) continue;
            this.getNodesToCreateExpand(kid, toCreate, toExpand, eIgnore, fullExpansion, fullExpansion ? false : childrenCreated);
        }
    }

    private void getNodesToCreateExpand(TreeNodeInterface node, Vector toCreate, Vector toExpand, String eIgnore, String[] wKids) {
        int nKids = node.getChildCount();
        if (nKids > 0) {
            if (wKids != null && Util.arrayContains((Object[])wKids, (Object)node.getName())) {
                if (!eIgnore.equals(node.getName()) && !node.isExpanded()) {
                    toExpand.add(node);
                }
            } else {
                toCreate.add(node);
            }
        }
        for (int i = 0; i < nKids; ++i) {
            this.getNodesToCreateExpand((TreeNodeInterface)node.getChildAt(i), toCreate, toExpand, eIgnore, wKids);
        }
    }

    private void writeJsSubtreeCode(PrintWriter out, String nodeName, TreeViewFull tvf, TreeNodeInterface node, ListModel selected, boolean fullExpansion) {
        if (this._tree.isRenderUsingDivs()) {
            this.writeJsSubtreeCodeUsingDivs(out, nodeName, tvf, node, selected, fullExpansion);
        } else {
            out.println("var p=" + this._tree.getId() + "_Obj.getNode(\"" + TreeViewFull.escapeTreeText(nodeName) + "\");");
            for (int i = 0; i < node.getChildCount(); ++i) {
                try {
                    TreeNodeInterface child = (TreeNodeInterface)node.getChildAt(i);
                    String str = tvf.getJavaScriptNodeCode(child, "n");
                    out.println(str);
                    out.println("p.addNode(n);");
                    TreeExpandAction.updateCheckboxSelections(child, selected, out);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            out.println("p.childrenCreated=true;");
            out.println("p.tree.setNodeState(p,true);");
            if (this._useIFrame) {
                out.println("sas_TreeView_processPostExpandNodeFunction(p);");
            }
        }
    }

    private void writeJsSubtreeCodeUsingDivs(PrintWriter out, String nodeName, TreeViewFull tvf, TreeNodeInterface node, ListModel selected, boolean fullExpansion) {
        String aName = fullExpansion ? Util.getName((String)"k") : "k";
        out.println("var " + aName + "=[];");
        String pName = fullExpansion ? Util.getName((String)"p") : "p";
        out.println("var " + pName + "=" + this._tree.getId() + "_Obj.getNode(\"" + TreeViewFull.escapeTreeText(nodeName) + "\");");
        int numChildren = node.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            TreeNodeInterface child = (TreeNodeInterface)node.getChildAt(i);
            String vName = fullExpansion ? Util.getName((String)"n") : "n";
            try {
                if (fullExpansion) {
                    child.setExpanded(true);
                }
                String str = tvf.getJavaScriptNodeCode(child, vName);
                out.println(str);
                out.println(pName + ".addChild(" + vName + ");");
                TreeExpandAction.updateCheckboxSelections(child, selected, out);
                out.println(aName + "[" + i + "]=" + vName + ";");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        out.println(pName + ".addNodes(" + aName + ");");
        out.println(pName + ".tree.setNodeState(" + pName + ",true);");
        if (this._useIFrame) {
            out.println("sas_TreeView_processPostExpandNodeFunction(" + pName + ");");
        }
        node.setExpanded(true);
        out.println("if(" + pName + ".tree.dndConfig)");
        out.println("\tfor (var i=0; i<" + pName + ".children.length; i++)");
        out.println("\t\tsas_DnD_Tree_buildFolder(" + pName + ".children[i]);");
    }

    private void setFullExpanded(TreeNodeInterface node) {
        node.setExpanded(true);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setFullExpanded((TreeNodeInterface)node.getChildAt(i));
        }
    }

    private static void updateCheckboxSelections(TreeNodeInterface node, ListModel selected, PrintWriter out) {
        if (selected != null) {
            for (int j = 0; j < selected.getSize(); ++j) {
                TreeNodeInterface selnode = (TreeNodeInterface)selected.getElementAt(j);
                if (selnode != node) continue;
                out.println("sas_TreeView_cbCheck(sas_TreeView_level0, true);");
            }
        }
    }

    public void setUseIFrame(boolean useIFrame) {
        this._useIFrame = useIFrame;
    }

    public boolean isUseIFrame() {
        return this._useIFrame;
    }
}

