/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.TimeStampType;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.html.ComboBoxView;
import com.sas.servlet.tbeans.form.html.Image;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Calendar;
import com.sas.servlet.tbeans.html.DatePicker;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.html.TimeStamp;
import com.sas.servlet.tbeans.html.TimeStampPickerPopupWindow;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.util.validators.DateTimeStringValidator;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.DateUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.text.Message;
import com.sas.text.NLInformats;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;

@SASScope
public class TimeStampPicker
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface {
    private ResourceBundle bundle;
    private static final String RB_KEY = "TimeStampPicker.";
    public static final String DEFAULT_AJAX_PALETTE_URL_TEMPLATE = "%BASE_AJAX_URL(%BASE_AJAX_URL)%AJAX_URL_SUFFIX(%AJAX_URL_SUFFIX)CLASS_PARAMETER=" + TimeStampPicker.class.getName() + "&id=%id";
    public static final String TIMESTAMPPICKER_CONTAINER_STYLE = "TIMESTAMPPICKER_CONTAINER";
    public static final String TIMESTAMPPICKER_COMBO_STYLE = "TIMESTAMPPICKER_COMBO";
    public static final String TIMESTAMPPICKER_LABEL_STYLE = "TIMESTAMPPICKER_LABEL";
    public static final String TIMESTAMPPICKER_NTIMELABEL_STYLE = "TIMESTAMPPICKER_NTIMELABEL";
    public static final String TIMESTAMPPICKER_TEXTENTRY_STYLE = "TIMESTAMPPICKER_TEXTENTRY";
    public static final String TIMESTAMPPICKER_N_TEXTENTRY_STYLE = "TIMESTAMPPICKER_N_TEXTENTRY";
    public static final String TIMESTAMPPICKER_BUTTON_STYLE = "TIMESTAMPPICKER_BUTTON";
    public static final String TIMESTAMPPICKER_LAUNCH_IMAGE_CELL_STYLE = "TIMESTAMPPICKER_LAUNCH_IMAGE_CELL";
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "TimeStampPicker.html";
    public static final String TIMESTAMP_COMPONENT = "TIMESTAMP_COMPONENT";
    public static final String LAUNCH_TIMESTAMP_COMPONENT = "LAUNCH_TIMESTAMP_COMPONENT";
    public static final String COMBOBOX_COMPONENT = "COMBOBOX_COMPONENT";
    public static final String COMBO_LABEL_COMPONENT = "COMBO_LABEL_COMPONENT";
    public static final String N_TIME_LABEL_COMPONENT = "N_TIME_LABEL_COMPONENT";
    public static final String TEXTENTRY_COMPONENT = "TEXTENTRY_COMPONENT";
    public static final String N_TEXTENTRY_COMPONENT = "N_TEXTENTRY_COMPONENT";
    public static final String TIMESTAMP_OK_BUTTON = "TIMESTAMP_OK_BUTTON";
    public static final String TIMESTAMP_CANCEL_BUTTON = "TIMESTAMP_CANCEL_BUTTON";
    private static HashMap defaultStyleMap;
    private MapWithDefaults componentStyleMap;
    private boolean enabled = true;
    private boolean relativeValuesIncluded = false;
    private boolean labelsVisible = false;
    private String title;
    private String onChange = null;
    private String onFocus = null;
    private String onBlur = null;
    private TimeStamp timeStamp = null;
    private Image launchImage = null;
    private ComboBoxView combo;
    private Label comboLabel;
    private Label nTimeLabel;
    private TextEntry nTextEntry = null;
    private TextEntry textEntry = null;
    private Date date = null;
    private ComboBoxModel comboModel = null;
    private Button okbtn;
    private Button cancelbtn;
    private TimeZone timezone = null;
    private SimpleDateFormat dateFormat = null;
    private int defaultDateStylePattern = 1;
    private Object initialValue;
    private DateTimeStringValidator validator = null;
    private boolean validationEnabled = false;
    private boolean isRelativeValuesAddedToModel = false;
    private SimpleTemplate ajaxURLTemplate;
    private SimpleTemplate ajaxPaletteURLTemplate;
    private boolean honor24HourLocale;

    public TimeStampPicker() {
        this(null);
    }

    public TimeStampPicker(String Id) {
        if (Id == null) {
            this.setId(Util.getName((String)"timeStamp_picker"));
        } else {
            this.setId(Id);
        }
        this.setObjectDataProperty("initialValue");
        this.setTemplateKey("Time_Stamp_Picker");
        this.componentStyleMap = new MapWithDefaults(TimeStampPicker.getDefaultStyleMap());
        this.ajaxURLTemplate = new SimpleTemplate();
        this.ajaxURLTemplate.setTemplate(DateUtil.DEFAULT_AJAX_URL_RELATIVE_VALUE_TEMPLATE);
        this.ajaxURLTemplate.setValueDictionary(new HashMap());
        this.ajaxPaletteURLTemplate = new SimpleTemplate();
        this.ajaxPaletteURLTemplate.setTemplate(DEFAULT_AJAX_PALETTE_URL_TEMPLATE);
        this.ajaxPaletteURLTemplate.setValueDictionary(new HashMap());
        this.setHonor24HourLocale(false);
        this.addComponents();
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        this.timeStamp.setHonor24HourLocale(this.isHonor24HourLocale());
        this.bundle = ResourceBundle.getBundle("com.sas.servlet.tbeans.html.Resources", locale);
        Button okbtn = (Button)this.getComponent(TIMESTAMP_OK_BUTTON);
        okbtn.setLabel(this.bundle.getString("TimeStampPicker.ok.txt"));
        Button cancelbtn = (Button)this.getComponent(TIMESTAMP_CANCEL_BUTTON);
        cancelbtn.setLabel(this.bundle.getString("TimeStampPicker.cancel.txt"));
        this.setDescription(this.bundle.getString("TimeStampPicker.description.txt"));
    }

    private static Map getDefaultStyleMap() {
        if (defaultStyleMap == null) {
            defaultStyleMap = new HashMap();
            ImmutableStyleInfo timeStampPickerContainerStyle = new ImmutableStyleInfo("timePickerContainer");
            defaultStyleMap.put(TIMESTAMPPICKER_CONTAINER_STYLE, timeStampPickerContainerStyle);
            ImmutableStyleInfo timeStampPickerComboStyle = new ImmutableStyleInfo("timePickerCombo");
            defaultStyleMap.put(TIMESTAMPPICKER_COMBO_STYLE, timeStampPickerComboStyle);
            ImmutableStyleInfo timeStampPickerLabelStyle = new ImmutableStyleInfo("timePickerLabel");
            defaultStyleMap.put(TIMESTAMPPICKER_LABEL_STYLE, timeStampPickerLabelStyle);
            ImmutableStyleInfo timeStampPickerNTimeLabelStyle = new ImmutableStyleInfo("timePickerNTimeLabel");
            defaultStyleMap.put(TIMESTAMPPICKER_NTIMELABEL_STYLE, timeStampPickerNTimeLabelStyle);
            ImmutableStyleInfo timeStampPickerNTextEntryStyle = new ImmutableStyleInfo("timePickerNTextEntry");
            defaultStyleMap.put(TIMESTAMPPICKER_N_TEXTENTRY_STYLE, timeStampPickerNTextEntryStyle);
            ImmutableStyleInfo timeStampPickerTextEntryStyle = new ImmutableStyleInfo("timePickerTextEntry");
            defaultStyleMap.put(TIMESTAMPPICKER_TEXTENTRY_STYLE, timeStampPickerTextEntryStyle);
            ImmutableStyleInfo timeStampButtonStyle = new ImmutableStyleInfo("timePickerButton");
            defaultStyleMap.put(TIMESTAMPPICKER_BUTTON_STYLE, timeStampButtonStyle);
            ImmutableStyleInfo timeStampPickerLaunchImageCellStyle = new ImmutableStyleInfo("timeStampPickerLaunchImageCell");
            defaultStyleMap.put(TIMESTAMPPICKER_LAUNCH_IMAGE_CELL_STYLE, timeStampPickerLaunchImageCellStyle);
        }
        return defaultStyleMap;
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.timeStamp = new TimeStamp(this.getId() + "_TimeStamp");
            this.setComponent(TIMESTAMP_COMPONENT, this.timeStamp);
            this.launchImage = new Image();
            this.launchImage.setId(this.getId() + "_LaunchImage");
            this.launchImage.setStyle("cursor: pointer;");
            this.launchImage.setUseAsFormElement(false);
            this.launchImage.setRequest(this.getRequest());
            this.launchImage.setTabIndex("0");
            this.setComponent(LAUNCH_TIMESTAMP_COMPONENT, this.launchImage);
            this.validator = new DateTimeStringValidator();
            this.textEntry = new TextEntry();
            this.textEntry.setId(this.getId());
            this.textEntry.setStyleInfo((ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_TEXTENTRY_STYLE));
            this.textEntry.setRequest(this.getRequest());
            this.setComponent(TEXTENTRY_COMPONENT, this.textEntry);
            this.combo = new ComboBoxView();
            this.combo.setId(this.getId() + "_combo");
            this.combo.setStyleInfo((ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_COMBO_STYLE));
            this.combo.setEditable(true);
            this.combo.setRenderUsingIFrame(true);
            this.combo.setRequest(this.getRequest());
            this.combo.getStyleMap().put("COMBOBOXVIEW_FRAME_SELECT", (ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_COMBO_STYLE));
            this.setComponent(COMBOBOX_COMPONENT, this.combo);
            this.okbtn = new Button();
            this.okbtn.setId(this.getId() + "_okbtn");
            this.okbtn.setRequest(this.getRequest());
            this.okbtn.getStyleMap().put("BUTTON_STYLE", (ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_BUTTON_STYLE));
            this.setComponent(TIMESTAMP_OK_BUTTON, this.okbtn);
            this.cancelbtn = new Button();
            this.cancelbtn.setId(this.getId() + "_cancelbtn");
            this.cancelbtn.setRequest(this.getRequest());
            this.cancelbtn.getStyleMap().put("BUTTON_STYLE", (ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_BUTTON_STYLE));
            this.setComponent(TIMESTAMP_CANCEL_BUTTON, this.cancelbtn);
        }
    }

    public void enableValidation() {
        this.validationEnabled = true;
    }

    public ValidationInterface getValidator() {
        return this.validator;
    }

    protected void addNComponents() {
        this.nTimeLabel = new Label();
        this.nTimeLabel.setId(this.getId() + "_nTimeLabel");
        this.nTimeLabel.setStyleInfo((ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_NTIMELABEL_STYLE));
        this.nTimeLabel.setRequest(this.getRequest());
        this.setComponent(N_TIME_LABEL_COMPONENT, this.nTimeLabel);
        this.nTextEntry = new TextEntry();
        this.nTextEntry.setId(this.getId() + "_te");
        this.nTextEntry.setStyleInfo((ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_N_TEXTENTRY_STYLE));
        this.nTextEntry.setRequest(this.getRequest());
        this.nTextEntry.setCustomAttributes("autocomplete=\"OFF\"");
        this.setComponent(N_TEXTENTRY_COMPONENT, this.nTextEntry);
    }

    protected void addLabelComponents() {
        this.comboLabel = new Label();
        this.comboLabel.setId(this.getId() + "_comboLabel");
        this.comboLabel.setText(RB.getStringResource(RB_KEY, "comboLabel.txt", this.getLocale()));
        this.comboLabel.setStyleInfo((ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_LABEL_STYLE));
        this.comboLabel.setRequest(this.getRequest());
        this.setComponent(COMBO_LABEL_COMPONENT, this.comboLabel);
    }

    public void setRelativeValuesAddedToModel(boolean relativeValuesAdded) {
        this.isRelativeValuesAddedToModel = relativeValuesAdded;
    }

    public ComboBoxModel getComboModel() {
        Locale locale = this.getLocale();
        TimeZone tz = this.getTimeZone();
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        if (this.comboModel == null) {
            this.comboModel = new DefaultComboBoxModel();
        }
        if (this.isRelativeValuesIncluded() && !this.isRelativeValuesAddedToModel) {
            JavaScriptNode curDateTimeNode = new JavaScriptNode();
            curDateTimeNode.setValue(new DatePeriod(DateTypes.TIMESTAMP, tz, locale).toString());
            curDateTimeNode.setText(RB.getStringResource(RB_KEY, "currentDateAndTime.txt", locale));
            JavaScriptNode prevYearNode = new JavaScriptNode();
            prevYearNode.setValue(new DatePeriod(DateTypes.TIMESTAMP, -1, 0, 0, 0, 0, 0, 0, tz, locale).toString());
            prevYearNode.setText(RB.getStringResource(RB_KEY, "currentDateAndTimePreviousYear.txt", locale));
            JavaScriptNode nxtYearNode = new JavaScriptNode();
            nxtYearNode.setValue(new DatePeriod(DateTypes.TIMESTAMP, 1, 0, 0, 0, 0, 0, 0, tz, locale).toString());
            nxtYearNode.setText(RB.getStringResource(RB_KEY, "currentDateAndTimeNextYear.txt", locale));
            JavaScriptNode curHourNode = new JavaScriptNode();
            curHourNode.setValue(new DatePeriod(DateTypes.HOUR, tz, locale).toString());
            curHourNode.setText(RB.getStringResource(RB_KEY, "currentHour.txt", locale));
            JavaScriptNode prevHourNode = new JavaScriptNode();
            prevHourNode.setValue(new DatePeriod(DateTypes.HOUR, 0, 0, 0, 0, 0, -1, 0, tz, locale).toString());
            prevHourNode.setText(RB.getStringResource(RB_KEY, "previousHour.txt", locale));
            JavaScriptNode nxtHourNode = new JavaScriptNode();
            nxtHourNode.setValue(new DatePeriod(DateTypes.HOUR, 0, 0, 0, 0, 0, 1, 0, tz, locale).toString());
            nxtHourNode.setText(RB.getStringResource(RB_KEY, "nextHour.txt", locale));
            JavaScriptNode curMinNode = new JavaScriptNode();
            curMinNode.setValue(new DatePeriod(DateTypes.MINUTE, tz, locale).toString());
            curMinNode.setText(RB.getStringResource(RB_KEY, "currentMinute.txt", locale));
            JavaScriptNode prevMinNode = new JavaScriptNode();
            prevMinNode.setValue(new DatePeriod(DateTypes.MINUTE, 0, 0, 0, 0, 0, 0, -1, tz, locale).toString());
            prevMinNode.setText(RB.getStringResource(RB_KEY, "previousMinute.txt", locale));
            JavaScriptNode nxtMinNode = new JavaScriptNode();
            nxtMinNode.setValue(new DatePeriod(DateTypes.MINUTE, 0, 0, 0, 0, 0, 0, 1, tz, locale).toString());
            nxtMinNode.setText(RB.getStringResource(RB_KEY, "nextMinute.txt", locale));
            JavaScriptNode nHoursAgoNode = new JavaScriptNode();
            nHoursAgoNode.setValue("T-NH");
            nHoursAgoNode.setText(RB.getStringResource(RB_KEY, "nHoursAgo.txt", locale));
            JavaScriptNode nHoursFromNowNode = new JavaScriptNode();
            nHoursFromNowNode.setValue("TNH");
            nHoursFromNowNode.setText(RB.getStringResource(RB_KEY, "nHoursFromNow.txt", locale));
            JavaScriptNode nMinutesAgoNode = new JavaScriptNode();
            nMinutesAgoNode.setValue("T-Nm");
            nMinutesAgoNode.setText(RB.getStringResource(RB_KEY, "nMinutesAgo.txt", locale));
            JavaScriptNode nMinutesFromNowNode = new JavaScriptNode();
            nMinutesFromNowNode.setValue("TNm");
            nMinutesFromNowNode.setText(RB.getStringResource(RB_KEY, "nMinutesFromNow.txt", locale));
            ((MutableComboBoxModel)this.comboModel).insertElementAt(curDateTimeNode, 0);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(prevYearNode, 1);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nxtYearNode, 2);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(curHourNode, 3);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(prevHourNode, 4);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nxtHourNode, 5);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(curMinNode, 6);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(prevMinNode, 7);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nxtMinNode, 8);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nHoursAgoNode, 9);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nHoursFromNowNode, 10);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nMinutesAgoNode, 11);
            ((MutableComboBoxModel)this.comboModel).insertElementAt(nMinutesFromNowNode, 12);
            this.isRelativeValuesAddedToModel = true;
        }
        return this.comboModel;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        ImmutableStyleInfo launchImageCellStyle;
        HashMap<String, String> dictionary;
        super.write(out);
        JavaScriptIncludeHandler.writeIncludes(out, "TIMESTAMPPICKER", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "MODALSELECTOR", this.getRequest());
        this.writeFastClickProtection(out);
        ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        if (this.getModel() != null || this.isRelativeValuesIncluded()) {
            this.combo.setModel(this.getComboModel());
            this.textEntry.setVisible(false);
            if (this.validationEnabled) {
                this.combo.setValidator(this.validator);
            }
        } else {
            if (this.validationEnabled) {
                this.validator.setValidationOnChange(true);
                this.textEntry.setValidator(this.validator);
            }
            this.combo.setVisible(false);
        }
        if (this.validator instanceof DateTimeStringValidator) {
            this.validator.setContainerId("container_" + this.getId());
        }
        if (this.isLabelsVisible()) {
            this.addLabelComponents();
        }
        if (this.isRelativeValuesIncluded()) {
            this.addNComponents();
        }
        if ((dictionary = this.getTemplateDictionary()) == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("TIMESTAMPPICKER_ID", this.getId());
        ImmutableStyleInfo containerStyle = (ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_CONTAINER_STYLE);
        if (containerStyle.getClassid() != null) {
            dictionary.put("TIMESTAMPPICKER_CONTAINER_CLASS", containerStyle.getClassid());
        }
        if ((launchImageCellStyle = (ImmutableStyleInfo)this.getStyleMap().get(TIMESTAMPPICKER_LAUNCH_IMAGE_CELL_STYLE)).getClassid() != null) {
            dictionary.put("TIMESTAMPPICKER_LAUNCH_IMAGE_CELL_CLASS", launchImageCellStyle.getClassid());
        }
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        if (this.isEnabled()) {
            this.launchImage.setImage(cpm.getImageURI("Time_Stamp"));
        } else {
            this.launchImage.setImage(cpm.getImageURI("Time_Stamp_Disabled"));
        }
        if (this.getTitle() != null) {
            dictionary.put("TIMESTAMPPICKER_TITLE", this.getTitle());
        }
        this.launchImage.setOnClick("if(" + this.getId() + "_Obj.enabled==true) {" + this.getId() + "_Obj.toggleTimeStampVisibility();}");
        this.launchImage.setOnKeyDown("if((" + this.getId() + "_Obj.enabled==true)&& event.keyCode==13) {" + this.getId() + "_Obj.toggleTimeStampVisibility();}");
        this.textEntry.setOnKeyDown("if(" + this.getId() + "_Obj.enabled==true) {sas_TimeStampPicker_checkAltDownArrow(event, '" + this.getId() + "_Obj.toggleTimeStampVisibility();');}");
        if (this.getOnChange() != null) {
            this.textEntry.setOnChange("sas_TimeStampPicker_checkForNSelection(event, '" + this.getId() + "', '" + this.combo.getId() + "');" + this.getOnChange());
            this.combo.setOnChange("sas_TimeStampPicker_checkForNSelection(event, '" + this.getId() + "', '" + this.combo.getId() + "'); if(" + this.getId() + "_Obj.comboComponent.getSelectedIndex()==-1){" + this.getId() + "_Obj.hideNSelection();} if(document.getElementById('" + this.getId() + "_te')==null){" + this.getOnChange() + ";} else if(" + this.getId() + "_Obj.comboComponent.getSelectedIndex()< 9 || " + this.getId() + "_Obj.comboComponent.getSelectedIndex()> 12){" + this.getOnChange() + ";}");
        } else {
            this.combo.setOnChange("sas_TimeStampPicker_checkForNSelection(event, '" + this.getId() + "', '" + this.combo.getId() + "'); if(" + this.getId() + "_Obj.comboComponent.getSelectedIndex()==-1){" + this.getId() + "_Obj.hideNSelection();}");
            this.textEntry.setOnChange("sas_TimeStampPicker_checkForNSelection(event, '" + this.getId() + "', '" + this.combo.getId() + "');");
        }
        if (this.getOnFocus() != null) {
            this.launchImage.setOnFocus(this.getOnFocus());
            this.launchImage.setTabIndex("0");
            this.combo.setOnFocus(this.getOnFocus());
            this.textEntry.setOnFocus(this.getOnFocus());
        }
        if (this.getOnBlur() != null) {
            this.launchImage.setOnBlur(this.getOnBlur());
            this.launchImage.setTabIndex("0");
            this.combo.setOnBlur(this.getOnBlur());
            this.textEntry.setOnBlur(this.getOnBlur());
        }
        this.okbtn.setOnClick(this.getId() + "_Obj.setTextEntryToDateAndTime();" + this.getId() + "_Obj.hideTime();");
        this.cancelbtn.setOnClick(this.getId() + "_Obj.hideTime();");
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    private void writeJavaScript(PrintWriter out) {
        Map map = this.ajaxURLTemplate.getValueDictionary();
        map.put("BASE_AJAX_URL", this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            map.put("AJAX_URL_SUFFIX", "?");
        } else {
            map.put("AJAX_URL_SUFFIX", "&");
        }
        map.put("id", this.getId());
        Map paletteMap = this.ajaxPaletteURLTemplate.getValueDictionary();
        paletteMap.put("BASE_AJAX_URL", this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            paletteMap.put("AJAX_URL_SUFFIX", "?");
        } else {
            paletteMap.put("AJAX_URL_SUFFIX", "&");
        }
        paletteMap.put("id", this.getId());
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("" + this.getId() + "_Obj = new sas_TimeStampPicker('" + this.getId() + "');");
        out.println(this.getId() + "_Obj.setLaunchImage('" + cpm.getImageURI("Time_Stamp") + "');\n");
        out.println(this.getId() + "_Obj.setLaunchImageDisabled('" + cpm.getImageURI("Time_Stamp_Disabled") + "');\n");
        out.println(this.getId() + "_Obj.url = '" + this.ajaxURLTemplate.format() + "';\n");
        out.println(this.getId() + "_Obj.paletteCreated = false;\n");
        out.println(this.getId() + "_Obj.palette_url = '" + this.ajaxPaletteURLTemplate.format() + "';\n");
        if (this.getOnChange() != null) {
            out.println(this.getId() + "_Obj.onChange=\"" + this.getOnChange() + "\";");
        }
        out.println(this.getId() + "_Obj.isValidationEnabled=" + this.validationEnabled + ";");
        if (this.getModel() != null || this.isRelativeValuesIncluded()) {
            out.println(this.getId() + "_Obj.setComboComponent(sas_getJavaScriptObject('" + this.combo.getId() + "'));");
            out.println(this.getId() + "_Obj.comboComponent.hiddenComponent.name=\"" + this.getId() + "\";");
            if (this.isRelativeValuesIncluded()) {
                out.println(this.getId() + "_Obj.setNTimeLabel(document.getElementById('" + this.nTimeLabel.getId() + "'));");
                out.println(this.getId() + "_Obj.setNComponent(document.getElementById('" + this.nTextEntry.getId() + "'));");
                out.println(this.getId() + "_Obj.invalidValueMessage = \"" + Message.format((String)RB.getStringResource(RB_KEY, "invalidValue.txt", this.getLocale()), (Object)this.getDescription()) + "\";");
                out.println(this.getId() + "_Obj.yearsAgoErrorMessage = \"" + RB.getStringResource(RB_KEY, "yearsAgoError.txt", this.getLocale()) + "\";");
                out.println(this.getId() + "_Obj.yearsFromNowErrorMessage = \"" + RB.getStringResource(RB_KEY, "yearsFromNowError.txt", this.getLocale()) + "\";");
            }
        } else {
            out.println(this.getId() + "_Obj.setComboComponent(document.getElementById('" + this.textEntry.getId() + "'));");
        }
        out.println(this.getId() + "_Obj.initialNValue = \"" + RB.getStringResource(RB_KEY, "initialNValue.txt", this.getLocale()) + "\";");
        if (this.isEnabled()) {
            out.println(this.getId() + "_Obj.enable();\n");
        } else {
            out.println(this.getId() + "_Obj.disable();\n");
        }
        if (this.getDate() != null || this.getInitialValue() != null) {
            java.util.Calendar cal = java.util.Calendar.getInstance();
            if (this.getDate() != null) {
                DatePeriod datePeriod = new DatePeriod(this.getDate(), DateTypes.valueOf((String)"TIMESTAMP"), this.getRequest().getLocale());
                TimeStampType dataType = new TimeStampType(this.timezone);
                SimpleDateFormat tempFormat = this.getFormat() != null ? this.getFormat() : (SimpleDateFormat)((BaseDateType)dataType).getDateFormatter(null, this.getRequest().getLocale());
                cal.setTime(this.getDate());
                if (this.timezone != null) {
                    cal.setTimeZone(this.timezone);
                    tempFormat.setTimeZone(this.timezone);
                }
                out.println(this.getId() + "_Obj.setInitialDateAndTime(\"" + DateUtil.removeBiDiCharacters(tempFormat.format((Date)datePeriod)) + "\");\n");
            } else {
                Object initVal = this.getInitialValue();
                if (initVal instanceof DatePeriod) {
                    String initValueString;
                    if (!((DatePeriod)initVal).isRelativeDate() && this.isHonor24HourLocale() && this.is24hrLocale(this.getLocale())) {
                        SimpleDateFormat _dateFormat = new SimpleDateFormat(NLInformats.getPattern((String)"NLDATML", (Locale)this.getLocale()), this.getLocale());
                        TimeZone tz = TimeZone.getTimeZone("GMT");
                        _dateFormat.setTimeZone(tz);
                        initValueString = _dateFormat.format((Date)((DatePeriod)initVal));
                    } else {
                        initValueString = ((DatePeriod)initVal).toString(null, this.getRequest().getLocale());
                    }
                    int nhours = ((DatePeriod)initVal).getNHours();
                    int nminutes = ((DatePeriod)initVal).getNMinutes();
                    if (initValueString.indexOf("T") == 0 && initValueString.endsWith("H") && initValueString.indexOf("B") != initValueString.length() - 2 && initValueString.indexOf("E") != initValueString.length() - 2 || initValueString.indexOf("T") == 0 && initValueString.endsWith("m") && initValueString.indexOf("B") != initValueString.length() - 2 && initValueString.indexOf("E") != initValueString.length() - 2 && nminutes != 0) {
                        try {
                            String replacementValue = "N";
                            String patternStr = "[0-9]{1,}";
                            Pattern pattern = Pattern.compile(patternStr);
                            Matcher matcher = pattern.matcher(initValueString);
                            initValueString = matcher.replaceAll(replacementValue);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            // empty catch block
                        }
                        if (nhours != 0) {
                            out.println(this.getId() + "_Obj.showNSelection(\"" + initValueString + "\", \"" + Math.abs(nhours) + "\");\n");
                        } else {
                            out.println(this.getId() + "_Obj.showNSelection(\"" + initValueString + "\", \"" + Math.abs(nminutes) + "\");\n");
                        }
                    } else {
                        out.println(this.getId() + "_Obj.setInitialDateAndTime(\"" + DateUtil.removeBiDiCharacters(initValueString) + "\");\n");
                        out.println("sas_TimeStampPicker_checkForNSelection(null, " + this.getId() + "_Obj.id, " + this.getId() + "_Obj.comboComponent.id)");
                    }
                } else if (initVal instanceof SpecialValues) {
                    String initValueString = ((SpecialValues)initVal).getName();
                    out.println(this.getId() + "_Obj.setInitialDateAndTime(\"" + DateUtil.removeBiDiCharacters(initValueString) + "\");\n");
                } else if (initVal instanceof MissingValues) {
                    String initValueString = MissingValues.toQueryString((MissingValues)((MissingValues)initVal));
                    out.println(this.getId() + "_Obj.setInitialDateAndTime(\"" + DateUtil.removeBiDiCharacters(initValueString) + "\");\n");
                } else {
                    out.println(this.getId() + "_Obj.setInitialDateAndTime(\"" + DateUtil.removeBiDiCharacters(initVal.toString()) + "\");\n");
                }
            }
        }
        if (!this.validationEnabled) {
            BaseFormElement bean = null;
            bean = this.getModel() != null || this.isRelativeValuesIncluded() ? this.combo : this.textEntry;
            this.validator.setValidationOnChange(false);
            out.println(this.getId() + "_Obj.isValid=function(){return " + this.validator.createValidationFunctionCall(bean) + ";}");
            this.validator.setValidationOnChange(true);
            out.println(this.getId() + "_Obj.validate=function(){return " + this.validator.createValidationFunctionCall(bean) + ";}");
            this.validator.setValidationOnChange(false);
        }
        out.println(this.getId() + "_Obj.amString = \"" + Strings.escapeForJavaScript((String)"AM") + "\";");
        out.println(this.getId() + "_Obj.pmString = \"" + Strings.escapeForJavaScript((String)"PM") + "\";");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private boolean is24hrLocale(Locale locale) {
        DateFormat instance = DateFormat.getTimeInstance(1, locale);
        String pattern = ((SimpleDateFormat)instance).toPattern();
        return pattern.indexOf("a") < 0;
    }

    private void writeFastClickProtection(PrintWriter out) throws IOException {
        out.println(JavaScriptIncludeHandler.getStartScript());
        String processText = "Awaiting confirmation";
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' ) ");
        out.println(" { ");
        out.println(" sas_FastClick_createFastClickManager(null,\"" + processText + "\");");
        out.println(" } ");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRelativeValuesIncluded() {
        return this.relativeValuesIncluded;
    }

    public void setRelativeValuesIncluded(boolean state) {
        this.relativeValuesIncluded = state;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setFormat(SimpleDateFormat newFormat) {
        this.dateFormat = newFormat;
    }

    public SimpleDateFormat getFormat() {
        return this.dateFormat;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Object initialValue) {
        this.initialValue = initialValue;
    }

    public ComboBoxModel getModel() {
        return this.comboModel;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.comboModel = comboBoxModel;
        this.isRelativeValuesAddedToModel = false;
    }

    @Override
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    public boolean isLabelsVisible() {
        return this.labelsVisible;
    }

    public void setLabelsVisible(boolean state) {
        this.labelsVisible = state;
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String pickerID = request.getParameter("pickerid");
        String date = request.getParameter("date");
        DateFormat dateFormat = null;
        DatePeriod datePeriod = null;
        TimeZone tz = TimeZone.getDefault();
        TimeStampType dataType = new TimeStampType(tz);
        int dateStylePattern = 1;
        ServletOutputStream out = response.getOutputStream();
        PrintWriter writer = new PrintWriter((OutputStream)out);
        writer.println(JavaScriptIncludeHandler.getStartScript());
        writer.print("var return_Obj = {");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID);
        if (ti != null && ti instanceof TimeStampPicker) {
            TimeStampPicker picker = (TimeStampPicker)ti;
            dateFormat = picker.getFormat();
            dateStylePattern = picker.getDefaultDateStylePattern();
        }
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateInstance(dateStylePattern, request.getLocale());
        }
        Date parsedDate = null;
        try {
            parsedDate = dateFormat.parse(date);
            if (parsedDate instanceof DatePeriod) {
                datePeriod = (DatePeriod)parsedDate;
            } else if (parsedDate instanceof Date) {
                datePeriod = new DatePeriod(parsedDate, DateTypes.DATE, request.getLocale());
            }
        }
        catch (ParseException e) {
            LoggerRepository2.getLogger((String)DatePicker.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            writer.print("error : \"" + Strings.escapeForJavaScript((String)e.getLocalizedMessage(), (boolean)true) + "\"}");
        }
        if (dataType != null && datePeriod != null) {
            int year = datePeriod.getYear() + 1900;
            int hour = datePeriod.getHour() == 0 ? 12 : datePeriod.getHour();
            writer.print("month : \"" + datePeriod.getMonth() + "\",");
            writer.print("date : \"" + datePeriod.getDate() + "\",");
            writer.print("year : \"" + year + "\",");
            writer.print("hour : \"" + hour + "\",");
            writer.print("minute : \"" + datePeriod.getMinutes() + "\",");
            writer.print("seconds : \"" + datePeriod.getSeconds() + "\",");
            DateFormatSymbols dfs = new DateFormatSymbols(request.getLocale());
            String[] ampm = dfs.getAmPmStrings();
            String am_pm = datePeriod.getAMPM() == 0 ? ampm[0] : ampm[1];
            writer.print("am_pm : \"" + am_pm + "\"");
            String relativeString = "";
            relativeString = dataType.getDisplayString((Object)datePeriod.getStartOfPeriod(), request.getLocale());
            writer.print(",");
            writer.print("relativeString : \"" + relativeString + "\"");
        }
        writer.print("}");
        writer.println(JavaScriptIncludeHandler.getEndScript(null));
        writer.flush();
    }

    public int getDefaultDateStylePattern() {
        return this.defaultDateStylePattern;
    }

    public void setDefaultDateStylePattern(int defaultDateStylePattern) {
        this.defaultDateStylePattern = defaultDateStylePattern;
        Calendar cal = this.timeStamp.getCalendar();
        if (cal != null) {
            cal.setDefaultDateStylePattern(defaultDateStylePattern);
        }
    }

    public static void createTimePickerPalette(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        PrintWriter out = response.getWriter();
        String pickerID = request.getParameter("pickerid");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID);
        if (ti instanceof TimeStampPicker) {
            TimeStampPicker picker = (TimeStampPicker)ti;
            TimeStampPickerPopupWindow popDialog = new TimeStampPickerPopupWindow(picker.getId());
            popDialog.setRequest(request);
            TimeStamp timeStamp = (TimeStamp)picker.getComponent(TIMESTAMP_COMPONENT);
            timeStamp.setRequest(request);
            popDialog.setComponent(TIMESTAMP_COMPONENT, timeStamp);
            Button okbtn = (Button)picker.getComponent(TIMESTAMP_OK_BUTTON);
            okbtn.setRequest(request);
            popDialog.setComponent(TIMESTAMP_OK_BUTTON, okbtn);
            Button cancelbtn = (Button)picker.getComponent(TIMESTAMP_CANCEL_BUTTON);
            cancelbtn.setRequest(request);
            popDialog.setComponent(TIMESTAMP_CANCEL_BUTTON, cancelbtn);
            popDialog.write(out);
            out.println(JavaScriptIncludeHandler.getStartScript());
            out.println("var " + pickerID + "_Obj = sas_getJavaScriptObject('" + pickerID + "');");
            out.println(pickerID + "_Obj.setTimeComponent(sas_getJavaScriptObject('" + timeStamp.getTime().getId() + "'));");
            out.println(pickerID + "_Obj.setClockComponent(sas_getJavaScriptObject('" + timeStamp.getTime().getClock().getId() + "'));");
            out.println(pickerID + "_Obj.setCalendarComponent(sas_getJavaScriptObject('" + timeStamp.getCalendar().getId() + "'));");
            out.println(JavaScriptIncludeHandler.getEndScript(null));
        }
    }

    public void setHonor24HourLocale(boolean honor24HourLocale) {
        this.honor24HourLocale = honor24HourLocale;
    }

    public boolean isHonor24HourLocale() {
        return this.honor24HourLocale;
    }

    static {
        JavaScriptIncludeHandler.addAlias(TimeStampPicker.class, "TIMESTAMPPICKER");
    }
}

